<?php

	//==============================================================================
	// Author: Davis Muhajereen D. Dimalen
	// From: Mindanao State University - Iligan Institute of Technology
	// Version: 1.0
	// E-mail: d_dimalen@yahoo.com
	// Celphone No.: +639177166010
		
	//	The class.gammuWin32 class serves as an API for PHP and Gammu.  Gammu is a free software used for 
	//	managing cellular phones and handheld devices.  The requirement for Gammu is a celluar phone 
	//	and an FBus interface.  I suggest you use Nokia 3310 since the class has been tested using it.  
	//	Gammu can be downloaded from http://www.mwiacek.com/zips/gsm/gammu/gammu_win32.zip  
	//  More information about Gammu can be found at http://www.gammu.net/index.php
	
	//	The following are the features of class.gammuWin32:
		
	//	-	You can implement a php page that could send SMS to single mobile phone (web2mobile)
	//	-	You can extract information from your cellphone such as, message status 
	//	    (read, unsent, sent), folder location (inbox and outbox) and etc.  
	//		Most of all you can extract messages from your cellphone and display it in html format.
		
	//	This is just an introductory version of class.gammuWin32.  A lot of enhancements will 
	//	be done to it as soon as possible.  My goal is to be able to use all the features offered
	//	by Gammu and have it accessed through PHP.
	//==============================================================================

	class gammuWin32
	{
		var $messagesCount;
		var $messagesUnreadCount;
		var $gammuPath;
		var $smsMessages = array(
								 "info" 	=> array(
													 "folder" 		=> '',  // Inbox, Outbox
													 "status" 		=> '',  // read, unsent, unread
													 "remotenumber" => ''   // cell number of message sender
													), 
								 "message" 	=> array()						// message of sender
								);

		function gammuWin32($gPath)
		{
			$this->gammuPath = $gPath;
			$contentArr = array();
	
			$command = $this->gammuPath.' --monitor 1';
			ob_start();
				passthru($command);
				$content = ob_get_contents();
			ob_end_clean();
			
			$contentArr = explode("\n",$content);
			$temp = explode(":", $contentArr[11]);
			$temp2 = explode(",", $temp[1]);
			$this->messagesCount = trim(substr($temp2[0], 0, strpos($temp2[0],'used')));
			$this->messagesUnreadCount = trim(substr($temp2[1], 0, strpos($temp2[1],'unread')));
		}

		function getMessageCount()
		{
			$command = $this->gammuPath.' --monitor 1';
			ob_start();
				passthru($command);
				$content = ob_get_contents();
			ob_end_clean();
			
			$contentArr = explode("\n",$content);
			$temp = explode(":", $contentArr[11]);
			$temp2 = explode(",", $temp[1]);
			$this->messagesCount = trim(substr($temp2[0], 0, strpos($temp2[0],'used')));
			$this->messagesUnreadCount = trim(substr($temp2[1], 0, strpos($temp2[1],'unread')));			
		}
				
		function sendSMS($cellnum, $messages)
		{	
			$command = 'echo '.$messages.' | '.$this->gammuPath.' --sendsms TEXT '.$cellnum;

			passthru($command." 2>&1");	
		}
		
		function getSMS($isComplete=false) // Will get all SMS messages from cell phone
		{
			$this->getMessageCount();

			for($i=0;$i<=$this->messagesCount;$i++)
			{
				$command = $this->gammuPath.' --getsms 0 '.$i.' '.$i;
				ob_start();
					passthru($command);
					$content = ob_get_contents();
				ob_end_clean();
				
				$contentArr = explode("\n",$content);
				$temp = explode(",",$contentArr[0]);
				$folder = strtolower(substr($temp[1], 9, (strlen($temp[1])-10)));
				
				if ($folder == 'outbox')
				{
					$temp2 = explode(":",$contentArr[5]);
					$temp3 = explode(":",$contentArr[4]);
					$temp4 = array();
					$indx = 0;
					if($isComplete)
					{
						for($j=6;$j<=sizeof($contentArr)-1;$j++)
						{
							$temp4[$indx] = $contentArr[$j];
							$indx++;						
						}						
					}
					else
					{
						for($j=6;$j<=sizeof($contentArr)-1;$j++)
						{
							if ($contentArr[$j] != chr(13))
							{
								$temp4[$indx] = $contentArr[$j];
								$indx++;
							}
						}
					}
				}
				elseif($folder == 'inbox')
				{
					$temp2 = explode(":",$contentArr[6]);
					$temp3 = explode(":",$contentArr[5]);
					$indx = 0;
					if($isComplete)
					{
						for($j=7;$j<=sizeof($contentArr)-1;$j++)
						{
							$temp4[$indx] = $contentArr[$j];
							$indx++;						
						}						
					}
					else
					{
						for($j=7;$j<=sizeof($contentArr)-1;$j++)
						{
							if ($contentArr[$j] != chr(13))
							{
								$temp4[$indx] = $contentArr[$j];
								$indx++;
							}
						}
					}		
				}
				
				$status = strtolower(trim($temp2[1]));
				$remotenumber = strtolower(substr(trim($temp3[1]),1,strlen($temp3[1])-4));
				
				$this->smsMessages[$i]["info"]["folder"] 		= $folder;          // Inbox, Outbox, etc
				$this->smsMessages[$i]["info"]["status"] 		= $status;			// read, unsent, etc
				$this->smsMessages[$i]["info"]["remotenumber"]	= $remotenumber;	// The number of the cell phone that sent the message
				$this->smsMessages[$i]["message"]				= $temp4;			// The message stored per line in the array $this->smsMessages[$i]["message"]
			}
		}
		
		function deleteAllSMS() // Deletes existing messages from cell phone
		{
			$command = $this->gammuPath.' --deleteallsms 0';
			ob_start();
				passthru($command);
				$content = ob_get_contents();
			ob_end_clean();
			return $content;
		}
	}
?>