<?php

require_once __DIR__ . '/../../include/Webservices/Utils.php';
require_once __DIR__ . '/../../include/Webservices/Create.php';
require_once __DIR__ . '/../../include/Webservices/Retrieve.php';

/**
 * sync relevant data from vtiger to mautic
 * using the mautic API interfaces
 */
function vebMatContactSync($entity)
{
    global $current_user, $adb, $log;

    $config = vebMatContactSync::getConfig();
    
    $mattool = strtolower($config['mattool']);

    include $mattool.'/vebMatAdapter.php';

    ini_set('display_errors', 0);

    // get the crm entity id
    $crmid = vebMatContactSync::cleanId($entity->id);

    // get the crm origin module
    $moduleName = $entity->moduleName;

    // get the id of the mautic, lead & contact use the same name
    $vebMatLeadId = ($moduleName == 'Leads') ? $entity->data[$config['Leads']['veb_mat_id']] : $entity->data[$config['Contacts']['veb_mat_id']];

    $vtAccountId = ($moduleName == 'Contacts') ? vebMatContactSync::cleanId($entity->data['account_id']) : false; // only available for contacts

    if (isset($entity->data['wv_sfvisitorid'])) { 
        $wvaVisitorId = $entity->data['wv_sfvisitorid']; // wv_sfvisitorid
    }

    file_put_contents("/home/cs1002/public_html/logs/".__FILE__ .'-'.date("Y-m"). '.log', "module={$moduleName}, id={$entity->id}, vebMatLeadId={$vebMatLeadId}, wvaVisitorId={$wvaVisitorId}, vtAccountId={$vtAccountId}\n" . print_r($entity->data, true), FILE_APPEND);

    // return if no id's found
    if (empty($vebMatLeadId) && empty($wvaVisitorId))
    {
        return;
    }

    // ================================================================================= Accountdata if a valid accountid
    if ($vtAccountId)
    {
        $wsaccountid = vtws_getWebserviceEntityId('Accounts', $vtAccountId);
        $account = vtws_retrieve($wsaccountid, $current_user);
        //print_r($account);
    }

    // create adapter
    $mat = new vebMatAdapter();

    // get vebMat data
    if ($vebMatLeadId)
    {
        $result = $mat->getByMatId($vebMatLeadId);
    }
    if ($result['resultcode'] != 'ok' && $wvaVisitorId)
    {
        $result = $mat->getByWebvisitorId($wvaVisitorId);
    }

    // compare data piece by piece
    $vebMatData = $result['data'];
    $vtigerData = $entity->data;
    $updatevebMat = array();

    // ================================================================================= Fieldmapping & Stage
    // @todo get stages from Account for the contact (prospect, customer, etc)

    $stages = $mat->getStages();
    $vebMatStage = false;

    switch ($moduleName)
    {
        case 'Leads':
            $mapping = vebMatContactSync::getLeadMapping();
            $stagemapping = vebMatContactSync::getLeadStageMapping();
            $leadstatus = $vtigerData['leadstatus'];
            //        $vtigerData['leadstatus'] = $stagemapping[$leadstatus];
            $vebMatStage = $stages[$stagemapping[$leadstatus]];
            break;

        case 'Contacts':
            $mapping = vebMatContactSync::getContactMapping();
            $stagemapping = vebMatContactSync::getAccountStageMapping();
            //        $accountType = $account['accounttype']; // standard field
            $accountTypes = vebMatContactSync::splitMultiSelect($account[$config['Contacts']['accounttype']]); // multi select

            foreach ($accountTypes as $key => $value)
            {
                $mappedvalue = $stagemapping[$value];
                $accountType[$mappedvalue] = $mappedvalue;
            }
            $stage = reset($accountType);
            $vebMatStage = $stages[$stage]; // take the first
            $leadstatus = implode(', ', $account[$config['Contacts']['accounttype']]);
            file_put_contents("/home/cs1002/public_html/logs/".__FILE__ .'-'.date("Y-m"). '.log', "module={$moduleName}, accountTypes={$account[$config['Contacts']['accounttype']]}, stage={$stage}, vebMatStage=".print_r($vebMatStage,true)."\nAccountTypes:" . print_r($accountTypes, true), FILE_APPEND);
            break;

        default:
            $msg = "module {$moduleName}  not found in " . __FILE__ . " on line " . __LINE__;
            file_put_contents("/home/cs1002/public_html/logs/".__FILE__ .'-'.date("Y-m"). '.log', $msg, FILE_APPEND);
            die();
    }

    // set status $vebMatStage
    if ($vebMatStage)
    {
        $mat->add2stage($vebMatLeadId, $vebMatStage['id']);
        $updatemsg['leadstatus'] = "Vtiger leadstatus {$leadstatus} in {$mattool} toegevoegd aan stage: {$vebMatStage['name']}";
    } else
    {
        $updatemsg['leadstatus'] = "Vtiger leadstatus {$leadstatus} NIET toegevoegd als {$mattool} stage: {$vebMatStage['name']}";
    }

    // ================================================================================= Campaigns / Categories / Segments
    // define which campaigns / or dowe do the Preferences = Segments
    // ================================================================================= Handle the field maping
    foreach ($mapping as $keyVtiger => $keyvebMat)
    {
        if ($vtigerData[$keyVtiger] != '' && $vtigerData[$keyVtiger] <> $vebMatData[$keyvebMat])
        {
            $updatevebMat[$keyvebMat] = $vtigerData[$keyVtiger];
            $updatemsg[$keyVtiger] = "{$mattool} {$keyvebMat} aangepast van {$vebMatData[$keyvebMat]} naar {$updatevebMat[$keyvebMat]}";
        }
    }

    // ================================================================================= opt in / out leads to enrollments and DNC
    // read stats table
    $dnc = $mat->getDnc($vebMatLeadId);
    // print_r($dnc); die();
    // @todo - want to know status in target system (vebMat)!
    // $vtigerData['c_newsletter_optout']; // 1 of 0
    // $vtigerData['veb_l_emailconsent']; // Optin|Invited|Reminded|Subscribed|Optout|Unsubscribed|Bounced
    // $vebMatData['optin']; // 1 of 0
    $emailconsent = ($moduleName == 'Leads') ? $vtigerData[$config['Leads']['emailconsent']] : $vtigerData[$config['Contacts']['emailconsent']];

    switch ($emailconsent)
    {
        case 'Optin':
            if ($dnc)
            {
                $response = $mat->removeDnc($vebMatLeadId);
                $updatemsg['emailconsent'] = " {$mattool}  DNC verwijderd - Optin";
            }
            break;

        case 'Subscribed':
            if ($dnc)
            {
                $response = $mat->removeDnc($vebMatLeadId);
                $updatemsg['emailconsent'] = " {$mattool}  DNC verwijderd - Subscribed";
            }
            break;

        case 'Unsubscribed':
            if (!$dnc)
            {
                // $reason 1=>Contacts::UNSUBSCRIBED, 2=>Contacts::BOUNCED, 3=>Contacts::MANUAL
                $response = $mat->addDnc($vebMatLeadId);
                $updatemsg['emailconsent'] = " {$mattool} DNC toegevoegd - Unsubscribed";
            }
            break;

        case 'Optout':
            if (!$dnc)
            {
                // $reason 1=>Contacts::UNSUBSCRIBED, 2=>Contacts::BOUNCED, 3=>Contacts::MANUAL
                $response = $mat->addDnc($vebMatLeadId);
                $updatemsg['emailconsent'] = " {$mattool} DNC toegevoegd - optout";
            }
            break;

        default:
            // empty is allowed
            //  die('invalid veb_l_emailconsent: ' . $vtigerData['veb_l_emailconsent']);
    }


    // ================================================================================= Update changed fields
    // entity <> $result
    if (count($updatevebMat) > 0)
    {
        $response = $mat->update($vebMatLeadId, $updatevebMat, false);
        file_put_contents("/home/cs1002/public_html/logs/".__FILE__ .'-'.date("Y-m"). '.log', "update vebMatLeadId={$vebMatLeadId}: " . print_r($response, true), FILE_APPEND);
    }

    // ================================================================================= Add note to vebMat & Vtiger
    // do relevant update towards vebMat
    if (count($updatemsg) > 0)
    {
        // add memo to vebMat
        $response = $mat->addNote($vebMatLeadId, implode(", ", $updatemsg));

        // add memo to vtiger
        /**
        try {
            $parameters = array(
                'commentcontent' => implode("\n", $updatemsg),
                'related_to' => vtws_getWebserviceEntityId($moduleName, $crmid),
                'assigned_user_id' => vtws_getWebserviceEntityId('Users', 1),
            );
            $ModComments = vtws_create('ModComments', $parameters, $current_user);
        } catch (WebServiceException $ex) {
            $msg = $ex->getMessage();
            file_put_contents("/home/cs1002/public_html/logs/".__FILE__ .'-'.date("Y-m"). '.log', $msg, FILE_APPEND);
        }
        */
        
        vebMatContactSync::addToChangeLog($crmid, $moduleName, $updatemsg);
        
    }
    
    return true;
}

// ================================================================================= class
class vebMatContactSync
{

    /**
     * Convert ##x#### to ####
     * @param   raw id
     * @return  crm entity id
     */
    static function cleanId($rawid)
    {
        if ($rawid == '')
        {
            return false;
        } else
        {
            $pieces = explode("x", $rawid);
            return $pieces[1];
        }
    }

    static function getConfig()
    {
        $config = array();
        // Custom fields containing the id in crm of the target system
        $config['mattool'] = 'mautic'; 

        $config['Leads']['veb_mat_id'] = 'veb_l_mautic_leadid';
        $config['Contacts']['veb_mat_id'] = 'veb_c_mautic_leadid';

        $config['Leads']['emailconsent'] = 'veb_l_emailconsent';
        $config['Contacts']['emailconsent'] = 'veb_c_emailconsent';

        $config['Contacts']['accounttype'] = 'cf_1759';

        return $config;
    }

    static function getLeadmapping()
    {
        return array(
            'firstname' => 'firstname',
            'lastname' => 'lastname',
            'company' => 'company',
            'email' => 'email',
            'cf_2087' => 'functie_vicus_indeling',

            // @change t47124
            // 'cf_1732' => 'email_optout_reden',
            //

            'c_linkedin_contact' => 'linkedin',
                // ' => 'skills',
                // 'stage' needs special handling
        );
    }

    static function getContactmapping()
    {
        return array(
            'firstname' => 'firstname',
            'lastname' => 'lastname',
            'email' => 'email',
            'cf_2271' => 'functie_vicus_indeling',
            'c_email_optout_reason' => 'email_optout_reden',
            'c_linkedin_contact' => 'linkedin',
            'cf_1976' => 'skills',
                // 'stage' needs special handling
        );
    }

    static function getLeadStageMapping()
    {
        return array(
            'Webbezoeker' => 'Onbekende',
            'Target' => 'Target',
            'Recycle' => 'Lead',
            'Nieuw' => 'Lead',
            'Marketing gekwalificeerd' => 'Lead',
                'Marketing Qualified' => 'Lead',
            'Sales gekwalificeerd' => 'Lead',
                'Sales Qualified'  => 'Lead',
            'Webformulier ontvangen' => 'Lead',
            'Voorgekwalificeerd' => 'Lead',
            'Demo vtiger leadflow' => 'Lead',
            'Proef vtiger leadflow' => 'Lead',
            'Demo afspraak ingepland' => 'Lead',
            'Bestelformulier verzonden' => 'Lead',
            'Infomail verzonden' => 'Lead',
            'Afspraak inplannen' => 'Lead',
            'Afspraak ingepland' => 'Lead',
            'Nurture' => 'Lead',
            'Uitval - Lost' => 'Lost',
            'Uitval - Qualified Out' => 'Qualified Out',
            'Uitval - Reden onbekend' => 'Lost',
            'Converted' => 'Prospect'
        );
    }

    /**
     * Status van de account achter de contact
     * Ex-Klant / Ex-Partner / Ex-Leverancier
     * Klant / Partner / Leverancier
     * Prospect
     */
    static function getAccountStageMapping()
    {
        return array(
            'Prospect' => 'Prospect',
            'Klant' => 'Klant / Partner / Leverancier',
            'Klant gesponsord' => 'Klant / Partner / Leverancier',
            'Concurrent' => 'Qualified Out',
            'Partner' => 'Klant / Partner / Leverancier',
            'Vicus Reseller' => 'Klant / Partner / Leverancier',
            'Aspirant Partner' => 'Klant / Partner / Leverancier',
            'Potentiele Partner' => 'Klant / Partner / Leverancier',
            'Actieve Leverancier' => 'Klant / Partner / Leverancier',
            'Potentiele Leverancier' => 'Klant / Partner / Leverancier',
            'Pers' => 'Prospect',
            'Offshore' => 'Klant / Partner / Leverancier',
            'Delivery partner' => 'Klant / Partner / Leverancier',
            'Netwerkclub' => 'Prospect',
            'Vicus zelf' => 'Klant / Partner / Leverancier',
            'Ind-Klant' => 'Klant / Partner / Leverancier',
            'Klant-opgezegd' => 'Klant / Partner / Leverancier',
            'Ex-klant' => 'Ex-Klant / Ex-Partner / Ex-Leverancier',
            'Ex-leverancier' => 'Ex-Klant / Ex-Partner / Ex-Leverancier',
            'Ex-partner' => 'Ex-Klant / Ex-Partner / Ex-Leverancier',
            'Anders' => 'Prospect'
        );
    }

    static function splitMultiSelect($rawdata)
    {   
        return explode(' |##| ', $rawdata);
    }
    
    static function addToChangeLog($crmid, $module, $updatemsg)
    {
        global $adb, $current_user;
        
        if (count($updatemsg) == 0) { return; }
        
        $resultset = $adb->pquery('SELECT * FROM vtiger_modtracker_basic_seq', array());
        $id = $adb->query_result($resultset, 0, 'id');
        
        $id++;
        $adb->pquery("UPDATE vtiger_modtracker_basic_seq SET id=$id", array());

	// @change t49263
        // $whodid = '2197';
	if (!$current_user) $current_user = Users::getActiveAdminUser();
	$whodid = $current_user->id;
	//

        $changedon = date("Y-m-d H:m:i");
        $status = 0;
        
        $adb->pquery("INSERT vtiger_modtracker_basic SET id=$id, crmid=$crmid, module='$module', whodid=$whodid, changedon='$changedon'; ", array());
        
        $prevalue = '';
        
        foreach ($updatemsg as $fieldname => $postvalue) 
        {
		$adb->pquery("INSERT vtiger_modtracker_detail
			      SET id=$id, fieldname='$fieldname', prevalue='$prevalue', postvalue='$postvalue'; ", array());
        }
    }

}

// ===============================  Documentatie

/* Mautic data
    [id] => 25368
    [points] => 10
    [firstname] => test
    [lastname] => test
    [company] => test
    [position] => 
    [email] => test@aa.com
    [phone] => 
    [mobile] => 
    [address1] => 
    [city] => Pune
    [zipcode] => 
    [timezone] => 
    [country] => India
    [preferred_locale] => nl
    [website] => 
    [meisjesnaam] => 
    [optin] => 1
    [functie_vicus_indeling] => 
    [facebook] => 
    [linkedin] => 
    [skype] => 
    [twitter] => 
    [location] => 
    [contactsocialdescription] => 
    [linkedin_samenvatting] => 
    [linkedin_posities] => 
    [linkedin_specialismen] => 
    [linkedin_headline] => 
    [email_optout_reden] => 
    [skills] => 
    [wvascoregroups] => 
    [wvasourcevisitorid] => 
    [wvasource] => 
*/

/* vtiger data (Lead)
[salutationtype] => 
    [firstname] => test
    [lead_no] => LEA13964
    [phone] => 
    [lastname] => test
    [mobile] => 
    [company] => test
    [fax] => 
    [designation] => xcxxxxxxxxxxxxxxxcxxxx
    [email] => test@aa.com
    [leadsource] => 
    [website] => 
    [industry] => 
    [leadstatus] => Uitval - Qualified Out
    [annualrevenue] => 
    [rating] => 
    [noofemployees] => 0
    [assigned_user_id] => 19x2179
    [secondaryemail] => 
    [createdtime] => 2019-04-26 10:54:13
    [modifiedtime] => 2019-05-04 15:42:11
    [modifiedby] => 19x10
    [lane] => 
    [code] => 
    [city] => Pune
    [country] => India
    [state] => 
    [pobox] => 
    [description] => 
    [emailoptout] => 0
    [c_onetimebudget] => 
    [c_date_follow_up] => 
    [c_annualbudget] => 
    [c_expectedvalue] => 0
    [c_probability] => 
    [c_picklist_priorities] => 
    [c_initiative_notes] => 
    [c_webform] => 
    [c_picklist_customertypes] => 
    [c_lead_email2] => 
    [c_lead_initials] => 
    [c_lead_linkedin] => 
    [c_lead_preamble] => 
    [c_picklist_languages] => nl
    [c_picklist_targetgroups] => 
    [c_industry_particular] => 
    [c_other_websites] => 
    [c_coc_number] => 
    [c_picklist_legal_entities] => 
    [c_sbi_codes] => 
    [c_coc_extra] => 
    [c_tradenames] => 
    [c_latest_update] => 
    [c_coc_block] => 0
    [c_picklist_lead_preferences] => 
    [c_picklist_solutions] => 
    [c_picklist_products] => 
    [c_lead_interest] => 
    [c_picklist_lead_source] => 
    [c_lead_source_bg] => 
    [c_lead_search_terms] => 
    [c_lead_purchaseprice] => 
    [c_seminar_code] => 
    [c_picklist_lead_point_of_entry] => 
    [c_picklist_commisionpartner] => 
    [c_current_shop_sw_other] => 
    [c_picklist_shop_sw] => 
    [c_current_crm_sw_other] => 
    [c_picklist_crm_sw] => 
    [c_current_erp_sw_other] => 
    [c_erp_details] => 
    [c_picklist_erp_sw] => 
    [c_picklist_king_dealer] => 
    [c_current_misc_sw_other] => 
    [c_picklist_misc_sw] => 
    [c_essential_functions] => 
    [c_desired_integrations] => 
    [c_systems_to_replace] => 
    [c_current_provider] => 
    [c_future_plans] => 
    [c_crm_users] => 0
    [c_weborders_pw] => 0
    [c_product_count] => 0
    [c_salesregion] => 
    [c_competition] => 
    [c_lostanalysis] => 
    [c_current_cms_sw_other] => 
    [c_picklist_cms_sw] => 
    [c_current_mailing_sw_other] => 
    [c_picklist_mailing_sw] => 
    [c_picklist_webanalysis_sw] => 
    [c_current_webanalysis_sw_other] => 
    [c_picklist_bi_reports_sw] => 
    [c_current_bi_reports_sw_other] => 
    [c_picklist_middleware_sw] => 
    [c_current_middleware_sw_other] => 
    [wv_score] => 0
    [wv_sourcefirstvisit] => 
    [wv_searchterms] => 
    [wv_datefirstvisit] => 
    [wv_lastvisitdate] => 
    [wv_allsources] => 
    [wv_nofvisits] => 0
    [wv_nofpages] => 0
    [wv_scoregroups] => 
    [wv_sfcocnumber] => 
    [wv_sfsbi] => 
    [wv_isic2] => 
    [wv_snaisic] => 
    [wv_sfbranche] => 
    [wv_snaisicdescr] => 
    [wv_picklist_sfemployeesrange] => 
    [wv_creditrating] => 
    [wv_picklist_sfsegments] => 
    [wv_picklist_sftags] => 
    [wv_sffollow] => 0
    [wv_sfforce] => 0
    [wv_wvaorgid] => 
    [wv_wvaconid] => 
    [wv_sforgid] => 
    [wv_sfvisitorid] => 
    [cf_1288] => 
    [cf_1429] => 
    [cf_1433] => 
    [cf_1465] => 0
    [cf_1481] => 0
    [cf_1483] => 
    [ee_google_search] => 
    [cf_1576] => 0
    [cf_1578] => 0
    [cf_1580] => 0
    [cf_1582] => 0
    [cf_1584] => 0
    [c_newsletter_optout] => 0
    [cf_1639] => 
    [cf_1651] => 
    [cf_1661] => 0
    [cf_1663] => 
    [c_linkedin_account] => 
    [c_linkedin_contact] => 
    [cf_1712] => 0
    [cf_1714] => 0
    [cf_1716] => 0
    [cf_1728] => 0
    [cf_1732] => 
    [cf_1751] => 0
    [cf_1753] => 0
    [cf_1767] => 0
    [cf_1771] => 
    [cf_1978] => 
    [cf_2035] => 0
    [cf_2050] => 
    [source] => WEBSERVICE
    [starred] => 0
    [tags] => 
    [cf_1757] => 
    [veb_l_picklist_employee] => 
    [veb_l_emailconsent] => 
    [veb_l_emailoptin] => 0
    [veb_l_emailinterests] => 
    [veb_l_mautic_leadid] => 25368
    [veb_l_mautic_companyid] => 
    [veb_l_mautic_leadpoints] => 0
    [veb_l_mautic_companyscore] => 0
    [cf_2087] => 
    [cf_2275] => 2019-04-26
    [c_is_insolvent] => 
    [c_companyactive] => 
    [c_coda_changed] => 0
    [c_first_manager] => 
    [c_coda_last_update] => 
    [c_coda_blockupdates] => 0
    [c_date_settlement] => 
    [c_kvk_nomailindicator] => 0
    [c_branchnumber] => 
    [c_sbi_code] => 
    [c_coda_legal_entity] => 
    [c_sbi_description] => 
    [c_vat_number_eu] => 
    [c_economically_active] => 
    [c_employeehistory_text] => 
    [c_coda_sourceid] => 
    [c_sbi_code2] => 
    [c_sbi_description2] => 
    [c_branchtype] => 
    [id] => 10x319446
    [label] => test test
*/

/* account
Array
(
    [accountname] => Testorganisatie tbv BOARDING
    [account_no] => ACC5948
    [phone] => 
    [website] => 
    [fax] => 
    [tickersymbol] => 
    [otherphone] => 
    [account_id] => 
    [email1] => hri@vicus.nl
    [employees] => 
    [email2] => 
    [ownership] => 
    [rating] => E3 Opgeheven
    [industry] => Overig nog niet bekend
    [siccode] => 
    [accounttype] => 
    [annual_revenue] => 
    [emailoptout] => 0
    [notify_owner] => 
    [assigned_user_id] => 19x10
    [createdtime] => 2017-04-04 12:28:50
    [modifiedtime] => 2018-11-27 08:05:09
    [modifiedby] => 19x10
    [bill_street] => 
    [ship_street] => 
    [bill_city] => 
    [ship_city] => 
    [bill_state] => 
    [ship_state] => 
    [bill_code] => 
    [ship_code] => 
    [bill_country] => Nederland
    [ship_country] => Nederland
    [bill_pobox] => 
    [ship_pobox] => 
    [description] => 
    [isconvertedfromlead] => 0
    [c_picklist_targetgroups] => bedrijven
    [c_industry_particular] => 
    [c_other_websites] => 
    [c_accountplan] => 
    [c_mutual_customers] => 
    [c_picklist_employee] => Onbekend
    [c_initiative_notes] => 
    [c_date_follow_up] => 
    [c_weborders_pw] => 0
    [c_picklist_successmodel] => 0:Ambitie
    [c_product_count] => 0
    [c_picklist_branchemodel] => Anders
    [c_os_maturity] => 
    [c_press_mailing_list] => 
    [c_coc_number] => 
    [c_date_foundation] => 
    [c_sbi_code] => 
    [c_sbi_codes] => 
    [c_coc_extra] => 
    [c_latest_update] => 
    [c_picklist_legal_entities] => 
    [c_tradenames] => 
    [c_coc_block] => 0
    [c_debtor_accounts] => 
    [c_customer_since] => 
    [c_last_nps_date] => 
    [c_picklist_company_profile] => Bewust geen
    [c_customer_due] => 
    [c_picklist_revenue_to_solution] => 
    [c_picklist_commisionpartner] => Geen
    [c_forecast_2015] => 
    [c_revenue_2015] => 0
    [c_forecast_2014] => 
    [c_revenue_2009] => 0
    [c_revenue_2014] => 0
    [c_revenue_2008] => 0
    [c_forecast_2013] => 
    [c_revenue_2007] => 0
    [c_revenue_2013] => 0
    [c_revenue_2006] => 0
    [c_revenue_2012] => 0
    [c_revenue_2005] => 0
    [c_revenue_2011] => 0
    [c_total_revenue] => 0
    [c_revenue_2010] => 0
    [c_customer_area] => 
    [c_value_proposition] => 
    [c_customer_relations] => 
    [c_strait] => 
    [c_revenue_streams] => 
    [c_main_sources] => 
    [c_main_activities] => 
    [c_main_partners] => 
    [c_cost_structure] => 
    [c_picklist_bmc_status] => 
    [c_future_plans] => 
    [c_picklist_community_role] => 
    [c_picklist_king_support] => 
    [c_picklist_partner] => 
    [c_picklist_ogone_support] => 
    [c_picklist_msdynamicsax_support] => 
    [c_picklist_buckaroo_support] => 
    [c_picklist_msdynamicscrm_support] => 
    [c_picklist_vtigercrm_support] => 
    [c_picklist_msdynamicsnav_support] => 
    [c_picklist_sugarcrm_support] => 
    [c_picklist_snoobi_support] => 
    [c_picklist_accountview_support] => 
    [c_picklist_magento_support] => 
    [c_picklist_u4multivers_support] => 
    [c_picklist_exact_support] => 
    [c_picklist_zencart_support] => 
    [c_picklist_osslo] => 
    [c_misc_partnerships] => 
    [c_main_competitor] => 0
    [c_competitive] => 
    [c_wwvd_2013] => 
    [c_wwvd_2014] => 
    [c_wwvd_2015] => 
    [c_picklist_disciplines] => 
    [c_current_shop_sw_other] => 
    [c_picklist_shop_sw] => 
    [c_psp_other] => 
    [c_picklist_psp] => 
    [c_payment_methods_other] => 
    [c_current_crm_sw_other] => 
    [c_picklist_crm_sw] => 
    [c_current_erp_sw_other] => 
    [c_erp_details] => 
    [c_picklist_erp_sw] => 
    [c_picklist_king_dealer] => 
    [c_current_misc_sw_other] => 
    [c_picklist_misc_sw] => 
    [c_picklist_hosting] => 
    [c_reason_for_ending] => 
    [c_combined_info] => Testorganisatie tbv BOARDING

 
    [c_picklist_satisfaction] => 
    [c_picklist_subco] => 
    [c_picklist_cms_sw] => 
    [c_current_cms_sw_other] => 
    [c_picklist_payment_methods] => 
    [c_current_mailing_sw_other] => 
    [c_picklist_mailing_sw] => 
    [c_current_bi_reports_sw_other] => 
    [c_picklist_bi_reports_sw] => 
    [c_picklist_webanalysis_sw] => 
    [c_current_webanalysis_sw_other] => 
    [c_picklist_middleware_sw] => 
    [c_current_middleware_sw_other] => 
    [wv_sfcocnumber] => 
    [wv_sfsbi] => 
    [wv_isic2] => 
    [wv_snaisic] => 
    [wv_sfbranche] => 
    [wv_snaisicdescr] => 
    [wv_picklist_sfemployeesrange] => 1
    [wv_creditrating] => 
    [wv_picklist_sfsegments] => 
    [wv_picklist_sftags] => 
    [wv_sffollow] => 
    [wv_sfforce] => 
    [wv_wvaorgid] => 
    [wv_sforgid] => 
    [wv_score] => 0
    [wv_sourcefirstvisit] => 
    [wv_searchterms] => 
    [wv_datefirstvisit] => 
    [wv_lastvisitdate] => 
    [wv_allsources] => 
    [wv_nofvisits] => 0
    [wv_nofpages] => 0
    [wv_scoregroups] => 
    [cf_1284] => 
    [cf_1286] => 0.00000000
    [cf_1381] => 
    [v_d_naw_nummer] => 0
    [v_c_naw_nummer] => 0
    [v_debiteur] => 0
    [v_crediteur] => 0
    [v_by_vosba] => 0
    [cf_1390] => 
    [cf_1392] => 
    [cf_1394] => 
    [cf_1396] => 
    [cf_1398] => 
    [cf_1400] => 0
    [cf_1413] => 0
    [cf_1473] => 
    [cf_1479] => 
    [ee_google_search] => 
    [c_newsletter_optout] => 0
    [cf_1641] => 
    [cf_1645] => 
    [cf_1647] => 
    [cf_1659] => Overig nog niet bekend /   ()  /  WVA visits/pages/score: 0/0/0
    [cf_1665] => 
    [iskingdealer] => 0
    [kingdealer] => 
    [xxx] => 
    [cf_1679] => 
    [cf_1687] => 0.00000000
    [c_linkedin_account] => 
    [c_linkedin_contact] => 
    [cf_1736] => 
    [cf_1738] => 
    [cf_1740] => 
    [cf_1742] => 
    [cf_1744] => 
    [cf_1748] => 0
    [cf_1757] => Overig
    [cf_1759] => Anders
    [rfm_recency] => 
    [rfm_frequency] => 
    [rfm_monetaryvalue] => 
    [rfm_solutionvalue] => 
    [rfm_score] => 
    [cf_1769] => 0
    [cf_1936] => 
    [cf_1938] => 
    [cf_1940] => 
    [cf_1942] => 
    [cf_1944] => 
    [cf_1946] => 0.00000000
    [cf_1950] => 
    [cf_1952] => 
    [cf_1954] => 
    [cf_1958] => 
    [cf_1960] => 
    [cf_1962] => 
    [cf_1964] => 
    [cf_1972] => 
    [cf_1974] => 
    [cf_2076] => 
    [cf_2078] => 
    [source] => 
    [starred] => 
    [tags] => 
    [cf_2243] => 
    [cf_2245] => 
    [veb_a_crm_users] => 
    [veb_a_mautic_companyid] => 
    [veb_a_mautic_companyscore] => 
    [c_is_insolvent] => 
    [c_companyactive] => 
    [c_coda_changed] => 
    [c_first_manager] => 
    [c_coda_last_update] => 
    [c_coda_blockupdates] => 
    [c_date_settlement] => 
    [c_kvk_nomailindicator] => 
    [c_branchnumber] => 
    [c_coda_legal_entity] => 
    [c_sbi_description] => 
    [c_vat_number_eu] => 
    [c_economically_active] => 
    [c_employeehistory_text] => 
    [c_coda_sourceid] => 
    [c_sbi_code2] => 
    [c_sbi_description2] => 
    [c_branchtype] => 
    [id] => 11x269258
    [label] => Testorganisatie tbv BOARDING
)
*/
