<?php

function updateSalestargetsRelationsFromTarget($entity){
	global $current_user, $adb, $log;
	include_once 'include/utils/CommonUtils.php';
	include_once 'include/database/PearDatabase.php';
	require_once('data/CRMEntity.php');
	require_once 'modules/SalestargetsRelations/SalestargetsRelations.php';

	$id = $entity->data['id'];
	$pieces = explode("x", $id);
	$record = $pieces[1];

	//Delete salestargetsrelations
	$sql 		= "DELETE FROM vtiger_salestargetsrelations WHERE salestarget_id = ?";
	$params 	= array($record);
	$result 	= $adb->pquery($sql, $params);

	//Get target information	
	$sql_st 	= "SELECT account_id, related_to, salestarget_quarter, salestarget_month, salestarget_year, related_user FROM vtiger_salestargets 
		INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_salestargets.salestargetsid 
		WHERE vtiger_crmentity.deleted=0 AND salestargetsid = ?";
	$params 	= array($record);
	$inner_rescf 	= $adb->pquery($sql_st, $params);
	$rel_account	= $adb->query_result($inner_rescf, 0, "account_id");
	$relatedto	= $adb->query_result($inner_rescf, 0, "related_to");
	$st_quarter 	= $adb->query_result($inner_rescf, 0, "salestarget_quarter");
	$st_month	= $adb->query_result($inner_rescf, 0, "salestarget_month");
	$st_year	= $adb->query_result($inner_rescf, 0, "salestarget_year");
	$related_user	= $adb->query_result($inner_rescf, 0, "related_user");

	if ($st_month != ""){
		switch ($st_month){
		case "January":
			$startdate = $st_year."-01-01"; 
			$enddate = $st_year."-02-01";
			break;
		case "February":
			$startdate = $st_year."-02-01"; 
			$enddate = $st_year."-03-01"; 
			break;
		case "March":
			$startdate = $st_year."-03-01"; 
			$enddate = $st_year."-04-01"; 
			break;
		case "April":
			$startdate = $st_year."-04-01"; 
			$enddate = $st_year."-05-01"; 
			break;
		case "May":
			$startdate = $st_year."-05-01"; 
			$enddate = $st_year."-06-01"; 
			break;
		case "June":
			$startdate = $st_year."-06-01"; 
			$enddate = $st_year."-07-01"; 
			break;
		case "July":
			$startdate = $st_year."-07-01"; 
			$enddate = $st_year."-08-01"; 
			break;
		case "August":
			$startdate = $st_year."-08-01"; 
			$enddate = $st_year."-09-01"; 
			break;
		case "September":
			$startdate = $st_year."-09-01"; 
			$enddate = $st_year."-10-01"; 
			break;
		case "October":
			$startdate = $st_year."-10-01"; 
			$enddate = $st_year."-11-01"; 
			break;
		case "November":
			$startdate = $st_year."-11-01"; 
			$enddate = $st_year."-12-01"; 
			break;
		case "December":
			$startdate = $st_year."-12-01"; 
			$newyear = $st_year+1;
			$enddate = $newyear."-01-01"; 
			break;
		}
	}
	elseif($st_quarter != ""){
		switch ($st_quarter){
		case "Q1":
			$startdate = $st_year."-01-01"; 
			$enddate = $st_year."-04-01";
			break;
		case "Q2":
			$startdate = $st_year."-04-01"; 
			$enddate = $st_year."-07-01";
			break;
		case "Q3":
			$startdate = $st_year."-07-01"; 
			$enddate = $st_year."-10-01";
			break;
		case "Q4":
			$startdate = $st_year."-10-01"; 
			$newyear = $st_year+1;
			$enddate = $newyear."-01-01"; 
			break;
		}
	}

	//Select orders
	$sql_so	= "SELECT accountid, salesorderid, total, smownerid FROM vtiger_salesorder 
				INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_salesorder.salesorderid
				WHERE vtiger_crmentity.deleted=0 AND orderdate >= '".$startdate."' AND orderdate < '".$enddate."'";	
	$params 	= array();
	$inner_rescf 	= $adb->pquery($sql_so, $params);
	$num_sorders 	= $adb->num_rows($inner_rescf);

	if ($num_sorders != "0"){
		for ($i = 0; $i < $num_sorders; $i++) {
			$accid 	= $adb->query_result($inner_rescf, $i, "accountid");
			$salesorderid = $adb->query_result($inner_rescf, $i, "salesorderid");
			$total 	= $adb->query_result($inner_rescf, $i, "total");
			$smownerid	= $adb->query_result($inner_rescf, $i, "smownerid");

			//get allocations
			$sql_alloc	= "SELECT related_user, allocation_amount, allocation_percent FROM vtiger_targetallocation 
				INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_targetallocation.targetallocationid 
				WHERE vtiger_crmentity.deleted=0 AND salesorder_id = ?";	
			$params 	= array($salesorderid);
			$inner_allow  = $adb->pquery($sql_alloc, $params);
			$num_alloc  	= $adb->num_rows($inner_allow);
		
			if ($num_alloc != "0"){
				for ($a = 0; $a < $num_alloc; $a++) {
					$alloc_user 		= $adb->query_result($inner_allow, $a, "related_user");
					$alloc_amount 	= $adb->query_result($inner_allow, $a, "allocation_amount");
					$alloc_percent 	= $adb->query_result($inner_allow, $a, "allocation_percent");

					if ($related_user == $alloc_user){
						if ((($rel_account != "0") && ($rel_account == $accid)) || ($rel_account == "0")|| ($rel_account == "")){
							if ($relatedto != "0"){
								//Select productrows
								$sql_po	= "SELECT productid, quantity FROM vtiger_inventoryproductrel WHERE id = ?";
								$params 	= array($record);
								$inner_rescf3	= $adb->pquery($sql_po, $params);
								$num_po   	= $adb->num_rows($inner_rescf3);
					
								for ($j = 0; $j < $num_po; $j++) {
									$productid 	= $adb->query_result($inner_rescf3, $j, "productid");
									if ($productid == $relatedto){
										//Create relation
										$focus = new SalestargetsRelations();
										$focus->column_fields['assigned_user_id'] = 1;
				    		 				$focus->column_fields['salesorder_id'] =  $salesorderid;
										$focus->column_fields['salestarget_id'] = $record;
										$focus->save("SalestargetsRelations");	
									}
								}				
							}else{
								//Create relation
								$focus = new SalestargetsRelations();
								$focus->column_fields['assigned_user_id'] = 1;
				    		 		$focus->column_fields['salesorder_id'] =  $salesorderid;
								$focus->column_fields['salestarget_id'] = $record;
								$focus->save("SalestargetsRelations");		
							}		
						}
					}
				}
			}
		
			else {
				if ($related_user == $smownerid){				
					if ((($rel_account != "0") && ($rel_account == $accid)) || ($rel_account == "0") || ($rel_account == "")){
						if ($relatedto != "0"){
							//Select productrows
							$sql_po	= "SELECT productid, quantity FROM vtiger_inventoryproductrel WHERE id = ?";
							$params 	= array($salesorderid);
							$inner_rescf3	= $adb->pquery($sql_po, $params);
							$num_po   	= $adb->num_rows($inner_rescf3);
					
							for ($j = 0; $j < $num_po; $j++) {
								$productid 	= $adb->query_result($inner_rescf3, $j, "productid");
								if ($productid == $relatedto){

									//Create relation
									$focus = new SalestargetsRelations();
									$focus->column_fields['assigned_user_id'] = 1;
				    		 			$focus->column_fields['salesorder_id'] =  $salesorderid;
									$focus->column_fields['salestarget_id'] = $record;
									$focus->save("SalestargetsRelations");	
								}
							}				
						}else{
							//Create relation
							$focus = new SalestargetsRelations();
							$focus->column_fields['assigned_user_id'] = 1;
				    		 	$focus->column_fields['salesorder_id'] =  $salesorderid;
							$focus->column_fields['salestarget_id'] = $record;
							$focus->save("SalestargetsRelations");		
						}		
					}
				}
			}
		}
	}
}	
?>