<?php

function updateSalestargetsFromTarget($entity){
	global $current_user, $adb, $log;
	include_once 'include/utils/CommonUtils.php';
	include_once 'include/database/PearDatabase.php';
	require_once('data/CRMEntity.php');

	$id = $entity->data['id'];
	$pieces = explode("x", $id);
	$record = $pieces[1];

	$salestargetid = $record;
	$sql_fo	= "SELECT related_user, related_to, financial_target, numerical_target FROM vtiger_salestargets WHERE salestargetsid = ?";
	$params 	= array($record);
	$inner_rescf2	= $adb->pquery($sql_fo, $params);

	$relatedto 		 = $adb->query_result($inner_rescf2, 0, "related_to");
	$financial_target 	 = $adb->query_result($inner_rescf2, 0, "financial_target");
	$sales_revenue 	 = 0;
	$numerical_target 	 = $adb->query_result($inner_rescf2, 0, "numerical_target");
	$actual_amount 	 = 0;
	$related_user		 = $adb->query_result($inner_rescf2, 0, "related_user");
	
	$updatesalestarget = "update vtiger_salestargets set sales_revenue=?, actual_amount=? where salestargetsid=?";
	$adb->pquery($updatesalestarget, array($sales_revenue, $actual_amount ,$salestargetid));	

	
	if ($relatedto != "0"){
		//Selectrelated orders
		$sql_sfr2	= "SELECT salesorder_id FROM vtiger_salestargetsrelations WHERE salestarget_id = ?";
		$params 	= array($salestargetid);
		$inner_rescf5 = $adb->pquery($sql_sfr2, $params);
		$num_sfr2  	= $adb->num_rows($inner_rescf5);

		for ($k = 0; $k < $num_sfr2; $k++) {
			$soid 		= $adb->query_result($inner_rescf5, $k, "salesorder_id");

			//get allocations
			$sql_alloc	= "SELECT allocation_amount, allocation_percent FROM vtiger_targetallocation WHERE salesorder_id = ? AND related_user = ?";	
			$params 	= array($record, $related_user);
			$inner_allow  = $adb->pquery($sql_alloc, $params);
			$num_alloc  	= $adb->num_rows($inner_allow);

			if ($num_alloc != "0"){
				for ($a = 0; $a < $num_alloc; $a++) {
					$alloc_amount 	= $adb->query_result($inner_allow, $a, "allocation_amount");
					$alloc_percent 	= $adb->query_result($inner_allow, $a, "allocation_percent");

					//Select productrows
					$sql_po	= "SELECT productid, quantity, listprice, discount_percent, discount_amount FROM vtiger_inventoryproductrel WHERE id = ?";
					$params 	= array($soid);
					$inner_rescf3	= $adb->pquery($sql_po, $params);
					$num_po   	= $adb->num_rows($inner_rescf3);
				
					for ($j = 0; $j < $num_po; $j++) {
						$productid 	= $adb->query_result($inner_rescf3, $j, "productid");

						if ($relatedto == $productid){
							$quantity 	=	 $adb->query_result($inner_rescf3, $j, "quantity");
							$listprice 		= $adb->query_result($inner_rescf3, $j, "listprice");
							$discount_percent 	= $adb->query_result($inner_rescf3, $j, "discount_percent");
							$discount_amount 	= $adb->query_result($inner_rescf3, $j, "discount_amount");
				
							$total = $listprice * $quantity;
							//discountamount	
							if ($discount_amount != ""){
								$total = $total - $discount_amount;
							}
							//discountpercent
							if ($discount_percent != ""){
								$total = ($total / 100) * (100 - $discount_percent);
							}
						}
							
						if ($alloc_amount > 0){
							$sales_revenue = $sales_revenue + $alloc_amount;	
							$actual_amount = $actual_amount + $quantity;	
						}
						else if ($alloc_percent > 0){
							$sales_revenue = $sales_revenue + (($total / 100)* $alloc_percent);
							$actual_amount = $actual_amount + (($quantity/ 100)* $alloc_percent);	
						}
						else {
							$sales_revenue = $sales_revenue + $total;	
							$actual_amount = $actual_amount + $quantity;	
						}
					}
					//UPDATE
					$updatesalestarget = "update vtiger_salestargets set sales_revenue=?, actual_amount=? where salestargetsid=?";
					$adb->pquery($updatesalestarget, array($sales_revenue, $actual_amount ,$salestargetid));	

					if ($financial_target > 0){
						$realised_percent = ($sales_revenue / $financial_target) * 100;
						$updatesalestarget = "update vtiger_salestargets set realised_percent=? where salestargetsid=?";
						$adb->pquery($updatesalestarget, array($realised_percent ,$salestargetid));	
					}
					if ($numerical_target > 0){
						$realised_percent_num = ($actual_amount / $numerical_target) * 100;
						$updatesalestarget = "update vtiger_salestargets set realised_percent_num=? where salestargetsid=?";
						$adb->pquery($updatesalestarget, array($realised_percent_num ,$salestargetid));	

					}
				}	
			}

			else{
				//Select productrows
				$sql_po	= "SELECT productid, quantity, listprice, discount_percent, discount_amount FROM vtiger_inventoryproductrel WHERE id = ?";
				$params 	= array($soid);
				$inner_rescf3	= $adb->pquery($sql_po, $params);
				$num_po   	= $adb->num_rows($inner_rescf3);
				
				for ($j = 0; $j < $num_po; $j++) {
					$productid 	= $adb->query_result($inner_rescf3, $j, "productid");
					if ($relatedto == $productid){
						$quantity 	=	 $adb->query_result($inner_rescf3, $j, "quantity");
						$listprice 		= $adb->query_result($inner_rescf3, $j, "listprice");
						$discount_percent 	= $adb->query_result($inner_rescf3, $j, "discount_percent");
						$discount_amount 	= $adb->query_result($inner_rescf3, $j, "discount_amount");
				
						$total = $listprice * $quantity;
						//discountamount	
						if ($discount_amount != ""){
							$total = $total - $discount_amount;
						}
						//discountpercent
						if ($discount_percent != ""){
							$total = ($total / 100) * (100 - $discount_percent);
						}
					}
					$sales_revenue = $sales_revenue + $total;	
				}
						
										
				$actual_amount = $actual_amount + $quantity;	
				//UPDATE
				$updatesalestarget = "update vtiger_salestargets set sales_revenue=?, actual_amount=? where salestargetsid=?";
				$adb->pquery($updatesalestarget, array($sales_revenue, $actual_amount ,$salestargetid));

				if ($financial_target > 0){
					$realised_percent = ($sales_revenue / $financial_target) * 100;
					$updatesalestarget = "update vtiger_salestargets set realised_percent=? where salestargetsid=?";
					$adb->pquery($updatesalestarget, array($realised_percent ,$salestargetid));	
				}
				if ($numerical_target > 0){
					$realised_percent_num = ($actual_amount / $numerical_target) * 100;
					$updatesalestarget = "update vtiger_salestargets set realised_percent_num=? where salestargetsid=?";
					$adb->pquery($updatesalestarget, array($realised_percent_num ,$salestargetid));	
				}
			}	
		}

	}
	else {
		//Selectrelated orders
		$sql_sfr3	= "SELECT salesorder_id FROM vtiger_salestargetsrelations WHERE salestarget_id = ?";
		$params 	= array($salestargetid);
		$inner_rescf6 = $adb->pquery($sql_sfr3, $params);
		$num_sfr3  	= $adb->num_rows($inner_rescf6);

		for ($j = 0; $j < $num_sfr3; $j++) {
			$soid 		= $adb->query_result($inner_rescf6, $j, "salesorder_id");

			//get allocations
			$sql_alloc	= "SELECT allocation_amount, allocation_percent FROM vtiger_targetallocation WHERE salesorder_id = ? AND related_user = ?";	
			$params 	= array($record, $related_user);
			$inner_allow  = $adb->pquery($sql_alloc, $params);
			$num_alloc  	= $adb->num_rows($inner_allow);

			if ($num_alloc != "0"){
				for ($a = 0; $a < $num_alloc; $a++) {
					$alloc_amount 	= $adb->query_result($inner_allow, $a, "allocation_amount");
					$alloc_percent 	= $adb->query_result($inner_allow, $a, "allocation_percent");
				
					//Select so total
					$sql_sototal	= "SELECT total, subtotal, discount_percent, discount_amount FROM vtiger_salesorder WHERE salesorderid = ?";
					$params 	= array($soid);
					$inner_rescf4	= $adb->pquery($sql_sototal, $params);
					$total  	= $adb->query_result($inner_rescf4, 0, "total");


					
					//EX BTW
					$subtotal  	= $adb->query_result($inner_rescf4, 0, "subtotal");
					$damount  	= $adb->query_result($inner_rescf4, 0, "discount_amount");
					$dper  	= $adb->query_result($inner_rescf4, 0, "discount_percent");

					if ($damount > 0){
						$total2 = $subtotal - $damount;
					}else if ($dper > 0){
						$total2 = $subtotal * ((100-$dper)/100);
					}else{ 
						$total2 = $subtotal;			
					}
					//$total = $total2;


					if ($alloc_amount > 0){
						$sales_revenue = $sales_revenue + $alloc_amount;	
					}
					else if($alloc_percent > 0){
						$alloc_percent = $sales_revenue + (($alloc_amount / 100)* $allow_percent);						
					}
					else {
						$sales_revenue = $sales_revenue + $total;	
					}
				}
			}
			else{
				//Select so total
				$sql_sototal	= "SELECT total FROM vtiger_salesorder WHERE salesorderid = ?";
				$params 	= array($soid);
				$inner_rescf4	= $adb->pquery($sql_sototal, $params);
				$total  	= $adb->query_result($inner_rescf4, 0, "total");
				$sales_revenue = $sales_revenue + $total;	
			}
		}

		//UPDATE
		$updatesalestarget = "update vtiger_salestargets set sales_revenue=? where salestargetsid=?";
		$adb->pquery($updatesalestarget, array($sales_revenue, $salestargetid));	

		if ($financial_target > 0){
			$realised_percent = ($sales_revenue / $financial_target) * 100;
			$updatesalestarget = "update vtiger_salestargets set realised_percent=? where salestargetsid=?";
			$adb->pquery($updatesalestarget, array($realised_percent ,$salestargetid));	
		}
		if ($numerical_target > 0){
			$realised_percent_num = ($actual_amount / $numerical_target) * 100;
			$updatesalestarget = "update vtiger_salestargets set realised_percent_num=? where salestargetsid=?";
			$adb->pquery($updatesalestarget, array($realised_percent_num ,$salestargetid));
		}
		
	}
}
?>