<?php
function updateSalestargetName($entity){
	global $current_user, $adb, $log;
	include_once 'include/utils/CommonUtils.php';
	include_once 'include/database/PearDatabase.php';
	require_once('data/CRMEntity.php');

	$id = $entity->data['id'];
	$pieces = explode("x", $id);
	$record = $pieces[1];

	//Get target information
	$sql_st 	= "SELECT account_id, related_to, salestarget_quarter, salestarget_month, salestarget_year, related_user FROM vtiger_salestargets
		INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_salestargets.salestargetsid
		WHERE vtiger_crmentity.deleted=0 AND salestargetsid = ?";
	$params 	= array($record);
	$inner_rescf 	= $adb->pquery($sql_st, $params);
	$rel_account	= $adb->query_result($inner_rescf, 0, "account_id");
	$relatedto	= $adb->query_result($inner_rescf, 0, "related_to");
	$st_quarter 	= $adb->query_result($inner_rescf, 0, "salestarget_quarter");
	$st_month	= $adb->query_result($inner_rescf, 0, "salestarget_month");
	$st_year	= $adb->query_result($inner_rescf, 0, "salestarget_year");
	$related_user	= $adb->query_result($inner_rescf, 0, "related_user");

	$sql_user	= "SELECT first_name, last_name FROM vtiger_users WHERE id = ?";
	$params 	= array($related_user);
	$inner_rescfu	= $adb->pquery($sql_user, $params);
	$firstname	 = $adb->query_result($inner_rescfu, 0, "first_name");
	$lastname	 = $adb->query_result($inner_rescfu, 0, "last_name");

	if ($firstname !=""){
		$nametarget = $firstname." ".$lastname;
	}else {
		$nametarget = $lastname;
	}

	if ($st_month !=""){
		$nametarget = $nametarget." ".$st_year."-".vtranslate($st_month, Salestargets);

	}elseif ($st_quarter !=""){
		$nametarget = $nametarget." ".$st_year."-".$st_quarter;
	}else{
		$nametarget = $nametarget." ".$st_year;

	}

	if ($st_month == 'January'){
		$cf_1489 = '01';
	}elseif ($st_month == 'February'){
		$cf_1489 = '02';
	}elseif ($st_month == 'March'){
		$cf_1489 = '03';
	}elseif ($st_month == 'April'){
		$cf_1489 = '04';
	}elseif ($st_month == 'May'){
		$cf_1489 = '05';
	}elseif ($st_month == 'June'){
		$cf_1489 = '06';
	}elseif ($st_month == 'July'){
		$cf_1489 = '07';
	}elseif ($st_month == 'August'){
		$cf_1489 = '08';
	}elseif ($st_month == 'September'){
		$cf_1489 = '09';
	}elseif ($st_month == 'October'){
		$cf_1489 = '10';
	}elseif ($st_month == 'November'){
		$cf_1489 = '11';
	}elseif ($st_month == 'December'){
		$cf_1489 = '12';
	}else {
		$cf_1489 = '';
	}

	$updatesalestarget = "update vtiger_salestargets set salestargetname=? where salestargetsid=?";
	$adb->pquery($updatesalestarget, array($nametarget ,$record));

	$updatesalestarget = "update vtiger_salestargetscf set cf_1489=? where salestargetsid=?";
	$adb->pquery($updatesalestarget, array($cf_1489 ,$record));

}
?>
