<?php
/*+*******************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *********************************************************************************/

include_once('modules/Workflow/Soap2Vosba.php');
include_once('include/utils/CommonUtils.php');
include_once('include/database/PearDatabase.php');

/*
 *
 *
 */
function sentAccount2King($entity)
{
  global $adb;
  
   // @change lro 170131 add logging
  global $log;

  if (is_object($entity))
  {

    $id = explode("x", $entity->get('id'));
    $accId = $id[1]; 
  }
  else
  {
    $accId = $entity;
  }

  $log->debug(__FUNCTION__."({$accId}) function started");

  if ($accId > 0)
  {
    // get account - updated account info
    $query = "SELECT * 
              FROM vtiger_crmentity e, vtiger_account acc, vtiger_accountscf cf,
                   vtiger_accountbillads bill, vtiger_accountshipads ship
              WHERE e.deleted = 0
              AND e.crmid = acc.accountid
              AND e.crmid = cf.accountid
              AND e.crmid = bill.accountaddressid
              AND e.crmid = ship.accountaddressid 
              AND acc.accountid = ?";

    //$result = $adb->pquery($query, array($accId)) or die ("helaas de query is mislukt <br /><br />$query<br /><br />".htmlspecialchars($adb->database->ErrorMsg()));
    
    $result = $adb->pquery($query, array($accId));
    
    if (!$result) {
      $logmsg = "helaas de query is mislukt <br /><br />$query<br /><br />".htmlspecialchars($adb->database->ErrorMsg());
      $log->error(__FUNCTION__." query failed $logmsg");
      die ($logmsg);
    }

   // @change lro 170131 add logging
    $log->debug(__FUNCTION__."({$accId}) fields: ".print_r($result->fields, true));

    $message = toXml('organisation', $result->fields);
    
    file_put_contents("/home/cs1002/public_html/modules/Workflow/logdata/account-".$accId."-".date("YmdHmi").".xml",$message);

    $sendToEndpoint = toEndpoint('Organisation', $message);
  }
}

/*
 *
 *
 */
function sentContact2King($entity)
{
  global $adb;

   // @change lro 170131 add logging
  global $log;


  if (is_object($entity))
  {
    $id = explode("x", $entity->get('id'));
    $conIds = array($id[1]); 
  }
  else
  {
    $conIds = $entity;
  }

  $query = "SELECT * 
            FROM vtiger_crmentity e, vtiger_contactdetails cd, vtiger_contactsubdetails csd, vtiger_contactscf cf, vtiger_contactaddress ca
            WHERE e.deleted = 0
            AND e.crmid = cd.contactid
            AND e.crmid = csd.contactsubscriptionid
            AND e.crmid = cf.contactid
            AND e.crmid = ca.contactaddressid
            AND (cd.v_debiteur = 1 or cd.v_crediteur = 1)
            AND cd.contactid = ?";
  
  foreach($conIds as $conId)
  {

    $log->debug(__FUNCTION__."({$conId}) function started");

//    $result = $adb->pquery($query,array($conId)) or die ("helaas de query is mislukt <br /><br />$query_get_con<br /><br />".htmlspecialchars($adb->database->ErrorMsg()));
    $result = $adb->pquery($query,array($conId));
    
    if (!$result) {
      $logmsg = "helaas de query is mislukt <br /><br />$query<br /><br />".htmlspecialchars($adb->database->ErrorMsg());
      $log->error(__FUNCTION__." query failed $logmsg");
      die ($logmsg);
    }


   // @change lro 170131 add logging
    $log->debug(__FUNCTION__."({$conId}) fields: ".print_r($result->fields, true));

    $message = toXml('contact', $result->fields);

    file_put_contents("/home/cs1002/public_html/modules/Workflow/logdata/contact-".$conId."-".date("YmdHmi").".xml",$message);

    $sendToEndpoint = toEndpoint('Contact', $message);
  }
}

/*
 *
 *
 */
function sendProduct2Vosba($productentity)
{
  global $log;

  list($moduleid, $id) = explode("x", $productentity['products']['id']);

  $log->debug(__FUNCTION__."({$id}) function started");

  file_put_contents("/home/cs1002/public_html/modules/Workflow/logdata/product-".$id."-".date("YmdHmi").".array", print_r($productentity, true));

  $message = newToXml('products', $productentity);

  file_put_contents("/home/cs1002/public_html/modules/Workflow/logdata/product-".$id."-".date("YmdHmi").".xml",$message);

  $sendToEndpoint = toEndpoint('Products', $message);
}
