<?php
/*********************************************************************************
 * this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *********************************************************************************/

include_once('include/utils/CommonUtils.php');
include_once('include/database/PearDatabase.php');
include_once('modules/Workflow/send2king.php');

// @change lro
include_once('modules/PDFMaker/resources/functions/veb_layout.php');
include_once('modules/PDFMaker/resources/functions/veb_subproducts_formatted.php');

function sendProduct($entity) {

  list($moduleId, $recordId) = explode('x', $entity->get('id'));

  $entityDelta = new VTEntityDelta();

  if (count($entityDelta->getEntityDelta($entity->getModuleName(), $recordId)) == 1) {

    // no need to sent it to vosba (always 1 delta entry: modifiedtime, if nothing is changed)
    return;
  }

  $recordModel = Vtiger_Record_Model::getInstanceById($recordId, 'Products');
  
  $entity->data['images']['image'] = $recordModel->getImageDetails();

  $entity = sendProductHook($entity, $recordId);

  $productData = array('products' => $entity->data);

  sendProduct2Vosba($productData);
}

// @change lro manipulate desriptions for woo
function sendProductHook($entity, $recordId) {

	// c_tagline = Brochure Tagline (60-80)
	// description = Offerte-/Brochuretekst 
	// cf_2072 = Offerte/Brochure Inclusief 
	// c_principles = Offerte Uitgangspunten, Exclusief, Beperkingen 
	// cf_1592 = Offerte/Brochure Voordelen/kenmerken 
	// cf_1986 = Licentie
	// c_annual_maintenance = bedrag per jaar
	// aanvullende webtekst : cf_2625

	// do some replacements for icons
	$entity->data['productname']  = str_replace('<>',' [vebsc icon=vic-arr-lr] ',$entity->data['productname'] );
	
	//$tagline = ($entity->data['c_tagline'] != '') ? '<h3>'.$entity->data['c_tagline'].'</h3>' : '';
	$description = ($entity->data['description'] != '') ? veb_getHTMLtext($entity->data['description']) : '';
	//$uitgangspunten = ($entity->data['c_principles'] != '') ? veb_getHTMLtext($entity->data['c_principles']) : '';

	$beschikbareversies = ($entity->data['c_version_compatibility'] != '') ? '<p>Beschikbaar voor versie: '.$entity->data['c_version_compatibility'].' (andere versies zijn op verzoek beschikbaar)</p>' : '<p>Neem contact met ons op om te checken of deze voor jouw softwareversie beschikbaar is';

	$inclusief = ($entity->data['cf_2072'] != '') ? '<h3>Inclusief</h3>'.veb_getHTMLtext($entity->data['cf_2072']) : '';
	// formatting of inclusief ul
	$inclusief = str_ireplace('<ul>', '<ul class="inclusief">', $inclusief);

	$voordelen = ($entity->data['cf_1592'] != '') ? '<h3>Voordelen</h3>'.veb_getHTMLtext($entity->data['cf_1592']) : '';
	// formatting of voordelen ul
	$voordelen = str_ireplace('<ul>', '<ul class="voordelen">', $voordelen);

	$licentie = ($entity->data['cf_1986'] != '') ? '<h3>Licentie</h3>'.veb_getHTMLtext($entity->data['cf_1986']) : '';
//	$jaarbedrag = ($entity->data['c_annual_maintenance'] != '' && $entity->data['c_annual_maintenance'] > 0) ? '<p>Op deze module is een betaald jaarabonnement van toepassing</p>' : '';
$jaarbedrag = '';
	
	$subproducts = veb_subproducts_formatted($recordId, '', FALSE);

	$extratext = ($entity->data['description'] != '') ? veb_getHTMLtext($entity->data['cf_2625']) : '';

	// categorie vullen
	// ================================================
	// let op wij doen alleen NL nu!
	// ================================================
	// cf_2554 vullen vanuit multi select cf_2591
	// format nl:####
	// nl:102#109#114,en:130#134#140
	$cats = explode(' |##| ',$entity->data['cf_2591']);
	$catstext = "<p>".$entity->data['cf_2591']."</p>";
	$catConfig = array(
		'Magento-extensies' => 1180,
		'Magento-koppelingen' => 1181,
		'Mage2king-extensies' => 1253,

		'Vtiger-extensies' => 1179,
		'Vtiger-koppelingen' => 1182,

		'WooCommerce-extensies' => 1183,
		'WooCommerce-koppelingen' => 1184,

		'VOSBA' => 1214,
		'WebVisitAnalyser' => 1215,

		'King-koppelingen' => 1216,
		'Exact-koppelingen' => 1217,

		'Marketing' => 1218,
		'Verkoop' => 1219,
		'Service' => 1220,
		'Levering' => 1221,
		'Rapportage' => 1222,

		'Beveiliging' => 1223,
		'Gegevensbeheer' => 1224,

		'Documentbeheer' => 1500,
		'Projectmanagement' => 1501,

	);
	
	$catids = array();
	foreach ($cats as $catid => $catname) {
		$catids[] = $catConfig[$catname];
	}

	// @change t47124
	// now make a textstring
	// $entity->data['cf_2554'] = 'nl:'.implode('#',$catids);
	// $catstext .= "<p>".$entity->data['cf_2554']."</p>";
	//

//	$datatext = print_r($entity->data, true);

	// deze settings lijken helamaal niet te werken!
/**
	if ($entity->data['discontinued'] == 0 OR $entity->data['c_webproduct'] == 0) {
		$entity->data['cf_2556'] = 'Concept';
		$entity->data['cf_2552'] = 'Verborgen';
	}
**/
// jho: t35375
	// @change lro 2-3-21 cf_2552 wordt niet aangepast, die bevat dus de waarden die uit de module komen
	switch ($entity->data['cf_2552']) {
		// case 'Catalogus en Zoeken': $entity->data['cf_2552'] = 'Zichtbaar'; break;
		// case 'Alleen Catalogus': $entity->data['cf_2552'] = 'Catalogus'; break;
		// case 'Alleen Zoeken': $entity->data['cf_2552'] = 'Zoeken'; break;
		// case 'Niet zichtbaar': $entity->data['cf_2552'] = 'Verborgen'; break;
	}

	// {$uitgangspunten} doen we niet
	// <br />{$datatext}
	// test:{$catstext}
	$entity->data['description'] = "{$jaarbedrag}{$beschikbareversies}{$description}{$extratext}{$inclusief}{$voordelen}<br />{$subproducts}{$licentie}";

	$entity->data['description'] = str_replace("</ul>\n<p>","</ul>\n<br />\n<p>", $entity->data['description']);
	$entity->data['description'] = str_replace("</ul>\n<h3>","</ul>\n<br />\n<h3>", $entity->data['description']);

	// 
	$entity->data['description'] = str_replace("<!--veb_getHTMLtext-leeg-->","", $entity->data['description']);
	$entity->data['description'] = str_replace("&nbsp;","", $entity->data['description']);

	// unset what we dont want to send outside
	
	unset($entity->data['c_sales_note']);
	unset($entity->data['vendor_id']);
	unset($entity->data['mfr_part_no']);
	unset($entity->data['vendor_part_no']);
	unset($entity->data['modifiedby']);
	unset($entity->data['commissionrate']);
	unset($entity->data['reorderlevel']);
	unset($entity->data['assigned_user_id']);
	unset($entity->data['c_active_partners']);
	unset($entity->data['c_thirdparty_upgrades']);
	unset($entity->data['c_purchase_price']);
	unset($entity->data['c_write_off']);
	unset($entity->data['c_purchase_note']);
	unset($entity->data['c_minutes_intern']);
	unset($entity->data['c_standard_ticket']);
	unset($entity->data['c_work_instruction']);
	unset($entity->data['c_principles']);
	unset($entity->data['purchase_cost']);
	unset($entity->data['source']);

	return $entity;
}

/**
	// discontinued = yes - als product disabled (active = no)
	// c_webproduct = no - of webartikel is uitgezet
	// dan dan moet product uit!
	// Webstatus cf_2556 -> 'Concept'
	// Zichtbaarheid cf_2552 naar 'Verborgen'
// Winkel en zoekresultaten
// Alleen winkel
// Alleen zoekresultaten
// Verborgen


test:Array
(
[productname] => Magento Internetkassa Mollie
[product_no] => PRO1843
[productcode] => mag-mollie
[discontinued] => 1
[manufacturer] => Community partner
[productcategory] => Add-on
[sales_start_date] => 2020-01-01
[sales_end_date] =>
[start_date] => 2020-01-01
[expiry_date] =>
[website] =>
[vendor_id] =>
[mfr_part_no] =>
[vendor_part_no] =>
[serial_no] =>
[productsheet] =>
[glacct] =>
[createdtime] => 2020-01-23 10:33:06
[modifiedtime] => 2020-05-18 13:13:09
[modifiedby] => 1910
[unit_price] => 526.00000000
[commissionrate] =>
[taxclass] =>
[usageunit] => Installatie
[qty_per_unit] =>
[qtyinstock] => 100000.000
[reorderlevel] =>
[assigned_user_id] => 1910
[qtyindemand] =>
[imagename] =>
[description] => Mollie is een collecterende payment service provider (cpsp), met een uitgebreide internetkassa die geschikte is voor internationale online verkoop. Zo ondersteunt de psp naast iDEAL ook betaalmethoden als creditcard, Bancontact en SOFORT Banking.
[c_active_partners] => 0
[c_sales_note] =>
[c_annual_maintenance] => 0
[c_thirdparty_upgrades] => 0
[c_purchase_price] => 0
[c_write_off] => 0
[c_purchase_note] =>
[c_url_manual] =>
[c_picklist_growth_modelphase] => 1:Platform
[c_clustercode] => E-08
[c_picklist_quote_cluster] => Add-on
[c_in_cvs] => 0
[c_version_compatibility] =>
[c_picklist_products] => Magento
[c_supplier_product_url] =>
[c_minutes_intern] => 0
[c_standard_ticket] => 0
[c_no_ticket] => 0
[c_ticket_description] =>
[c_work_instruction] => [] overleg met HDR hoe aan te pakken
[] leg het installatiescript vast.
[] is het geheel (code + installatie-instructie) in CVS opgenomen?
[] let op dat MSP zelf de module heeft gebouwd en wij daar niet voor verantwoordelijk zijn! Ze verlenen prima support!
[c_package_available] => 0
[c_tagline] => Met Mollie betalen je klanten soepel
[c_principles] => Vicus zal de standaard module van Mollie installeren en configureren. Het eventueel aanpassen van vormgeving van de betaalpaginas is niet begroot. Vraag tijdig het abonnement aan bij Mollie als u dat nog niet heeft.
[c_webproduct] => 1
[c_picklist_websale_lvl1] =>
[c_picklist_websale_lvl2] =>
[c_picklist_websale_lvl3] =>
[cf_1494] =>
[cf_1496] =>
[cf_1548] =>
[cf_1592] =>
[cf_1681] =>
[cf_1986] =>
[cf_2031] => Mollie_Payment
[cf_2042] => 0
[cf_2054] =>
[cf_2058] => 0
[cf_2072] =>
[purchase_cost] => 0.00000000
[source] => CRM
[starred] =>
[tags] =>
[cf_2552] => Zichtbaar
[cf_2554] => nl:1181#1180
[cf_2556] => Tonen
[cf_2558] => 100
[cf_2591] => Magento-koppelingen |##| Magento-extensies
[id] => 14411429
[label] => Magento Internetkassa Mollie
[tax1] => 21.000
[currency1] => 526
[currency_id] => 211
[images] => Array
(
[image] => Array
(
[0] => Array
(
[id] => 437125
[orgname] => mollie_logo_1024x768.png
[path] => storage/2020/May/week3/437125
[name] => mollie_logo_1024x768.png
)

)

)

)


**/
