<?php

/**
 * Vtiger - Mautic adapter
 * @see mautic adapter at WebVisitAnalysr SaaS server with extended implementation
 * 
 * called by workflows to:
 * 1) update data in Mautic of existing Contacts
 * 2) create new contacts in Mautic
 * 
 * Be Aware: only realtime incidental
 * Structural sync will be done through separate sync process initiated by custom code at the Mautic side
 */
require_once __DIR__ . '/vendor/autoload.php';
require_once __DIR__ . '/Cache/Lite.php';

use App\ContactApi;

class vebMatAdapter
{

    public $cache;

    function __construct()
    {
        $cacheOptions = array(
            'cacheDir' => __DIR__ . '/data/',
            'lifeTime' => 3600,
            'automaticSerialization' => TRUE,
            'automaticCleaningFactor' => 200,
        );

        $this->cache = new Cache_Lite($cacheOptions);
        //$this->cache->setToDebug();
    }

    /**
     * @param   string mauticid
     * @return  array  mautic data
     */
    public function getByMatId($mauticid = null)
    {
        $resultcode = 'ok';

        try {
            $contactApi = new ContactApi();

            $conPayload = [
                [
                    'col' => 'id',
                    'expr' => 'eq',
                    'val' => "{$mauticid}"
                ]
            ];

            $response = $contactApi->getByQuery($conPayload);

            // should be 1
            $count = count($response['contacts']);
            if ($count == 1)
            {
                $result = reset($response['contacts']); // take the first
                $return = $result['fields']['all'];
            } else
            {
                $resultcode = 'nok';
                $return = "counted {$count} results for mauticid={$mauticid}";
            }
        } catch (\Exception $ex) {
            echo $ex->getMessage();
            $return = $ex->getMessage();
        }

        return array(
            'resultcode' => $resultcode,
            'data' => $return
        );
    }

    /**
     * @param   string wvasourcevisitorid
     * @return  array  mautic data
     */
    public function getByWebvisitorId($webvisitorid = null)
    {
        $resultcode = 'ok';

        try {
            $contactApi = new ContactApi();

            $conPayload = [
                [
                    'col' => 'wvasourcevisitorid',
                    'expr' => 'eq',
                    'val' => "{$webvisitorid}"
                ],
            ];

            $response = $contactApi->getByQuery($conPayload);

            // should be 1
            $count = count($response['contacts']);
            if ($count == 1)
            {
                $result = reset($response['contacts']); // take the first
                $return = $result['fields']['all'];
            } else
            {
                $resultcode = 'nok';
                $return = "counted {$count} results for wvasourcevisitorid={$webvisitorid}";
            }
        } catch (\Exception $ex) {
            echo $ex->getMessage();
            $return = $ex->getMessage();
        }

        return array(
            'resultcode' => $resultcode,
            'data' => $return
        );
    }

    /**
     * @param   string mauticContactId
     * @return  void
     */
    public function removeDnc($mauticContactId)
    {
        try {
            $contactApi = new ContactApi();
            $response = $contactApi->removeDnc($mauticContactId, 'email');
        } catch (\Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * @param   string mauticContactId
     * @return  void
     */
    public function addDnc($mauticContactId)
    {
        try {
            $contactApi = new ContactApi();
            $response = $contactApi->addDnc($mauticContactId, 'email', 1, null, 'Unsubscribed via vtiger');
        } catch (\Exception $ex) {
            echo $ex->getMessage();
        }
    }

    /**
     * @param   string mauticContactId
     * @return  void
     */
    public function getDnc($mauticContactId)
    {
        try {
            $contactApi = new ContactApi();
            $response = $contactApi->getDnc($mauticContactId);
        } catch (\Exception $ex) {
            echo $ex->getMessage();
        }
        return $response;
    }

    /**
     * @param   string mauticContactId
     * @param   string the note
     * @return  void
     */
    public function addNote($mauticContactId, $mauticNote)
    {
        try {
            $contactApi = new ContactApi();
            $response = $contactApi->addNote($mauticContactId, ['text' => "Wijzigingen uit vtiger verwerkt:\n" . $mauticNote, 'type' => 'general']);
        } catch (\Exception $ex) {
            echo $ex->getMessage();
            die();
        }
    }

    public function update($mauticContactId, $data, $createIfNotFound = false)
    {
        try {
            $contactApi = new ContactApi();
            $response = $contactApi->update($mauticContactId, $data, $createIfNotFound);
        } catch (\Exception $ex) {
            echo $ex->getMessage();
            die();
        }
        return $response;
    }

    /**
     * Get all stages
     */
    public function getStages()
    {   
        $cacheId = __FILE__ . __FUNCTION__;
        
        $stages == $this->cache->get($cacheId);
        //var_dump($stages);
                
        if (!$stages)
        {
            try {
                $contactApi = new ContactApi();
                $stages = $contactApi->getStages();
                //var_dump($stages);
            } catch (\Exception $ex) {
                echo $ex->getMessage();
                die();
            }
            $this->cache->save($stages, $cacheId);
        }

        return $stages;
    }

    /**
     * Add a contact to a stage
     */
    public function add2stage($mauticContactId, $stageid)
    {
        try {
            $contactApi = new ContactApi();
            $response = $contactApi->add2stage($mauticContactId, $stageid);
        } catch (\Exception $ex) {
            echo $ex->getMessage();
            die();
        }
        return $response;
    }

}
