<?php

namespace App;

use Mautic\Api\Api;
use Mautic\Auth\ApiAuth;
use Mautic\Auth\OAuth;
use Mautic\MauticApi;

class MauticApiConnect
{
    /**
     *
     * @var array 
     */
    protected $config = null;
    
    /**
     * Mautic authentication
     * 
     * @return array
     * @throws \Exception
     */
    protected function getAuth()
    {
        $this->configureCredentials();
        $authMethod = isset($this->config['AuthMethod']) ? $this->config['AuthMethod'] : 'OAuth';
        
        if (file_exists('config/config.tokens.php')) {
            $this->config = array_merge($this->config, include 'config/config.tokens.php');
        }
        
        $apiAuth = new ApiAuth();
        $auth = $apiAuth->newAuth($this->config, $authMethod);
        
        if ($authMethod != 'BasicAuth') {
            if (empty($this->config['refreshToken']) && !$auth->isAuthorized()) {
                $msg = 'Authorization failed. Check credentials in config/config.php.';
                //\Classes_Log::error(__CLASS__."::".__FUNCTION__." ".$msg);
                throw new \Exception($msg);
            } else {
                $auth->validateAccessToken();
                if ($auth->accessTokenUpdated()) {
                    $tokens = $auth->getAccessTokenData();
                    $tokens['accessToken'] = (isset($tokens['access_token'])) ? $tokens['access_token'] : null;
                    $tokens['accessTokenExpires'] = (isset($tokens['expires'])) ? $tokens['expires'] : null;
                    $tokens['refreshToken'] = (isset($tokens['refresh_token'])) ? $tokens['refresh_token'] : null;

                    file_put_contents('config/config.tokens.php', '<?php return '.var_export($tokens, true).';');
                }
            }
        }

        return array($auth, $this->config['apiUrl']);
    }
    
    /**
     * Get MauticApi with context
     * 
     * @param string $context
     * @return MauticApi
     */
    protected function getContext($context)
    {
        list($auth, $apiUrl) = $this->getAuth();
        $api = new MauticApi();

        return $api->newApi($context, $auth, $apiUrl);
    }
    
    /**
     * Configure credentials
     */
    protected function configureCredentials()
    {
      /**
        if (!file_exists('config/config.php')) {
            copy('config/config.php.dist', 'config/config.php');
            throw new \Exception('Configure authentication details in config/config.php');
        }        
        $this->config = include 'config/config.php';
        
        if ($this->config['AuthMethod']=='' || $this->config['baseUrl']=='') {
            throw new \Exception('Configure authentication details in config/config.php');
        }
      */
      global $WVAconfig;
      if (empty($WVAconfig)) {
      // echo getcwd();
              $this->config = require 'modules/Workflow/mautic/config/config.php';
      }
      else {
      
        $this->config = array(
            //Required BasicAuth,OAuth
            'AuthMethod'       => $WVAconfig->adapters->mautic->AuthMethod,
            'baseUrl'          => $WVAconfig->adapters->mautic->baseUrl,
            'apiUrl'           => $WVAconfig->adapters->mautic->apiUrl,
            
            //Required for BasicAuth method
            'userName'         => $WVAconfig->adapters->mautic->userName,
            'password'         => $WVAconfig->adapters->mautic->password,
                  
            // Required only for OAuth 1a
            'version'          => '',
            'accessTokenSecret'=> '',
            'requestTokenUrl'  => '',
        
            // Required only for OAuth 2
            'refreshToken'     => '',
            
            // Required for both OAuth 1a and 2 testing
            'accessToken'      => '',
            'clientKey'        => '',
            'clientSecret'     => '',
            'callback'         => '',
        );
      }
      //\Classes_Log::debug(__CLASS__."::".__FUNCTION__." config read: ".print_r($this->config, true));  
    }
}
