<?php

namespace App;

abstract class MauticAbstract extends MauticApiConnect
{
    /**
     *
     * @var MauticApi 
     */
    protected $api;
    
    /**
     *
     * @var string 
     */
    protected $apiContext;
    
    /**
     *
     * @var array 
     */
    protected $apiPayload;
    
    /**
     *
     * @var int
     */
    protected $identifier;
    
    /**
     * Create new record in mautic
     * 
     * @return array
     */
    protected function createExc()
    {
        return $this->api->create($this->apiPayload);
    }
    
    /**
     * Read a record from mautic
     * 
     * @return array
     */
    protected function readExc()
    {
        return $this->api->get($this->identifier);
    }
    
    /**
     * Update a record in mautic
     * 
     * @return array
     */
    protected function updateExc()
    {
        $createIfNotFound = true;
        return $this->api->edit($this->identifier, $this->apiPayload, $createIfNotFound);
    }
    
    /**
     * Delete a record in mautic
     * 
     * @return array
     */
    protected function deleteExc()
    {        
        return $this->api->delete($this->identifier);
    }
    
    /**
     * 
     * @param string $name
     * @param array $arguments
     * 
     * @return method
     */
    public function __call($name, $arguments)
    {
        $this->apiContext = $arguments[0];
        $this->identifier = $arguments[1];
        $this->errorHandler($name);
        if (in_array($name, ['create','update'])) {
            $this->{'payload'.ucfirst($name).ucfirst($this->apiContext)}();
        }
        $this->api = $this->getContext($this->apiContext);
        
        return $this->{$name.'Exc'}();
    }
    
    /**
     * 
     * @param string $name
     * @throws \Exception
     */
    protected function errorHandler($name)
    {
        if (!method_exists($this, 'payload'.ucfirst($name).ucfirst($this->apiContext)) && in_array($name, ['create','update'])) {
            $msg = 'Payload method for '.ucfirst($name).' in context '.ucfirst($this->apiContext).' not defined / Command not found';
            //\Classes_Log::error(__CLASS__."::".__FUNCTION__." ".$msg);
            throw new \Exception($msg);
        }
        if (!method_exists($this, $name.'Exc')) {
            $msg = 'Adapter action '.$name.' not found';
            //\Classes_Log::error(__CLASS__."::".__FUNCTION__."  ".$msg);
            throw new \Exception($msg);
        }
        if ($name!='create' && !$this->identifier) {
            $msg = 'Argument --id is required for this operation';
            //\Classes_Log::error(__CLASS__."::".__FUNCTION__."  ".$msg);
            throw new \Exception($msg);
        }
    }
    
    
    
}
