<?php

namespace App;

use Mautic\QueryBuilder\QueryBuilder;
use Vosba\Profiler;

class ContactApi extends MauticAbstract
{
    /**
     * method to addContact2Segments
     * 
     * @param int $mauticContactId
     * @param array $wvaSegments
     */
    public function addContact2Segments($mauticContactId, $wvaSegments) 
    {
        $this->api = $this->getContext('segments');
        $response = false;
        foreach ($wvaSegments as $segmentId) {
            $response[] = $this->api->addContact($segmentId, $mauticContactId);
        }
        
        return $response;
    }
    
    /**
     * method to removeContact4mSegments
     * 
     * @param int $mauticContactId
     * @param array $wvaSegments
     */
    public function removeContact4mSegments($mauticContactId, $wvaSegments) 
    {
        $this->api = $this->getContext('segments');
        $response = false;
        foreach ($wvaSegments as $segmentId) {
            $response[] = $this->api->removeContact($segmentId, $mauticContactId);
        }
        
        return $response;
    }
    
    /**
     * method to addDnc
     * 
     * @param int $mauticContactId
     * @param string $channel
     * @param int $reason | 1=>Contacts::UNSUBSCRIBED, 2=>Contacts::BOUNCED, 3=>Contacts::MANUAL
     * @param int $channelId | primary key of channel entity eg: 
     * @param text $comments
     */
    public function addDnc($mauticContactId, $channel, $reason = 3, $channelId = null, $comments = 'via API')
    {
        $this->api = $this->getContext('contacts');
        
        return $this->api->addDnc($mauticContactId, $channel, $reason, $channelId, $comments);
    }
    
    /**
     * method to removeDnc
     * 
     * @param int $mauticContactId
     * @param string $channel
     */
    public function removeDnc($mauticContactId, $channel = 'email')
    {
        $this->api = $this->getContext('contacts');
        
        return $this->api->removeDnc($mauticContactId, $channel);
    }

    /**
     * method to getDnc
     * @see https://developer.mautic.org/#get-stats-from-a-table
     * 
     * @param int $mauticContactId
     * @param string $channel
     */
    public function getDnc($mauticContactId)
    {
        $this->api = $this->getContext('stats');
        $table = 'lead_donotcontact';
        $start = 0;
        $limit = 2;
        $order = array(
            array(
              'col' => 'id',
              'dir' => 'asc'
            )
        );
        $where = array(
            array(
              'col' => 'lead_id',
              'expr' => 'eq',
              'val' => $mauticContactId,
            )
        );
        $result = $this->api->get($table, $start, $limit, $order, $where);
        if ($result['total'] > 0) {
            $dnc = $result['stats'][0];
        } else {
            $dnc = false;
        }
        return $dnc;
    }

    /**
     * method to addPoints
     * 
     * @param int $mauticContactId
     * @param int $pointsDelta
     * @param array $parameters | 'eventName' and 'actionName'
     */
    public function addPoints($mauticContactId, $pointsDelta, $parameters = array())
    {
        $this->api = $this->getContext('contacts');
        
        return $this->api->addPoints($mauticContactId, $pointsDelta, $parameters);
    }
    
    /**
     * method to subtractPoints
     * 
     * @param int $mauticContactId
     * @param int $pointsDelta
     * @param array $parameters | 'eventName' and 'actionName'
     */
    public function subtractPoints($mauticContactId, $pointsDelta, $parameters = array())
    {
        $this->api = $this->getContext('contacts');
        
        return $this->api->subtractPoints($mauticContactId, $pointsDelta, $parameters);
    }
    
    /**
     * method to addNote
     * 
     * @param int $mauticContactId
     * @param array $mauticNote | ['text' => '', 'type' => 'general']
     */
    public function addNote($mauticContactId, $mauticNote)
    {
        if (!is_array($mauticNote)) {
          $note = array(
            'text' => $mauticNote,
            'type' => 'general',
            'lead' =>  $mauticContactId
          );
        } 
        else {
          $note = $mauticNote;
          $note['lead'] = $mauticContactId;
        }
    
        $this->api = $this->getContext('notes');
        
        return $this->api->create($note);
    }
    
    /**
     * method to add contact to campaign
     * 
     * @param int $mauticContactId
     * @param int $mauticCampaignId
     */
    public function addToCampaign($mauticContactId, $mauticCampaignId)
    {
        $this->api = $this->getContext('campaigns');
        
        return $this->api->addContact($mauticCampaignId, $mauticContactId);
    }
    
    /**
     * method to remove contact from campaign
     * 
     * @param type $mauticContactId
     * @param type $mauticCampaignId
     */
    public function removeFromCampaign($mauticContactId, $mauticCampaignId)
    {
        $this->api = $this->getContext('campaigns');
        
        return $this->api->removeContact($mauticCampaignId, $mauticContactId);
    }
    
    /**
     * method get custom data with where filter
     * 
     * Argument passed must be an array, which should be mautic wherebuilder compatible array.
     * @see https://github.com/mautic/api-library/tree/master/lib/QueryBuilder
     * 
     * @param type $payload
     */
    public function getByQuery($payload)
    {
       // \Vosba_Profiler::enterSection(__CLASS__ . '::' . __FUNCTION__);
       // \Classes_Log::debug(__CLASS__."::".__FUNCTION__." payload: ".print_r($payload, true));

        $this->api = $this->getContext('contacts');
        $qb = new QueryBuilder();
        $whereBuilder = $qb->getWhereBuilder();
        foreach ($payload as $clause) {
            $whereBuilder->add($clause);
        }
        
        $response = $this->api->getCustomList($qb);
        //print_r($response);
       // \Classes_Log::debug(__CLASS__."::".__FUNCTION__." response: ".print_r($response, true));
       // \Vosba_Profiler::leaveSection(__CLASS__ . '::' . __FUNCTION__);
        
        return $response;
    }
    
    public function getIdentified($payload)
    {
        \Vosba_Profiler::enterSection(__CLASS__ . '::' . __FUNCTION__);
        \Classes_Log::debug(__CLASS__."::".__FUNCTION__." payload: ".print_r($payload, true));

        $this->api = $this->getContext('contacts');

        $response = $this->api->getIdentified($payload);
       // \Classes_Log::debug(__CLASS__."::".__FUNCTION__." response: ".print_r($response, true));
        \Vosba_Profiler::leaveSection(__CLASS__ . '::' . __FUNCTION__);
        
        return $response;
    }
    
    public function getList($payload)
    {
        \Vosba_Profiler::enterSection(__CLASS__ . '::' . __FUNCTION__);
        \Classes_Log::debug(__CLASS__."::".__FUNCTION__." payload: ".print_r($payload, true));

        $this->api = $this->getContext('contacts');

        $response = $this->api->getList($payload);
        
        \Vosba_Profiler::leaveSection(__CLASS__ . '::' . __FUNCTION__);
        
        return $response;
    }
    
    /**
     * get Segments
     *
     * @see https://developer.mautic.org/#list-contact-segments
     * 
     * @change 190418   Added during development of vtiger api 
     * @param   void
     * @return  array   all segments that are avavilable for API usage 
     */
    public function getSegments()
    {
        $this->api = $this->getContext('contacts');

        $response = $this->api->getSegments();

        return $response;
    }
    

    /**
     * Update
     *
     * @see https://developer.mautic.org/#edit-contact
     * 
     * @change 190504   Added during development of vtiger api 
     * @param   void
     * @return  array   all segments that are avavilable for API usage 
     */
    public function update($mauticContactId, $data,  $createIfNotFound = false)
    {
        $this->api = $this->getContext('contacts');

        $response = $this->api->edit($mauticContactId, $data, $createIfNotFound);

        return $response;
    }

    public function getstages()
    {
        $this->api = $this->getContext('stages');
        
        $searchFilter = '';
        $start = 0;
        $limit = 0;
        $orderBy = '';
        $orderByDir = 'ASC';
        $publishedOnly = false;
        $minimal = false;

        $response = $this->api->getlist($searchFilter, $start, $limit, $orderBy, $orderByDir, $publishedOnly, $minimal);
        
        $stages = array();
        
        if (count($response['total']) >0) 
        {

            foreach ($response['stages'] as $key => $data) {
                $stages[$data['name']] = array(
                    'id' => $data['id'],
                    'name' => $data['name'],
                    'category' => $data['category']['alias'],
                    'description' => $data['description']
                );
            }
        } else {
            $stages = $response;
        }

        return $stages;
    }
    
    public function add2stage($mauticContactId, $stageid)
    {
        $this->api = $this->getContext('stages');

        $response = $this->api->addContact($stageid, $mauticContactId);

        return $response;
    }
    
}