<?php

namespace App;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class ApiCommand extends Command
{
    /**
     * Configures the argument and options
     */
    protected function configure()
    {
        $this
            ->setName('execute:api')
            ->setDescription('Send third party data to mautic instance')
            ->addArgument('activity', InputArgument::IS_ARRAY | InputArgument::REQUIRED, 'Provide service to execute. eg: <fg=blue>vtiger contacts create</fg=blue>')
            ->addOption('id', null, InputOption::VALUE_OPTIONAL, 'Read/Update/Delete identifier. eg: <fg=blue>--id=75</fg=blue>')
        ;
    }

    /**
     * Executes the logic and creates the output.
     * 
     * @param InputInterface $input
     * @param OutputInterface $output
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $activity = $input->getArgument('activity');
        $id = $input->getOption('id');
        
        return $this->doProcess($activity, $id, $output);
    }
    
    
    /**
     * Do the process and return output.
     * 
     * @return string
     */
    public function doProcess($params, $id, OutputInterface $output)
    {
        try {
            $adapterClass = 'App\\'.ucfirst($params[0]);
            if (!class_exists($adapterClass)) {
                throw new \Exception('Adapter class '.$adapterClass.' not found');
            }
            $adapterObj = new $adapterClass;
            $response = $adapterObj->{$params[2]}($params[1], $id);
            $this->processOutput($output, $response, $params);
        } catch (\Exception $ex) {
            $output->writeln('<fg=red>'.$ex->getMessage().'</fg=red>');
        }
    }
    
    /**
     * Process output
     * 
     * @param type $response
     */
    public function processOutput(OutputInterface $output, $response, $params)
    {
        if ($response) {
            if (isset($response['errors'])) {
                if (isset($response['error_description'])) {
                    $output->writeln('<fg=red>Error! '. $response['error_description'] .'</fg=red>');
                } else {
                    $output->writeln('<fg=red>Error! '. implode(' - ',$response['errors'][0]) .'</fg=red>');
                }
            } else {
                if ($params[2] == 'read') {
                    print_r($response);
                }
                $output->writeln('<fg=green>Done -> '. join(' ',$params) .'</fg=green>');
            }
        } else {
            $output->writeln('<fg=red>Oops! Something went wrong.</fg=red>');
        }
    }
}
