<?php
use \Vosba\Profiler;

namespace App;

use Mautic\QueryBuilder\QueryBuilder;


class AccountApi extends MauticAbstract
{
    /**
     * method to addPoints
     * 
     * @param int $mauticAccountId
     * @param int $pointsDelta
     */
    public function addPoints($mauticAccountId, $pointsDelta)
    {
        if ($mauticAccountId == 0) {
          \Classes_Log::error(__CLASS__."::".__FUNCTION__." mauticAccountId: ".$mauticAccountId);
        }
    
        $this->api = $this->getContext('companies');
        $company = $this->api->get($mauticAccountId);
        
        if (!empty($company)) { 
          $point = $company['company']['score'] + $pointsDelta;
          
          return $this->api->edit($mauticAccountId, ['score' => $point], false);
        }
        else {
          \Classes_Log::error(__CLASS__."::".__FUNCTION__." error no info found for mauticAccountId: ".$mauticAccountId);
          return false;
        }

    }
    
    /**
     * method to subtractPoints
     * 
     * @param int $mauticAccountId
     * @param int $pointsDelta
     */
    public function subtractPoints($mauticAccountId, $pointsDelta)
    {
        if ($mauticAccountId == 0) {
          \Classes_Log::error(__CLASS__."::".__FUNCTION__." mauticAccountId: ".$mauticAccountId);
        }

        $this->api = $this->getContext('companies');
        $company = $this->api->get($mauticAccountId);
        $point = $company['company']['score'] - $pointsDelta;
        
        return $this->api->edit($mauticAccountId, ['score' => $point], false);
    }
    
    /**
     * method to addContact to company
     * 
     * @param int $mauticAccountId
     * @param int $mauticContactId
     */
    public function addContact($mauticAccountId, $mauticContactId)
    {
        if ($mauticAccountId == 0) {
          \Classes_Log::error(__CLASS__."::".__FUNCTION__." mauticAccountId: ".$mauticAccountId);
        }

        $this->api = $this->getContext('companies');
        
        return $this->api->addContact($mauticAccountId, $mauticContactId);
    }
    
    /**
     * method get custom data with where filter
     * 
     * Argument passed must be an array, which should be mautic wherebuilder compatible array.
     * @see https://github.com/mautic/api-library/tree/master/lib/QueryBuilder
     * 
     * @param type $payload
     */
    public function getByQuery($payload)
    {
        \Vosba_Profiler::enterSection(__CLASS__ . '::' . __FUNCTION__);
        \Classes_Log::debug(__CLASS__."::".__FUNCTION__." payload: ".print_r($payload, true));
          		
        $this->api = $this->getContext('companies');
        $qb = new QueryBuilder();
        $whereBuilder = $qb->getWhereBuilder();
        foreach ($payload as $clause) {
            $whereBuilder->add($clause);
        }
        
        $response = $this->api->getCustomList($qb);
        
//        \Classes_Log::debug(__CLASS__."::".__FUNCTION__." response: ".print_r($response, true));
        \Vosba_Profiler::leaveSection(__CLASS__ . '::' . __FUNCTION__);
                
        return $response;
    }
}