<?php

/**
 * Part of the WebVisitAnalyser
 *
 * PHP 5
 *
 * THIS IS COPYRIGHTED SOFTWARE, UNAUTORIZED USE WILL BE PROSECUTED.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * 
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is Vicus eBusiness Solutions.
 * All Rights Reserved.
 *
 * @copyright	(c)2018 Vicus eBusiness Solutions bv <www.vicus.nl>
 * @author		l.roovers <l.roovers@vicus.nl>
 * @package		Adapters
 * @category	Mautic
 * @version		$Id: Exp $
 */
Zend_Loader::loadClass('Adapters_Mautic');

use App\Mautic;
use App\ContactApi;

/**
 * Class Adapters_Mautic_Contacts
 *
 * Adapter for Mautic marketing automation
 * @author Luuk Roovers
 * @since	Version 1.0
 * @created 28-jun-2018 23:54:23
 */
class Adapters_Mautic_Contacts Extends Adapters_Mautic
{

    const MODULE = 'contacts';
    const MODULERESPONSE = 'contact';

    function __construct()
    {
        Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__);
        parent::__construct();
    }

    public function addVisitToCRM()
    {
        
    }

    /**
     * find the record in Mautic CRM
     * 1) by WVA source visitor ID
     * 2) by IP
     * @param   array
     * @param   string  date / time stamp like: Webvisitreport 2019-04-09 09:00:50 visitId: 17797
     * @return  array|boolean   response array contains data of the visitor
     */
    public function getFromCRM($data = array(), $timestamp = '')
    {

        if (empty($data['wvasourcevisitorid']))
        {
            Classes_Log::info(__CLASS__ . "::" . __FUNCTION__ . " - parameter (wvasourcevisitorid) is empty");
            $response = false;
//		  return false;
        } else
        {
            // define the query params
            $wvasourcevisitorid = $data['wvasourcevisitorid'];

            $response = $this->findByVisitorId($wvasourcevisitorid);
        }

        if (!$response || (isset($response['total']) && $response['total'] == 0))
        {
            global $WVAconfig;
            $prefix = $WVAconfig->adapters->vtigercrm->leads->fieldname->lastname->prefix;
            // check if a general contact with 'Directie van [comapnyname' already exists
            $searchstring = $prefix.$data['company'];
            $response = $this->findByLastnamePrefix($searchstring);
        }

        //Classes_Log::debug(__CLASS__."::".__FUNCTION__." - response: ".print_r($response,true)." -> let op we kregen hier ooit een Notice: Undefined index: total in /home/cs1005/public_html/webvisitanalyser-1.0.0/Adapters/Mautic/Contacts.php on line 76");
        // Classes_Log::debug(__CLASS__."::".__FUNCTION__." - data: ".print_r($data,true));
        // data: Array ( [lastname] => Directie van Van Breda B.V. [ipAddress] => 31.149.194.66 [phone] => 0575568100 [company] => Van Breda B.V. [website] => www.vanbreda.nl [wvasource] => Google [wvasourcevisitorid] => 1f95c242 [segments] => [tags] => [score] => 10 )

        if (!$response || (isset($response['total']) && $response['total'] == 0))
        {
            if (empty($data['ipAddress']))
            {
                Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - cannot use empty ipAddress, data: " . print_r($data, true));
                return false;
            } else
            {
                $ip = $data['ipAddress'];
                $response = $this->findByVisitorIp($ip);
                
                $timeWebVisit = new Datetime($timestamp);
                
                if ($response['total'] == 1)
                {
                    Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - 1 record found by ip:" . $ip);

                    $mauticContact = reset($response['contacts'] ); // First Element's Value
                    $timeMautic = new Datetime($mauticContact['dateModified']);

                    // @change T30615
                    if (!$this->timeInFrame($timeWebVisit, $timeMautic, 60)) {
                        $response = false;
                    }

                } elseif (isset($response['total']) && $response['total'] > 0)
                {
                    $responsetext = '';
                    $response = false;
                    $responseCounter == 0;
                    foreach ($response['contacts'] as $id => $responseData)
                    {
                        $responsetext .= print_r($responseData['fields']['all'], true);

                        // @change T30615
                        if (!$this->timeInFrame($timeWebVisit, $timeMautic, 60)) {
                            $response = $responseData;
                            $responseCounter++;
                        }
                    }
                    if ($responseCounter >1) {
                        // so  we found 1+ hits in same timeframe
                        Classes_Log::critical(__CLASS__ . "::" . __FUNCTION__ . " - NOT LINKED {$response['total']} record(s) ({$responseCounter} in same timeframe) found by ip:" . $ip . " details: {$responsetext}");
                        $response = false;
                    } elseif(!$response) 
                    {
                        Classes_Log::critical(__CLASS__ . "::" . __FUNCTION__ . " - NOT LINKED {$response['total']} record(s) found by ip:" . $ip . " details: {$responsetext}");
                    }
                }
            }
        } else
        {
            Classes_Log::info(__CLASS__ . "::" . __FUNCTION__ . " - found by wvasourcevisitorid: " . $wvasourcevisitorid);
        }

        // how do we ensure that the ipnumber in Mautic fits this visit? we assume they fit in a timeframe
        // eg +/- 10 minutes
        // any other way to look?
        // makes no sense since SalesFeed has no visitornames !	  
        return $response;
    }

    /**
     * @change T30615
     * @param string  date/time string
     * @param integer Minutes minus
     * @param integer Minutes plus
     */
    private function timeInFrame($timeWebVisit, $timeMautic, $minDiff = 10)
    {

        $diff = abs($timeWebVisit->getTimestamp() - $timeMautic->getTimestamp())/60; // we dont care about +/- only the difference in minutes
        Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - timestamps to be compared WVA:{$timeWebVisit->format('Y-m-d\TH:i:s\Z')}/{$timeWebVisit->getTimestamp()},  Mautic:{$timeMautic->format('Y-m-d\TH:i:s\Z')}/{$timeMautic->getTimestamp()}, Diff:{$diff} minutes");

        if ($diff < $minDiff)
        {
            Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - time is within frame {$minDiff}");
            return true;
        } else
        {
            Classes_Log::info(__CLASS__ . "::" . __FUNCTION__ . " - time is NOT within frame {$minDiff}");
            return false;
        }
    }

    private function findByVisitorId($id)
    {
        $contactApi = new ContactApi();

        $conPayload = Array(
            array(
                'col' => 'orX',
                'expr' => 'orX',
                'val' => array(
                    array(
                        'col' => 'wvasourcevisitorid',
                        'expr' => 'eq',
                        'val' => "{$id}"
                    )
                )
            )
        );

        $response = $contactApi->getByQuery($conPayload);
        
        if ($response && $response['total'] > 0)
        {
            Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - found {$response['total']} results");
        }

        return $response;
    }

    private function findByLastnamePrefix($string)
    {
        $contactApi = new ContactApi();

        $conPayload = Array(
            array(
                'col' => 'orX',
                'expr' => 'orX',
                'val' => array(
                    array(
                        'col' => 'lastname',
                        'expr' => 'eq',
                        'val' => "{$string}"
                    )
                )
            )
        );

        $response = $contactApi->getByQuery($conPayload);
        
        if ($response && $response['total'] > 0)
        {
            Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - found {$response['total']} results");
        }
        
        return $response;
    }

    /**
     * find by IP
     * Mautic can use as well ip:xxx alone 
     * as combined with is:anonymous
     * @todo: see if result is withing expected timeframe
     */
    private function findByVisitorIp($ip)
    {
        $contactApi = new ContactApi();
        $response = $contactApi->getIdentified("ip:{$ip}");

        if ($response && $response['total'] == 0)
        {
            Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " not foud by ip:{$ip} now try including using getList ip:{$ip} is:anonymous");
            $response = $contactApi->getList("ip:{$ip} is:anonymous");
        }
        
        if ($response && $response['total'] > 0)
        {
            Classes_Log::debug(__CLASS__ . "::" . __FUNCTION__ . " - found {$response['total']} results");
        }

        return $response;
    }

    public function addDnc($mauticContactId, $channel, $reason = 3, $channelId = null, $comments = 'via API')
    {
        $contactApi = new ContactApi();
        return $response = $contactApi->addDnc($mauticContactId, $channel, $reason, $channelId, $comments);
    }

    public function removeDnc($mauticContactId, $channel = 'email')
    {
        $contactApi = new ContactApi();
        return $response = $contactApi->removeDnc($mauticContactId, $channel);
    }

    public function addPoints($mauticContactId, $pointsDelta, $parameters = array())
    {
        $contactApi = new ContactApi();
        return $response = $contactApi->addPoints($mauticContactId, $pointsDelta, $parameters);
    }

    public function subtractPoints($mauticContactId, $pointsDelta, $parameters = array())
    {
        $contactApi = new ContactApi();
        return $response = $contactApi->subtractPoints($mauticContactId, $pointsDelta, $parameters);
    }

    public function addNote($mauticContactId, $mauticNote)
    {
        $contactApi = new ContactApi();
        return $response = $contactApi->addNote($mauticContactId, $mauticNote);
    }

    /**
     * @todo do we want to store the labels here to be able to validate all data?
     */
    protected function _getMapping()
    {

        $mapping = array(
            // WVA fieldname -> Mautic fieldname
//			'salutationtype' => 'salutationtype',
            'firstname' => 'firstname',
            'lastname' => 'lastname',
            'ipnumber' => 'ipAddress',
            'phone' => 'phone',
//@todo			'mobile' => 'mobile',
//@todo			'account_id' => 'account_id',
//			'homephone' => 'homephone',
//@todo fixed			'leadsource' => 'leadsource',
//			'otherphone' => 'otherphone',
//			'title' => 'title',
//			'birthday' => 'birthday',
//@todo			'email' => 'email',
//			'assistant' => 'assistant',
//@todo			'emailoptout' => 'emailoptout',
            'mailingstreet' => 'address1',
            'mailingzip' => 'zipcode',
            'mailingcity' => 'city',
//			'mailingstate' => 'state',
            'mailingcountry' => 'country',
            'name' => 'company',
            'website' => 'website',
//			'description' => 'description',
            // WebVisitAnalyser 
            'wv_scoregroups ' => 'wvascoregroups',
            'source' => 'wvasource',
            'source_visitor_id' => 'wvasourcevisitorid',
            'segments' => 'segments',
            'tags' => 'tags',
            'score' => 'score',
//@todo		'wv_follow' => 'wv_follow',
//@todo		'wv_force' => 'wv_sfforce',
        );
        return $mapping;
    }

    /**
     * @todo do we want to store the labels here to be able to validate all data?
     */
    public function getTestdata()
    {

        $data = array(
            // WVA fieldname -> vtiger CRM fieldname
//			'contact_id' => 'contact_id', // autoincr
//			'contact_no' => 'contact_no', // autofill
            'salutationtype' => 'heer',
            'firstname' => 'Firstname',
            'lastname' => 'Lastname',
            'phone' => '+31334611196',
            'mobile' => '+31642301865',
//?			'account_id' => 'account_id', // @todo dit is interesseant, wellicht pas invullen als we account inserten
            'homephone' => '+31334611196',
            'leadsource' => 'Koud bellen',
            'otherphone' => '+31334611196',
            'title' => 'Title',
            'fax' => '+31334611196',
            'department' => 'Afdeling',
            'birthday' => '01-01-2012', // @todo - check if formatting is correct
            'email' => 'sales@vicus.nl',
            'assistant' => 'assistant',
            'secondaryemail' => 'sales2@vicus.nl',
            'assistantphone' => '+31334611196',
            'donotcall' => false,
            'emailoptout' => true,
            'assigned_user_id' => $this->_assigned2username,
            'reference' => true,
            'notify_owner' => false,
//			'createdtime' => 'createdtime',
//			'modifiedtime' => 'modifiedtime',
//			'modifiedby' => 'modifiedby',
            'portal' => false, // be sure to keep this empty, else vtiger will send a welcome email for the portal!
            'support_start_date' => Date("Y-m-d"),
            'support_end_date' => "2050-12-31",
            'mailingstreet' => 'Amsterdamseweg 16',
            'otherstreet' => 'Amsterdamseweg 16',
            'mailingcity' => 'Amersfoort',
            'othercity' => 'Amersfoort',
            'mailingstate' => 'Utrecht',
            'otherstate' => 'Utrecht',
            'mailingzip' => '3812 RS',
            'otherzip' => '3812 RS',
            'mailingcountry' => 'Nederland',
            'othercountry' => 'Nederland',
            'mailingpobox' => 'Postbus 21',
            'otherpobox' => 'Postbus 21',
            'imagename' => 'imagename', // @todo - wat invullen? logo Vicus :-)
            'description' => 'Testgeval WebVisitAnalyser',
            'isconvertedfromlead' => false,
//			'created_user_id' => '',	
            // WebVisitAnalyser own fields
            'wv_wvaconid' => 'WVATESTCASECONTACT01',
            //'cf_967' => 'WVATESTCASECONTACT01', // @todo replace by real fieldname
            // WebVisitAnalyser calculated fields
            'wv_score' => 99,
            'wv_searchterms' => 'zoeken',
            'wv_datefirstvisit' => '01-01-1970',
            'wv_lastvisitdate' => '01-02-2015',
            'wv_sourcefirstvisit' => 'v-tiger.nl',
            'wv_allsources' => 'v-tiger.nl',
            'wv_nofvisits' => 4,
            'wv_nofpages' => 12,
//			'wv_scoregroups' => 'Contacts',
            'wv_ratinggroups' => 'Contacts',
        );
        return $data;
    }

}

?>