<?php
/**
 * Part of the WebVisitAnalyser
 *
 * PHP 5
 *
 * THIS IS COPYRIGHTED SOFTWARE, UNAUTORIZED USE WILL BE PROSECUTED.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * 
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is Vicus eBusiness Solutions.
 * All Rights Reserved.
 *
 * @copyright	(c)2018 Vicus eBusiness Solutions bv <www.vicus.nl>
 * @author		l.roovers <l.roovers@vicus.nl>
 * @package		Adapters
 * @category	Mautic
 * @version		$Id: Exp $
 */

//namespace WebVisitAnalyser\Adapters\VtigerCRM;
Zend_Loader::loadClass('Adapters_Mautic');

/**
 * Class Adapters_Mautic_Accounts
 *
 * Adapter for Mautic marketing automation
 * @author Luuk Roovers
 * @since	Version 1.0
 * @created 28-jun-2018 23:54:23
 */
class Adapters_Mautic_Campaigns extends Adapters_Mautic
{

	const MODULE = 'Campaigns';

	function __construct()
	{
		Classes_Log::debug(__CLASS__."::".__FUNCTION__);
		parent::__construct();
	}

	/**
	 * Adds a visit to CRM
	 */
	public function addVisitToCRM()
	{
	}

	/**
	 * Gets a single Campaign from CRM
	 * use specific fieldname? eg cocnumber
	 * or sourcename/source_id (eg Salesfeed, salesfeed_id)
	 * @todo cf_975 -> wv_wvacamid
	 */
	public function getFromCRM($data = array())
	{
//		$wv_sforgid 	= $data['wv_sforgid'];
//		$wv_sfcocnumber = $data['wv_sfcocnumber'];
		// salesfeed 
//		$where = "wv_sforgid = '{$wv_sforgid}' OR wv_sfcocnumber = '{$wv_sfcocnumber}'"; 
//		$where = "cf_975 = '{$data['cf_975']}'";
		$where = "wv_wvacamid = '{$data['wv_wvacamid']}'";
		
		return $this->getByQuery(self::MODULE,$where);
	}

	/**
	 * @todo do we want to store the labels here to be able to validate all data?
	 */
	protected function _getMapping()
	{
		// WVA fieldname -> vtiger CRM fieldname
		$mapping= array(
			// core fields
			'id' => 'id',
			'campaign_no' => 'campaign_no',
			'campaignname' => 'campaignname',
			'campaigntype' => 'campaigntype',
			'product_id' => 'product_id',
			'campaignstatus' => 'campaignstatus',
			'closingdate' => 'closingdate',
			'assigned_user_id' => 'assigned_user_id',
			'numsent' => 'numsent',
			'sponsor' => 'sponsor',
			'targetaudience' => 'targetaudience',
			'targetsize' => 'targetsize',
			'createdtime' => 'createdtime',
			'modifiedtime' => 'modifiedtime',
			'modifiedby' => 'modifiedby',
			'expectedresponse' => 'expectedresponse',
			'expectedrevenue' => 'expectedrevenue',
			'budgetcost' => 'budgetcost',
			'actualcost' => 'actualcost',
			'expectedresponsecount' => 'expectedresponsecount',
			'expectedsalescount' => 'expectedsalescount',
			'expectedroi' => 'expectedroi',
			'actualresponsecount' => 'actualresponsecount',
			'actualsalescount' => 'actualsalescount',
			'actualroi' => 'actualroi',
			'description' => 'description',
			
			// WebVisitAnalyser fields
			
			'wv_wvacamid' => 'wv_wvacamid',
			
			'wv_score' => 'wv_score',
			'wv_searchterms' => 'wv_searchterms',
			'wv_datefirstvisit' => 'wv_datefirstvisit',
			'wv_lastvisitdate' => 'wv_lastvisitdate',
			'wv_sourcefirstvisit' => 'wv_sourcefirstvisit',
			'wv_allsources' => 'wv_allsources',
			'wv_nofvisits' => 'wv_nofvisits',
			'wv_nofpages' => 'wv_nofpages'
		);
		return $mapping;
	}
	
	/**
	 * @todo do we want to store the labels here to be able to validate all data?
	 * @todo cf_975 -> wv_wvacamid
	 */
	public function getTestdata()
	{
	
		$data = array(
			// WVA fieldname -> vtiger CRM fieldname
			// core fields
//			'id' => 'id',
//			'campaign_no' => 'campaign_no',
			'campaignname' => 'WVA TEST Campaignname',
			'campaigntype' => 'Others',
			'product_id' => false,
			'campaignstatus' => 'Active',
			'closingdate' => Date("Y-m-d"),
			'assigned_user_id' => $this->_assigned2username,
			'numsent' => 80,
			'sponsor' => 'Sponsor van de campagne',
			'targetaudience' => 'Doelgroep van de campagne',
			'targetsize' => 200,
//			'createdtime' => 'createdtime',
//			'modifiedtime' => 'modifiedtime',
//			'modifiedby' => 'modifiedby',
			'expectedresponse' => 'Expected response',
			'expectedrevenue' => 100000,
			'budgetcost' => 10000,
			'actualcost' => 20000,
			'expectedresponsecount' => 100,
			'expectedsalescount' => 50,
			'expectedroi' => 20,
			'actualresponsecount' => 90,
			'actualsalescount' => 30,
			'actualroi' => 10,
			'description' => 'WVA TEST Description - record created to test WebVisitAnalyser',

			'wv_wvacamid' => 'WVATESTCASECAMPAIGN01',
			//'cf_975' => 'WVATESTCASECAMPAIGN01', // @todo replace by real fieldname
			
			// WebVisitAnalyser fields
			'wv_score' => 10,
			'wv_searchterms' => 'zoekterm',
			'wv_datefirstvisit' => '01-02-1970',
			'wv_lastvisitdate' => '01-03-1990',
			'wv_sourcefirstvisit' => 'vicus.nl',
			'wv_allsources' => 'vicus.nl',
			'wv_nofvisits' => 5,
			'wv_nofpages' => 25,
//			'wv_scoregroups' => 'Klant',
//			'wv_companyinformation' => 'Information over this account/organisation. Collected by external sources.',
//			'wv_contactinformation' => 'Information how to contact this account/organisation. Collected by external sources.',
		);
		return $data;
	}
	
}
?>