<?php
/**
 * Part of the WebVisitAnalyser
 *
 * PHP 5
 *
 * THIS IS COPYRIGHTED SOFTWARE, UNAUTORIZED USE WILL BE PROSECUTED.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * 
 * You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is Vicus eBusiness Solutions.
 * All Rights Reserved.
 *
 * @copyright	(c)2018 Vicus eBusiness Solutions bv <www.vicus.nl>
 * @author		l.roovers <l.roovers@vicus.nl>
 * @package		Adapters
 * @category	Mautic
 * @version		$Id: Exp $
 */

//namespace WebVisitAnalyser\Adapters\VtigerCRM;
Zend_Loader::loadClass('Adapters_Mautic');

use App\Mautic;
use App\AccountApi;

/**
 * Class Adapters_Mautic_Accounts
 *
 * Adapter for Mautic marketing automation
 * @author Luuk Roovers
 * @since	Version 1.0
 * @created 28-jun-2018 23:54:23
 */
class Adapters_Mautic_Accounts extends Adapters_Mautic
{

    const MODULE = 'companies';
    const MODULERESPONSE = 'company';

    private	$_fieldnameCoC = false;

    private	$_fieldnameSfCoC = false;

    private	$_filterByNameAndPC = false;

    function __construct()
    {
            Classes_Log::debug(__CLASS__."::".__FUNCTION__);

            global $WVAconfig;

            if ( isset($WVAconfig->adapters->mautic->accounts->fieldname->coc) )
                    $this->_fieldnameCoC = $WVAconfig->adapters->mautic->accounts->fieldname->coc;

            if ( isset($WVAconfig->adapters->mautic->accounts->fieldname->coc) )
                    $this->_fieldnameSfCoC = $WVAconfig->adapters->mautic->accounts->fieldname->sfcoc;

            if ( isset($WVAconfig->adapters->mautic->accounts->filter->bynameandpc) )
                    $this->_filterByNameAndPC = $WVAconfig->adapters->mautic->accounts->filter->bynameandpc;

            parent::__construct();
    }

    /**
     * Adds a visit to CRM
     */
    public function addVisitToCRM()
    {
    }

    /**
     * Gets a single Account from CRM
     * use specific fieldname? eg cocnumber
     * or sourcename/source_id (eg Salesfeed, salesfeed_id)
     * 
     * @param	array	data
     * @return	array|boolean	data (or false)
     */
    public function getFromCRM($data = array(), $timestamp = '')
    {
        $aWhere = array();
        $where = '';

        // sf orgid    
        // or wva orgid
        // or Salesfeed CoC number field in Mautic
        // or CoC number field in Mautic

        // different peace of cake here
        $sfcocnumber = $data['sfcocnumber'];
        $wvaorgid = $data['wvaorgid'];
        $sforgid = $data['sforgid'];
        //print_r($data);

        $result = $this->findByIdnumbers($sfcocnumber, $wvaorgid, $sforgid);

        // If not found by the id numbers try Account name + Postal Code
        $zipcode = str_replace(' ','',$data['companyzipcode']);  // remove blanks
        $companyname = $data['companyname'];

        if (!$result AND $this->_filterByNameAndPC AND !empty( $companyname) AND strlen( $zipcode ) >5 ) 
        {
            $result = $this->findByNameAndPoco($data['companyname'], $zipcode);
        }

        return $result;

    }
    
    private function findByIdnumbers($sfcocnumber, $wvaorgid, $sforgid) 
    {
    
        $accountApi = new AccountApi();
    
        $val1 = '';
        $val2 = '';
        $sfcocnumberTrim = ltrim($sfcocnumber,'0');

        $accPayload = Array(
          array(
                'col' => 'orX',
                'expr' => 'orX',
                'val' => array(
                    array(
                        'col' => 'wvaorgid',
                        'expr' => 'eq',
                        'val' => "{$wvaorgid}"
                   ),
                    array(
                        'col' => 'sforgid',
                        'expr' => 'eq',
                        'val' => "{$sforgid}"
                   ),
                   
                ),
            ),
      );


        if($this->_fieldnameSfCoC and !empty( $sfcocnumber)) 
        {

          $accPayload[0]['val'][] = array(
                'col' => 'sfcocnumber',
                'expr' => 'eq',
                'val' => "{$sfcocnumber}"
              );
          $accPayload[0]['val'][] = array(
                'col' => 'sfcocnumber',
                'expr' => 'eq',
                'val' => "{$sfcocnumberTrim}"
              );
        }

        // or Custom field as set in configuration	    
        if ( $this->_fieldnameCoC and !empty( $sfcocnumber)) 
        {

          $accPayload[0]['val'][] = array(
                'col' => 'cocnumber',
                'expr' => 'eq',
                'val' => "{$sfcocnumber}"
              );

          $accPayload[0]['val'][] = array(
                'col' => 'cocnumber',
                'expr' => 'eq',
                'val' => "{$sfcocnumberTrim}"
            );
        }
        
        
    $accxPayload = [
        [
            'col' => 'orX',
            'expr' => 'orX',
            'val' => [
                [
                    'col' => 'wvaorgid',
                    'expr' => 'eq',
                    'val' => '5107'
                ],
                [
                    'col' => 'sforgid',
                    'expr' => 'eq',
                    'val' => '4561972'
                ],
                
                
            ]            
        ]
    ];
        
        $response = $accountApi->getByQuery($accPayload);

        return $response;
    }

  function findByNameAndPoco($companyname, $zipcode)
  {
    $result = false;
    $accountApi = new AccountApi();
    
    // Json Spes say you can escape ' as \u0027, not that you can escape it as \'
    // name can contain " or '
    $companyname = str_ireplace("'","\u0027",$data['companyname']);
    // format AAAA ##
    $zipcode = substr($zipcode,0,4)." ".substr($zipcode,4,2);

    // without the dots
    $patterns = array();
    $replacements = array();
    $patterns = array('/B.V./','/V.O.F./','/N.V./');
    $replacements = array('BV','VOF','NV');
    $companynameNodots = preg_replace($patterns, $replacements, $companyname);	

    $accPayload = Array(
      array(
        'col' => 'andX',
        'expr' => 'andX',
        'val' => array(
            array(
                'col' => 'orX',
                'expr' => 'orX',
                'val' => array(
                    array(
                        'col' => 'companyzipcode',
                        'expr' => 'eq',
                        'val' => "{$zipcode}"
                    ),
                    array(
                        'col' => 'companyzipcode',
                        'expr' => 'eq',
                        'val' => "{$zipcodeNospace}"
                    ),
                ),
            ),
            array(
                'col' => 'orX',
                'expr' => 'orX',
                'val' => array(
                    array(
                      'col' => 'companyname',
                      'expr' => 'eq',
                      'val' => "{$companyname}",
                    ),
                    array(
                      'col' => 'companyname',
                      'expr' => 'eq',
                      'val' => "{$companynameNodots}"
                    ),
                ),
            ),
        ),
      ),
    );
    
    $response = $accountApi->getByQuery($accPayload);
    return $response;
    }

    public function addPoints($mauticAccountId, $pointsDelta)
    {
      $accountApi = new AccountApi();
      return $response = $accountApi->addPoints($mauticAccountId, $pointsDelta);
    }
    
    public function subtractPoints($mauticAccountId, $pointsDelta)
    {
      $accountApi = new AccountApi();
      $response = $accountApi->subtractPoints($mauticAccountId, $pointsDelta);
    }

    public function addContact($mauticAccountId, $mauticContactId)
    {
      $accountApi = new AccountApi();
      $response = $accountApi->addContact($mauticAccountId, $mauticContactId); 
    }

    /**
     * Get Mapping of database fields
     * 
     * WebVisitAnalyser database fieldname => vtiger fieldname
     * 
     * @todo	disabled all fields that are not available in wva database
     * @todo	do we want to store the labels here to be able to validate all data?
     * 
     * @see	Adapters_Mautic::mapData
     * @see	Adapters_Salesfeed_Visitreports::Load
     * 
     * @return	array	contains mapping
     */
    protected function _getMapping()
    {
    /*
                    'organisation_id' => $visit['organisation_id'],
                    'source' => "WebVisitAnalyser", // $visit['source'],
                    'source_id' => $visit['source_id'],
                    'name' => $visit['name'],
                    'coc_number' => $visit['coc_number'], // kvknummer
                    'sbi_code' => $visit['sbi_code'],
                    'branche' => $visit['branche'],
                    'employees' => $visit['employees'],
                    'employees_range' => $visit['employees_range'],
                    'street' => $visit['street'],
                    'zipcode' => $visit['zipcode'],
                    'city' => $visit['city'],
                    'website' => $visit['website'],
                    'phone' => $visit['phone'],
                    'segments' => $visit['segments'],
                    'tags' => $visit['tags'],
                    'creditrating' => $visit['creditrating'],
    */


            $mapping= array(

            // 	Salesfeed field => Mautic field

                    // core fields
            //	'account_id' => 'account_id',
            //	'account_no' => 'account_no',
                    'name' => 'companyname',
                    'phone' => 'companyphone',
                    'website' => 'companywebsite',
            //	'email1' => 'companyemail',
                    'employees' => 'employees',
            //	'rating' => 'rating',
            //@	'industry' => 'industry',
            //@	'accounttype' => 'accounttype',
            //	'annual_revenue' => 'annual_revenue',
            //@	'emailoptout' => 'emailoptout',
            //	'notify_owner' => 'notify_owner',
            //	'assigned_user_id' => 'assigned_user_id',
            //	'createdtime' => 'createdtime',
            //	'modifiedtime' => 'modifiedtime',
            //	'modifiedby' => 'modifiedby',
            //	'bill_street' => 'bill_street',
                    'street' => 'companyaddress1',
            //	'bill_city' => 'bill_city',
                    'city' => 'companycity',
            //	'bill_state' => 'bill_state',
            //	'ship_state' => 'ship_state',
            //	'bill_code' => 'bill_code',
                    'zipcode' => 'companyzipcode',
            //	'bill_country' => 'bill_country',
                    'country' => 'companycountry',
            //	'bill_pobox' => 'bill_pobox',
            //	'ship_pobox' => 'ship_pobox',
              'description' => 'companydescription',
            //	'isconvertedfromlead' => 'isconvertedfromlead',
            //	'created_user_id' => 'created_user_id',

                    'organisation_id' => 'wvaorgid',

                    // WebVisitAnalyser fields
                    /* autocalculated, so just skip
                    'wv_score' => 'wv_score',
                    'wv_searchterms' => 'wv_searchterms',
                    'wv_datefirstvisit' => 'wv_datefirstvisit',
                    'wv_lastvisitdate' => 'wv_lastvisitdate',
                    'wv_sourcefirstvisit' => 'wv_sourcefirstvisit',
                    'wv_allsources' => 'wv_allsources',
                    'wv_nofvisits' => 'wv_nofvisits',
                    'wv_nofpages' => 'wv_nofpages',
                    'wv_scoregroups' => 'wv_scoregroups',
                    'wv_companyinformation' => 'wv_companyinformation',
                    */
                    'source_id' => 'sforgid',
//@todo		'segments' => 'wv_picklist_sfsegments',
            // filled in Modules\Queue.php line 1180
                    'sbi_code' => 'sbi_code',
                    'isic2' => 'isic2_code',
//@todo		'snaisic' => 'wv_snaisic',
//@todo		'snaisicdescr' => 'wv_snaisicdescr',
  'tags' => 'tags',
                    'branche' => 'sbi_text',
                    'coc_number' => 'sfcocnumber',
//@todo		'employees_range' => 'wv_picklist_sfemployeesrange',
//@todo		'wv_follow' => 'wv_follow',
//@todo		'wv_force' => 'wv_sfforce',
                    'creditrating' => 'creditrating',
            );
            return $mapping;
    }

    /**
     * @todo do we want to store the labels here to be able to validate all data?
     */
    public function getTestdata()
    {
            $data = array(
                    // WVA fieldname -> Mautic fieldname
                    // core fields
                    'accountname' => 'WVA TEST Accountname',
                    'phone' => '+31334611196',
                    'website' => 'www.vicus.nl',
                    'fax' => '+31334611196',
                    'tickersymbol' => 'VEB',
                    'otherphone' => '+31334611196',
                    'email1' => 'sales@vicus.nl',
                    'employees' => '10',
                    'email2' => 'sales2@vicus.nl',
                    'ownership' => 'Eigenaars',
                    'rating' => 'Aktief',
                    'industry' => 'Kleding',
                    'siccode' => '94997',
                    'accounttype' => 'Klant',
                    'annual_revenue' => '100000',
                    'emailoptout' => true,
                    'notify_owner' => true,
                    'assigned_user_id' => $this->_assigned2username,
//			'createdtime' => 'createdtime',
//			'modifiedtime' => 'modifiedtime',
//			'modifiedby' => 'modifiedby',
                    'bill_street' => 'Amsterdamseweg 16',
                    'ship_street' => 'Amsterdamseweg 16',
                    'bill_city' => 'Amersfoort',
                    'ship_city' => 'Amersfoort',
                    'bill_state' => 'Utrecht',
                    'ship_state' => 'Utrecht',
                    'bill_code' => '3812 RS',
                    'ship_code' => '3812 RS',
                    'bill_country' => 'Nederland',
                    'ship_country' => 'Nederland',
                    'bill_pobox' => 'Postbus 21',
                    'ship_pobox' => 'Postbus 21',
                    'description' => 'Test case description',
                    'isconvertedfromlead' => true,
//			'created_user_id' => 'created_user_id',

                    'wv_wvaorgid' => 'WVATESTCASEACCOUNT01',
                    //'cf_969' => 'WVATESTCASEACCOUNT01', // @todo replace by real fieldname

                    // WebVisitAnalyser fields
                    'wv_score' => 10,
                    'wv_searchterms' => 'zoekterm',
                    'wv_datefirstvisit' => '01-02-1999',
                    'wv_lastvisitdate' => '01-05-2015',
                    'wv_sourcefirstvisit' => 'vicus.nl',
                    'wv_allsources' => 'vicus.nl',
                    'wv_nofvisits' => 5,
                    'wv_nofpages' => 25,
//			'wv_scoregroups' => 'Klant',
                    'wv_ratinggroups' => 'Klant',
                    'wv_companyinformation' => 'Information over this account/organisation. Collected by external sources.',
                    'wv_contactinformation' => 'Information how to contact this account/organisation. Collected by external sources.',

                    // WVA Salesfeed
                    'wv_sforgid' => '375833',
                    'wv_sfsegments' => 'leads |##| klanten', // multiselect! |##| beiden fout!
                    'wv_sftags' => 'Test |##| CRM', // multiselect!
                    'wv_sfsbi' => '94997',
                    'wv_sfbranche' => 'Overige belangenbehartiging n.e.g.',
                    'wv_sfcocnumber' => '30180920',
                    'wv_sfemployeesrange' => '20-49', // fails if multiselect not available
                    'wv_follow' => true,
                    'wv_snoobiorgid' => 'SnoobiId'
            );
            return $data;
    }
}
?>