<?php

ini_set('include_path', get_include_path() . ':../');
require_once 'config.php';
require_once 'include/utils/utils.php';
include_once 'include/utils/CommonUtils.php';
include_once 'include/database/PearDatabase.php';
require_once('data/CRMEntity.php');
require_once 'modules/Kingdealers/Kingdealers.php';

function updateKingdealers(){
	global $site_URL, $adb;
	$valid_accounts = array();

	//set all king-dealers inactive
	$setinactive = "UPDATE vtiger_kingdealers SET kingdealer_status = 'Inactive'";
	$adb->pquery($setinactive);

	//select accounts that are king-dealers
	$accountid = "SELECT accountid FROM vtiger_account a INNER JOIN vtiger_crmentity c ON a.accountid = c.crmid WHERE a.iskingdealer=1 AND c.deleted = 0 GROUP BY a.accountid";
	//put the accountid's in an array
	$result_accountid = $adb->pquery($accountid, array());

	foreach ($result_accountid as $row) {
		array_push($valid_accounts, $row['accountid']);
	}

	//select all current King-dealers that are not deleted
	$vtiger_kingdealers = array();
	$kingdealers_accountid = "SELECT vtiger_kingdealers.account_id_txt FROM vtiger_kingdealers INNER JOIN vtiger_crmentity ON vtiger_kingdealers.kingdealersid = vtiger_crmentity.crmid GROUP BY vtiger_kingdealers.account_id_txt";

	$result_kingdealers_accountid = $adb->pquery($kingdealers_accountid, array());
		foreach ($result_kingdealers_accountid as $row) {
		array_push($vtiger_kingdealers, $row['account_id_txt']);
	}

	$numrows = $adb->num_rows($result_kingdealers_accountid);

	//set king-dealers active if they belong to a valid account
	for ($i = 0; $i < $numrows; $i++) {
	 	if(in_array($vtiger_kingdealers[$i], $valid_accounts) ) {
	 		$update_kingdealers1 = "UPDATE vtiger_kingdealers SET kingdealer_status= 'Active' WHERE account_id_txt = $vtiger_kingdealers[$i]";
	  	   	$adb->pquery($update_kingdealers1);
	  	}
	}


		//add new king-dealer if an account exists and has 'Is King-dealer' filled in as a checkbox when King-dealer doesn't exist allready
		foreach ($valid_accounts as $valid_account_id) {
		//Check not allready King-dealer exists
		$valid_kingdealers = "SELECT kingdealersid FROM vtiger_kingdealers a INNER JOIN vtiger_crmentity b ON a.kingdealersid = b.crmid WHERE account_id_txt = ? AND b.deleted = 0";
		$params = array($valid_account_id);
		$result_valid_kingdealers = $adb->pquery($valid_kingdealers, $params);
		$kingdealer_id 		= $adb->query_result($result_valid_kingdealers, 0, "kingdealersid");

		//so all valid_accounts that have kingdealersid should not be created, rest will be created
		if(!isset($kingdealer_id)){
		//get accountname for filling label
		$select_accountname = "SELECT accountname FROM vtiger_account WHERE accountid = $valid_account_id";
		$result_select_accountname = $adb->pquery($select_accountname);
		$accountname_for_new_account = $adb->query_result($result_select_accountname, 0, "accountname");

		//create new King-dealer
		$focus = new Kingdealers();
		$focus->column_fields['assigned_user_id'] = 1;
		$focus->column_fields['kingdealer_label'] = $accountname_for_new_account;
		$focus->column_fields['account_id_txt'] = $valid_account_id;
		//$focus->column_fields['link_to_account'] = $site_URL . 'index.php?module=Accounts&view=Detail&record=' . $valid_account_id;
		$focus->column_fields['kingdealer_status'] = 'Active';
		$focus->save("Kingdealers");

		}
	}

	//Update label of King-dealers
	$select_all_kingdealers = "SELECT a.account_id_txt, a.kingdealer_status, c.accountname FROM vtiger_kingdealers a INNER JOIN vtiger_crmentity b ON a.kingdealersid = b.crmid INNER JOIN vtiger_account c ON c.accountid = a.account_id_txt";
	$result_all_kingdealers = $adb->pquery($select_all_kingdealers, array());

	foreach ($result_all_kingdealers as $row) {
		if($row['kingdealer_status']=='Inactive'){
			$right_label = $row['accountname'] . ' (Inactief)';
		} else {
			$right_label = $row['accountname'];
		}
		$update_kingdealers2 = "UPDATE vtiger_kingdealers SET kingdealer_label = '" . $right_label . "' WHERE account_id_txt = " . $row['account_id_txt'];
		$adb->pquery($update_kingdealers2);
	}
}
