<?php

function updateSalestargetsRelations($entity){
	global $current_user, $adb, $log;
	include_once 'include/utils/CommonUtils.php';
	include_once 'include/database/PearDatabase.php';
	require_once('data/CRMEntity.php');
	require_once 'modules/SalestargetsRelations/SalestargetsRelations.php';

	$id = $entity->data['id'];
	$pieces = explode("x", $id);
	$record = $pieces[1];

	//Delete forecastrelations
	$sql 		= "DELETE FROM vtiger_salestargetsrelations WHERE salesorder_id = ?";
	$params 	= array($record);
	$result 	= $adb->pquery($sql, $params);

	//Select account
	$sql_so	= "SELECT orderdate, accountid, total, smownerid FROM vtiger_salesorder 
				INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_salesorder.salesorderid
				WHERE salesorderid = ?";	
	$params 	= array($record);
	$inner_rescf 	= $adb->pquery($sql_so, $params);
	$accid 		= $adb->query_result($inner_rescf, 0, "accountid");
	$total 		= $adb->query_result($inner_rescf, 0, "total");
	$orderdate 		= $adb->query_result($inner_rescf, 0, "orderdate");
	$smownerid		= $adb->query_result($inner_rescf, 0, "smownerid");

	if ($orderdate != ""){
		$dateexplode 	= explode("-", $orderdate);
		$so_year 	= $dateexplode['0'];
    		$so_month 	= $dateexplode['1'];
		$so_day 	= $dateexplode['2'];
		
		//set quarter Q1, Q2, Q3, or Q4
		if ($so_month == "1" || $so_month == "2" || $so_month == "3"){ $so_quarter = Q1;}
		elseif ($so_month == "4" || $so_month == "5" || $so_month == "6"){ $so_quarter = Q2;}
		elseif ($so_month == "7" || $so_month == "8" || $so_month == "9"){ $so_quarter = Q3;}
		elseif ($so_month == "10" || $so_month == "11" || $so_month == "12"){ $so_quarter = Q4;}    		

		$date = new DateTime();
		$date->setDate($so_year,$so_month,$so_day);
		$so_month = $date->format('F');

		//get allocations
		$sql_alloc	= "SELECT related_user, allocation_amount, allocation_percent FROM vtiger_targetallocation 
		INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_targetallocation.targetallocationid 
		WHERE vtiger_crmentity.deleted=0 AND salesorder_id = ?";	
		$params 	= array($record);
		$inner_allow  = $adb->pquery($sql_alloc, $params);
		$num_alloc  	= $adb->num_rows($inner_allow);	
		
		if ($num_alloc != "0"){
			for ($a = 0; $a < $num_alloc; $a++) {

				$alloc_user 		= $adb->query_result($inner_allow, $a, "related_user");
				$alloc_amount 	= $adb->query_result($inner_allow, $a, "allocation_amount");
				$alloc_percent 	= $adb->query_result($inner_allow, $a, "allocation_percent");
	
				//Select salestarget in year
				$sql_fo	= "SELECT account_id, salestargetsid, related_to, salestarget_quarter, salestarget_month FROM vtiger_salestargets 
					INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_salestargets.salestargetsid 
					WHERE vtiger_crmentity.deleted=0 AND salestarget_year = ? AND related_user = ?";
				$params 	= array($so_year, $alloc_user);
				$inner_rescf2 = $adb->pquery($sql_fo, $params);
				$num_fo   	= $adb->num_rows($inner_rescf2);
				
				for ($i = 0; $i < $num_fo; $i++) {
					$salestargetsid 	= $adb->query_result($inner_rescf2, $i, "salestargetsid");
					$relatedto 		= $adb->query_result($inner_rescf2, $i, "related_to");
					$st_quarter 		= $adb->query_result($inner_rescf2, $i, "salestarget_quarter");
					$st_month 		= $adb->query_result($inner_rescf2, $i, "salestarget_month");
					$rel_account 		= $adb->query_result($inner_rescf2, $i, "account_id");
					$rel_user		= $alloc_user;

					if ($st_month != ""){
						switch ($st_month){
							case "January":
								$st_month = 1; 
								break;
							case "February":
								$st_month = 2; 
								break;
							case "March":
								$st_month = 3; 
								break;
							case "April":
								$st_month = 4; 
								break;
							case "May":
								$st_month = 5; 
								break;
							case "June":
								$st_month = 6; 
								break;
							case "July":
								$st_month = 7; 
								break;
							case "August":
								$st_month = 8; 
								break;
							case "September":
								$st_month = 9; 
								break;
							case "October":
								$st_month = 10; 
								break;
							case "November":
								$st_month = 11; 
								break;
							case "December":
								$st_month = 12; 
								break;
						}
					}


					if ((($rel_account != "0") && ($rel_account == $accid)) || ($rel_account == "0")|| ($rel_account == "")){
						$inperiod = 0;

						if ($st_quarter != ""){		
							if ($st_quarter == $so_quarter){
								$inperiod = 1;
							}else {
								$inperiod = 0;
							}
						}
				
						if ($st_month != ""){		
							if ($st_month == $so_month){
								$inperiod = 1;
							}else {
								$inperiod = 0;
							}
						}
						
						if ($relatedto != "0" && $inperiod == 1){
							//Select productrows
							$sql_po	= "SELECT productid, quantity FROM vtiger_inventoryproductrel WHERE id = ?";
							$params 	= array($record);
							$inner_rescf3	= $adb->pquery($sql_po, $params);
							$num_po   	= $adb->num_rows($inner_rescf3);
					
							for ($j = 0; $j < $num_po; $j++) {
								$productid 	= $adb->query_result($inner_rescf3, $j, "productid");
								if ($productid == $relatedto){
									//Create relation
									$focus = new SalestargetsRelations();
									$focus->column_fields['assigned_user_id'] = 1;
				    		 			$focus->column_fields['salesorder_id'] =  $record;
									$focus->column_fields['salestarget_id'] = $salestargetsid;
									$focus->save("SalestargetsRelations");	
								}
							}				
						}else{
							if ($inperiod == 1){
								//Create relation
								$focus = new SalestargetsRelations();
								$focus->column_fields['assigned_user_id'] = 1;
				    		      		$focus->column_fields['salesorder_id'] =  $record;
								$focus->column_fields['salestarget_id'] = $salestargetsid;
								$focus->save("SalestargetsRelations");	
							}		
						}
					}
				}
			}
		}
		else {
			
			//Select salestarget in year
			$sql_fo	= "SELECT account_id, salestargetsid, related_to, salestarget_quarter, salestarget_month FROM vtiger_salestargets 
				INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_salestargets.salestargetsid 
				WHERE vtiger_crmentity.deleted=0 AND salestarget_year = ? AND related_user = ?";
			$params 	= array($so_year, $smownerid);
			$inner_rescf2 = $adb->pquery($sql_fo, $params);
			$num_fo   	= $adb->num_rows($inner_rescf2);
		
			for ($i = 0; $i < $num_fo; $i++) {
				$salestargetsid 	= $adb->query_result($inner_rescf2, $i, "salestargetsid");
				$relatedto 		= $adb->query_result($inner_rescf2, $i, "related_to");
				$st_quarter 		= $adb->query_result($inner_rescf2, $i, "salestarget_quarter");
				$st_month 		= $adb->query_result($inner_rescf2, $i, "salestarget_month");
				$rel_account 		= $adb->query_result($inner_rescf2, $i, "account_id");
				if ($st_month != ""){
					switch ($st_month){
						case "January":
							$st_month = 1; 
							break;
						case "February":
							$st_month = 2; 
							break;
						case "March":
							$st_month = 3; 
							break;
						case "April":
							$st_month = 4; 
							break;
						case "May":
							$st_month = 5; 
							break;
						case "June":
							$st_month = 6; 
							break;
						case "July":
							$st_month = 7; 
							break;
						case "August":
							$st_month = 8; 
							break;
						case "September":
							$st_month = 9; 
							break;
						case "October":
							$st_month = 10; 
							break;
						case "November":
							$st_month = 11; 
							break;
						case "December":
							$st_month = 12; 
							break;
						}
					}

				$inperiod = 0;
	
				if ((($rel_account != "0") && ($rel_account == $accid)) || ($rel_account == "0") || ($rel_account == "")){
					if ($st_quarter != ""){		
						if ($st_quarter == $so_quarter){	
							$inperiod = 1;
						}else {
							$inperiod = 0;
						}
					}
					if ($st_month != ""){		
						if ($st_month == $so_month){
							$inperiod = 1;
						}else {
							$inperiod = 0;
						}
					}
	
					if ($relatedto != "0" && $inperiod == 1){
						//Select productrows
						$sql_po	= "SELECT productid, quantity FROM vtiger_inventoryproductrel WHERE id = ?";
						$params 	= array($record);
						$inner_ref3	= $adb->pquery($sql_po, $params);
						$num_po   	= $adb->num_rows($inner_rescf3);
			
						for ($j = 0; $j < $num_po; $j++) {
							$productid 	= $adb->query_result($inner_rescf3, $j, "productid");
							if ($productid == $relatedto){
								//Create relation
								$focus = new SalestargetsRelations();
								$focus->column_fields['assigned_user_id'] = 1;
			    			 		$focus->column_fields['salesorder_id'] =  $record;
								$focus->column_fields['salestarget_id'] = $salestargetsid;
								$focus->save("SalestargetsRelations");	
							}
						}				
					}else{
						if ($inperiod == 1){
							//Create relation
							$focus = new SalestargetsRelations();
							$focus->column_fields['assigned_user_id'] = 1;
			    	   		  	$focus->column_fields['salesorder_id'] =  $record;
							$focus->column_fields['salestarget_id'] = $salestargetsid;
							$focus->save("SalestargetsRelations");			
						}
					}
				}
			}
		}
	}	
}
?>