<?php
/*
 * generic xml conversion and soap call to endPoint
 *
 */

// new xml
/**
 * Extends the DOMDocument to implement personal (utility) methods.
 *
 * @author Toni Van de Voorde
 */
class XmlDomConstruct extends DOMDocument
{
  /**
   * Constructs elements and texts from an array or string.
   * The array can contain an element's name in the index part
   * and an element's text in the value part.
   *
   * It can also creates an xml with the same element tagName on the same
   * level.
   *
   * ex:
   * <nodes>
   *   <node>text</node>
   *   <node>
   *     <field>hello</field>
   *     <field>world</field>
   *   </node>
   * </nodes>
   *
   * Array should then look like:
   *
   * Array (
   *   "nodes" => Array (
   *     "node" => Array (
   *       0 => "text"
   *       1 => Array (
   *         "field" => Array (
   *           0 => "hello"
   *           1 => "world"
   *         )
   *       )
   *     )
   *   )
   * )
   *
   * @param mixed $mixed An array or string.
   *
   * @param DOMElement[optional] $domElement Then element
   * from where the array will be construct to.
   *
   */
  public function fromMixed($mixed, DOMElement $domElement = null)
  {
    $domElement = is_null($domElement) ? $this : $domElement;

    if (is_array($mixed))
    {
      foreach( $mixed as $index => $mixedElement )
      {
        if ( is_int($index) )
        {
          if ( $index == 0 )
          {
            $node = $domElement;
          }
          else
          {
            $node = $this->createElement($domElement->tagName);
            $domElement->parentNode->appendChild($node);
          }
        }
        else
        {
          $node = $this->createElement($index);
          $domElement->appendChild($node);
        }

        $this->fromMixed($mixedElement, $node);
      }
    }
    else
    {
      $domElement->appendChild($this->createTextNode($mixed));
    }
  }
}

function newToXml($targetName, $data)
{
  $xml = new XmlDomConstruct('1.0', 'utf-8');
  $xml->fromMixed($data);
  return $xml->saveXML();
}

function toXml($targetName, $data)
{
  $message = '<?xml version="1.0" encoding="UTF-8"?><message>';
  $message .= '<envelop></envelop>';
  $message .= '<content>';
  $message .= '<' . $targetName . '>' ;

  // add the queried data
  foreach($data as $key => $value)
  {
    if (is_numeric($key)) continue;
    // $message .= '<' . $key . '>' . htmlentities($value, ENT_COMPAT, 'utf-8', true) . '</' . $key . '>';
    $message .= '<' . $key . '>' . html_entity_decode($value, ENT_COMPAT, 'UTF-8') . '</' . $key . '>';
  }

  $message .= '</' . $targetName . '>';
  $message .= '</content>';
  $message .= '</message>';

  return $message;
}

/*
 * @todo location is hardcoded
 *
 */
function toEndpoint($action, $call)
{
  // test, no export to king
  // return;

  $location = 'https://vosba.oskantoor.nl';

  try
  {
    $client = new SoapClient(NULL, array(
                                          'trace' => 1,
                                          'location' => $location . '/k2w/portal/portal.php?wsdl',
                                          'uri' => 'http://tempuri.org/message/',
                                          'version' => SOAP_1_2,
                                          'encoding' => 'UTF-8'
                                        )
                            );

    $result = $client->__soapCall($action, array($call));

    // error_log(var_export($result, true), 1, 'jho@vicus.nl');
  }
  catch (SoapFault $s)
  {
    // vosba send all kind of messy debug msgs which result in error for crm.....
    echo $s->getMessage();
  }
}
