<?php
/************************************************************************************************
** The contents of this file are subject to the Vtiger WebVisits Module License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
**
************************************************************************************************/
class WebVisits_Module_Model extends Vtiger_Module_Model {

	/**
	 * Function to check whether the module is an entity type module or not
	 * @return <Boolean> true/false
	 */
	/*public function isQuickCreateSupported(){
		global $log;
		$log->debug("Entering isQuickCreateSupported() method....");
		$log->debug("Exiting isQuickCreateSupported() method....");
		return false;
	}
	/**
	 * Function to get Default View name for Echosign module
	 */	
	/*public function getDefaultViewName() {
		global $log;
		$log->debug("Entering getDefaultViewName() method....");
		$log->debug("Exiting getDefaultViewName() method....");
		if(EchoSign_Setting_Model::validate_licence(false))
			return 'Setting';
		else
			return 'List';
	}*/
	/**
	 * Function to get default Setting Links
	 */	
	public function getSettingLinks(){
		 global $log;
		$log->debug("Entering getSettingLinks() method....");
		
		if(!$this->isEntityModule()) {
			$log->debug("Exiting getSettingLinks() method....");
            return array();
        }
		vimport('~~modules/com_vtiger_workflow/VTWorkflowUtils.php');

		$layoutEditorImagePath = Vtiger_Theme::getImagePath('LayoutEditor.gif');
		$editWorkflowsImagePath = Vtiger_Theme::getImagePath('EditWorkflows.png');
		$settingsLinks = array();

		$settingsLinks[] = array(
					'linktype' => 'LISTVIEWSETTING',
					'linklabel' => 'LBL_EDIT_FIELDS',
                    'linkurl' => 'index.php?parent=Settings&module=LayoutEditor&sourceModule='.$this->getName(),
					'linkicon' => $layoutEditorImagePath
		);

		if($this->hasSequenceNumberField()) {
			$settingsLinks[] = array(
				'linktype' => 'LISTVIEWSETTING',
				'linklabel' => 'LBL_MODULE_SEQUENCE_NUMBERING',
				'linkurl' => 'index.php?parent=Settings&module=Vtiger&view=CustomRecordNumbering&sourceModule='.$this->getName(),
				'linkicon' => ''
			);
		}

		if(VTWorkflowUtils::checkModuleWorkflow($this->getName())) {
			$settingsLinks[] = array(
					'linktype' => 'LISTVIEWSETTING',
					'linklabel' => 'LBL_EDIT_WORKFLOWS',
                    'linkurl' => 'index.php?parent=Settings&module=Workflows&view=List&sourceModule='.$this->getName(),
					'linkicon' => $editWorkflowsImagePath
			);
		}

		$settingsLinks[] = array(
					'linktype' => 'LISTVIEWSETTING',
					'linklabel' => 'LBL_EDIT_PICKLIST_VALUES',
					'linkurl' => 'index.php?parent=Settings&module=Picklist&view=Index&source_module='.$this->getName(),
					'linkicon' => ''
			);
		$settingsLinks[] = array(
					'linktype' => 'LISTVIEWSETTING',
					'linklabel' => 'LBL_CONFIGURATION_SETTINGS',
					'linkurl' => 'index.php?parent=Settings&module=WebVisits&view=Edit&source_module=WebVisits',
					'linkicon' => ''
			);

		$log->debug("Exiting getSettingLinks() method....");		
		return $settingsLinks;
	}	
	/**
	 * Function to get Specific Relation Query for this Module
	 * @param <type> $relatedModule
	 * @return <type>
	 */
	public function getSpecificRelationQuery($relatedModule) {
		global $log;
		$log->debug("Entering getSpecificRelationQuery($relatedModule) method....");
		$log->debug("Exiting getSpecificRelationQuery($relatedModule) method....");
		if($relatedModule == 'Documents'){
			return '';
		}
		return;
	}
	
	/*
	 * Function to get the url for default view of the module
	 * @return <string> - url
	 */
	public function getUninstallUrl($module) {
		global $log;
		$log->debug("Entering getUninstallUrl($module) method....");
		$log->debug("Exiting getUninstallUrl($module) method....");
		return 'index.php?module='.$module.'&view=Uninstall&parent=Tools';

	}
}