<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class WebVisits_Save_Action extends Vtiger_Save_Action {

	public function process(Vtiger_Request $request) {
				
			global $adb;
			$leadid         =	$request->get('leadid');	
			$contactid		=	$request->get('contactid');
			$accountid		=	$request->get('accountid');
			$campaignid		=	$request->get('campaignid');
			$weblocationid	=	$request->get('weblocationid');
			
			$record 		= $request->get('record');
			if($record!='')
			{
				if($leadid!='')
				{
					$this->tkssetRelation($leadid,$record,'Leads');
				}
				if($contactid!='')
				{
					$this->tkssetRelation($contactid,$record,'Contacts');
				}
				if($accountid!='')
				{
					$this->tkssetRelation($accountid,$record,'Accounts');
				}
				if($campaignid!='')
				{
					$this->tkssetRelation($campaignid,$record,'Campaigns');
				}
				if($weblocationid!='')
				{
					$this->tkssetRelation($weblocationid,$record,'WebLocations');
				}
			}
			if(($request->get('start_time')!='' && $request->get('startdate')!='') || ($request->get('end_time')!='' && $request->get('enddate')!='')) 
			{
				$startTime = Vtiger_Time_UIType::getTimeValueWithSeconds($request->get('start_time'));
				$startDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($request->get('startdate')." ".$startTime);
				list($startDate, $startTime) = explode(' ', $startDateTime);
				$request->set('startdate', $startDateTime);
				$request->set('start_time', $startTime);
				
				$endTime = Vtiger_Time_UIType::getTimeValueWithSeconds($request->get('end_time'));
				//$endDateTime = $request->get('enddate')." ".$endTime;
				$endDateTime = Vtiger_Datetime_UIType::getDBDateTimeValue($request->get('enddate')." ".$endTime);
				list($endDate, $endTime) = explode(' ', $endDateTime);
				$request->set('enddate', $endDateTime);
				$request->set('end_time', $endTime);
			}
			$recordModel 	= $this->saveRecord($request);	
			
			$request->set('record', $recordModel->getId());
			$recordid		=	$request->get('record');
			$mode 			=	$recordModel->get('mode');
			$on_focus		=	CRMEntity::getInstance('WebVisits');
			
			if($mode != 'edit')
			{
				if(!empty($leadid))
				{
					$on_focus->save_related_module('Leads',$leadid,'WebVisits',$recordid);	
				}
				if(!empty($contactid))
				{
					$on_focus->save_related_module('Contacts',$contactid,'WebVisits',$recordid);	
				}
				if(!empty($accountid))
				{
					$on_focus->save_related_module('Accounts',$accountid,'WebVisits',$recordid);	
				}
				if(!empty($campaignid))
				{
					$on_focus->save_related_module('Campaigns',$campaignid,'WebVisits',$recordid);	
				}
				if(!empty($weblocationid))
				{
					$on_focus->save_related_module('WebLocations',$weblocationid,'WebVisits',$recordid);	
				}
			}
		parent::process($request);
	
	}
	public function tkssetRelation($id,$record,$module)
	{
		global $adb;
		$qry 	= "SELECT crmid FROM vtiger_crmentityrel 
					WHERE relcrmid=? AND module=? AND relmodule=?";
		$res 	= $adb->pquery($qry, array($record,$module,'WebVisits'));
		$rows	= $adb->num_rows($res);
		if($rows>0)
		{		
			$qry1 	= "UPDATE vtiger_crmentityrel SET crmid=? 
						WHERE relcrmid=? AND module=? AND relmodule=?";
			$res1 	= $adb->pquery($qry1, array($id,$record,$module,'WebVisits'));
		}
		else
		{
			$on_focus		=	CRMEntity::getInstance('WebVisits');
			$on_focus->save_related_module($module,$id,'WebVisits',$record);
		}
		return $res1;
	}
}