<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Vtiger_DocumentsFolder_UIType extends Vtiger_Base_UIType {

	/**
	 * Function to get the Template name for the current UI Type object
	 * @return <String> - Template Name
	 */
	public function getTemplateName() {
		return 'uitypes/DocumentsFolder.tpl';
	}

	/**
	 * Function to get the Display Value, for the current field type with given DB Insert Value
	 * @param <Object> $value
	 * @return <Object>
	 */
	// t44336 - start
	// Declaration of Vtiger_DocumentsFolder_UIType::getDisplayValue($value) should be compatible
	// with Vtiger_Base_UIType::getDisplayValue($value, $record = false, $recordInstance = false)
	// public function getDisplayValue($value) {
	public function getDisplayValue($value, $record = false, $recordInstance = false) {
	// t44336 - end

		$db = PearDatabase::getInstance();
		$result = $db->pquery('SELECT * FROM vtiger_attachmentsfolder WHERE folderid = ?', array($value));
		if($db->num_rows($result)) {
			return $db->query_result($result, 0, 'foldername');
		}
		return false;
	}
    
    public function getListSearchTemplateName() {
        return 'uitypes/DocumentsFolderFieldSearchView.tpl';
    }
}
