<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/ 
class Vtiger_WVASBICodeWidget_Model extends Vtiger_Widget_Model {

	protected $widgetModel;
	protected $extraData;

	protected $listviewController;
	protected $queryGenerator;
	protected $listviewHeaders;
	protected $listviewRecords;
	protected $targetModuleModel;

	public function getSalesTargets() {
		global $adb;
		$all_reports 	=	array();
		if(isset($_REQUEST['year']) && !empty($_REQUEST['year']))
		{
			$tks_year	= 	$_REQUEST['year'];
		}
		else
		{
			$tks_year 	= 	date('Y');
		}	 
		
		$adb = PearDatabase::getInstance();
		//TODO need to handle security
		$result = $adb->pquery('SELECT COUNT( * ) AS count, CASE WHEN SUBSTR( vtiger_leaddetails.wv_sfsbi,1,2) IS NULL OR SUBSTR( vtiger_leaddetails.wv_sfsbi,1,2) = ""
								THEN "" ELSE SUBSTR( vtiger_leaddetails.wv_sfsbi,1,2) END AS name, vtiger_leaddetails.leadid AS id FROM vtiger_leaddetails
								INNER JOIN vtiger_crmentity ON vtiger_leaddetails.leadid = vtiger_crmentity.crmid WHERE deleted =0
								AND converted = 0 AND vtiger_leaddetails.wv_sfsbi != "" AND vtiger_leaddetails.wv_sfcocnumber != "" GROUP BY name ORDER BY vtiger_leaddetails.wv_sfsbi', array());

		$data = array();
		
		$rows = $adb->num_rows($result);
		$sector = strtolower('count');
		$legend  = strtolower('name');
		
		if($rows > 0)
		{
			for($i = 0; $i < $rows; $i++) 
			{
				$row = $adb->query_result_rowdata($result, $i);
				$value = (float) $row[$sector];
				$label = $row[strtolower($legend)];
				$values[] = $value;
				$labels[] = (strlen($label) > 30) ? substr($label, 0, 30).'..' : $label;
				$links[] = "index.php?module=Leads&view=List";
				$graph_label = "";
			}
		
			$data = array(	'labels' => $labels,
						'values' => $values,
						'links' => $links,
						'graph_label' => $graph_label
					);
					
		}
		else
		{
			$data = "No Data Found";
		}				
		
		return $data;
	}
	
}