<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/ 
class Vtiger_SalesTargetsWidget_Model extends Vtiger_Widget_Model {

	protected $widgetModel;
	protected $extraData;

	protected $listviewController;
	protected $queryGenerator;
	protected $listviewHeaders;
	protected $listviewRecords;
	protected $targetModuleModel;

	public function getSalesTargets() {
		global $adb,$current_user;
		$all_reports 	=	array();
		$tks_year 		= 	date('Y');
		$tks_user		=	'0';
		$sql		=	"SELECT tks_selected_user,year FROM `vtiger_track_salestargets_data` WHERE `user_id` = ".$current_user->id;
		$res 		= 	$adb->pquery($sql, array());
		$num_rows	=	$adb->num_rows($res);
		if($num_rows > 0)
		{
			$tks_year 		= 	$adb->query_result($res,0,'year');
			$tks_user 		= 	$adb->query_result($res,0,'tks_selected_user');
		} 
	
		$sql			=	"SELECT vtiger_salestargets.salestarget_quarter,SUM(vtiger_salestargets.financial_target) as 'sum_of_target',
						SUM(vtiger_salestargets.sales_revenue)as 'sum_of_sales_revenue',vtiger_salestargets.salestarget_year,
						vtiger_salestargets.salestargetsid
						FROM vtiger_salestargets 
						INNER JOIN vtiger_crmentity
						ON vtiger_salestargets.salestargetsid=vtiger_crmentity.crmid
						WHERE vtiger_salestargets.salestarget_year='".$tks_year."' 
						and vtiger_crmentity.deleted=0 ";
						
		if($tks_user!='0' && $tks_user!=' ')
		{
			$sql	.=	" AND vtiger_salestargets.related_user=".$tks_user;
		}						
		$sql	.=	" GROUP BY salestarget_quarter";
		
		$res 			= 	$adb->pquery($sql, array());
		$num_rows		=	$adb->num_rows($res);
		$data			=	array();
		$label			=	array();
		$values			=	array();
		$links			=	array();
		$type			=	'';
		$data_labels	=	array();
		$graph_label	=	'';
		$type			=	'multiBar';
		
		$data_labels[0]	=	vtranslate('Financial_Target', 'Home');//'Financial Target';
		$data_labels[1]	= 	vtranslate('Actual_Revenue', 'Home');//'Actual Revenue';
		$graph_label	=	vtranslate('Target_vs_Actual_Revenue', 'Home');//'Target vs Actual Revenue';
		for($i=0;$i<$num_rows;$i++)
		{						
			$sum_of_target			= 	round($adb->query_result($res,$i,'sum_of_target'));
			$sum_of_sales_revenue	= 	round($adb->query_result($res,$i,'sum_of_sales_revenue'));
			$values[$i][0]			=	$sum_of_target;
			$values[$i][1]			=	$sum_of_sales_revenue;
			$label[$i]				=	$adb->query_result($res,$i,'salestarget_quarter');
			$links[$i]				=	'#';
		}
		
		$data['labels']		=	$label;
		$data['values']		=	$values;
		$data['links']		=	$links;
		$data['type']		=	$type;
		$data['data_labels']=	$data_labels;
		$data['graph_label']=	$graph_label;
		$data['tks_year']	=	$tks_year;
		$data['tks_user']	=	$tks_user;
		return $data;
	}
	
	public function getYearRange() {
		global $adb;
		$year_arr	=	array();
		$sql		=	"SELECT MIN(vtiger_salestargets.salestarget_year) as 'min_year', MAX(vtiger_salestargets.salestarget_year)as 'max_year' FROM vtiger_salestargets";
		$res 		= 	$adb->pquery($sql, array());
		$min_year 	= 	$adb->query_result($res,0,'min_year');
		$max_year 	= 	$adb->query_result($res,0,'max_year');
		for($i=$min_year;$i<=$max_year;$i++)
		{
			$year_arr[] 	= 	$i;
		}
		return $year_arr;
	}	
	
	public function getUsersData() {
		global $adb;
		$users_arr	=	array();
		$sql		=	"SELECT user_name,id FROM `vtiger_users` ";
		$res 		= 	$adb->pquery($sql, array());
		$num_rows		=	$adb->num_rows($res);
		$users_arr[]	= 	"All" ;
		for($i=0;$i<$num_rows;$i++)
		{						
			$users_arr[$adb->query_result($res,$i,'id')]	= 	$adb->query_result($res,$i,'user_name');
		}
		return $users_arr;
	}
	
	
	
	public function updateLastSelectedData() {
		global $current_user,$adb;
		
		if(isset($_REQUEST['tks_user']) && $_REQUEST['tks_user']!='' && isset($_REQUEST['year']) && !empty($_REQUEST['year']))
		{
			$sql		=	"DELETE FROM `vtiger_track_salestargets_data` WHERE `user_id` = ".$current_user->id;
			$res 		= 	$adb->pquery($sql, array());
			$tks_user	= 	$_REQUEST['tks_user'];
			$tks_year	= 	$_REQUEST['year'];
			$sql		=	"INSERT INTO `vtiger_track_salestargets_data`(`user_id`, `year`, `tks_selected_user`) VALUES ('".$current_user->id."','".$tks_year."','".$tks_user."')";
			$res 		= 	$adb->pquery($sql, array());
		}
		
		
	}
}