<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

// class Vtiger_Journey_Model extends HelpDesk_Record_Model {
class Vtiger_Journey_Model {

  public function gettksFieldModels($id) {

    $tksfocus = Vtiger_Record_Model::getInstanceById($id);
    return $tksfocus;
  }

  public function getVebEmailContent($description, $cnt = 5) {

    // lines in array are counted from 0, so cnt is from 0 to 4
    $cnt -= 1;

    // split on "\n" and/or "<br>"
    $longString = str_replace('&lt;br /&gt;', "\n", $description);
    $longString = str_replace('&lt;br&gt;', "\n", $longString);
    $longString = str_replace('<br />', "\n", $longString);
    $longString = str_replace('<br>', "\n", $longString);
    $longString = strip_tags(htmlspecialchars_decode($longString));
    $content = explode("\n", $longString);

    // first 3 are bogus, so requirement of 5 set to 8
    $description = '';
    foreach($content as $index => $text) {

      $text = trim($text);

      if (empty($text)) {

        $cnt += 1;
        continue;
      }

      $description .= $text . "\n";

      if ($index == $cnt) break;
    }

    // last 2 lines are bogus
    if (count($content) > ($cnt)) $description .= "...";

    return trim(nl2br($description));
  }

  public function obsolete_getVebEmailContent($description, $cnt = 8) {

    $content = explode("\n", $description);

    // first 3 are bogus, so requirement of 5 set to 8
    $description = '';
    foreach($content as $index => $text) {

        $description .= $text . "\n";

        if ($index == $cnt) break;
    }

                if (count($content) > ($cnt + 3)) $description .= "\n...";

                return trim($description);
  }

  public function gettksusername($id) {

    $tksfocus = Vtiger_Record_Model::getInstanceById($id,"Users");
    // return $tksfocus->get('last_name') . " " . $tksfocus->get('first_name');
    return $tksfocus->get('first_name') . " " . $tksfocus->get('last_name');
  }

  public function gettksrelatedto($id) {

    if($id) {

      $tksfocus = Vtiger_Record_Model::getInstanceById($id);
      return $tksfocus->get('label');
    }
    else
      return '';

  }
  public function gettkscontact($id) {

    if($id) {

      $tksfocus = Vtiger_Record_Model::getInstanceById($id,"Contacts");
      return $tksfocus->get('label');
    }
    else
      return "";
  }
}
