<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Vtiger_WVASalesFunnelWidget_Dashboard extends Vtiger_IndexAjax_View {
	
	
	 function getSearchParams($value) {
        $listSearchParams = array();
        $conditions = array(array('ticketstatus','e','Open'),array('assigned_user_id','e',$value));
        $listSearchParams[] = $conditions;
        return '&search_params='. json_encode($listSearchParams);
    }
	
	public function process(Vtiger_Request $request, $widget=NULL) {
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$linkId = $request->get('linkid');

		// Initialize Widget to the right-state of information
		if ($widget && !$request->has('widgetid')) {
			$widgetId = $widget->get('id');
		} else {
			$widgetId = $request->get('widgetid');
		}
		
		$widget = Vtiger_Widget_Model::getInstanceWithWidgetId($widgetId, $currentUser->getId());
		$WVASalesFunnelWidgetModel = new Vtiger_WVASalesFunnelWidget_Model();
	
		$viewer->assign('LINKID', $linkId);
		$viewer->assign('WIDGETID', $widgetId);
		$viewer->assign('WIDGET', $widget);
		$viewer->assign('MODULE_NAME', $moduleName);
		//$viewer->assign('YEAR', $value);
		//	$viewer->assign('SCRIPTS',$this->getHeaderScripts($request));
		$viewer->assign('STYLES',$this->getHeaderCss($request));
		$viewer->assign('CHART_TYPE','funnelChart');
		$viewer->assign('CLICK_THROUGH', true);
		$content = $request->get('content');
		$data = $WVASalesFunnelWidgetModel->getSalesTargets();
		
		$moduleModel = Vtiger_Module_Model::getInstance('Leads');
		$listViewUrl = $moduleModel->getListViewUrl();
		/*for($i = 0;$i<count($data);$i++){
            $data[$i]["links"] = $listViewUrl;
        }*/
		
		$viewer->assign('YEAR_DATA',$year_range);
		$viewer->assign('WIDGET', $widget);
		$viewer->assign('MODULE_NAME', $moduleName);
		//$viewer->assign('DATA', json_encode($data));
		$viewer->assign('CURRENTUSER', $currentUser);
		
		if($data !='No Data Found')
		{
			$viewer->assign('DATA', json_encode($data));
		}	
		else
		{
			$viewer->assign('DATA', json_encode($data));
		}

		//$viewer->assign('DATA',$data);
		if(!empty($content)) {
			$viewer->view('dashboards/WVASalesFunnelWidgetContents.tpl', $moduleName);
		} else {
		
			$viewer->view('dashboards/WVASalesFunnelWidget.tpl', $moduleName);
		}
		
	}
	
	/**
	 * Function to get the list of Css models to be included
	 * @param Vtiger_Request $request
	 * @return <Array> - List of Vtiger_CssScript_Model instances
	 */
	public function getHeaderCss(Vtiger_Request $request) {
		$parentHeaderCssScriptInstances = parent::getHeaderCss($request);

		$headerCss = array(
			'~/libraries/jquery/jqplot/jquery.jqplot.min.css',
		);
		$cssScripts = $this->checkAndConvertCssStyles($headerCss);
		$headerCssScriptInstances = array_merge($parentHeaderCssScriptInstances , $cssScripts);
		return $headerCssScriptInstances;
	}

}