<?php
/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/

class Vtiger_SalesTargetsWidget_Dashboard extends Vtiger_IndexAjax_View {
	
	public function process(Vtiger_Request $request, $widget=NULL) {
		$currentUser = Users_Record_Model::getCurrentUserModel();
		$viewer = $this->getViewer($request);
		$moduleName = $request->getModule();
		$linkId = $request->get('linkid');
		$tks_user ='';
		// Initialize Widget to the right-state of information
		if ($widget && !$request->has('widgetid')) {
			$widgetId = $widget->get('id');
		} else {
			$widgetId = $request->get('widgetid');
		}
		/*if(isset($_REQUEST['year']) && !empty($_REQUEST['year']))
		{
			$value	= $_REQUEST['year'];
		}
		else
		{
			$value = date('Y');
		}	 
		$tks_user =	$_REQUEST['tks_user'];*/

		$widget = Vtiger_Widget_Model::getInstanceWithWidgetId($widgetId, $currentUser->getId());
		$salesTargetWidgetModel = new Vtiger_SalesTargetsWidget_Model();
		$viewer->assign('LINKID', $linkId);
		$viewer->assign('WIDGETID', $widgetId);
		$viewer->assign('WIDGET', $widget);
		$viewer->assign('MODULE_NAME', $moduleName);
		//	$viewer->assign('SCRIPTS',$this->getHeaderScripts($request));
		$viewer->assign('STYLES',$this->getHeaderCss($request));
		$viewer->assign('CHART_TYPE','lineChart');
		$viewer->assign('CLICK_THROUGH', true);
		$content = $request->get('content');

		$salesTargetWidgetModel->updateLastSelectedData();
		$data = $salesTargetWidgetModel->getSalesTargets();
		$year_range	=	$salesTargetWidgetModel->getYearRange();
		$user_data	=	$salesTargetWidgetModel->getUsersData();
		$value		=	$data['tks_year'];
		$tks_user	=	$data['tks_user'];
		$viewer->assign('YEAR', $value);
		$viewer->assign('TKSUSER', $tks_user);
		unset($data['tks_year']);
		unset($data['tks_user']);
		//$viewer->assign('CANDIDATE_WIDGET_MODEL', $candidatesummaryWidgetModel);
		$viewer->assign('YEAR_DATA',$year_range);
		$viewer->assign('USER_DATA',$user_data);
		$viewer->assign('NO_DATA',false);

// @change to show example
/*
		$data['values'] = array(
			0 => array(0 => 450, 1 => 480),
			1 => array(0 => 450, 1 => 450),
			2 => array(0 => 450, 1 => 470),
			3 => array(0 => 450, 1 => 490),
		);
*/	

		if(empty($data['values']))
			$viewer->assign('NO_DATA',true);
		$viewer->assign('DATA', json_encode($data, JSON_HEX_APOS));
		
		if(!empty($content)) {
			$viewer->view('dashboards/SalesTargetsWidgetContents.tpl', $moduleName);
		} else {
		
			$viewer->view('dashboards/SalesTargetsWidget.tpl', $moduleName);
		}
		
	}
	
	/**
	 * Function to get the list of Css models to be included
	 * @param Vtiger_Request $request
	 * @return <Array> - List of Vtiger_CssScript_Model instances
	 */
	public function getHeaderCss(Vtiger_Request $request) {
		$parentHeaderCssScriptInstances = parent::getHeaderCss($request);

		$headerCss = array(
			'~/libraries/jquery/jqplot/jquery.jqplot.min.css',
		);
		$cssScripts = $this->checkAndConvertCssStyles($headerCss);
		$headerCssScriptInstances = array_merge($parentHeaderCssScriptInstances , $cssScripts);
		return $headerCssScriptInstances;
	}

}