<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

class Vtiger_ProcessDuplicates_Action extends Vtiger_Action_Controller {

	function checkPermission(Vtiger_Request $request) {
		$module = $request->getModule();
		$records = $request->get('records');
		if($records) {
			foreach($records as $record) {
				$recordPermission = Users_Privileges_Model::isPermitted($module, 'EditView', $record);
				if(!$recordPermission) {
					throw new AppException(vtranslate('LBL_PERMISSION_DENIED'));
				}
			}
		}
	}

	function process (Vtiger_Request $request) {
		global $skipDuplicateCheck;
		$moduleName = $request->getModule();
		$moduleModel = Vtiger_Module_Model::getInstance($moduleName);
		$records = $request->get('records');
		$primaryRecord = $request->get('primaryRecord');
		$primaryRecordModel = Vtiger_Record_Model::getInstanceById($primaryRecord, $moduleName);

		$response = new Vtiger_Response();
		try {
			$skipDuplicateCheckOldValue = $skipDuplicateCheck;
			$skipDuplicateCheck = true;

			$fields = $moduleModel->getFields();
			foreach($fields as $field) {
				$fieldValue = $request->get($field->getName());
				if($field->isEditable()) {
					if($field->uitype == 71) {
						$fieldValue = CurrencyField::convertToUserFormat($fieldValue);
					}
					$primaryRecordModel->set($field->getName(), $fieldValue);
				}
			}
			$primaryRecordModel->set('mode', 'edit');
			$primaryRecordModel->save();

			$deleteRecords = array_diff($records, array($primaryRecord));
			
			foreach($deleteRecords as $deleteRecord) {
				$recordPermission = Users_Privileges_Model::isPermitted($moduleName, 'Delete', $deleteRecord);
				
        // @change lro 190207 T
        $logtext = date("Ymd");
        $source_crmid = $deleteRecord;
        $target_crmid = $primaryRecord;
        $logtext .= " source = {$source_crmid} -> target = {$target_crmid} ";
        $logtext .= " setype = {$moduleName}";
        //file_put_contents("/home/cs1002/public_html/modules/Vtiger/actions/ProcessDuplicates-test.log",$logtext."\n\n",FILE_APPEND);
        global $adb;
        // id and timestamp are autiocreated
        // insert in table vtiger_wv_merged - id, setype, crmid_source, crmid_target
        $sql = "INSERT INTO vtiger_wv_merged (setype, crmid_source, crmid_target) VALUES ('{$moduleName}', {$source_crmid}, {$target_crmid});";
        //file_put_contents("/home/cs1002/public_html/modules/Vtiger/actions/ProcessDuplicates-test.log",$sql."\n\n",FILE_APPEND);
        $merged = $adb->pquery($sql);
        // end of change 
				
				if($recordPermission) {
					$primaryRecordModel->transferRelationInfoOfRecords(array($deleteRecord));
					$record = Vtiger_Record_Model::getInstanceById($deleteRecord);
										
					$record->delete();
				}
			}
			$skipDuplicateCheck = $skipDuplicateCheckOldValue;

			$response->setResult(true);
		} catch (DuplicateException $e) {
			$response->setError($e->getMessage(), $e->getDuplicationMessage(), $e->getMessage());
		} catch (Exception $e) {
			$response->setError($e->getMessage());
		}
		$response->emit();
	}

	public function validateRequest(Vtiger_Request $request) {
		$request->validateWriteAccess();
	}
}