<?php

include('../../config.php');

class Honeypot {

  // webservice url - from a config somewhere?
  protected $honeypotUrl = 'https://honeypot.static-vicus.nl/index.php';

  protected $token = null;

  protected $session = null;

  // what email for incorrect forms (mostly spam) - from a config somewhere?
  protected $recipient = 'someone@company.nl';

  public function __construct() {

    $this->getSpamScore();
  }

  private function checkHoneyPot() {

    // tbd
    // idea: check if up and running
  }

  /*
   * get spamscore via honeypot
   *
   */
  private function getSpamScore() {

    // not sanitized, send as is
    $params = $_REQUEST;

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $params);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_URL, $this->honeypotUrl);
    curl_setopt($curl, CURLOPT_HEADER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 30);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);

    // Exec
    $response = curl_exec($curl);

    // Data
    $info = curl_getinfo($curl);
    curl_close($curl);

    $header = trim(substr($response, 0, $info['header_size']));
    $result = substr($response, $info['header_size']);

    $spamResult = json_decode($result);

    if ($spamResult->spamStatus == 'NOK') {

      // $url = $returnURL;

      $subject = sprintf('Webformulier captured by spamfilter (spamScore=%s)', $spamResult->spamScore);

      $mailMessage = sprintf('Een webformulier is tegengehouden door het spamfilter (spamScore=%s) op basis van:%s- ', $spamResult->spamScore, "\n\n");
      $mailMessage .= implode("\n- ", $spamResult->spamMsg) . "\n";
      $mailMessage .= "\nHet formulier bevat de volgende inhoud ". print_r($params, true);

      // to admin - disabled - lots of emails
      if ($this->recipient != 'someone@company.nl') {

        mail($this->recipient, $subject, $mailMessage);
      }

      $logDataPath = VtigerConfig::get('root_directory');

      // would like some logging iso mail
      $logdate = date('Ymd');
      file_put_contents($logDataPath . 'veb/logs/honeypot_' . $logdate . '.log', date('Y-m-d H:i:s') . ' ', FILE_APPEND);
      file_put_contents($logDataPath . 'veb/logs/honeypot_' . $logdate . '.log', var_export($mailMessage, true)."\n", FILE_APPEND);
    }

    // store status
    $_REQUEST['vwfstatus'] = $spamResult->spamStatus;

    // store the score
    $_REQUEST['vwfspamscore'] = $spamResult->spamScore;
  }
}

$capture = new Honeypot;
