<?php

class VebWebforms_Honeypot {

  // webservice url - from a config somewhere?
  static $honeypotUrl = 'https://honeypot.static-vicus.nl/index.php';

  // what email for incorrect forms (mostly spam) - from a config somewhere?
  static $recipient = 'sales@vicus.nl';

  /*
   * get spamscore via honeypot
   *
   */
  public static function getSpamScore() {

    // not sanitized, send as is
    $params = $_REQUEST;

    $curl = curl_init();

    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $params);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($curl, CURLOPT_URL, self::$honeypotUrl);
    curl_setopt($curl, CURLOPT_HEADER, true);
    curl_setopt($curl, CURLOPT_TIMEOUT, 30);
    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, true);

    // Exec
    $response = curl_exec($curl);

    // Data
    $info = curl_getinfo($curl);
    curl_close($curl);

    $header = trim(substr($response, 0, $info['header_size']));
    $result = substr($response, $info['header_size']);

    $spamResult = json_decode($result);

    // store status
    $_REQUEST['vwfstatus'] = $spamResult->spamStatus;

    // store the score
    $_REQUEST['vwfspamscore'] = $spamResult->spamScore;

    if ($spamResult->spamStatus == 'NOK') {

      $subject = sprintf('VebWebformsHoneypot: Webformulier captured by spamfilter (spamScore=%s)', $spamResult->spamScore);

      $mailMessage = sprintf('VebWebformsHoneypot: Een webformulier is tegengehouden door het spamfilter (spamScore=%s) op basis van:%s- ', $spamResult->spamScore, "\n\n");
      $mailMessage .= implode("\n- ", $spamResult->spamMsg) . "\n";
      $mailMessage .= "\nHet formulier bevat de volgende inhoud ". print_r($params, true);

      // to admin - disabled - lots of emails
      if (self::$recipient != 'lro@vicus.nl') {

        mail(self::$recipient, $subject, $mailMessage);
      }

      $logDataPath = VtigerConfig::get('root_directory');

      // would like some logging iso mail
      $logdate = date('Ymd');
      file_put_contents($logDataPath . 'veb/logs/honeypot_' . $logdate . '.log', date('Y-m-d H:i:s') . ' ', FILE_APPEND);
      file_put_contents($logDataPath . 'veb/logs/honeypot_' . $logdate . '.log', var_export($mailMessage, true)."\n", FILE_APPEND);

      echo "<p>Dank voor uw bericht. Uw IP nummer is geregistreerd {$_SERVER['REMOTE_ADDR']}.</p><p>Excuses voor het ongemak</p>";
      die(); 
    }
  }
}
