<?php
/* ***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * ************************************************************************************/

/*
 * config:
 * https:%honeypoturl%/honeypot.php
 *
 */

class VebWebformsHandler extends VTEventHandler {

  protected $systemMsgs = array();

  function handleEvent($eventName, $entityData) {

    $moduleName = $entityData->getModuleName();

    switch ($eventName . '|' . $moduleName) {

      case 'vtiger.entity.beforesave|VebWebforms': {

        $this->entityBeforeSave($entityData);
        break;
      }

      case 'vtiger.entity.aftersave|VebWebforms': {

        $this->entityAfterSave($entityData);
        break;
      }

      default: {

        return;
      }
    }
  }

  private function entityAfterSave($entityData) {

    $entityId = $entityData->getId();

    // just to do some cleaning on the table - clear the linkage
    $query = "DELETE FROM vtiger_crmentityrel WHERE crmid = ? OR relcrmid = ?";
    $this->queryQuery($query, array($entityData->get('id'), $entityId));

    // initiate consent process if active
    $this->emailConsentProcess($entityData);
  }

  private function entityBeforeSave($entityData) {

    if ($entityData->isNew() === true) {

      // @change 230529 lro added due to excessive passing the main filter
      $firstName = $entityData->get('firstname');
      $lastName = $entityData->get('lastname');
	
      if ($firstName == 'RobertTaw' | $lastName == 'RobertTaw') exit();
      //


      $this->beforeSaveNewRecord($entityData);
      return;
    }

    if ($entityData->isNew() === false) {

      $this->beforeSaveExistingRecord($entityData);
      return;
    }
  }

  private function getFieldsFromRequest() {

    $recordModel = Vtiger_Record_Model::getCleanInstance('VebWebforms');

    $fields = array();

    $this->log(var_export($_REQUEST,true));

    foreach($_REQUEST as $field => $value) {

       // determine type of to field
       $fieldModel = Vtiger_Field_Model::getInstance($field, $recordModel->getModule());

       if ($fieldModel == false) {

         // this field is not defined in this module - default string (?)
         $fields[$field] = array( 'type' => 'string', 'value' => $value, 'label' => $field, 'status' => 'notfound');
         continue;
       }

       $fieldLabel = $fieldModel->get('label');
       $fieldType = $fieldModel->getFieldDataType();
       $fields[$field] = array( 'type' => $fieldType, 'value' => $value, 'label' => $fieldLabel, 'status' => 'found');
    }

    $this->log(var_export($fields,true));

    return $fields;
  }

  private function beforeSaveExistingRecord($entityData) {

    $adb = PearDatabase::getInstance();

    $query = "SELECT f.columnname, f.fieldname
              FROM vtiger_fieldmodulerel r, vtiger_field f
              WHERE r.fieldid = f.fieldid
              AND module = 'VebWebforms'";

    $result = $adb->pquery($query, array());

    // query to find the entity in crmentity
    $query = "SELECT crmid FROM vtiger_crmentity WHERE deleted = 0 AND crmid = ?";

    while($row = $adb->fetchByAssoc($result)) {

      $fieldName = $row['fieldname'];

      if (empty($entityData->get($fieldName))) {

        // no need to check for existance
        continue;
      }

      $rslt = $adb->pquery($query, array($entityData->get($fieldName)));

      // if exactly 1 found, entity still exists
      $noRows = $adb->num_rows($rslt);

      if ($noRows == 1) {

        // it still exists
        continue;
      }

      // entity is deleted, set to 0
      $entityData->set($fieldName, 0);
    }
  }

  private function beforeSaveNewRecord($entityData) {

    /*
     * - die het formulier afhandelt zodra het is opgeslagen (on save) en de Relatie naar bestaande Contacten/Leads verzorgt
     * --- wat is de match?
     * --- * email - entityData->get('email');
     * --- *** welk email adres - contact: email/otheremail/secondaryemail
     * --- *** welk email adres - lead: email/otheremail/secondaryemail
     * --- * voornaam/achernaam - entityData->get('firstname'), entityData->get('lastname');
     ********** alle velden type email
     *
     * - bij 100% exact match ook aan organisatie
     * --- std. vragen we niet om organisatie
     * --- klant customveld organisatie -> hoe herken ik dat in handler?
     *
     * - Als geen bestaande Contact/Lead dan een Lead aanmaken (ook als er wel een organisatie bestaat)
     *
     */

    // see if account exists, spins off to contact and/or lead
    $this->handleAccount($entityData);

    // so, visitor has entered emailaddress, we are allowed to contact him/her
    // $entityData->set('emailoptin', 1);

    /*
     * enrich data with utm_*
     *
     */
    $this->enrichWithUtm($entityData);

    /*
     * enrich data with campaign
     *
     */
    $this->enrichWithCampaign($entityData);

    /*
     * enrich data with request
     *
     */
    $this->enrichWithRequest($entityData);

    /*
     * set default statusd
     *
     */
    $this->enrichWithSystemMsgs($entityData);
  }

  private function enrichWithSystemMsgs($entityData) {

    $entityData->set('vwfsystem', 'VebWebformsHandler: '.implode("\n", $this->systemMsgs));
  }

  private function enrichWithCampaign($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // link to campaign - if activated
    if (!vtlib_isModuleActive('Campaigns')) {

      $this->systemMsgs[] = 'VebWebformsHandler: Module Campaigns is not active/installed';
      return false;
    }

    if (array_key_exists('utm_campaign', $_REQUEST) && !empty($_REQUEST['utm_campaign'])) {

      // figure out if field 'veb_campaignid' exists within the campaigns-module
      $moduleModel = Vtiger_Module_Model::getInstance('Campaigns');
      $fieldnameCampaignId = 'vwfcampaignid';
      $fieldModel = $moduleModel->getFieldByColumn($fieldnameCampaignId);

      // backwards compatible
      if (empty($fieldModel)) {

        $fieldnameCampaignId = 'veb_campaignid';
        $fieldModel = $moduleModel->getFieldByColumn($fieldnameCampaignId);
      }

      // when NULL, no field by that name
      if (empty($fieldModel)) return;

      $query = sprintf("SELECT e.crmid FROM vtiger_campaign c, vtiger_crmentity e
                        WHERE c.campaignid = e.crmid
                        AND e.deleted = 0
                        AND c.%s = ?", $fieldnameCampaignId);

      $result = $this->queryQuery($query, array(vtlib_purify($_REQUEST['utm_campaign'])));

      if ($result) $entityData->set('campaignid', $result['crmid']);
    }
  }

  private function enrichWithUtm($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    /*
     * array(4) {
     *   ["utm_source"]=> string(8) "Facebook"
     *   ["utm_medium"]=> string(4) "Paid"
     *   ["utm_campaign"]=> string(21) "Conversiecampagne2018"
     *   ["utm_term"]=> string(4) "Term"
     *   ["utm_content"]=> string(4) "Ad_a"
     * }
     */
    $utmKeys = array('utm_source', 'utm_medium', 'utm_campaign', 'utm_term', 'utm_content');

    foreach($utmKeys as $utmKey) {

      if (array_key_exists($utmKey, $_REQUEST) && !empty($_REQUEST[$utmKey])) {

        $entityData->set($utmKey, vtlib_purify($_REQUEST[$utmKey]));
      }
    }
  }

  private function enrichWithRequest($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    if (!$entityData->isNew()) return;

    // nog velden skippen?

    // get the fields from request matched in vtiger - to get translation
    $fields = $this->getFieldsFromRequest();

    $dataEntities = array();
    foreach($_REQUEST as $fieldName => $value) {

      $translatedLabel = vtranslate($fields[$fieldName]['label'], 'VebWebforms');
      $dataEntities[] = sprintf("%s=%s", vtlib_purify($translatedLabel), vtlib_purify($value));
    }

    $entityData->set('vwfrequest', 'VebWebformsHandler: '.implode("\n", $dataEntities));
  }

  private function handleAccount($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    if (!vtlib_isModuleActive('Accounts')) {

       $this->systemMsgs[] = 'VebWebformsHandler: Module Accounts is not active/installed';

       // handle contact
       return $this->handleContact($entityData);
    }

    if ($entityData->get('accountid') > 0) {

      $this->systemMsgs[] = 'VebWebformsHandler: Account already specified in submitted data';

      // to contact-routine-check
      return $this->handleContact($entityData);
    }

    if ($entityData->get('accountid') == 0 && empty($entityData->get('accountname'))) {

       $this->systemMsgs[] = 'VebWebformsHandler: Account/Organisation name not specified';

       // handle contact
       return $this->handleContact($entityData);
    }

    if ($entityData->get('accountid') == 0 && !empty($entityData->get('accountname'))) {

      $this->checkForAccountByAccountName($entityData);
    }

    // match done for accountid via vwf.accountname - match either found or not
    // enter contact-routine
    return $this->handleContact($entityData);
  }

  private function checkForAccountByAccountName($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    $accountName = strtolower($entityData->get('accountname'));

    $query = "SELECT accountid
              FROM vtiger_account a, vtiger_crmentity e
              WHERE a.accountid = e.crmid
              AND e.deleted = 0
              AND LOWER(accountname) = ?";

    $accountData = $this->queryQuery($query, array($accountName));

    // when found, enrich $entityData
    if ($accountData !== false) {

      $entityData->set('accountid', $accountData['accountid']);
    }
    else {

      $this->systemMsgs[] = sprintf('VebWebformsHandler: No matching Account/Organisation found: %s', $accountName);
    }
  }

  private function handleLead($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    if (!vtlib_isModuleActive('Leads')) {

       $this->systemMsgs[] = 'VebWebformsHandler: Module Leads is not active/installed';
       return false;
    }

    // check when set
    if (empty($entityData->get('email'))) {

      $this->systemMsgs[] = 'VebWebformsHandler: Lead Email-address not specified';

      return $this->createLead($entityData);
    }

    return $this->checkForLeadByEmailAddress($entityData);
  }

  private function checkForLeadByEmailAddress($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    if (empty($entityData->get('accountname'))) {

      return $this->checkForLeadWithoutAccountName($entityData);
    }

    // !empty($entityData->get('accountname'))
    return $this->checkForLeadWithAccountName($entityData);
  }

  private function checkForLeadWithoutAccountName($entityData) {

    // @change t49019
    $emailAddress = strtolower($entityData->get('email'));
    //
 
    // get the type email fields
    $emailTypeFields = $this->getAllTypeEmailFields('Leads');

    $params = array($emailAddress);

    foreach($emailTypeFields as $emailTypeField) {

      // @change t49019
      /*
      $query = sprintf("SELECT l.leadid
                        FROM vtiger_leaddetails l, vtiger_leadscf cf, vtiger_crmentity e
                        WHERE l.leadid = cf.leadid
                        AND l.leadid = e.crmid
                        AND e.deleted = 0
                        AND l.converted = 0
                        AND %s = ?", $emailTypeField['columnname']);
      */
      $query = sprintf("SELECT l.leadid
                        FROM vtiger_leaddetails l, vtiger_leadscf cf, vtiger_crmentity e
                        WHERE l.leadid = cf.leadid
                        AND l.leadid = e.crmid
                        AND e.deleted = 0
                        AND l.converted = 0
                        AND LOWER(%s) = ?", $emailTypeField['columnname']);
      //

      $leadData = $this->queryQuery($query, $params);

      if ($leadData !== false) break;
    }

    // when found, enrich $entityData
    if ($leadData !== false) {

      $entityData->set('leadid', $leadData['leadid']);
      return true;
    }

    // as last resort
    return $this->createLead($entityData);
  }

  private function checkForLeadWithAccountName($entityData) {

    // @change lro 250430
    // $emailAddress = $entityData->get('email');
    $emailAddress = strtolower($entityData->get('email'));

    // @change t49019
    // $accountName = $entityData->get('accountname');
    $accountName = strtolower($entityData->get('accountname'));
    //

    // get the type email fields
    $emailTypeFields = $this->getAllTypeEmailFields('Leads');

    $params = array($emailAddress, $accountName);

    foreach($emailTypeFields as $emailTypeField) {

      // take account into account :)
      // @change t49019
      /*
      $query = sprintf("SELECT l.leadid
                        FROM vtiger_leaddetails l, vtiger_leadscf cf, vtiger_crmentity e
                        WHERE l.leadid = cf.leadid
                        AND l.leadid = e.crmid
                        AND e.deleted = 0
                        AND l.converted = 0
                        AND %s = ?
                        AND LOWER(company) = ?", $emailTypeField['columnname']);
      */
      $query = sprintf("SELECT l.leadid
                        FROM vtiger_leaddetails l, vtiger_leadscf cf, vtiger_crmentity e
                        WHERE l.leadid = cf.leadid
                        AND l.leadid = e.crmid
                        AND e.deleted = 0
                        AND l.converted = 0
                        AND LOWER(%s) = ?
                        AND LOWER(company) = ?", $emailTypeField['columnname']);
      //

      $leadData = $this->queryQuery($query, $params);

      if ($leadData !== false) break;
    }

    // when found, enrich $entityData
    if ($leadData !== false) {

      $entityData->set('leadid', $leadData['leadid']);
      return true;
    }

    // as last resort
    return $this->createLead($entityData);
  }

  private function checkForLeadByFirstLastname($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // @change t49019
    // $firstName = $entityData->get('firstname');
    // $lastName = $entityData->get('lastname');
    $firstName = strtolower($entityData->get('firstname'));
    $lastName = strtolower($entityData->get('lastname'));
    //

    if (empty($firstName) && empty($lastname)) return false;

    // @change t49019
    /*
    $query = "SELECT l.leadid
              FROM vtiger_leaddetails l, vtiger_crmentity e
              WHERE l.leadid = e.crmid
              AND l.converted = 0
              AND e.deleted = 0
              AND l.firstname = ?
              AND l.lastname = ?";
     */
    $query = "SELECT l.leadid
              FROM vtiger_leaddetails l, vtiger_crmentity e
              WHERE l.leadid = e.crmid
              AND l.converted = 0
              AND e.deleted = 0
              AND LOWER(l.firstname) = ?
              AND LOWER(l.lastname) = ?";

    return $this->queryQuery($query, array($firstName, $lastName));
  }

  private function createLead($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // using webservice (?)
    $focus = CRMEntity::getInstance('Leads');
    $srcEntity = CRMEntity::getInstance('VebWebforms');

    $focus->column_fields->offsetSet('company', $entityData->get('accountname'));
    $focus->column_fields->offsetSet('salutationtype', $entityData->get('salutationtype'));
    $focus->column_fields->offsetSet('firstname', $entityData->get('firstname'));
    $focus->column_fields->offsetSet('lastname', $entityData->get('lastname'));
    $focus->column_fields->offsetSet('email', strtolower($entityData->get('email')));
    $focus->column_fields->offsetSet('phone', $entityData->get('phone'));
    $focus->column_fields->offsetSet('mobile', $entityData->get('mobile'));

    $this->handleOptin($focus, $entityData);

    $focus->column_fields->offsetSet('assigned_user_id', $entityData->get('assigned_user_id'));
    $focus->mode = '';

    // defaults
    $focus->column_fields->offsetSet('leadstatus', 'Unknown');

    // need to check if additional mapping is needed
    $webformMapping = Settings_VebMapping_Module_Model::getMapping('VebWebforms', 'Leads');

    foreach($webformMapping as $srcFldName => $dstFldName) {

      if ($srcEntity->column_fields->offsetExists($srcFldName) && $focus->column_fields->offsetExists($dstFldName)) {

        $focus->column_fields->offsetSet($dstFldName, $entityData->get($srcFldName));
      }
      else {

        // log?
      }
    }

    $leadId = $focus->saveentity('Leads');

    // created id is stored in id
    $entityData->set('leadid', $focus->id);

    return true;
  }

  private function handleOptin($focus, $entityData) {

     // does field exist on webform?
     if (is_null($entityData->get('emailoptin'))) return false;

     $moduleName = get_class($focus);

     switch($moduleName) {

       case 'Leads':

         // original fieldname - backwards compatible
         $optinFieldName = 'veb_l_emailoptin';

         // new fieldname
         if ($focus->column_fields->offsetExists('veb_emailoptin')) $optinFieldName = 'veb_emailoptin';
         break;

       case 'Contacts':

         // original fieldname - backwards compatible
         $optinFieldName = 'veb_c_emailoptin';

         // new fieldname
         if ($focus->column_fields->offsetExists('veb_emailoptin')) $optinFieldName = 'veb_emailoptin';
         break;

       default:
         break;
     }

     // set value
     $focus->column_fields->offsetSet($optinFieldName, $entityData->get('emailoptin'));

     // set reason
     $this->handleConsentText($focus, $entityData);

     return true;
  }

  private function handleConsentText($focus, $entityData) {

    if (empty($entityData->get('emailoptin'))) {

      $focus->column_fields->offsetSet('veb_emailconsent_text', vtranslate('UnSet via contact-form', 'VebWebforms'));
    }
    else {

      $focus->column_fields->offsetSet('veb_emailconsent_text', vtranslate('Set via contact-form', 'VebWebforms'));
    }
  }

  private function handleContact($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

/*
    // what to do if entitydata.accountid = 0, but contact is member of account? i.e. contactdetails.accountid != 0
    // what to do if entitydata.accountid != 0, but contact is member of another account?
    // i.e. contactdetails.accountid != 0 && contactdetails.accountid != entitydata.accountid
    // - note: these checks are *not* implemented
    if ($entityData->get('contactid') > 0) {

      $this->systemMsgs[] = 'Contact already specified in submitted data';
      return;
    }
*/
    if (!vtlib_isModuleActive('Contacts')) {

       $this->systemMsgs[] = 'VebWebformsHandler: Module Contacts is not active/installed';

       // handle the lead
       return $this->handleLead($entityData);
    }

    if (empty($entityData->get('email'))) {

      $this->systemMsgs[] = 'VebWebformsHandler: Contact Email address not specified';

      return $this->handleLead($entityData);
    }

    // @change t45570
    return $this->checkForContactWithoutAccountId($entityData);
    //
 
    // !empty($entityData->get('email'))
    return $this->checkForContactByEmailAddress($entityData);
  }

  private function checkForContactByEmailAddress($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // no account found, so accountId = 0, do not link it to a Contact, but check Lead
    if ((int)$entityData->get('accountid') == 0 && !empty($entityData->get('accountname'))) {

      $this->systemMsgs[] = 'VebWebformsHandler: Account/Organisation specified, but non existing, so no need to look for Contact';

      return $this->handleLead($entityData);
    }

    // if account is matched via handleAccount (accountid > 0) check only those contacts
    if ((int)$entityData->get('accountid') == 0) {

      return $this->checkForContactWithoutAccountId($entityData);
    }

    // (int)$entityData->get('accountid') > 0
    return $this->checkForContactWithAccountId($entityData);
  }

  private function checkForContactWithAccountId($entityData) {

    $emailAddress = strtolower($entityData->get('email'));
    $accountId = $entityData->get('accountid');

    // get the type email fields
    $emailTypeFields = $this->getAllTypeEmailFields('Contacts');

    $sqlQuery = "SELECT c.contactid FROM vtiger_contactdetails c, vtiger_contactscf cf, vtiger_crmentity e
                 WHERE c.contactid = cf.contactid
                 AND c.contactid = e.crmid
                 AND e.deleted = 0
                 AND LOWER(%s) = ?
                 AND c.accountid = ?";

    $params = array($emailAddress, $accountId);

    foreach($emailTypeFields as $emailTypeField) {

      $query = sprintf($sqlQuery, $emailTypeField['columnname']);

      $contactData = $this->queryQuery($query, $params);

      if ($contactData !== false) break;
    }

    // when found, enrich $entityData
    if ($contactData !== false) {

      $entityData->set('contactid', $contactData['contactid']);
      return true;
    }

    // as last escape: lead
    return $this->handleLead($entityData);
  }

  private function checkForContactWithoutAccountId($entityData) {

    // @change t45570
    // $emailAddress = $entityData->get('email');
    $emailAddress = strtolower($entityData->get('email'));

    // get the type email fields
    $emailTypeFields = $this->getAllTypeEmailFields('Contacts');

    $sqlQuery = "SELECT c.contactid, c.accountid FROM vtiger_contactdetails c, vtiger_contactscf cf, vtiger_crmentity e
                 WHERE c.contactid = cf.contactid
                 AND c.contactid = e.crmid
                 AND e.deleted = 0
                 AND LOWER(%s) = ?";

    $params = array($emailAddress);

    foreach($emailTypeFields as $emailTypeField) {

      $query = sprintf($sqlQuery, $emailTypeField['columnname']);

      $contactData = $this->queryQuery($query, $params);

      if ($contactData !== false) break;
    }

    // when found, enrich $entityData
    if ($contactData !== false) {

      $entityData->set('contactid', $contactData['contactid']);

      // set the linked account too, if previous account is empty
      // if ((int)$contactData['accountid'] > 0 && $accountId == 0) $entityData->set('accountid', $contactData['accountid']);

      return true;
    }

    // as last escape: lead
    return $this->handleLead($entityData);
  }

  private function checkForContactByFirstLastname($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // @change t49019
    // $firstName = $entityData->get('firstname');
    // $lastName = $entityData->get('lastname');
    $firstName = strtolower($entityData->get('firstname'));
    $lastName = strtolower($entityData->get('lastname'));
    //

    if (empty($firstName) && empty($lastname)) return false;

    // @change t49019
    /*
    $query = "SELECT c.contactid, c.accountid
              FROM vtiger_contactdetails c, vtiger_crmentity e
              WHERE c.contactid = e.crmid
              AND e.deleted = 0
              AND c.firstname = ?
              AND c.lastname = ?";
     */
    $query = "SELECT c.contactid, c.accountid
              FROM vtiger_contactdetails c, vtiger_crmentity e
              WHERE c.contactid = e.crmid
              AND e.deleted = 0
              AND LOWER(c.firstname) = ?
              AND LOWER(c.lastname) = ?";

    return $this->queryQuery($query, array($firstName, $lastName));
  }

  private function getAllTypeEmailFields($moduleName) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // get the tabid
    $instance = Vtiger_Module::getInstance($moduleName);
    $tabId = $instance->getId();

    // get all email address fields from vtiger_field - uitype 13
    $query = "SELECT columnname, tablename FROM vtiger_field WHERE tabid = ? AND uitype = ?";
    $result = $this->queryQuery($query, array($tabId, 13), false);

    return $result;
  }

  private function queryQuery($query, $params, $onlyOne = true) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    $adb = PearDatabase::getInstance();

    $result = $adb->pquery($query, $params);

    $noOfRows = $adb->num_rows($result);

    // preferable 1 result ... other than 1, return first one
    if ($noOfRows > 1 && $onlyOne === true) {

      $this->systemMsgs[] = sprintf('VebWebformsHandler: Found 2 or more matches for: %s', implode("\n", $params));
      return false;
    }

    if ($noOfRows == 1 && $onlyOne === true) {

      // 1 100% match
      return $adb->fetchByAssoc($result);
    }

    if ($noOfRows == 0) return false;

    $row = array();

    while($row = $adb->fetchByAssoc($result)) {

      $rows[] = $row;
    }

    return $rows;
  }

  private function emailConsentProcess($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // is module installed and active?
    if (!vtlib_isModuleActive('VebEmailConsent')) {

      // systemMsgs heeft hier niet zoveel zin... is al weggeschreven
      $this->systemMsgs[] = 'VebWebformsHandler: Module VebEmailConsent is not active/installed';
      return false;
    }

    // consent module adds the emailoptin field to the Lead/Contact-form
    $this->processEmailConsent($entityData);

    return true;
  }

  private function processEmailConsent($entityData) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    if ((int)$entityData->get('leadid') > 0) {

      // update emailconsent & run workflows
      $focus = CRMEntity::getInstance('Leads');

      $focus->id = $entityData->get('leadid');
      $focus->mode = 'edit';
      $focus->retrieve_entity_info($focus->id, 'Leads');

      $this->handleOptin($focus, $entityData);

      // save and execute workflows
      $focus->save('Leads');
    }

    if ((int)$entityData->get('contactid') > 0) {

      // update emailconsent & run workflows
      $focus = CRMEntity::getInstance('Contacts');

      $focus->id = $entityData->get('contactid');
      $focus->mode = 'edit';
      $focus->retrieve_entity_info($focus->id, 'Contacts');

      $this->handleOptin($focus, $entityData);

      // save and execute workflows - update updateTab
      $focus->save('Contacts');
    }
  }

  // static function linkRelation($sourceModule, $sourceId, $targetModule, $targetId)
  private function updateUpdateTab($sourceModule, $sourceId, $targetId) {

    $this->log(__LINE__ . ' ' . var_export(__FUNCTION__, true));

    // Track the time the relation was added
    require_once('modules/ModTracker/ModTracker.php');
    ModTracker::linkRelation($sourceModule, $sourceId, 'VebWebforms', $targetId);
  }

  private function log($msg) {

    return;
    error_log('VebWebforms - ' . $msg, 0);
  }
}
