<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once('modules/Vtiger/CRMEntity.php');

class VebWebforms extends Vtiger_CRMEntity {

  var $table_name = 'vtiger_veb_webforms';
  var $table_index= 'webformid';

  /**
   * Mandatory table for supporting custom fields.
   */
  var $customFieldTable = array('vtiger_veb_webformscf', 'webformid');

  /**
   * Mandatory for Saving, Include tables related to this module.
   */
  var $tab_name = array('vtiger_crmentity', 'vtiger_veb_webforms', 'vtiger_veb_webformscf');

  /**
   * Mandatory for Saving, Include tablename and tablekey columnname here.
   */
  var $tab_name_index = array(
    'vtiger_crmentity' => 'crmid',
    'vtiger_veb_webforms' => 'webformid',
    'vtiger_veb_webformscf' =>'webformid');

  /**
   * Mandatory for Listing (Related listview)
   */
  var $list_fields = array (
    'LBL_VEBWEBFORM_NO' => array('veb_webforms', 'webformno'),
    'LBL_ACCOUNTNAME' => array('veb_webforms', 'accountname'),
    'Firstname' => array('veb_webforms', 'firstname'),
    'Lastname' => array('veb_webforms', 'lastname'),
    'Email' => array('veb_webforms', 'email'),
    'Phone' => array('veb_webforms', 'phone'),
    'Mobile' => array('veb_webforms', 'mobile'),
  );

  var $list_fields_name = array (
    'LBL_VEBWEBFORM_NO' => 'webformno',
    'LBL_ACCOUNTNAME' => 'accountname',
    'Firstname' => 'firstname',
    'Lastname' => 'lastname',
    'Email' => 'email',
    'Phone' => 'phone',
    'Mobile' => 'mobile',
  );

  // Make the field link to detail view
  var $list_link_field = '';

  // For Popup listview and UI type support
  var $search_fields = array(
    'LBL_VEBWEBFORM_NO' => array('veb_webforms', 'webformno'),
    'LBL_ACCOUNTNAME' => array('veb_webforms', 'accountname'),
    'Firstname' => array('veb_webforms', 'firstname'),
    'Lastname' => array('veb_webforms', 'lastname'),
    'Email' => array('veb_webforms', 'email'),
    'Phone' => array('veb_webforms', 'phone'),
    'Mobile' => array('veb_webforms', 'mobile'),
  );

  var $search_fields_name = array (
    'LBL_VEBWEBFORM_NO' => 'webformno',
    'LBL_ACCOUNTNAME' => 'accountname',
    'Firstname' => 'firstname',
    'Lastname' => 'lastname',
    'Email' => 'email',
    'Phone' => 'phone',
    'Mobile' => 'mobile',
  );

  // For Popup window record selection
  var $popup_fields = array ('');

  // For Alphabetical search
  var $def_basicsearch_col = '';

  // Column value to use on detail view record text display
  var $def_detailview_recname = '';

  // Used when enabling/disabling the mandatory fields for the module.
  // Refers to vtiger_field.fieldname values.
  var $mandatory_fields = array('','assigned_user_id');

  var $default_order_by = '';
  var $default_sort_order='ASC';

  /**
   * Invoked when special actions are performed on the module.
   * @param String Module name
   * @param String Event Type
   */
  function vtlib_handler($moduleName, $eventType) {

    global $adb;

    if($eventType == 'module.postinstall') {

      // TODO Handle actions after this module is installed.
      $entity= new CRMEntity();
      $entity->setModuleSeqNumber('configure', 'VebWebforms', 'VWF', 1);

      // Mark the module as Standard module
      $adb->pquery('UPDATE vtiger_tab SET customized = 0 WHERE name = ?', array($moduleName));
       
      $instance = Vtiger_Module::getInstance('VebWebforms');

      //adds sharing accsess
      Vtiger_Access::setDefaultSharing($instance);

      // get relation field to accounts
      $fieldInstance = Vtiger_Field_Model::getInstance('accountid', $instance);
      $fieldId = $fieldInstance->getId();

      // accounts related tab
      $relatedInstance = Vtiger_Module::getInstance('Accounts');
      $relatedInstance->setRelatedlist($instance, 'VebWebforms', array(), 'get_dependents_list', $fieldId);

      // get relation field to contacts
      $fieldInstance = Vtiger_Field_Model::getInstance('contactid', $instance);
      $fieldId = $fieldInstance->getId();

      // contacts related tab
      $relatedInstance = Vtiger_Module::getInstance('Contacts');
      $relatedInstance->setRelatedlist($instance, 'VebWebforms', array(), 'get_dependents_list', $fieldId);

      // test for active
      if (vtlib_isModuleActive('Leads')) {

        // get relation field to leads
        $fieldInstance = Vtiger_Field_Model::getInstance('leadid', $instance);
        $fieldId = $fieldInstance->getId();

        // leads related tab
        $relatedInstance = Vtiger_Module::getInstance('Leads');
        $relatedInstance->setRelatedlist($instance, 'VebWebforms', array(), 'get_dependents_list', $fieldId);
      }

      // test for active
      if (vtlib_isModuleActive('Campaigns')) {

        // add campaign-reference-id to Campaigns table
        $this->addCampaignId();

        // get relation field to campaigns
        $fieldInstance = Vtiger_Field_Model::getInstance('campaignid', $instance);
        $fieldId = $fieldInstance->getId();

        // campaign related tab
        $relatedInstance = Vtiger_Module::getInstance('Campaigns');
        $relatedInstance->setRelatedlist($instance, 'VebWebforms', array(), 'get_dependents_list', $fieldId);
      }
      else {

        // disable field campaignid
        $adb->pquery("UPDATE vtiger_field SET presence = 1 WHERE columnname = 'campaignid' AND tablename = 'vtiger_veb_webforms'", array());
      }

      // test for active
      if (!vtlib_isModuleActive('WebVisits')) {

        // disable field webvisit fields
        $adb->pquery("UPDATE vtiger_field SET presence = 1 WHERE columnname = 'webvisitid' AND tablename = 'vtiger_veb_webforms'", array());
        $adb->pquery("UPDATE vtiger_field SET presence = 1 WHERE columnname = 'wv_sfvisitid' AND tablename = 'vtiger_veb_webforms'", array());
      }

      // the update tab
      $tabId = $instance->getId();
      $adb->pquery("INSERT INTO `vtiger_modtracker_tabs` (`tabid`, `visible`) VALUES (?, ?);", array($tabId,1));

      // headerscript for readonly edit and quickedit views
      Vtiger_Link::addLink($tabId, 'HEADERSCRIPT', 'ReadOnlyFieldsScript', 'layouts/v7/modules/VebWebforms/resources/Readonly.js');

      // modcomments on summary tab
      $modCommentsInstance = Vtiger_Module::getInstance('ModComments');
      $modCommentsFieldInstance = Vtiger_Field_Model::getInstance('related_to', $modCommentsInstance);
      $fieldId = $modCommentsFieldInstance->getId();

      $adb->pquery("INSERT INTO `vtiger_fieldmodulerel` (`fieldid`, `module`, `relmodule`, `status`, `sequence`)
                    VALUES (?, 'ModComments', 'VebWebforms', NULL, NULL);", array($fieldId));

      $this->setWSEntity();
      $this->handlePackaged();

    } else if($eventType == 'module.disabled') {
      // TODO Handle actions before this module is being uninstalled.
    } else if($eventType == 'module.preuninstall') {
      // TODO Handle actions when this module is about to be deleted.
    } else if($eventType == 'module.preupdate') {
      // TODO Handle actions before this module is updated.
    } else if($eventType == 'module.postupdate') {
      // TODO Handle actions after this module is updated.
    }    
  }

  private function setWSEntity() {

    global $adb;

    $query = "SELECT name FROM vtiger_ws_entity WHERE name=?";
    $result = $adb->pquery($query,array('VebWebforms'));
    $noRows = $adb->num_rows($result);

    if($noRows == 0) {

      $query = "INSERT INTO vtiger_ws_entity (name, handler_path, handler_class, ismodule)
                VALUES ('VebWebforms', 'include/Webservices/VtigerModuleOperation.php', 'VtigerModuleOperation', '1')";
      $result = $adb->pquery($query, array());

      $query = "UPDATE vtiger_ws_entity_seq SET id = id + 1;";
      $result = $adb->pquery($query, array());
    }
  }

  private function addCampaignId() {

    $blockName = 'LBL_CAMPAIGN_INFORMATION';
    $campaignsInstance = Vtiger_Module::getInstance('Campaigns');
    $blockInstance = Vtiger_Block::getInstance($blockName, $campaignsInstance);

    $field = new Vtiger_Field();

    if ($field->getInstance('veb_campaignid', $campaignsInstance) === false) {

      $field->label = 'Campaign Id';
      $field->name = 'veb_campaignid';
      $field->table = 'vtiger_campaign';
      $field->column = 'veb_campaignid';
      $field->columntype = 'varchar(100)';
      $field->uitype = 1;
      $field->typeofdata = 'V~O';
      $blockInstance->addField($field);
    }
  }

  private function handlePackaged() {

    $packagedFiles = array(
                           array('src' => 'Module.php',
                                 'dst' => 'Module.php',
                                 'path' => 'modules/Settings/Webforms/models/',
                                 'note' => 'core update to enable VebWebforms in picklist'
                           ),
                           array('src' => 'capture.php',
                                 'dst' => 'capture.php',
                                 'path' => 'modules/Settings/Webforms/',
                                 'note' => 'new capture.php to enable honeypot'
                           ),
                           array('src' => 'capture_vtigecrm.php',
                                 'dst' => 'capture_vtigecrm.php',
                                 'path' => 'modules/Settings/Webforms/',
                                 'note' => 'original capture.php to collaborate with honeypot'
                           ),
                           array('src' => 'honeypot.php',
                                 'dst' => 'honeypot.php',
                                 'path' => 'modules/Settings/Webforms/',
                                 'note' => 'script to enable call to honeypot server'
                           ),
                           array('src' => 'jquery-min.js',
                                 'dst' => 'jquery-min.js',
                                 'path' => 'js/',
                                 'note' => 'addon to enable extra javascript to form'
                           ),
                           array('src' => 'capture.js',
                                 'dst' => 'capture.js',
                                 'path' => 'js/',
                                 'note' => 'addon to enable extra javascript to form'
                           ),
                           array('src' => 'htaccess',
                                 'dst' => '.htaccess',
                                 'path' => 'js/',
                                 'note' => 'addon to prevent directory browsing'
                           ),
                           array('src' => 'LeadHandler.php',
                                 'dst' => 'LeadHandler.php',
                                 'path' => 'modules/Leads/handlers/',
                                 'note' => 'core update related Tab mapping VebWebforms and WebVisits when converting Lead'
                           ),
                           array('src' => 'List.js',
                                 'dst' => 'List.js',
                                 'path' => 'layouts/v7/modules/Settings/Webforms/resources/',
                                 'note' => 'core update to enable extra javascript at end of form'
                           ),
                           array('src' => 'Detail.js',
                                 'dst' => 'Detail.js',
                                 'path' => 'layouts/v7/modules/Settings/Webforms/resources/',
                                 'note' => 'core update to enable extra javascript at end of form'
                           )
                       ); 

    foreach($packagedFiles as $packagedFile) {

      // test if directory exists
      if (!file_exists($packagedFile['path'])) mkdir($packagedFile['path'], 0755, true);

      if (file_exists($packagedFile['path'] . $packagedFile['dst'])) {

        // check the hash
        $sha1org = sha1_file('modules/VebWebforms/packaged/' . $packagedFile['src']);
        $sha1dst = sha1_file($packagedFile['path'] . $packagedFile['dst']);

        // no overwrite needed if hash is equal
        if ($sha1org == $sha1dst) continue;

        if (file_exists($packagedFile['path'] . $packagedFile['dst'] . '.orig')) {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '_before' . date('Y-m-d'));
        }
        else {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '.orig');
        }
      }

      // ok to override
      copy('modules/VebWebforms/packaged/' . $packagedFile['src'], $packagedFile['path'] . $packagedFile['dst']);
    }
  }
}
