<?php

/*
 * needed for php/cron-processing:
 * include('includes/Loader.php');
 * include('include/utils/utils.php');
 * include('includes/runtime/Globals.php');
 * include('includes/runtime/BaseModel.php');
 * include('modules/Vtiger/models/Module.php');
 *
 * but not needed for taskplanner
 *
 */
chdir('../../../');
include('include/utils/utils.php');
include('emailbounceVerify.class.php');

class emailTest {

  private $adb;

  private $debug = false;

  private $verifyEmailClass;
  private $mtaErrorCodes;
  private $output;

  public function __construct() {

    // need to get the entities to handle
    $this->adb = PearDatabase::getInstance();
    $this->adb->setDebug('true');

    // the class
    $this->verifyEmailClass = new VerifyEmail;

    // the error codes
    $this->mtaErrorCodes = include('modules/VebEmailValidation/MTAErrorCodes.inc');
  }

  public function run() {

    $result = $this->adb->pquery($this->getSelectQuery(), array());

    $noOfRecords = $this->adb->num_rows($result);

    /*
     * object(stdClass)#28 (4) {
     *  ["code"]=> string(3) "250"
     *  ["subcode"]=> string(5) "2.1.5"
     *  ["msgs"]=> string(47) "250 2.1.5 <hoosting@fa.knaw.nl>... Recipient ok"
     *  ["debug"]=> array(11) {
     *     [0]=> string(49) "220 filter2-til.mf.surf.net ESMTP CanIt-Appliance"
     *     [1]=> string(40) "Connection success mx1.surfmailfilter.nl"
     *     [2]=> string(13) "HELO vicus.nl"
     *     [3]=> string(88) "250 filter2-til.mf.surf.net Hello tiberius.vicus.nl [185.87.248.85], pleased to meet you"
     *     [4]=> string(33) "MAIL FROM: <nieuwsbrief@vicus.nl>"
     *     [5]=> string(45) "250 2.1.0 <nieuwsbrief@vicus.nl>... Sender ok"
     *     [6]=> string(30) "RCPT TO: <hoosting@fa.knaw.nl>"
     *     [7]=> string(47) "250 2.1.5 <hoosting@fa.knaw.nl>... Recipient ok"
     *     [8]=> string(4) "RSET"
     *     [9]=> string(21) "250 2.0.0 Reset state"
     *     [10]=> string(4) "QUIT"
     *   }
     * }
     */
    for($i=0; $i<$noOfRecords; ++$i) {

      // get the id of the applicable lead
      $emailAddress = $this->adb->query_result($result, $i, 'email');
      $setype = $this->adb->query_result($result, $i, 'setype');
      $entityId = $this->adb->query_result($result, $i, 'id');

      // results are stored in $this->output
      $this->validateEmail($emailAddress);

      // default type
      $this->output->type = 'updateReason';

      // find the subcode in the MTAErrorcodes for a descriptive msg
      if (array_key_exists($this->output->subcode, $this->mtaErrorCodes)) {

        // use only the msg - or should we react on type?
        $this->output->msgs = $this->mtaErrorCodes[$this->output->subcode]['msg'];
        $this->output->type = $this->mtaErrorCodes[$this->output->subcode]['type'];
      }

      // store the output in the reference table
      $rslt = $this->insertIntoReferenceTable($emailAddress);

      // update the entity
      switch($setype) {

        case 'Leads':

          $rslt = $this->updateEntityLeads($entityId);
          break;

        case 'Contacts':

          $rslt = $this->updateEntityContacts($entityId);
          break;
      } 
    }

    return true;
  }

  private function insertIntoReferenceTable($emailAddress) {
  
    $params = array($emailAddress,
                    date('Y-m-d H:m:s'),
                    date('Y-m-d H:m:s'),
                    $this->output->msgs,
                    $this->output->code,
                    $this->output->subcode,
                    $this->output->type,
                    print_r($this->output->debug, true),
                    date('Y-m-d H:m:s'),
                    $this->output->msgs,
                    $this->output->code,
                    $this->output->subcode,
                    $this->output->type,
                    print_r($this->output->debug, true)
              );

    // insert into designated table
    return $this->adb->pquery($this->getEmailVerifiedQuery(), $params);
  }

  private function updateEntityLeads($entityId) {

    // we should not do anything when output->type = 'ok';
    if ($this->output->type == 'nobounce') return;

    $emailConsentOptoutReason = sprintf('%s %s %s', $this->output->code, $this->output->subcode, $this->output->msgs);

    switch(strtolower($this->output->type)) {

      case 'updatereason':
     
        // keep emailconsent status unchanged
        $query = 'UPDATE vtiger_leaddetails SET emailconsent_optout_reason = CONCAT(?, "\n", IF(emailconsent_optout_reason IS NULL, "", emailconsent_optout_reason))
                  WHERE leadid = ?;';
        $params = array($emailConsentOptoutReason, $entityId);
        break;

      default:
        // set emailconsent status bounced
        $query = 'UPDATE vtiger_leaddetails SET veb_l_emailconsent = ?,
                                                emailconsent_optout_reason = CONCAT(?, "\n", IF(emailconsent_optout_reason IS NULL, "", emailconsent_optout_reason))
                  WHERE leadid = ?;';
        $params = array('Bounced', $emailConsentOptoutReason, $entityId);
        break;
    }

    // update the entity
    return $this->adb->pquery($query, $params);
  }

  private function updateEntityContacts($entityId) {

    // we should not do anything when output->type = 'ok';
    if ($this->output->type == 'nobounce') return;

    $emailConsentOptoutReason = sprintf('%s %s %s', $this->output->code, $this->output->subcode, $this->output->msgs);

    switch(strtolower($output->code)) {

      case 'invalid':
      case 'unknown':
     
        // keep emailconsent status unchanged
        $query = 'UPDATE vtiger_contactdetails SET emailconsent_optout_reason = CONCAT(?, "\n", IF(emailconsent_optout_reason IS NULL, "", emailconsent_optout_reason))
                  WHERE contactid = ?;';
        $params = array($emailConsentOptoutReason, $entityId);
        break;

      default:

        // set emailconsent status bounced
        $query = 'UPDATE vtiger_contactdetails SET veb_c_emailconsent = ?,
                                                   emailconsent_optout_reason = CONCAT(?, "\n", IF(emailconsent_optout_reason IS NULL, "", emailconsent_optout_reason))
                  WHERE contactid = ?;';
        $params = array('Bounced', $emailConsentOptoutReason, $entityId);
        break;
     }

    // update the entity
    return $this->adb->pquery($query, $params);
  }

  private function validateEmail($emailAddress) {

    $this->verifyEmailClass->setStreamTimeoutWait(20);
    $this->verifyEmailClass->Debug= TRUE;
    $this->verifyEmailClass->setEmailFrom('nieuwsbrief@vicus.nl');

    $this->output = $this->verifyEmailClass->check($emailAddress);
  }

  private function getSelectQuery() {

    $query = "(SELECT vtiger_leaddetails.leadid AS id, vtiger_leaddetails.email, vtiger_crmentity.setype 
               FROM vtiger_leaddetails, vtiger_crmentity
               WHERE vtiger_leaddetails.leadid = vtiger_crmentity.crmid
               AND vtiger_crmentity.deleted =0
               AND vtiger_leaddetails.email != ''
               AND vtiger_leaddetails.email NOT IN (SELECT emailaddress FROM vtiger_emailverified)
               AND vtiger_leaddetails.veb_l_emailconsent NOT IN ('Bounced', 'Blacklisted', 'Unsubscribed')
              )
              UNION
              (SELECT vtiger_contactdetails.contactid AS id, vtiger_contactdetails.email, vtiger_crmentity.setype 
               FROM vtiger_contactdetails, vtiger_crmentity
               WHERE vtiger_contactdetails.contactid = vtiger_crmentity.crmid
               AND vtiger_crmentity.deleted =0
               AND vtiger_contactdetails.email != ''
               AND vtiger_contactdetails.email NOT IN (SELECT emailaddress FROM vtiger_emailverified)
               AND vtiger_contactdetails.veb_c_emailconsent NOT IN ('Bounced', 'Blacklisted', 'Unsubscribed')
              )
              LIMIT 100";

    return $query;
  }

  private function getEmailVerifiedQuery() {

    $query = "INSERT INTO vtiger_emailverified (`emailaddress`, `createdtime`, `validatetime`, `status`, `substatusprefix`, `substatus`, `action`, `message`)
              VALUES (?, ?, ?, ?, ?, ?, ?, ?)
              ON DUPLICATE KEY UPDATE `validatetime` = ?, `status` = ?, `substatusprefix` = ?, `substatus` = ?, `action` = ?, `message` = ?";

    return $query;
  }
}

$emailTest = new emailTest;
$emailTest->run();
