<?php
// run it from document root!
// so in public_html: php modules/VebEmailValidator/emailParser.php
// includes
require_once('includes/Loader.php');
require_once('vtlib/Vtiger/Utils.php');
require_once('includes/runtime/Globals.php');
require_once('includes/runtime/BaseModel.php');

// require_once('modules/Users/Users.php');
$user = new Users();

// define current user
$current_user = $user->retrieveCurrentUserInfoFromFile("1");

require_once('include/Webservices/Query.php');
require_once('include/Webservices/Revise.php');

class emailParser {

  private $inbox = null;

  private $emails = null;

  private $current_user;

  public $bounceCodes = array();

  public function __construct() {

    global $current_user;

    $this->current_user = $current_user;

    $this->bounceCodes = include('MTAErrorCodes.inc');
  }

  private function connect() {

    // Connectie maken met de mail - antoninus.vicus.nl (89.105.218.38) - config?
    // $hostname = '{89.105.218.38:143/imap/tls/novalidate-cert}INBOX';
    // $hostname = '{185.87.248.231:143/imap/tls/novalidate-cert}';
    // $hostname = 'mail.vicus.nl:143/imap/tls/novalidate-cert}';
    // $hostname = '{mail.vicus.nl:143/imap/tls/novalidate-cert}';
    $hostname = '{outlook.office365.com:993/imap/ssl/novalidate-cert}';
    // $hostname = '{outlook.office365.com:993/IMAP2/ssl/novalidate-cert}';

    $username = 'bounce@vicus.nl';
    $password = 'doteiT2u';

    // Connecten met mail
    $this->inbox = imap_open($hostname, $username, $password) or die('Cannot connect to mail: ' . imap_last_error());

    $this->server = str_replace('INBOX', '', $hostname);
    $this->connection = imap_open($this->server, $username, $password);
  }

  public function run() {

    // first of all, connect to the inbox
    $this->connect();

    // to tickle another box:
    // imap_reopen($this->inbox, $this->server.'INBOX.Undeliverable') or die(implode(", ", imap_errors()));

    $this->emails = imap_search($this->inbox,'ALL');

    $this->diagnosticRelated();

    // close it to expunge and cleanup
    $this->disconnect();

    // reconnect to the inbox
    $this->connect();

    // to tickle another box:
    // imap_reopen($this->inbox, $this->server.'INBOX.Undeliverable') or die(implode(", ", imap_errors()));

    $this->emails = imap_search($this->inbox,'ALL');
    $this->dispositionRelated();

    // close it to expunge and cleanup
    $this->disconnect();

    // reconnect for the next bunch
    $this->connect();

    // to tickle another box:
    // imap_reopen($this->inbox, $this->server.'INBOX.AutoReply') or die(implode(", ", imap_errors()));

    $this->emails = imap_search($this->inbox,'ALL');

    $this->autoReplyRelated();

    // close it to expunge and cleanup
    $this->disconnect();

    // reconnect for the next bunch
    $this->connect();

    // to tickle another box:
    // imap_reopen($this->inbox, $this->server.'INBOX.AutoReply') or die(implode(", ", imap_errors()));

    $this->emails = imap_search($this->inbox,'ALL');

    $this->statusCodeEmpty();

    // close it to expunge and cleanup
    $this->disconnect();

/*
    // reconnect for the next bunch
    $this->connect();

    // to tickle another box:
    // imap_reopen($this->inbox, $this->server.'INBOX.AutoReply') or die(implode(", ", imap_errors()));

    $this->emails = imap_search($this->inbox,'ALL');

    $this->mailboxFullRelated();

    // close it to expunge and cleanup
    $this->disconnect();
*/
  }

  private function statusCodeEmpty() {

    $reportingMta = array(
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#X-SendGrid-Sender: [\s\S]*?Action: ?(.*)[\s\S]*?Status: ?(.*)[\s\S]*?Diagnostic-Code: ?unable to get mx info: ?(.*)#i',
                            'location' => 4),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#X-SendGrid-Sender: [\s\S]*?Action: ?(.*)[\s\S]*?Status: ?(.*)[\s\S]*?Diagnostic-Code: ?550 ?(.*)#i',
                            'location' => 4),
                    );

    foreach($this->emails as $emailNumber) {

      $body = $this->getBody($emailNumber);

      foreach($reportingMta as $mta) {

        if (array_key_exists($emailNumber, $this->errors)) continue;

        $pattern = $mta['pattern'];
        $matches = array();
        preg_match($pattern, $body, $matches);

        if(count($matches) ==  0) continue;

        $reasonDescription = '';

        // matches > 1 = msg (only 2 lines extra)
        foreach($matches as $index => $match) {

          $match = trim($match);

          if ($index < $mta['location'] || empty($match)) continue;

          $reasonDescription .= ' ' . $match;
        }

        $bounceType = $this->getBounceInfo('5.5.0');

        // if no bouncetype found, next pattern
        if ($bounceType === false) continue;

        $this->errors[$emailNumber] = array('code' => $code,
                                            'status' => $statusCode,
                                            'message' => $reasonDescription,
                                            'type' => $bounceType['type'],
                                            'description' => sprintf("%s %s %s\n%s", $bounceType['type'], $statusCode, $bounceType['msg'], $reasonDescription),
                                            'recipient' => $this->getOriginalRecipient($emailNumber)
                                      );
      }
    }

    // reassign mail and handle errors
    $this->handle();
  }

  private function mailboxFullRelated($emailNumber) {

    $body = $this->getBody($emailNumber);

    $pattern = '/(.*)Delay reason:(.*)/i';
    $matches = array();
    preg_match($pattern, $body, $matches);

    if (empty(trim($matches[2]))) return false;

    return trim($matches[2]);
  }

  private function autoReplyRelated() {

    $this->errors = array();

    // create an array with subjects to search - config?
    $subjects = array('Automatisch Antwoord',
                      'Automatic Reply',
                      'Autoreply',
                      'Auto reply',
                      'Afwezig',
                      'Autosvar',
                );

    foreach($subjects as $subject) {

      // handle the email - it's 'auto-wildcard' and ignore case
      $this->emails = imap_search($this->inbox,'SUBJECT "' . $subject . '"');

      // move the emails found
      foreach($this->emails as $emailNumber) {

        $this->move($emailNumber, 'INBOX.AutoReply');
      }
    }
  }

  private function dispositionRelated() {

    $reportingUa = array(
                     array('msg' => 'Disposition',
                           'pattern' => '#Reporting-UA: ?([\s\S]*)?Disposition: ?(.*)([\s\S])#i',
                           'location' => 4),
                   );

    $this->errors = array();

    foreach($this->emails as $emailNumber) {

      // already matched? next
      if (array_key_exists($emailNumber, $this->errors)) continue;

      $body = $this->getBody($emailNumber);

      foreach($reportingUa as $ua) {

        // already matched? next
        if (array_key_exists($emailNumber, $this->errors)) continue;

        $pattern = $ua['pattern'];
        $matches = array();
        preg_match($pattern, $body, $matches);

        if (count($matches) == 0) continue;

        $this->errors[$emailNumber] = array('code' => $code,
                                            'status' => $statusCode,
                                            'message' => $matches[2],
                                            'type' => 'softbounce',
                                            'description' => 'softbounce Quota exceeded (mailbox for user is full)',
                                            'recipient' => $this->getOriginalRecipient($emailNumber)
                                      );
      }
    }

    // reassign mail and handle errors
    $this->handle();
  }

  private function diagnosticRelated() {

    // config?
    $reportingMta = array(
                      array('msg' => 'Last-Attempt-Date',
                            'pattern' => '#Reporting-MTA: ?([\s\S]*)?Status: ?(.*)([\s\S])Last-Attempt-Date: ?(.*)([\s\S])#i',
                            'location' => 4),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#Reporting-MTA: ?([\s\S]*)?Status: ?(.*)([\s\S])Diagnostic-Code: ?(.*)\s*(.*)#i',
                            'location' => 4),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#Reporting-MTA: ?([\s\S]*)?Status: ?(.*)([\s\S])Remote-MTA: ?(.*)([\s\S])Diagnostic-Code: smtp; ?(.*)\s*(.*)\s*(.*)\s*(.*)\s*(.*)#i',
                            'location' => 6),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#Reporting-MTA: ?([\s\S]*\v)?Status: ?(.*)([\s\S\v])Diagnostic-Code: smtp; ?(.*)#i',
                            'location' => 6),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#Reporting-MTA: ?([\s\S]*)?Status: ?(.*)([\s\S])Diagnostic-Code: smtp; ?(.*)#i',
                            'location' => 6),
                      array('msg' => 'Status',
                            'pattern' => '#Reporting-MTA: ?([\s\S]*)?Status: ?(\d.\d.\d)([\s\S])#i',
                            'location' => 4),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#X-SendGrid-Sender: [\s\S]*?Action: ?(.*)[\s\S]*?Status: ?(.*)[\s\S]*?Diagnostic-Code: ?(.*)#i',
                            'location' => 4),
                      array('msg' => 'Diagnostic-Code',
                            'pattern' => '#Reporting-MTA: [\s\S]*?Action: ?(.*)[\s\S]*?Status: ?(.*)[\s\S]*?Diagnostic-Code: ?(.*)#i',
                            'location' => 4),
                      array('msg' => 'Remote-MTA',
                            'pattern' => '#Reporting-MTA: [\s\S]*?Action: ?(.*)[\s\S]*?Status: ?(.*)[\s\S]*?Remote-MTA: ?(.*)#i',
                            'location' => 4),
                    );

    $this->errors = array();

    foreach($this->emails as $emailNumber) {

      // already matched? next
      if (array_key_exists($emailNumber, $this->errors)) continue;

      $body = $this->getBody($emailNumber);

      foreach($reportingMta as $mta) {

        $pattern = $mta['pattern'];
        $matches = array();
        preg_match($pattern, $body, $matches);    

        // already matched? next
        if (array_key_exists($emailNumber, $this->errors)) continue;

        // if(count($matches) ==  0) continue;

        // Notice: Undefined offset: 2
        $statusCode = trim(@$matches[2]);
        $code = $mta['msg'];

        // not found? next pattern
        if (empty($statusCode)) continue;

        $reasonDescription = '';

        // matches > 1 = msg (only 2 lines extra)
        foreach($matches as $index => $match) {

          $match = trim($match);

          if ($index < $mta['location'] || empty($match)) continue;
          if (strpos($match, '--') === 0) break;

          $reasonDescription .= ' ' . $match;
        }

        $bounceType = $this->getBounceInfo($statusCode);

        // if no bouncetype found, next pattern
        if ($bounceType === false) continue;

        $this->errors[$emailNumber] = array('code' => $code,
                                            'status' => $statusCode,
                                            'message' => $reasonDescription,
                                            'type' => $bounceType['type'],
                                            'description' => sprintf("%s %s %s\n%s", $bounceType['type'], $statusCode, $bounceType['msg'], $reasonDescription),
                                            'recipient' => $this->getOriginalRecipient($emailNumber)
                                      );
      }
    }

    // reassign mail and handle errors
    $this->handle();
  }

  private function getBounceInfo($status) {

    if(array_key_exists($status, $this->bounceCodes)) return $this->bounceCodes[$status];

    return false;
  }

  private function getBody($emailNumber) {

    return imap_body($this->inbox, $emailNumber);
  }

  private function getOriginalRecipient($emailNumber) {

    $body = $this->getBody($emailNumber);

    $pattern = '/Original-Recipient: rfc822;(.*)/i';
    $matches = array();
    preg_match($pattern, $body, $matches);

    $recipient = @trim($matches[1]);

    if (empty($recipient)) {

      $pattern = '/Final-Recipient: rfc822;(.*)/i';
      $matches = array();
      preg_match($pattern, $body, $matches);

      $recipient = trim($matches[1]);
    }

    return str_replace('>', '', str_replace('<', '', $recipient));
  }

  private function handle() {

// error_log(var_export($this->errors,true));

    // no errors, skip
    if (count($this->errors) == 0) return;

    foreach($this->errors as $emailNumber => $error) {

        $recipientFound  = 0;

       // no recipient found: next
       if (empty($error['recipient'])) continue;

      // get the information from crm - lead first
      $query = sprintf("select * from Leads where email = '%s';", $error['recipient']);
      $result = vtws_query($query, $this->current_user);
      $recipientFound = $recipientFound + count($result);
      $this->updateEntity($emailNumber, $result, $error);

      // get the information from crm - account
      $query = sprintf("select * from Accounts where email1 = '%s';", $error['recipient']);
      $result = vtws_query($query, $this->current_user);
      $recipientFound = $recipientFound + count($result);
      $this->updateEntity($emailNumber, $result, $error);

      // get the information from crm - contact
      $query = sprintf("select * from Contacts where email = '%s';", $error['recipient']);
      $result = vtws_query($query, $this->current_user);
      $recipientFound = $recipientFound + count($result);
      $this->updateEntity($emailNumber, $result, $error);
      
      if ($recipientFound == 0) {
        $this->move($emailNumber, 'INBOX.RecipientNotFound');
      }
      
    }
  } 

  private function updateEntity($emailNumber, $result, $error) {

    // when email is no lead/contact/account: then what?!??
    if (count($result) == 0) return;

    // for now - dirty quick fix
    $elementTypeXref = array( 10 => 'veb_l_emailconsent',
                              11 => 'veb_a_emailconsent',
                              12 => 'veb_c_emailconsent'
                       );

    foreach($result as $record) {

      /*
       * ["id"]=> string(9) "12x185888"
       * ["veb_emailconsent_nofbounces"]=> string(1) "0"
       *
       * ["veb_l_emailconsent"]=> string(1) "0" - lead (wsid: 10)
       * ["veb_a_emailconsent"]=> string(1) "0" - account (wsid: 11)
       * ["veb_c_emailconsent"]=> string(1) "0" - contact (wsid: 12)
       *
       */
      switch($error['type']) {

        // hard bounces
        case 'hardbounce': {

             // need to find out the type of user
             list($elementType, $element) = explode('x', $record['id']);

             // only update if key exists - for account in vicus crm f.i., not needed
             if (array_key_exists($elementTypeXref[$elementType], $record)) {

               // only change if not 'Unsubscribed' or 'Blacklisted'
               if (!in_array($record[$elementTypeXref[$elementType]], array('Unsubscribed', 'Blacklisted'))) {

                 // set the correct emailconsent status field
                 $record[$elementTypeXref[$elementType]] = 'Bounced';
                 $record['emailconsent_optout_reason'] = $error['description'];
               }

               $record['veb_emailconsent_nofbounces'] += 1;
               $result = vtws_revise($record, $this->current_user);
             }

             // move message to Undeliverable
             $this->move($emailNumber, 'INBOX.Undeliverable');
             break;
        }

        // soft bounces
        case 'softbounce': {

             $record['veb_emailconsent_nofbounces'] += 1;
             $record['emailconsent_optout_reason'] = $error['description'];
             $result = vtws_revise($record, $this->current_user);

             // move message to Undeliverable
             $this->move($emailNumber, 'INBOX.Undeliverable');
             break;
        }

        default: {
             // keep msg in INBOX - so no action taken here
             // move message to NotProcessable
             $this->move($emailNumber, 'INBOX.NotProcessable');
        }
      }
    }
  }

  private function move($emailNumber, $toMailFolder) {

// for test, no move
// return;
    imap_mail_move($this->inbox, $emailNumber, $toMailFolder);
  }

  private function disconnect() {

    // close the connection
    imap_expunge($this->inbox);
    imap_close($this->inbox);
  }
}

$parser = new emailParser();
// var_dump($parser->bounceCodes);
$parser->run();
