<?php

// @change lro 170114
// ?cid=$vebrecordid&utm_source=crm&utm_medium=email&utm_term=$tid&utm_content=$linktype&utm_campaign=$templ_name";
// @change lro 190131 T31178
// added token and version of token to ensure identity
// now we have extra: &cid={$vebrecordid}&vebwvat={$vebwvat}&vebwvatv=1 


/*
 * Adding all reuired parameters
 * - utm_source=crm
 * - utm_medium=email
 * - utm_term = template id
 * - utm_content = assumed to be set already in source
 * - utm_campaign = 
 * 
 * @param   integer $crmid  crm id of the target, receiving the mail
 * @param   integer $tid    template id
 * @param   string  $templ_name, template name
 * @return url including all required tracking params
 */
function vebAddTrackingParamsToUrl($url, $crmid, $utm_tags = array())
{
    $params = array();

    // @todo add this in a settungs module
    if (function_exists('vglobal')) {
        $siteURL = vglobal('site_URL');
    } else {
        $siteURL = '';
    }
    
    include('tksConfig.php');

    $parsed_url = parse_url($url);
    $scheme = isset($parsed_url['scheme']) ? $parsed_url['scheme'] . '://' : '';
    $host = isset($parsed_url['host']) ? $parsed_url['host'] : '';
    $port = isset($parsed_url['port']) ? ':' . $parsed_url['port'] : '';
    $user = isset($parsed_url['user']) ? $parsed_url['user'] : '';
    $pass = isset($parsed_url['pass']) ? ':' . $parsed_url['pass'] : '';
    $pass = ($user || $pass) ? "$pass@" : '';
    $path = isset($parsed_url['path']) ? $parsed_url['path'] : '';
    $query = isset($parsed_url['query']) ? $parsed_url['query'] : '';
    $fragment = isset($parsed_url['fragment']) ? '#' . $parsed_url['fragment'] : '';

    // if the url is not our own then dont change it.
    if (!in_array($host, $ownUrlArray))
    {
        return $url;
    }

    if ($crmid > 0 && $crmid != '$leads-lead_no$')
    {
        $vebwvat = vebCreateWVAtokenV2($crmid);
        $params['cid'] = $crmid;
        $params['vebwvat'] = $vebwvat;
        $params['vebwvatv'] = 2;
    }

    // we want to keep what we have, but add some for our own sake
    // if utm_tags are given they will replace the original in the url
    $params['utm_source'] = isset($utm_tags['utm_source']) ? $utm_tags['utm_source'] : 'crm';
    $params['utm_medium'] = isset($utm_tags['utm_medium']) ? $utm_tags['utm_medium'] : 'email';
    $params['utm_term'] = isset($utm_tags['utm_term']) ? $utm_tags['utm_term'] : null;
    $params['utm_content'] = isset($utm_tags['utm_content']) ? $utm_tags['utm_content'] : null;
    $params['utm_campaign'] = isset($utm_tags['utm_campaign']) ? $utm_tags['utm_campaign'] : null;


    // any parameters that are in the incoming url will overwrite
    // split query in separate params to get existing parameters in the url
    $linkParams = explode('&', $query);

    foreach ($linkParams as $key => $param)
    {
        list($paramkey, $paramvalue) = explode('=', $param);
        $params[$paramkey] = $paramvalue;
    }

    $params['utm_campaign'] = vebFormatCampaignName($params['utm_campaign']);

    $params = vebRemoveEmptyValuesFromArray($params);
    $query = '?' . http_build_query($params, '', '&');

    return "$scheme$user$pass$host$port$path$query$fragment";
}

// Ensure we dont get empty parameters anymore
function vebRemoveEmptyValuesFromArray($array){
    return array_filter($array); 
}

function vebCreateWVAtokenV2($crmid){
    return md5('crmid' . $crmid . 'v1cus1sth3b3st');
}

function vebValidateWVAtoken($token, $crmid, $version = 2){
    $tokenExpected = md5('crmid' . $crmid . 'v1cus1sth3b3st');
    return ($token = $tokenExpected) ? true : false;
}

// Only alphanumeric characters and spaces are allowed
function vebFormatCampaignName($name)
{
    $name = VebNormalizeChars($name);
    $name = str_ireplace('+','-',$name);
    $name = str_ireplace(' ','-',$name);
    $name = str_ireplace('%20','-',$name);
    $res = preg_replace("/[^a-zA-Z0-9\-]/", "", $name);
    return $name;
}


/**
 * Replace language-specific characters by ASCII-equivalents.
 * @param string $s
 * @return string
 */
function VebNormalizeChars($s) {
    $replace = array(
        'ъ'=>'-', 'Ь'=>'-', 'Ъ'=>'-', 'ь'=>'-',
        'Ă'=>'A', 'Ą'=>'A', 'À'=>'A', 'Ã'=>'A', 'Á'=>'A', 'Æ'=>'A', 'Â'=>'A', 'Å'=>'A', 'Ä'=>'Ae',
        'Þ'=>'B',
        'Ć'=>'C', 'ץ'=>'C', 'Ç'=>'C',
        'È'=>'E', 'Ę'=>'E', 'É'=>'E', 'Ë'=>'E', 'Ê'=>'E',
        'Ğ'=>'G',
        'İ'=>'I', 'Ï'=>'I', 'Î'=>'I', 'Í'=>'I', 'Ì'=>'I',
        'Ł'=>'L',
        'Ñ'=>'N', 'Ń'=>'N',
        'Ø'=>'O', 'Ó'=>'O', 'Ò'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'Oe',
        'Ş'=>'S', 'Ś'=>'S', 'Ș'=>'S', 'Š'=>'S',
        'Ț'=>'T',
        'Ù'=>'U', 'Û'=>'U', 'Ú'=>'U', 'Ü'=>'Ue',
        'Ý'=>'Y',
        'Ź'=>'Z', 'Ž'=>'Z', 'Ż'=>'Z',
        'â'=>'a', 'ǎ'=>'a', 'ą'=>'a', 'á'=>'a', 'ă'=>'a', 'ã'=>'a', 'Ǎ'=>'a', 'а'=>'a', 'А'=>'a', 'å'=>'a', 'à'=>'a', 'א'=>'a', 'Ǻ'=>'a', 'Ā'=>'a', 'ǻ'=>'a', 'ā'=>'a', 'ä'=>'ae', 'æ'=>'ae', 'Ǽ'=>'ae', 'ǽ'=>'ae',
        'б'=>'b', 'ב'=>'b', 'Б'=>'b', 'þ'=>'b',
        'ĉ'=>'c', 'Ĉ'=>'c', 'Ċ'=>'c', 'ć'=>'c', 'ç'=>'c', 'ц'=>'c', 'צ'=>'c', 'ċ'=>'c', 'Ц'=>'c', 'Č'=>'c', 'č'=>'c', 'Ч'=>'ch', 'ч'=>'ch',
        'ד'=>'d', 'ď'=>'d', 'Đ'=>'d', 'Ď'=>'d', 'đ'=>'d', 'д'=>'d', 'Д'=>'D', 'ð'=>'d',
        'є'=>'e', 'ע'=>'e', 'е'=>'e', 'Е'=>'e', 'Ə'=>'e', 'ę'=>'e', 'ĕ'=>'e', 'ē'=>'e', 'Ē'=>'e', 'Ė'=>'e', 'ė'=>'e', 'ě'=>'e', 'Ě'=>'e', 'Є'=>'e', 'Ĕ'=>'e', 'ê'=>'e', 'ə'=>'e', 'è'=>'e', 'ë'=>'e', 'é'=>'e',
        'ф'=>'f', 'ƒ'=>'f', 'Ф'=>'f',
        'ġ'=>'g', 'Ģ'=>'g', 'Ġ'=>'g', 'Ĝ'=>'g', 'Г'=>'g', 'г'=>'g', 'ĝ'=>'g', 'ğ'=>'g', 'ג'=>'g', 'Ґ'=>'g', 'ґ'=>'g', 'ģ'=>'g',
        'ח'=>'h', 'ħ'=>'h', 'Х'=>'h', 'Ħ'=>'h', 'Ĥ'=>'h', 'ĥ'=>'h', 'х'=>'h', 'ה'=>'h',
        'î'=>'i', 'ï'=>'i', 'í'=>'i', 'ì'=>'i', 'į'=>'i', 'ĭ'=>'i', 'ı'=>'i', 'Ĭ'=>'i', 'И'=>'i', 'ĩ'=>'i', 'ǐ'=>'i', 'Ĩ'=>'i', 'Ǐ'=>'i', 'и'=>'i', 'Į'=>'i', 'י'=>'i', 'Ї'=>'i', 'Ī'=>'i', 'І'=>'i', 'ї'=>'i', 'і'=>'i', 'ī'=>'i', 'ĳ'=>'ij', 'Ĳ'=>'ij',
        'й'=>'j', 'Й'=>'j', 'Ĵ'=>'j', 'ĵ'=>'j', 'я'=>'ja', 'Я'=>'ja', 'Э'=>'je', 'э'=>'je', 'ё'=>'jo', 'Ё'=>'jo', 'ю'=>'ju', 'Ю'=>'ju',
        'ĸ'=>'k', 'כ'=>'k', 'Ķ'=>'k', 'К'=>'k', 'к'=>'k', 'ķ'=>'k', 'ך'=>'k',
        'Ŀ'=>'l', 'ŀ'=>'l', 'Л'=>'l', 'ł'=>'l', 'ļ'=>'l', 'ĺ'=>'l', 'Ĺ'=>'l', 'Ļ'=>'l', 'л'=>'l', 'Ľ'=>'l', 'ľ'=>'l', 'ל'=>'l',
        'מ'=>'m', 'М'=>'m', 'ם'=>'m', 'м'=>'m',
        'ñ'=>'n', 'н'=>'n', 'Ņ'=>'n', 'ן'=>'n', 'ŋ'=>'n', 'נ'=>'n', 'Н'=>'n', 'ń'=>'n', 'Ŋ'=>'n', 'ņ'=>'n', 'ŉ'=>'n', 'Ň'=>'n', 'ň'=>'n',
        'о'=>'o', 'О'=>'o', 'ő'=>'o', 'õ'=>'o', 'ô'=>'o', 'Ő'=>'o', 'ŏ'=>'o', 'Ŏ'=>'o', 'Ō'=>'o', 'ō'=>'o', 'ø'=>'o', 'ǿ'=>'o', 'ǒ'=>'o', 'ò'=>'o', 'Ǿ'=>'o', 'Ǒ'=>'o', 'ơ'=>'o', 'ó'=>'o', 'Ơ'=>'o', 'œ'=>'oe', 'Œ'=>'oe', 'ö'=>'oe',
        'פ'=>'p', 'ף'=>'p', 'п'=>'p', 'П'=>'p',
        'ק'=>'q',
        'ŕ'=>'r', 'ř'=>'r', 'Ř'=>'r', 'ŗ'=>'r', 'Ŗ'=>'r', 'ר'=>'r', 'Ŕ'=>'r', 'Р'=>'r', 'р'=>'r',
        'ș'=>'s', 'с'=>'s', 'Ŝ'=>'s', 'š'=>'s', 'ś'=>'s', 'ס'=>'s', 'ş'=>'s', 'С'=>'s', 'ŝ'=>'s', 'Щ'=>'sch', 'щ'=>'sch', 'ш'=>'sh', 'Ш'=>'sh', 'ß'=>'ss',
        'т'=>'t', 'ט'=>'t', 'ŧ'=>'t', 'ת'=>'t', 'ť'=>'t', 'ţ'=>'t', 'Ţ'=>'t', 'Т'=>'t', 'ț'=>'t', 'Ŧ'=>'t', 'Ť'=>'t', '™'=>'tm',
        'ū'=>'u', 'у'=>'u', 'Ũ'=>'u', 'ũ'=>'u', 'Ư'=>'u', 'ư'=>'u', 'Ū'=>'u', 'Ǔ'=>'u', 'ų'=>'u', 'Ų'=>'u', 'ŭ'=>'u', 'Ŭ'=>'u', 'Ů'=>'u', 'ů'=>'u', 'ű'=>'u', 'Ű'=>'u', 'Ǖ'=>'u', 'ǔ'=>'u', 'Ǜ'=>'u', 'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'У'=>'u', 'ǚ'=>'u', 'ǜ'=>'u', 'Ǚ'=>'u', 'Ǘ'=>'u', 'ǖ'=>'u', 'ǘ'=>'u', 'ü'=>'ue',
        'в'=>'v', 'ו'=>'v', 'В'=>'v',
        'ש'=>'w', 'ŵ'=>'w', 'Ŵ'=>'w',
        'ы'=>'y', 'ŷ'=>'y', 'ý'=>'y', 'ÿ'=>'y', 'Ÿ'=>'y', 'Ŷ'=>'y',
        'Ы'=>'y', 'ž'=>'z', 'З'=>'z', 'з'=>'z', 'ź'=>'z', 'ז'=>'z', 'ż'=>'z', 'ſ'=>'z', 'Ж'=>'zh', 'ж'=>'zh'
    );
    return strtr($s, $replace);
}

/**
 * Replace Optin/out tokens
 * @since 190521
 * @param   text    body text
 * @param   integer id  
 * $return  text
 * https://castellum.vicus.n/modules/Emails/actions/TrackAccess.php?record=323809
 *                          &parentId=323590
 *                          &applicationKey=31d6a7c6a1889bc189f2391dcae546a1
 *                          &method=click&redirectUrl=https%3A%2F%2Fcastellum.vicus.nl%2Fconsent.php%3Fconsent%3Doptout
 */
function replaceConsentToken($body, $crmid) {

    $siteURL = vglobal('site_URL');

    $query = "&cid=$crmid";

    $tokens = array();
    $tokens[0] = '/\[CONSENTOPTINLINK\]/';
    $tokens[1] = '/\[CONSENTCONFIRMLINK\]/'; // be aware of the escaping []
    $tokens[2] = '/\[CONSENTOPTOUTLINK\]/';
    $tokens[3] = '/\[VIEWONLINELINK\]/';
    ksort($tokens);
    
    $replacements = array();
    $replacements[0] = '<a href="' . $siteURL . 'vema_hub.php?a=optin'.$query.'">Aanmelden</a>';
    $replacements[1] = '<a href="' . $siteURL . 'vema_hub.php?a=confirm'.$query.'">Bevestig</a>';
    $replacements[2] = '<a href="' . $siteURL . 'vema_hub.php?a=optout'.$query.'">Afmelden</a>';
    $replacements[3] = '<a href="' . $siteURL . 'vema_hub.php?a=view'.$query.'">Bekijk online</a>';
    ksort($replacements);

    return preg_replace($tokens, $replacements, $body);
}

/**
 * Returns the clean crm id of the related contact from the entity ##x### -> ###
 */
function VebGetContactCrmId($entity)
{
    $vebrecordId = 0;
    // $entity->getId() = entity = Installation ##x### -> 
    switch ($entity->getModuleName())
    {
        case 'Leads':
            $contactId = $entity->get('leadid');
            break;
        case 'Contacts':
            $contactId = $entity->get('contactid');
            break;
        case 'Installations':
            $contactId = $entity->get('inst_contact');
            break;
        default:
            $contactId = $entity->get('contactid');
    }
    if ($contactId)
    {
        list($wsId, $vebrecordId) = explode('x', $contactId);
    }
    return $vebrecordId;
}
