<?php
/*
 * Example: $mailer->Signature = vebAddSignature($currentUserModel->get('user_name'), $vebrecordid, $tid, $templ_name);
 * @param   string  $user_name - username, default admin, sending the mail
 * @param   integer $vebrecordid, crm id of the target, receiving the mail
 * @param   integer $tid, template id
 * @param   string  $templ_name, template name
 * @return
 */
include_once('VebTrackerFunctions.php');

function vebAddSignature($user_name = "admin", $crmid = 0, $tid = 0, $templ_name = "")
{
    global $adb;

    $adb->println("Inside the function vebAddSignature");

    $sign = null;

    $utm_tags = array(
        'utm_campaign' => $templ_name,
    );

    $sign = VTCacheUtils::getUserSignature($user_name);

    if ($sign === null)
    {
        $result = $adb->pquery("select first_name, last_name, title from vtiger_users where user_name=?", array($user_name));

        $firstname = $adb->query_result($result, 0, "first_name");
        $lastname = $adb->query_result($result, 0, "last_name");
        $jobtitle = $adb->query_result($result, 0, "title");
        
        if ($firstname == '' && $lastname == '') {
            $firstname = 'Team';
            $lastname = 'Vicus';
            $jobtitle = 'We horen graag van je!';
        }

        $sign = '<p style="font-family:Roboto,arial,sans-serif;font-size:14px;font-weight:normal;color:rgb(61,61,61);background-color:rgb(255,255,255);"><br />Met vriendelijke groet,<br /><br />' . $firstname . ' ' . $lastname . '<br>' . $jobtitle . '<br /><br /></p>';

        $sign .= '<hr style="color:rgb(4,21,38);background-color:rgb(4,21,38);height:1px;border: 0 none;">';
        // ===============================================================================    
        // Standaard reclame
        $sign .= '<p style="color:rgb(4,21,38);font-size:12px;line-height:14px;">Vicus verbetert uw marketing, verkoop en klantenservice met <a href="' . vebAddTrackingParamsToUrl('https://www.vicus.nl/magento?utm_content=textlink', $crmid, $utm_tags) . '" style="color:rgb(238,130,30);text-decoration:none;">Magento webshops</a> en <a href="' . vebAddTrackingParamsToUrl('https://www.vicus.nl/vtiger?utm_content=textlink', $crmid, $utm_tags) . '" style="color:rgb(238,130,30);text-decoration:none;">vtiger CRM</a> en integreert deze met backoffice systemen zoals King, Exact, Baan, Dynamics NAV/AX. Winnaar iCMG Award 2016 met WebVisitAnalyser en het achterliggende <a href="' . vebAddTrackingParamsToUrl('https://www.vicus.nl/modellen/journeyfunnel-model?utm_content=textlink', $crmid, $utm_tags) . '" style="color:rgb(238,130,30);text-decoration:none;">JourneyFunnel Model</a> - kwalitatief meer en betere prospects en klanten.</p>';

        // ===============================================================================
        // Prestaties
//    $sign .= '<p style="color:rgb(4,21,38);font-size:12px;line-height:14px;">Winnaar iCMG Award 2016 met <a href="https://www.vicus.nl/journeyfunnel/webvisitanalyser.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">WebVisitAnalyser</a> en het achterliggende JourneyFunnel Model - kwalitatief meer en betere prospects en klanten.</p>';
        // ===============================================================================
        // Extra Teaser
        // Kent u <a href="https://www.vicus.nl/journeyfunnel/webvisitanalyser.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">WebVisitAnalyser</a> al? De meest betaalbare online marketing & sales automation voor B2B bedrijven. Volledig automatisch informatie over uw klanten en prospects, kant en klaar in uw vtiger crm-systeem, inclusief kredietscore en KvK-gegevens.
//    $sign .= '<p style="color:rgb(4,21,38);font-size:12px;line-height:14px;">Wij ondersteunen u graag met het <a href="https://www.vicus.nl/magento/e-commerce-succes-model.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">ecommerce succesmodel</a> en het <a href="https://www.vicus.nl/actueel/persberichten/persbericht/archive/2016/september/article/vicus-wint-prestigieuze-internationale-award-met-journeyfunnelc-model-en-webvisitanalyser.html'.$linkParams.'" style="color:rgb(238,130,30);text-decoration:none;">bekroonde JourneyFunnel model</a> om uw succes te ondersteunen. </p>';
// less links ivm spam <br />Twitter: <a href="https://vicus.nl/s/twvicuseb" style="color:rgb(238,130,30);text-decoration:none;">vicus_ebusiness</a>
        // ===============================================================================
        // formal / company adres
        $sign .= '<p style="color:rgb(4,21,38);font-size:12px;"><b>Vicus eBusiness Solutions B.V.</b><br>Vanadiumweg 22, 3812 PZ  Amersfoort<br>KvK: 32105890<br>Web: <a href="' . vebAddTrackingParamsToUrl('https://www.vicus.nl?utm_content=textlink', $crmid, $utm_tags) . '" style="color:rgb(238,130,30);text-decoration:none;">www.vicus.nl</a><br />Tel: +31(0)334611196';

        // ===============================================================================
        // user adders (missing fields for twitter and linkedIn from vtiger user settings
        if ($firstname == 'Luuk' && $lastname == 'Roovers')
        {
            $sign .= '<br>LinkedIn: <a href="https://nl.linkedin.com/in/lroovers" style="color:rgb(238,130,30);text-decoration:none;">lroovers</a>';
        }
        if ($firstname == 'Helenus' && $lastname == 'de Rijke')
        {
            $sign .= '<br>LinkedIn: <a href="https://www.linkedin.com/in/helenusderijke" style="color:rgb(238,130,30);text-decoration:none;">helenusderijke</a>';
        }

        $sign .= '</p>';

        // ===============================================================================
        // disclaimer
        // 
        // ===============================================================================
        // store in cache
        VTCacheUtils::setUserSignature($user_name, $sign);
        VTCacheUtils::setUserFullName($user_name, $firstname . ' ' . $lastname);
    }
    return $sign;
}