<?php

include_once('includes/exceptions/AppException.php');
include_once('modules/VebEmailConsent/models/LeadsRecord.php');
include_once('modules/VebEmailConsent/models/ContactsRecord.php');

// webservices
include_once('include/Webservices/Query.php');
include_once('include/Webservices/Create.php');
include_once('include/Webservices/Revise.php');
include_once('include/Webservices/Retrieve.php');
include_once('include/Webservices/DescribeObject.php');

// to find the right id (after conversions/merges)
if (file_exists('include/Webservices/VebWvaCrmId.php')) {

  include_once('include/Webservices/VebWvaCrmId.php');
}

class VebEmailConsent_Record_Model {

  private static function getRecordModelName($objectName) {

     return 'VebEmailConsent_' . $objectName . 'Record_Model';
  }

  public static function getSubscriberEntity($crmId, $emailAddress) {

    if (!empty($crmId)) $crmIdEntity = self::getEntityById($crmId);
    if (!empty($emailAddress)) $crmEmailEntity = self::getEntityByEmail($emailAddress);

    // it might be possible, emailaddress is shared among many leads/contacts, so entity found by crmId is leading
    if ($crmIdEntity === $crmEmailEntity || $crmIdEntity->id != 0) return $crmIdEntity;

    return false;
  }

  public static function getEntityById($crmid) {

    global $current_user;

    if (function_exists('get_wvacrmid')) {

      // is it converted/merged
      $result = get_wvacrmid($crmid);

      if ($result['result'] == 'error') {

        // is dit een error als er geen merged/converted zijn gevonden?
        error_log(__FUNCTION__ . ' - ' . serialize($result),0);
        $entity->id = 0;
        $entity->type = false;

        return $entity;
      }

      // found
      $crmid = $result['id'];
      $moduleName = $result['setype'];
    }

    $recordModel = self::getRecordModelName($moduleName);

    $entity = $recordModel::getRecordById($crmid);

    $wsId = vtws_getWebserviceEntityId($moduleName, $crmid);

    // entity->crmid is known, so set entity->id and internal entity->wsid
    $entity->id = $wsId;
    $entity->wsid = $wsId;

    return $entity;
  }

  public static function getEntityByEmail($email) {

    global $current_user;

    $recordModel = self::getRecordModelName('Contacts');

    $entity = $recordModel::getRecordByEmail($email, $current_user);

    if (empty($entity)) {

      $recordModel = self::getRecordModelName('Leads');
      $entity = $recordModel::getRecordByEmail($email, $current_user);
    }

    // entity->id and entity->crmid is already known, so set internal entity->wsid
    $entity->wsid = $entity->id;

    return $entity;
  }

  public static function getEnrollmentsSettingsHtml($entity) {

    // make a form section
    $enrollmentsSection = '';

    foreach ($entity->emailconsent_mailings as $label => $value) {

        $checked = ($value == 1) ? 'checked' : '';
        $enrollmentsSection .= '<div style="text-align:left;">';
        $enrollmentsSection .= '<input type="checkbox" name="' . $label . '" value="1" ' . $checked . '>';
        $enrollmentsSection .= $label;
        $enrollmentsSection .= '</div>';
    }

    return $enrollmentsSection;
  }

  public static function setEmailConsentOptin($entity) {

    $entity->emailconsent_status = 'Optin';

    $entity->emailconsent_optin = '1';
    $entity->emailconsent_optout = '0';
    $entity->emailconsent_optout_reason = '';

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '0';

    // default setting
    $entity->emailoptout = '0';

    self::reviseEntity($entity);
  }

  public static function setEmailConsentInvited($entity) {

    $entity->emailconsent_status = 'Invited';

    $entity->emailconsent_optin = '1';
    $entity->emailconsent_optout = '0';
    $entity->emailconsent_optout_reason = '';

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '0';

    // default setting
    $entity->emailoptout = '0';

    self::reviseEntity($entity);
  }

  public static function setEmailConsentReminded($entity) {

    $entity->emailconsent_status = 'Reminded';

    $entity->emailconsent_optin = '1';
    $entity->emailconsent_optout = '0';
    $entity->emailconsent_optout_reason = '';

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '0';

    // default setting
    $entity->emailoptout = '0';

    self::reviseEntity($entity);
  }

  public static function setEmailConsentConfirmed($entity) {

    $entity->emailconsent_status = 'Subscribed';

    $entity->emailconsent_optin = '1';
    $entity->emailconsent_optout = '0';
    $entity->emailconsent_optout_reason = '';

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '0';

    // default setting
    $entity->emailoptout = '0';

    self::reviseEntity($entity);
  }

  public static function setEmailConsentExpired($entity) {

    $entity->emailconsent_status = 'Expired';

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    self::reviseEntity($entity);
  }

  public static function setEmailConsentBlacklisted($entity) {

    $entity->emailconsent_status = 'Blacklisted';

    // set emailconsentOptin to false
    // set emailcampaign_optout to true
    $entity->emailconsent_optin = '0';
    $entity->emailconsent_optout = '1';

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '1';

    self::reviseEntity($entity);
  }

  public static function setEmailConsentOptout($entity) {

    // zet emailconsent op unsubscribed
    $entity->emailconsent_status = 'Optout';

    // afhandelen als opt-out - no
    // bij klik op uitschrijflink word je al uitgeschreven, dus status is Unsubscribed
    $entity->emailconsent_optin = '0';
    $entity->emailconsent_optout = '1';
    if (array_key_exists('reason', $_POST)) $entity->emailconsent_optout_reason = implode(' |##| ', $_POST['reason']);

    // only when empty - otherwise reasons from vema will be overwritten
    if (empty($entity->emailconsent_optout_reason)) {

      $enity->emailconsent_optout_reason = 'Afgemeld via werkstroom';
    }

    // help! cleanGetParam-call
    $freeformatReason = self::cleanGetParam('freeformatreason', 'POST');

    if (!empty($freeformatReason)) $entity->emailconsent_optout_reason = $freeformatReason;

    // set processed date
    $dateToday = new DateTime(date('Y-m-d'));
    $entity->emailconsent_date = $dateToday->format('Y-m-d');

    if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '1';

    self::reviseEntity($entity);
  }

  public static function reactivateSubscription($entity) {

    // update profile, so it must exist
    if (is_object($entity) && !empty($entity->id)) {

      $entity->emailconsent_optin = '1';
      $entity->emailconsent_status = 'Subscribed';
      $entity->emailconsent_optout = '0';
      $entity->emailconsent_optout_reason = '';

      if (vtlib_isModuleActive('EmailCampaigns')) $entity->emailcampaign_optout = '0';

      self::reviseEntity($entity);
    }
  }

  public static function updateProfile($entity) {

    // we can update the entity
    $emailConsentMailings = $entity->mapping['emailConsent'];

    foreach($emailConsentMailings as $label => $field) {

      // set to 0
      $emailConsentMailings[$label] = 0;

      // due to submit, in post spaces are replaced by '_', so:
      $convertedLabel = str_replace(' ', '_', $label);

      // set to 1 if checked
      if (array_key_exists($convertedLabel, $_POST)) $emailConsentMailings[$label] = $_POST[$convertedLabel];
    }

    // save in entity for further processing
    $entity->emailconsent_mailings = $emailConsentMailings;

    self::reviseEntity($entity);
  }

  /*
   * also called from vema_hub
   *
   */
  public static function reviseEntity($entity) {

    global $current_user;

    $crmEntity = CRMEntity::getInstance($entity->type);
    $crmEntity->mode = 'edit';
    $crmEntity->id = $entity->crmid;
    $crmEntity->retrieve_entity_info($entity->crmid, $entity->type);

    // copy over the std fields from entity
    foreach($entity->mapping as $entityField => $elementField) {

        // skip emailconsent settings
        if (is_array($entityField)) continue;

        $crmEntity->column_fields->offsetSet($elementField, $entity->$entityField);
    }

    // and the new emailconsent settings
    foreach($entity->mapping['emailConsent'] as $entityField => $elementField) {

        // set the consent
        $crmEntity->column_fields->offsetSet($elementField, $entity->emailconsent_mailings[$entityField]);
    }

    $assignedUser = $crmEntity->column_fields->offsetGet('assigned_user_id');

    if (self::isWsId($assignedUser)) {

      list($wsModule, $assignedUserId) = explode('x', $assignedUser);
      $crmEntity->column_fields->offsetSet('assigned_user_id', $assignedUserId);
    }

    try {

        $crmEntity->saveentity($entity->type);
    }
    catch (WebServiceException $ex) {

        error_log(__FUNCTION__ . ' - crmid:' . $entity->crmid . ' ' . $ex->getMessage(), 0);
    }
  }

  public static function cleanGetParam($param, $method = 'GET', $type = '') {

    if ($method == 'POST') {

        $value = (isset($_POST[$param])) ? $_POST[$param] : '';
    }
    else {

        $value = (isset($_GET[$param])) ? $_GET[$param] : '';
    }

    $value = trim($value);

    switch ($type) {

        case 'email':
            $value = filter_var($value, FILTER_SANITIZE_EMAIL);
            break;

        case 'integer':
            $value = filter_var($value, FILTER_VALIDATE_INT);
            break;

        default:
            $value = filter_var($value, FILTER_SANITIZE_STRING);
            break;
    }

    return $value;
  }

  public static function blacklistToAddress() {

    $sendMailSet = (Settings_VebSettings_Record_Model::getSetting('send_error_mail', 'VebEmailConsent') == 1);

    if ($sendMailSet === true) {

      $userId = Settings_VebSettings_Record_Model::getSetting('emailconsent_to_id', 'VebEmailConsent');

      // do nothing if no user is defined
      if (empty($userId)) return false;

      $emailAddress = getUserEmail($userId);

      return $emailAddress;
    }

    return false;
  }

  public static function testmailToAddress() {

    $testMailSet = (Settings_VebSettings_Record_Model::getSetting('send_test_mail', 'VebEmailConsent') == 1);

    if ($testMailSet === true) {

      $userId = Settings_VebSettings_Record_Model::getSetting('test_mail_to_id', 'VebEmailConsent');

      // do nothing if no user is defined
      if (empty($userId)) return false;

      $emailAddress = getUserEmail($userId);

      return $emailAddress;
    }

    return false;
  }

  static public function encrypt($string) {

        $output = false;
        $encryptMethod = "AES-256-CBC";
        $secretKey = Settings_VebSettings_Record_Model::getSetting('vema_secret_key', 'VebEmailConsent');
        $secretIv = VtigerConfig::get('application_unique_key');

        // hash
        $key = hash('sha256', $secretKey);

        // iv - encrypt method AES-256-CBC expects 16 bytes
        $iv = substr(hash('sha256', $secretIv), 0, 16);

        $output = openssl_encrypt($string, $encryptMethod, $key, 0, $iv);
        $output = base64_encode($output);

        return $output;
  }

  static public function decrypt($string) {

        $output = false;
        $encryptMethod = "AES-256-CBC";
        $secretKey = Settings_VebSettings_Record_Model::getSetting('vema_secret_key', 'VebEmailConsent');
        $secretIv = VtigerConfig::get('application_unique_key');

        // hash
        $key = hash('sha256', $secretKey);

        // iv - encrypt method AES-256-CBC expects 16 bytes
        $iv = substr(hash('sha256', $secretIv), 0, 16);

        $output = openssl_decrypt(base64_decode($string), $encryptMethod, $key, 0, $iv);

        return $output;
  }

  // returns secret key
  public static function getSecretKey($cid) {

    $secretKey = Settings_VebSettings_Record_Model::getSetting('vema_secret_key', 'VebEmailConsent');
    return md5($cid . $secretKey);
  }

  // returns true or false
  public static function isSecretKeyValid() {

    $secretKey = Settings_VebSettings_Record_Model::getSetting('vema_secret_key', 'VebEmailConsent');
    return (md5(self::cleanGetParam('cid', 'POST') . $secretKey) == self::cleanGetParam('token', 'POST'));
  }

  public static function isWsId($id) {

    $checkedId = explode('x', $id);
    return (count($checkedId) > 1);
  }
}
