<?php
/*
 *
 *
 */
class VebEmailConsent_ContactsRecord_Model {

  static public function populateRecord($result) {

    $entity = new stdClass();

    $entity->mapping = self::getRecordMapping();

    // std fields
    foreach($entity->mapping as $entityField => $resultField) {

      // skip the emailconsent preferences
      if (is_array($resultField)) continue;

        $entity->$entityField = $result[$resultField];
    }

    // only valid if module EmailCampaigns is installed
    if (vtlib_isModuleActive('EmailCampaigns') && vtlib_isModuleActive('VebEmailCampaigns')) {

      // email consent preferences
      self::formatConsentCampaignsMailings($entity, $result);
    }

    // set crmid
    list($wsEntity, $crmId) = explode('x', $entity->id);
    $entity->crmid = $crmId;
 
    // finally set type
    $entity->type = 'Contacts';

    return $entity;
  }

  static public function getRecordMapping() {

    // backwards compatible
    $mappedFields = self::fieldMapping();

    // std fields
    $fields = self::getFields();

    return array_merge($fields, $mappedFields);
  }

  static public function fieldMapping() {

    $focus = CRMEntity::getInstance('Contacts');

    $mapping['emailconsent_date'] = self::getConsentDateFieldName($focus);
    $mapping['emailconsent_optin'] = self::getConsentOptinFieldName($focus);
    $mapping['emailconsent_status'] = self::getConsentStatusFieldName($focus);
    $mapping['emailconsent_optout'] = self::getConsentOptoutFieldName($focus);
    $mapping['emailconsent_optout_reason'] = self::getConsentOptoutReasonFieldName($focus);

    return $mapping;
  }

  /*
   * standarized field for Contact and Leads in later versions
   * old version: emailconsent_date
   * new version: veb_emailconsent_date
   */
  static protected function getConsentDateFieldName($focus) {

    $consentDateFieldName = 'emailconsent_date';
    $offsetExists = $focus->column_fields->offsetExists($consentDateFieldName);

    if ($offsetExists === false) $consentDateFieldName = 'veb_emailconsent_date';

    return $consentDateFieldName;
  }

  /*
   * standarized field for Contact and Leads in later versions
   * old version: veb_l_emailoptin, veb_c_emailoptin
   * new version: veb_emailconsent_optin
   */
  static protected function getConsentOptinFieldName($focus) {

    $consentOptinFieldName = 'veb_c_emailoptin';
    $offsetExists = $focus->column_fields->offsetExists($consentOptinFieldName);

    if ($offsetExists === false) $consentOptinFieldName = 'veb_emailconsent_optin';

    return $consentOptinFieldName;
  }

  /*
   * standarized field for Contact and Leads in later versions
   * old version: c_newsletter_optout
   * new version: veb_emailconsent_optout
   */
  static protected function getConsentOptoutFieldName($focus) {

    $consentOptoutFieldName = 'c_newsletter_optout';
    $offsetExists = $focus->column_fields->offsetExists($consentOptoutFieldName);

    if ($offsetExists === false) $consentOptoutFieldName = 'veb_emailconsent_optout';

    return $consentOptoutFieldName;
  }

  /*
   * standarized field for Contact and Leads in later versions
   * old version: veb_l_emailconsent, veb_c_emailconsent
   * new version: veb_emailconsent_status
   */
  static protected function getConsentStatusFieldName($focus) {

    $consentStatusFieldName = 'veb_c_emailconsent';
    $offsetExists = $focus->column_fields->offsetExists($consentStatusFieldName);

    if ($offsetExists === false) $consentStatusFieldName = 'veb_emailconsent_status';

    return $consentStatusFieldName;
  }

  /*
   * standarized field for Contact and Leads in later versions
   * old version: emailconsent_optout_reason
   * new version: veb_emailconsent_optout_reason
   */
  static protected function getConsentOptoutReasonFieldName($focus) {

    $emailconsentOptoutReasonFieldName = 'emailconsent_optout_reason';
    $offsetExists = $focus->column_fields->offsetExists($emailconsentOptoutReasonFieldName);
    if ($offsetExists === false) $emailconsentOptoutReasonFieldName = 'veb_emailconsent_optout_reason';

    return $emailconsentOptoutReasonFieldName;
  }

  static public function getFields() {

    $mapping = array('email' => 'email',
                     'firstname' => 'firstname',
                     'lastname' => 'lastname',
                     'company' => 'company',
                     'emailoptout' => 'emailoptout',
                     'assigned_user_id' => 'assigned_user_id',
                     'id' => 'id',
               );

    // only valid if module EmailCampaigns is installed
    if (vtlib_isModuleActive('EmailCampaigns')) $mapping['emailcampaign_optout'] = 'emailcampaign_optout';

    return $mapping;
  }

  public function getRecordByEmail($email) {

    global $current_user;

    $entity = false;
    $result = false;

    try {

      // Does it exist as contact?
      $query = "SELECT * FROM Contacts WHERE email = '$email'";

      // NOTE: Make sure to terminate query with ;
      $query = $query . ';';

      $records = vtws_query($query, $current_user);
    }
    catch (WebServiceException $ex) {

      error_log(__FUNCTION__ . ' - Contacts email:' . $email . ' ' . $ex->getMessage(), 0);
    }

    if (count($records) > 0) {

      // if > 1 we use the first we find
      $result = $records[0];
    }

    if ($result !== false) {

      // make it generic for the emailconsent fields
      $entity = self::populateRecord($result, $current_user);
    }

    return $entity;
  }

  static public function getRecordById($crmid) {

    global $current_user;

    $entity = false;
    $result = false;

    $wsId = vtws_getWebserviceEntityId('Contacts', $crmid);

    try {

      // retrieve the entity
      $result = vtws_retrieve($wsId, $current_user);
    }
    catch (WebServiceException $ex) {

      error_log(__FUNCTION__ . ' - vtws_retrieve wsid=:' . $wsid . ' ' . $ex->getMessage() ,0);
    }

    if ($result !== false) {

      // make it generic for the emailconsent fields
      $entity = self::populateRecord($result);
    }

    return $entity;
  }

  // return array
  static private function formatConsentCampaignsMailings($entity, $data) {

    if (!vtlib_isModuleActive('VebEmailCampaigns')) {

      $entity->emailconsent_mailings = false;
      return false;
    }

    $result = false;

    // get the fieldmapping from config
    $emailConsentMapping = Settings_VebSettings_Record_Model::getSetting('contactConsent', 'VebEmailCampaigns');

    $emailConsent = array();
    foreach($emailConsentMapping as $emailConsentString) {

      list($emailConsentFieldName, $emailConsentFieldLabel) = explode('$', $emailConsentString);
      $emailConsent[$emailConsentFieldLabel] = $emailConsentFieldName;
    }

    $entity->mapping = array_merge($entity->mapping, array('emailConsent' => $emailConsent));

    if (count($emailConsent) > 0) {

      $fieldlabels = array();
      $result = array();

      foreach ($emailConsent as $fieldlabel => $fieldname) {

        $result[$fieldlabel] = $data[$fieldname];
      }
    }

    $entity->emailconsent_mailings = $result;

    return $entity;
  }
}
