<?php

class VebEmailConsentParser {

  //
  // https://autoresponder.vicus.nl/vema_hub.php?v=1&c=d83idhJDSNCDS,CJLUWENJSKCNADSCULEIWLSNCANZX
  //
  protected $version = 1;

  protected $siteURL;
  protected $siteURLfound = false;
  protected $siteURLConverted = 0;

  protected $config = array();

  protected $companySettings = null;
  protected $consentSettings = null;

  // @change t46562
  protected $skipHrefEncoding = array('mailto:', 'tel:');
  //

  /**
   * Constructor
   * @param boolean $exceptions Should we throw external exceptions?
   */
  public function __construct() {

    if (function_exists('vglobal')) {

        $this->siteURL = vglobal('site_URL');
    }
    else {

        $this->siteURL = '';
    }

    // get the company information
    $this->companySettings = Settings_Vtiger_CompanyDetails_Model::getInstance();

    // get the email consent settings
    $this->consentSettings = Settings_VebSettings_Record_Model::getSettings('VebEmailConsent');  
  }

  public function isVemaMail($body) {

    return (strpos($body, 'id="veb_ema_mail"') !== false);
  }

  public function setBody($body) {

    $this->Body = $body;
  }

  public function getBody() {

    return $this->Body;
  }

  public function formatLink($url) {

    return str_replace($this->siteURL . 'vema_hub.php', $this->consentSettings->get('endpoint_url'), $url);
  }

  public function formatEmailLinks() {

    // als allereerste preset doc
    $this->setDocument();

    // en dan: rebuildURLs
    $this->rebuildURLs();
  }

  protected function setDocument() {

    if (strpos($this->Body, $this->siteURL) !== false) {

      $this->siteURLfound = true;
    }

    // we need to all links to the site URL
    $this->srcDoc = new DOMDocument('1.0', 'UTF-8');

    // load HTML
    $this->srcDoc->loadHTML(utf8_decode($this->Body));

    // get the list of the siteURL
    $this->srcXpath = new DOMXPath($this->srcDoc);
  }

  protected function rebuildURLs() {

    // do it for the links
    $this->rebuildLinkLinks();

    // do it for imagelinks - no converted imagelinks
    // $this->rebuildImageLinks();

    // saves UTF-8
    $this->Body = $this->srcDoc->saveHTML($this->srcDoc->documentElement);
  }

  private function rebuildLinkLinks() {

    $itemsList = $this->srcXpath->query("//a");

    foreach($itemsList as $index => $item) {

      // do it for href attribute
      $attribute = $item->getAttribute('href');

      // @change t46562
      $encode = true;

      if (empty($attribute)) {

        $encode = false;
      }
      else {

        // check for mailto or tel
        foreach($this->skipHrefEncoding as $skipHref) {

          // it should start with the string to skip
          if (strpos($attribute, $skipHref) === 0) $encode = false;
        }
      }

      // when not true, skip encoding
      if ($encode === false) continue;
      //

      $encodedURL = $this->rebuildURL($attribute);

      if ($encodedURL === false) continue;

      // save this in the href attribute
      $item->setAttribute('href', $encodedURL);
    }
  }

  private function rebuildImageLinks() {

    // do it for the img 
    $itemsList = $this->srcXpath->query("//img");

    foreach($itemsList as $index => $item) {

      // do it for href attribute
      $attribute = $item->getAttribute('src');

      $encodedURL = $this->rebuildURL($attribute);

      if ($encodedURL === false) continue;

      // save this in the src attribute
      $item->setAttribute('src', $encodedURL);
    }
  }

  private function rebuildURL($attrib) {

    // only EmailCampaigns links
    // $link1 = sprintf('%smodules/EmailCampaigns', $this->siteURL);
    // $link2 = sprintf('%smodules/Emails/actions/TrackAccess.php', $this->siteURL);

    // if (strpos($attrib, $link1) !== 0 && strpos($attrib, $link2) !== 0) return false;

    // one found
    // $this->siteURLConverted = +1;

    $encodedURL = $attrib;

    // found it, get the part to encrypt
    $partToEncode = str_replace($this->siteURL, '', $attrib, $cnt);

    $encodedPart = VebEmailConsent_Record_Model::encrypt($partToEncode);

    // build the new URL
    $encodedURL = sprintf("%s?v=%s&c=%s", $this->consentSettings->get('endpoint_url'), $this->version, $encodedPart);

    return $encodedURL;
  }

  private function debug($line, $msg) {

    file_put_contents('veb/logs/VebEmailConsent.txt', $line . ' ' . var_export($msg, true)."\n", FILE_APPEND);
  }
}
