<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class VebEmailConsent extends Vtiger_CRMEntity {

  /**
   * Invoked when special actions are performed on the module.
   * @param String Module name
   * @param String Event Type
   */
  public function vtlib_handler($moduleName, $eventType) {

    if ($eventType == 'module.postinstall') {

      global $adb;

      // Mark the module as Standard module
      $adb->pquery('UPDATE vtiger_tab SET customized=0 WHERE name=?', array($moduleName));

      $this->fieldsEmailConsent();
      $this->workflowsEmailConsent();
      $this->insertTemplates();
      $this->handlePackaged();

      $linkName = 'EmailConsent Settings';
      $linkURL = 'index.php?parent=Settings&module=VebEmailConsent&view=Detail';
      $blockName = 'LBL_CONFIGURATION';

      // $moduleName not given ->  menu item LBL_OTHER_SETTINGS
      vtlib_addSettingsLink($linkName, $linkURL, $blockName);
    }
    elseif($eventType == 'module.disabled') {

      // TODO Handle actions before this module is being uninstalled.
    }
    elseif($eventType == 'module.preuninstall') {

      // TODO Handle actions when this module is about to be deleted.
    }
    elseif($eventType == 'module.preupdate') {

      // TODO Handle actions before this module is updated.
    }
    elseif($eventType == 'module.postupdate') {

      // TODO Handle actions after this module is updated.
    }
  }

  public function fieldsEmailConsent() {

    //// leads ////
    $targetModules = array('Leads' => array('table' => 'vtiger_leaddetails',
                                            'createPicklist' => true
                                      ),
                           'Contacts' => array('table' => 'vtiger_contactdetails',
                                              'createPicklist' => false
                                         )
                     );

    // block name
    $blockName = 'EmailConsent';

    foreach($targetModules as $targetModule => $referenceData) {

      $tableName = $referenceData['table'];
      $createPicklist = $referenceData['createPicklist'];

      $moduleInstance = Vtiger_Module::getInstance($targetModule);

      $blockInstance = Vtiger_Block::getInstance($blockName, $moduleInstance);

      if ($blockInstance === false) {

        // new block
        $blockInstance= new Vtiger_Block();
        $blockInstance->label = $blockName;
        $moduleInstance->addBlock($blockInstance);
      }
      else {

        // existing block
        $blockInstance = Vtiger_Block::getInstance($blockName, $moduleInstance);
      }

      // consent
      $fieldName = 'veb_emailconsent_status';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module) === false) {

        $field->label = 'E-mailconsent status';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'varchar(255)';
        $field->uitype = 15;
        $field->typeofdata = 'V~O';

        if ($createPicklist === true) {

          $field->setPicklistValues(
             array(
                array('Optin', '#00ff00'),
                array('Invited', '#00ff00'),
                array('Reminded', '#0000ff'),
                array('Confirmed', '#64ff67'),
                array('Subscribed', '#329432'),
                array('Optout', '#ff0000'),
                array('Unsubscribed', '#ff0000'),
                array('Bounced', '#0000ff'),
                array('Blacklisted', '#000000'),
                array('Expired', '#7f7f7f')
             )
           );
        }

        $blockInstance->addField($field);
      }

      // optin
      $fieldName = 'veb_emailconsent_optin';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module) === false) {

        $field->label = 'E-mail opt-in';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'varchar(1)';
        $field->uitype = 56;
        $field->typeofdata = 'C~O';
        $blockInstance->addField($field);
      }

      /* ticket 31218 - Velden toevoegen email consent (standaard veldenset) */
      // date
      $fieldName = 'veb_emailconsent_date';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module)  === false) {

        $field->label = 'E-mailconsent datum';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'date';
        $field->uitype = 5;
        $field->typeofdata = 'D~O';
        $blockInstance->addField($field);
      }

      /* ticket 31218 - Velden toevoegen email consent (standaard veldenset) */
      // integer
      $fieldName = 'veb_emailconsent_nofbounces';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module) === false) {

        $field->label = 'E-mailconsent bounces';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'int(19)';
        $field->uitype = 1;
        $field->typeofdata = 'I~O';
        $blockInstance->addField($field);
      }

      /* ticket 31218 - Velden toevoegen email consent (standaard veldenset) */
      // text
      $fieldName = 'veb_emailconsent_text';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module) === false) {

        $field->label = 'E-mailconsent text';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'varchar(255)';
        $field->uitype = 19;
        $field->typeofdata = 'V~O';
        $blockInstance->addField($field);
      }

      /* ticket 32964 - Vtiger 7 VEMA Vicus Email Marketing Automation - handle bounces */
      // text
      $fieldName = 'veb_emailconsent_optout_reason';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module) === false) {

        $field->label = 'E-mail optout reden';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'varchar(255)';
        $field->uitype = 21;
        $field->typeofdata = 'V~O';
        $blockInstance->addField($field);
      }

      /* ticket 31218 - Velden toevoegen email consent (standaard veldenset) */
      $fieldName = 'veb_emailconsent_optout';

      $field = new Vtiger_Field();

      if ($field->getInstance($fieldName, $module) === false) {

        $field->label = 'E-mail optout';
        $field->name = $fieldName;
        $field->table = $tableName;
        $field->column = $fieldName;
        $field->columntype = 'int(1)';
        $field->uitype = 56;
        $field->typeofdata = 'C~O';
        $blockInstance->addField($field);
      }
    }
  }

  private function workflowsEmailConsent() {

    global $adb;

    require('modules/com_vtiger_workflow/VTEntityMethodManager.inc');
    // addEntityMethod("Module Name","Label", "Path to file" , "Method Name" );
    $emm = new VTEntityMethodManager($adb);
    $emm->addEntityMethod('Contacts', 'emailConsent', 'cron/modules/VebEmailConsent/VebEmailConsent.php', 'emailConsent');
    $emm->addEntityMethod('Leads', 'emailConsent', 'cron/modules/VebEmailConsent/VebEmailConsent.php', 'emailConsent');
  }

  private function insertTemplates() {

    global $adb;

    $adb->pquery("INSERT INTO `vtiger_emailtemplates` (`foldername`, `templatename`, `templatepath`, `subject`, `description`, `body`, `deleted`, `templateid`, `systemtemplate`, `module`) VALUES (NULL, 'Consent Confirm Optout Leads', NULL, 'Bevestiging afmelding \$leads-email$', 'VEMA: Bevestigingse-mail na afmelding naar een lead', '<html>\r\n<head>\r\n     <title></title>\r\n</head>\r\n<body>\r\n<p>Beste \$leads-firstname$,</p>\r\n\r\n<p>Bij deze bevestigen wij dat we je afmelding op onze e-mailberichten met het e-mailadres \$leads-email$ in goede orde hebben verwerkt. Natuurlijk vinden wij het jammer dat je bij ons via dat kanaal uit beeld bent. Maar je kunt je altijd bedenken en je weer [CONSENTOPTINLINK].</p>\r\n\r\n<p><em>Het kan zijn dat je je in het verleden met meer e-mailadressen hebt aangemeld bij ons. Het is dan best mogelijk dat je op dat adres alsnog e-mail ontvangt. Je kunt je op dat adres dan ook afmelden.</em></p>\r\n</body>\r\n</html>\r\n', 0, NULL, 0, 'Leads')");

    $adb->pquery("INSERT INTO `vtiger_emailtemplates` (`foldername`, `templatename`, `templatepath`, `subject`, `description`, `body`, `deleted`, `templateid`, `systemtemplate`, `module`) VALUES (NULL, 'Consent Remind to Confirm Leads', NULL, 'Herinnering voor \$leads-firstname$; bevestig je inschrijving bij [BEDRIJFSNAAM]', 'VEMA: Reminder of Invite Leads to confirm subscription', '<html>\r\n<head>\r\n   <title></title>\r\n</head>\r\n<body>\r\n<p>Beste \$leads-firstname$,</p>\r\n\r\n<p>Enige tijd geleden heb je je aangemeld om e-mailberichten te ontvangen van [BEDRIJFSNAAM].</p>\r\n\r\n<p>Vervolgens stuurde we je een bericht om deze aanmelding te bevestigen. Tot op heden hebben we deze bevestiging nog niet mogen registeren.</p>\r\n\r\n<p>Klik op [CONSENTCONFIRMLINK] om je inschrijving alsnog te bevestigen. Of stuur een reply met je bevestiging.</p>\r\n\r\n<p><em>Dit is overigens de enige herinnering. Mocht je verder geen berichten van ons willen ontvangen dan hoef je helemaal niets te doen.</em></p>\r\n</body>\r\n</html>\r\n', 0, NULL, 0, 'Leads')");

    $adb->pquery("INSERT INTO `vtiger_emailtemplates` (`foldername`, `templatename`, `templatepath`, `subject`, `description`, `body`, `deleted`, `templateid`, `systemtemplate`, `module`) VALUES (NULL, 'Consent Invite to Confirm Leads', NULL, '\$leads-firstname$, bevestig je inschrijving bij [BEDRIJFSNAAM]', 'VEMA: Invite Leads to confirm subscription', '<html>\r\n<head>\r\n        <title></title>\r\n</head>\r\n<body>\r\n<p>Beste \$leads-firstname$,</p>\r\n\r\n<p>Dank je wel voor je aanvraag om e-mailberichten te ontvangen van [BEDRIJFSNAAM].</p>\r\n\r\n<p>Klik op [CONSENTCONFIRMLINK] om je inschrijving te bevestigen.</p>\r\n\r\n<p><em>Mocht je geen nieuwsberichten van ons willen ontvangen, dan hoef je helemaal niets te doen.</em></p>\r\n</body>\r\n</html>\r\n', 0, NULL, 0, 'Leads')");

    $adb->pquery("INSERT INTO `vtiger_emailtemplates` (`foldername`, `templatename`, `templatepath`, `subject`, `description`, `body`, `deleted`, `templateid`, `systemtemplate`, `module`) VALUES (NULL, 'Consent Confirm Optout Contacts', NULL, 'Bevestiging afmelding \$contacts-email$', 'VEMA: Bevestigingsemail na afmelding naar een contactpersoon.', '<html>\r\n<head>\r\n     <title></title>\r\n</head>\r\n<body>\r\n<p>Beste \$contacts-firstname$,</p>\r\n\r\n<p>Bij deze bevestigen wij dat we je afmelding op onze e-mailberichten met het e-mailadres \$contacts-email$ in goede orde hebben verwerkt. Natuurlijk vinden wij het jammer dat je bij ons via dat kanaal uit beeld bent. Maar je kunt je altijd bedenken en je weer [CONSENTOPTINLINK].</p>\r\n\r\n<p><em>Het kan zijn dat je je in het verleden met meer e-mailadressen hebt aangemeld bij ons. Het is dan best mogelijk dat je op dat adres alsnog e-mail ontvangt. Je kunt je op dat adres dan ook afmelden.</em></p>\r\n</body>\r\n</html>\r\n', 0, NULL, 0, 'Contacts')");

    $adb->pquery("INSERT INTO `vtiger_emailtemplates` (`foldername`, `templatename`, `templatepath`, `subject`, `description`, `body`, `deleted`, `templateid`, `systemtemplate`, `module`) VALUES (NULL, 'Consent Remind to Confirm Contacts', NULL, 'Herinnering voor \$contacts-firstname$; bevestig je inschrijving bij [BEDRIJFSNAAM]', 'VEMA: Reminder of Invite Contacts to confirm subscription', '<html>\r\n<head>\r\n  <title></title>\r\n</head>\r\n<body>\r\n<p>Beste \$contacts-firstname$,</p>\r\n\r\n<p>Enige tijd geleden heb je je aangemeld om e-mailberichten te ontvangen van [BEDRIJFSNAAM].</p>\r\n\r\n<p>Vervolgens stuurde we je een bericht om deze aanmelding te bevestigen. Tot op heden hebben we deze bevestiging nog niet mogen registeren.</p>\r\n\r\n<p>Klik op [CONSENTCONFIRMLINK] om je inschrijving alsnog te bevestigen. Of stuur een reply met je bevestiging.</p>\r\n\r\n<p><em>Dit is overigens de enige herinnering. Mocht je verder geen berichten van ons willen ontvangen dan hoef je helemaal niets te doen.</em></p>\r\n</body>\r\n</html>\r\n', 0, NULL, 0, 'Contacts')");

    $adb->pquery("INSERT INTO `vtiger_emailtemplates` (`foldername`, `templatename`, `templatepath`, `subject`, `description`, `body`, `deleted`, `templateid`, `systemtemplate`, `module`) VALUES (NULL, 'Consent Invite to Confirm Contacts', NULL, '\$contacts-firstname$, bevestig je inschrijving bij [BEDRIJFSNAAM]', 'VEMA: Invite Contacts to confirm subscription', '<html>\r\n<head>\r\n       <title></title>\r\n</head>\r\n<body>\r\n<p>Beste \$contacts-firstname$,</p>\r\n\r\n<p>Dank je wel voor je aanvraag om e-mailberichten te ontvangen van [BEDRIJFSNAAM].</p>\r\n\r\n<p>Klik op [CONSENTCONFIRMLINK] om je inschrijving te bevestigen.</p>\r\n\r\n<p><em>Mocht je geen nieuwsberichten van ons willen ontvangen, dan hoef je helemaal niets te doen.</em></p>\r\n</body>\r\n</html>\r\n', 0, NULL, 0, 'Contacts')");

    $adb->pquery("UPDATE `vtiger_emailtemplates_seq` SET `id` = `id` + 6");
  }

  private function handlePackaged() {

    $packagedFiles = array(array('src' => 'VebWvaCrmId.php',
                                 'dst' => 'VebWvaCrmId.php',
                                 'path' => 'include/Webservices/'
                           ),
                           array('src' => 'Record.php',
                                 'dst' => 'Record.php',
                                 'path' => 'modules/Emails/models/'
                           ),
                           array('src' => 'tksClickable.php',
                                 'dst' => 'tksClickable.php',
                                 'path' => 'modules/Emails/models/'
                           ),
                           array('src' => 'tksConfig.php',
                                 'dst' => 'tksConfig.php',
                                 'path' => 'modules/Emails/models/'
                           ),
                           array('src' => 'VebAddSignature.php',
                                 'dst' => 'VebAddSignature.php',
                                 'path' => 'modules/Emails/models/'
                           ),
                           array('src' => 'VebTrackerFunctions.php',
                                 'dst' => 'VebTrackerFunctions.php',
                                 'path' => 'modules/Emails/models/'
                           ),
                           array('src' => 'vema_hub.php',
                                 'dst' => 'vema_hub.php',
                                 'path' => './'
                           ),
                     );

    foreach($packagedFiles as $packagedFile) {

      // test if directory exists
      if (!file_exists($packagedFile['path'])) mkdir($packagedFile['path'], 0755, true);

      if (file_exists($packagedFile['path'] . $packagedFile['dst'])) {

        // check the hash
        $sha1org = sha1_file('modules/VebEmailConsent/packaged/' . $packagedFile['src']);
        $sha1dst = sha1_file($packagedFile['path'] . $packagedFile['dst']);

        // no overwrite needed if hash is equal
        if ($sha1org == $sha1dst) continue;

        if (file_exists($packagedFile['path'] . $packagedFile['dst'] . '.orig')) {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '_before' . date('Ymd'));
        }
        else {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '.orig');
        }
      }

      // ok to override
      $src = 'modules/VebEmailConsent/packaged/' . $packagedFile['src'];
      $dst = $packagedFile['path'] . $packagedFile['dst'];
      copy($src, $dst);
    }
  }
}
