<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */
require_once 'config.inc.php';

global $root_directory;

// start - vicus add-on for email-campaigns-suite
include_once($root_directory . '/modules/VebEmailCampaigns/VebEmailCampaignParser.php');
// end - vicus add-on for email-campaigns-suite

require_once($root_directory . "/modules/SubscribersList/autoload_wf.php");
require_once($root_directory . "/modules/EmailCampaigns/autoload_wf.php");

class EmailCampaigns_SaveAjax_Action extends Vtiger_SaveAjax_Action
{

    function __construct()
    {
        parent::__construct();
        $this->exposeMethod('sendenow');
        $this->exposeMethod('schedulelater');
        $this->exposeMethod('schedulelatersave');
        $this->exposeMethod('sendetest');
        $this->exposeMethod('filter_subscribers_cond');
        $this->exposeMethod('filter_subscribers');
        $this->exposeMethod('step2');
        $this->exposeMethod('savesmtp');
        // VTCONN_TT17186 #RG Inizio
        $this->exposeMethod('getModulesByReport');
        $this->exposeMethod('getModulesByFlexReport');
        // VTCONN_TT17186 #RG Fine
    }

    // VTCONN_TT17186 #RG Inizio
    /**
     * Funzione che, dato il nome di un modulo, ritorna tutte i report nei quali il modulo compare
     *
     * @param String $modulename Nome del modulo (ammessi: Accounts, Contacts, Leads)
     * @return array Lista ID->Nome delle Custom Views definite per $modulename
     *          Oppure false, se il modulo indicato non ÃƒÆ’Ã‚Â¨ tra i moduli disponibili
     */
    public function getModulesByFlexReport(Vtiger_Request $request)
    {
        global $root_directory;
        require_once($root_directory . "/modules/RedooReports/autoload_wf.php");

        $reportid = $request->get("reportid");
        $report = \RedooReports\Report::getInstance($reportid);
        $modules = $report->getAffectedModules();
        $allowedModules = array('Accounts', 'Contacts', 'Leads');
        $picklistFields = array();
        foreach ($modules as $module) {
            if (in_array($module, $allowedModules)) {
                $picklistFields[] = $module;
            }
        }
        $response = new Vtiger_Response();
        $response->setResult(array(
            'options' => $picklistFields
        ));
        $response->emit();
    }

    public function savesmtp(Vtiger_Request $request)
    {
        require_once("modules/Emails/class.phpmailer.php");
        require_once("modules/Emails/mail.php");
        global $current_user;
        $adb = PearDatabase::getInstance();
        $response = new Vtiger_Response();
        $server = $request->get('server');
        $server_username = $request->get('server_username');
        $server_password = $request->get('server_password');
        $smtp_auth = $request->get('smtp_auth') ? 1 : 0;
        $from_email = $request->get('from_email_field');
        $from_name = $request->get('from_name_field');
        $reply_email = $request->get('replyto_email_field');
        $return_path = $request->get('returnpath');
        try {

            $mail = new PHPMailer(true);
            //$mail->SMTPDebug=1;

            $mail->Subject = 'Test from EmailCampaigns';
            $mail->Body = 'This is a test email sent by the EmailCampaigns module for VtigerCRM you can ignore this message';
            $mail->IsSMTP();
            $mail->Host = $server;
            // To support TLS
            $hostinfo = explode("://", $server);
            $smtpsecure = $hostinfo[0];
            if ($smtpsecure == 'tls') {
                $mail->SMTPSecure = $smtpsecure;
                $mail->Host = $hostinfo[1];
            }
            // End

            $mail->Username = $server_username; //$mail_server_username ;   // SMTP username
            $mail->Password = htmlspecialchars_decode($server_password); //$mail_server_password ;    // SMTP password
            if ($from_email != null && $from_email != "") {
                $mail->From = $from_email;
            } else {
                $mail->From = $server_username; //$mail_server_username;
            }
            $mail->FromName = $from_name;
            $mail->AddAddress($current_user->email1);                  // name is optional
            $mail->WordWrap = 50;                                 // set word wrap to 50 characters
            $mail->IsHTML(true);                                  // set email format to HTML
            $mail->SMTPAuth = $smtp_auth;
            $mail->AltBody = 'This is a test email sent by the EmailCampaigns module for VtigerCRM you can ignore this message';

            $mail_status = MailSend($mail);
        } catch (phpmailerException $e) {
            $response->setEmitType(Vtiger_Response::$EMIT_JSON);
            $response->setError($e->getMessage());
            $response->emit();
            return;
        } catch (Exception $e) {
            $response->setEmitType(Vtiger_Response::$EMIT_JSON);
            $response->setError($e->getMessage());
            $response->emit();
            return;
        }
        $moduleName = "EmailCampaigns";
        $moduleModel = Settings_Picklist_Module_Model::getInstance($moduleName);
        $fieldModel = Settings_Picklist_Field_Model::getInstance("smtpsetting", $moduleModel);

        if ($mail_status && $fieldModel) {
            if ($request->get('id') != '') {

                $currId = $request->get('id');

                $picklistId = $adb->pquery("SELECT smtpsettingid FROM vtiger_smtpsetting where smtpsetting like '%($currId)'", array())->fields['smtpsettingid'];
                $adb->pquery("UPDATE vtiger_smtpsetting SET smtpsetting=? WHERE smtpsettingid= ? ", array($from_name . " [" . $from_email . "] ($currId)", $picklistId));
                //$status = $moduleModel->renamePickListValues("smtpsetting", $valueToAdd);
                $adb->pquery("UPDATE vtiger_emailcampaigns_smtpsettings SET servername=?, email=?, password=?,fromemail=?,fromname=?,replytoemail=?,returnpath=?,auth=? WHERE id=?", array($server, $server_username, $server_password, $from_email, $from_name, $reply_email, $return_path, $smtp_auth, $request->get('id')));
            } else {

                $adb->pquery("INSERT INTO vtiger_emailcampaigns_smtpsettings (`email`, `servername`, `password`, `replytoemail`, `fromemail`,`fromname`,`returnpath`,`auth`) values(?,?,?,?,?,?,?,?)", array($server_username, $server, $server_password, $reply_email, $from_email, $from_name, $return_path, $smtp_auth));
                $maxId = $adb->pquery("SELECT MAX(id) as id FROM vtiger_emailcampaigns_smtpsettings", array())->fields['id'];

                $valueToAdd = array($from_name . " [" . $from_email . "] ($maxId)");
                $status = $moduleModel->addPickListValues($fieldModel, $valueToAdd);
            }

            $response->setResult(array('result' => 'success'));
        } else {
            $response->setResult(array('result' => 'error', 'message' => 'Unable to save'));
        }
        $response->emit();
    }

    /**
     * Funzione che, dato il nome di un modulo, ritorna tutte i report nei quali il modulo compare
     *
     * @param String $modulename Nome del modulo (ammessi: Accounts, Contacts, Leads)
     * @return array Lista ID->Nome delle Custom Views definite per $modulename
     *          Oppure false, se il modulo indicato non ÃƒÆ’Ã‚Â¨ tra i moduli disponibili
     */
    public function getModulesByReport(Vtiger_Request $request)
    {
        $reportid = $request->get("reportid");
        $db = PearDatabase::getInstance();
        $res = $db->pquery("SELECT CONCAT(primarymodule, ':', secondarymodules) as rmodules
            FROM vtiger_reportmodules
            WHERE reportmodulesid = ?", array(
            $reportid
        ));

        $picklistFields = explode(":", $db->query_result($res, 0, "rmodules"));
        foreach ($picklistFields as $k => $mod) {
            if (!in_array($mod, array(
                    "Accounts",
                    "Leads",
                    "Contacts"
                ))) {
                unset($picklistFields[$k]);
            }
        }
        $response = new Vtiger_Response();
        $response->setResult(array(
            'options' => $picklistFields
        ));
        $response->emit();
    }

    public function step2(Vtiger_Request $request)
    {
        global $vtiger_current_version;

        if ($vtiger_current_version <= "6.5.0") {
            $this->step2_6($request);
        } else {
            $this->step2_7($request);
        }
    }

    public function step2_7(Vtiger_Request $request)
    {
        global $adb;
        $name = $request->get('name');
        $recordId = $request->get('record');
        $listData = array();
        $recordModel = Vtiger_Record_Model::getInstanceById($recordId);
        if ($name == 'From SubscribersList') {
            $listData['filter'] = $request->get('settings');
            $reqmod = $request->get('data');
            $listData['data']['module'] = $reqmod['module'];
            //Save join conditions in listData to use in refreshtotalcount ($_POST["join"] request was used now but will not be available later)
            if ($request->get('join') != '')
                $listData['filter']['join'] = $request->get('join');

            $listType = 'fromlist';
            $subscribers_list = $request->get('subscriperListId');
            $query = "select vtiger_subscriberslist.*,vtiger_crmentity.crmid FROM vtiger_subscriberslist
        INNER JOIN vtiger_crmentity
        ON vtiger_subscriberslist.subscriberslistid  = vtiger_crmentity.crmid
        WHERE vtiger_crmentity.deleted = 0 and vtiger_subscriberslist.subscriberslistid = $subscribers_list
        ";
            $result = $adb->pquery($query, array());
            $count = $adb->num_rows($result);
            if ($count > 0) {
                $subscriberslist_name = $adb->query_result($result, 0, 'list_name');
            }

            $name = $name . ' "' . $subscriberslist_name . '"';
        } else if ($name == 'From Emailcampaigns') {
            $listType = 'fromEmailcampaign';
            $listData['parent_emailcampaignsid'] = $request->get('parent_emailcampaignsid');
            $listData['notemailclicklink'] = $request->get('notemailclicklink');
            $listData['notwhopenemail'] = $request->get('notwhopenemail');
            $listData['emailclicklink'] = $request->get('emailclicklink');
            $listData['whopenemail'] = $request->get('whopenemail');
            $listData['allprevsubcribers'] = $request->get('allprevsubcribers');

            $campaign = $adb->pquery("select campaign_name from vtiger_emailcampaigns where emailcampaignsid=?", array(
                $request->get('parent_emailcampaignsid')
            ));
            $name = $name . ' "' . $campaign->fields['campaign_name'] . '"';
        } else if ($name == 'From Report') {
            $listType = 'fromReport';
            $listData['reportId'] = $request->get('reportId');
            $listData['reportModule'] = $request->get('reportModule');

            $report = $adb->pquery("SELECT reportname FROM vtiger_report WHERE reportid=?", array(
                $request->get('reportId')
            ));
            $name = $name . ' "' . $report->fields['reportname'] . '" for module "' . $request->get('reportModule') . '"';
        } else if ($name == 'From Flex Report') {
            $listType = 'fromFlexReport';
            $listData['reportId'] = $request->get('reportId');
            $listData['reportModule'] = $request->get('reportModule');

            $report = $adb->pquery("SELECT title FROM vtiger_redooreport WHERE id=?", array(
                $request->get('reportId')
            ));
            $name = $name . ' "' . $report->fields['title'] . '" for module "' . $request->get('reportModule') . '"';
        }

        $emails_list = $recordModel->getEmailListByListType($listType, $listData);

        $adb->pquery('INSERT INTO vtiger_emailcampaigns_list_rel (emailcampaignsid, list_type, list_data, list_name, count) values(?,?,?,?,?)', array(
            $recordId,
            $listType,
            json_encode($listData),
            $name,
            count($emails_list)
        ));
        $emaillistRelId = $adb->getLastInsertID();

        // VTCONN_TT17186 #RG Fine
        $response = new Vtiger_Response();
        $response->setResult(array(
            'count' => count($emails_list),
            'emaillistRelId' => $emaillistRelId,
            'emailListName' => $name
        ));
        $response->emit();
    }

    public function step2_6(Vtiger_Request $request)
    {
        global $adb;
        $db = PearDatabase::getInstance();
        $name = $request->get('name');
        $recordId = $request->get('record');
        $listData = array();
        $recordModel = Vtiger_Record_Model::getInstanceById($recordId);
        if ($name == 'From Subscribers List') {
            $module_name = $request->get('module_name');
            $listData['moduleName'] = $module_name;
            $listData['filter'] = $request->get('filter');
            $listType = 'subscriperList';
            $subscribers_list = $request->get('subscriperListId');
            $query = "select vtiger_subscriberslist.*,vtiger_crmentity.crmid FROM vtiger_subscriberslist
        INNER JOIN vtiger_crmentity
        ON vtiger_subscriberslist.subscriberslistid  = vtiger_crmentity.crmid
        WHERE vtiger_crmentity.deleted = 0 and vtiger_subscriberslist.subscriberslistid = $subscribers_list
        ";
            $result = $db->pquery($query, array());
            $count = $db->num_rows($result);
            if ($count > 0) {
                $subscriberslist_name = $db->query_result($result, 0, 'list_name');
            }

            $name = $name . ' "' . $subscriberslist_name . '"';
        } else if ($name == 'From Emailcampaigns') {
            $listType = 'fromEmailcampaign';
            $listData['parent_emailcampaignsid'] = $request->get('parent_emailcampaignsid');
            $listData['notemailclicklink'] = $request->get('notemailclicklink');
            $listData['notwhopenemail'] = $request->get('notwhopenemail');
            $listData['emailclicklink'] = $request->get('emailclicklink');
            $listData['whopenemail'] = $request->get('whopenemail');
            $listData['allprevsubcribers'] = $request->get('allprevsubcribers');

            $campaign = $adb->pquery("select campaign_name from vtiger_emailcampaigns where emailcampaignsid=?", array(
                $request->get('parent_emailcampaignsid')
            ));
            $name = $name . ' "' . $campaign->fields['campaign_name'] . '"';
        } else if ($name == 'From Report') {
            $listType = 'fromReport';
            $listData['reportId'] = $request->get('reportId');
            $listData['reportModule'] = $request->get('reportModule');

            $report = $db->pquery("SELECT reportname FROM vtiger_report WHERE reportid=?", array(
                $request->get('reportId')
            ));
            $name = $name . ' "' . $report->fields['reportname'] . '" for module "' . $request->get('reportModule') . '"';
        }
        $emails_list = $recordModel->getEmailListByListType($listType, $listData);
        $db->pquery('INSERT INTO vtiger_emailcampaigns_list_rel (emailcampaignsid, list_type, list_data, list_name, count) values(?,?,?,?,?)', array(
            $recordId,
            $listType,
            json_encode($listData),
            $name,
            count($emails_list)
        ));
        $emaillistRelId = $db->getLastInsertID();

        // VTCONN_TT17186 #RG Fine
        $response = new Vtiger_Response();
        $response->setResult(array(
            'count' => count($emails_list),
            'emaillistRelId' => $emaillistRelId,
            'emailListName' => $name
        ));
        $response->emit();
    }

    public function sendetest(Vtiger_Request $request)
    {
        global $current_user, $adb, $emailcamp_sparkpost_api;
        $ownerid = $current_user->id;
        $recordId = $request->get('record');
        $testemail = $request->get('testemail');
        $moduleName = $request->getModule();

        if (!$this->record) {
            $this->record = Vtiger_DetailView_Model::getInstance($moduleName, $recordId);
        }
        $recordModel = $this->record->getRecord();
        $module_name = $recordModel->get('module_name');

        try {
            $mailserverresult = $adb->pquery("select * from vtiger_systems", array());
            $numberofrow = $adb->num_rows($mailserverresult);
            if ($numberofrow == 0) {
                $mailserverresult = $adb->pquery("INSERT INTO vtiger_systems (`server`,`server_type`,`smtp_auth`) VALUES (' ','email',1);", array());
            }
            //GET ID OF SMTP SETTING FROM PICKLIST NAME VAL BETWEEN PARENTHESIS
            preg_match('#\((.*?)\)#', $recordModel->get('smtpsetting'), $match);
            $res = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_smtpsettings WHERE id=?", array($match[1]));

            while ($resultrow = $adb->fetch_array($res)) {
                $userName = $resultrow['email'];
                $mail_server = $resultrow['servername'];
                $fromEmail = $resultrow['fromemail'];
                $replyTo = $resultrow['replytoemail'];
                $smtp_auth = $resultrow['auth'];
                $password = $resultrow['password'];
                $fromName = $resultrow['fromname'];
                $returnPath = $resultrow['returnpath'];
            }

            $mailer = Emails_Mailer_Model::getInstance();

            $mailer->IsHTML(true);
            $toEmailInfo = $recordModel->get('from_email');
            $mailer->reinitialize();
            $mailer->ConfigSenderInfo($fromEmail, $userName, $replyTo);
            $mergedDescription = $recordModel->get('description');

            $description = getMergedDescription($mergedDescription, $id, "Users");
            $mailer->Body = decode_html($description);
            $mailer->AltBody = decode_html($description);

            $mailer->Subject = decode_html($recordModel->get('subject'));
            $mailer->FromName = $fromName;
            $mailer->Sender = $returnPath;
            //$mailer->AddAddress($toEmailInfo);
            $mailer->AddAddress($testemail);
            $response = new Vtiger_Response();

            if (!isset($emailcamp_sparkpost_api) || !$emailcamp_sparkpost_api) {

                $mailer->Host = $mail_server; // specify main and backup server
                $mailer->Username = $userName; // SMTP username
                $mailer->Password = htmlspecialchars_decode($password); // SMTP password
                $mailer->SMTPAuth = $smtp_auth;
                // To support TLS
                $hostinfo = explode("://", $mail_server);
                $smtpsecure = $hostinfo[0];
                if ($smtpsecure == 'tls' || $smtpsecure == 'ssl') {
                    $mailer->SMTPSecure = $smtpsecure;
                    $mailer->Host = $hostinfo[1];
                }
                // End
                $portinfo = explode(":", $mailer->Host);
                if (count($portinfo) > 1) {
                    $mailer->Host = $portinfo[0];
                    $mailer->Port = $portinfo[1];
                }

                $status = $mailer->Send(true);

                if ($status) {
                    $response->isJson(true);
                    $response->setResult(array(
                        'message' => vtranslate('LBL_SEND_TEST_OK', $moduleName)
                    ));
                } else {
                    $response->isJson(true);
                    $response->setResult(array(
                        'message' => "SEND_FAIL",
                        'text' => $mailer->getError()
                    ));
                }
            } else {
                $ch = curl_init('https://api.sparkpost.com/api/v1/transmissions');
                if (FALSE === $ch) {
                    echo "failed";
                    throw new Exception('failed to initialize');
                }
                $body = $mailer->Body;
                $data_string = '{"options": {"sandbox": false}, "content": {"from": "' . $mailer->From . '", "subject": "' . $mailer->Subject . '", "html":' . json_encode($body) . '}, "recipients": [{"address": "' . $testemail . '"}]}';
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
                curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Authorization: cc490b26fb5cd56eb7ac07960732a6274b0af55f',
                    'Content-Length: ' . strlen($data_string)
                ));
                $result = json_decode(curl_exec($ch));
                $err = curl_error($ch);
                if ($result->results->total_accepted_recipients == 1) {
                    $response->isJson(true);
                    $response->setResult(array(
                        'message' => vtranslate('LBL_SEND_TEST_OK', $moduleName)
                    ));
                } else {
                    $response->isJson(true);
                    $response->setResult(array(
                        'message' => "SEND_FAIL",
                        'text' => $mailer->getError()
                    ));
                }
            }
        } catch (phpmailerException $e) {
            $response->isJson(true);
            $response->setResult(array(
                'message' => "SEND_FAIL",
                'text' => $e->errorMessage()
            ));
        } catch (Exception $e) {
            $response->isJson(true);
            $response->setResult(array(
                'message' => "SEND_FAIL",
                'text' => $e->getMessage()
            ));
        }
        $response->emit();
    }

    public function process(Vtiger_Request $request)
    {
        $mode = $request->get('mode');
        if (!empty($mode)) {
            $this->invokeExposedMethod($mode, $request);
            return;
        }
    }

    public function schedulelatersave(Vtiger_Request $request)
    {
        $startdate = $request->get('startdate');
        $time = $request->get('time');
        $record = $request->get('record');
        $notifyTo = implode(',',$request->get('notify_to'));
        $otherNotify = $request->get('other_notify');
        $status = 2;
        if($request->get('status') == 'true'){
            $status = 1;
        }
        $user = Users_Record_Model::getCurrentUserModel();
        $user = $user->getEntity();
        $timezone = $user->time_zone;
        $t = new DateTime($startdate . " " . $time, new DateTimeZone($timezone));
        $timezone = new DateTimeZone('UTC');
        $t->setTimezone($timezone);
        $next_trigger_time = $t->format('Y-m-d H:i:s');

        $db = PearDatabase::getInstance();
        $response = new Vtiger_Response();
        $query = "SELECT * FROM vtiger_scheduleemailcampagine  WHERE emailcampaignsid =?";
        $result = $db->pquery($query, array(
            $record
        ));
        //update campaign status
        $querycheckschedule = "UPDATE `vtiger_emailcampaigns` set campaign_status='LBL_SCHEDULED' where emailcampaignsid=$record";
        $db->pquery($querycheckschedule, array());

        if ($db->num_rows($result)) {

            //list($startDate, $startTime) = explode(' ', $time);
            //$currentUser = Users_Record_Model::getCurrentUserModel();
            //if($currentUser->get('hour_format') == '12')

            $query = "UPDATE vtiger_scheduleemailcampagine SET next_trigger_time = ? ,status=?, other_notify=?,notify_to=? WHERE emailcampaignsid = ? LIMIT 1";
            $result = $db->pquery($query, array(
                $next_trigger_time,
                $status,
                $otherNotify,
                $notifyTo,
                $record
            ));
            $response->setResult(array(
                'success' => true,
                'result' => $result
            ));
        } else {
            $query = "INSERT INTO vtiger_scheduleemailcampagine(`emailcampaignsid`, `status`, `other_notify`, `notify_to`, `next_trigger_time`,`is_scheduled`) VALUES (?, ?,?,?,?,?)";
            $result = $db->pquery($query, array(
                $record,
                $status,
                $otherNotify,
                $notifyTo,
                $next_trigger_time,
                1
            ));
            $response->setResult(array(
                'success' => false,
                'result' => $result
            ));
        }
        $response->emit();
    }

    public function vtigercron($recordId, $status = 1)
    {
        $moduleName = 'EmailCampaigns';
        $record = Vtiger_DetailView_Model::getInstance($moduleName, $recordId);

        $recordModel = $record->getRecord();
        if ($status == 1) {
            $status = EmailCampaigns_SaveAjax_Action::massSave($recordModel);
        }
        $saveresult = EmailCampaigns_SaveAjax_Action::updateCampaignStats($recordModel->getId());
        return $status;
    }

    public function sendenow(Vtiger_Request $request)
    {
        global $log, $adb;
        $email = $request->get('email');
        $recordId = $request->get('record');
        $moduleName = $request->getModule();

        if (!$this->record) {
            $this->record = Vtiger_DetailView_Model::getInstance($moduleName, $recordId);
        }

        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " Entering sendenow ");
        $this->debug("EmailCampaignsDebug " . $currentTimestamp . " Entering sendenow ");

        //update campaign status
        $querycheckschedule = "UPDATE `vtiger_emailcampaigns` set campaign_status='LBL_SCHEDULED' where emailcampaignsid=$recordId";
        $adb->pquery($querycheckschedule, array());

        //Verifico se presente la riga su vtiger_scheduleemailcampagine, setto lo stato ad attivo.
        $this->debug("EmailCampaignsDebug " . $currentTimestamp . " SELECT * FROM vtiger_scheduleemailcampagine WHERE emailcampaignsid = $recordId");
        $schedleEmailCamp = $adb->pquery("SELECT * FROM vtiger_scheduleemailcampagine WHERE emailcampaignsid = ?", array($recordId));
        $noOfScheduledReports = $adb->num_rows($schedleEmailCamp);
        if ($noOfScheduledReports == 0) {
            $querycheckschedule = "INSERT INTO `vtiger_scheduleemailcampagine` (`emailcampaignsid`, `status`, `next_trigger_time`, `send_email`) VALUES ('$recordId', 1, '$currentTimestamp', 0)";
            $this->debug("EmailCampaignsDebug " . $currentTimestamp . " " . $querycheckschedule);
            $adb->pquery($querycheckschedule, array());
        }

        //Get cron info
        $checkCronSql = "SELECT * FROM vtiger_cron_task WHERE `name` = 'ScheduleEmailCampaign'";
        $checkCronResult = $adb->pquery($checkCronSql, array());
        $cronStatus = $adb->query_result($checkCronResult, 0, 'status');
        $lastStart = $adb->query_result($checkCronResult, 0, 'laststart');
        $frequency = $adb->query_result($checkCronResult, 0, 'frequency');
        $nextRunTimeInMin = ($lastStart == 'null' || $lastStart == 0) ? $frequency / 60 : (($lastStart + $frequency) - time()) / 60;
        $viwer = new Vtiger_Viewer();
        $viwer->assign('CRON_STATUS', $cronStatus);
        $viwer->assign('NEXT_RUM_TIME_IN_MIN', ceil($nextRunTimeInMin));
        $viwer->assign('MODULE', 'EmailCampaigns');
        $viwer->assign('CALL_BACK_URL', "index.php?module=EmailCampaigns&view=Detail&record=" . $recordId);
        $cronInfoHtml = $viwer->view('nextCronInfo.tpl', $request->getModule(), true);
        $response = new Vtiger_Response();
        $response->setResult(array(
            'success' => true,
            '$rajkiran' => $masssave_response,
            'cronStaus' => $cronStatus,
            'cronInfoHtml' => $cronInfoHtml
        ));
        $response->emit();
    }

    // VTCONN_TT17192 #RG Inizio
    /**
     * Funzione che, dato un oggetto di tipo record model, aggiorna le statistiche dell'oggetto sulla base delle statistiche incrociate presenti nei report
     * @param EmailCampaigns_Record_Model $recordModel_email Il record model del modulo EmailCampaigns
     * @return L'output del save
     */
    public function updateCampaignStats($campaignid)
    {
        $db = PearDatabase::getInstance();
        //$campaignid = $recordModel_email->getId();
        $sent_emails = EmailCampaigns_Record_Model::getTotalSentEmailCount($campaignid);
        $unique_opens = EmailCampaigns_Record_Model::getUniqOpenCount($campaignid);
        $unsubscribers = EmailCampaigns_Record_Model::getSubscribers($campaignid, 1, null, "All");
        $totalEmails = EmailCampaigns_Record_Model::getTotalEmails($campaignid);
        

        $res = $db->pquery("UPDATE vtiger_emailcampaigns
            SET mailsent_tot = ?,
            uniqueopen_tot = ?,
            uniqueopen_per = ?,
            unsubscribers_tot = ?,
            clickonlink_tot = ?,
            tosent_tot = ?
            WHERE emailcampaignsid = ?", array(
            $sent_emails,
            $unique_opens,
            ($sent_emails == 0) ? 0 : ($unique_opens * 100) / $sent_emails,
            $db->num_rows($unsubscribers),
            EmailCampaigns_Record_Model::getClickedLinksTotal($campaignid),
            $totalEmails - $sent_emails,    
            $campaignid
        ));

        return $res;
    }

    function massSave($recordModel_email)
    {
        global $log;
        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');

        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " Entering massSave ");
        self::debug("EmailCampaignsDebug " . $currentTimestamp . " Entering massSave ");

        $adb = PearDatabase::getInstance();
        //Verifica se c'Ã¨ cron in esecuzione, se si, esci dalla funzione
        $checkForDuplicateSession = $adb->pquery("SELECT createdtime FROM vtiger_crmentity WHERE setype='EmailTrackingReport' order by 1 desc limit 1");
        if ($adb->num_rows($checkForDuplicateSession) > 0) {
            while ($rowLastEntity = $adb->fetch_array($checkForDuplicateSession)) {
                $time_utc = new DateTime('now', new DateTimeZone('UTC'));
                $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
                $to_time = strtotime($currentTimestamp);
                $from_time = strtotime($rowLastEntity["createdtime"]);

                //Se la differenza Ã¨ minore o uguale a 1minuto non continuare
                if (round(($to_time - $from_time) / 60, 2) <= 1) {
                    $time_utc = new DateTime('now', new DateTimeZone('UTC'));
                    $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
                    $log->debug("EmailCampaignsDebug " . $currentTimestamp . " EXITING PREMATURELY freq<1 ");
                    self::debug("EmailCampaignsDebug " . $currentTimestamp . " EXITING PREMATURELY freq<1 ");
                    return $currentTimestamp;
                }
            }
        }

        $currentUserModel = Users_Record_Model::getCurrentUserModel();
        $batch = $recordModel_email->get('batch');
        $recordId = $recordModel_email->get('id');
        $related_recortslist = array();
        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " Selecting from vtiger_emailcamp_sendemail");
        self::debug("EmailCampaignsDebug " . $currentTimestamp . " Selecting from vtiger_emailcamp_sendemail");

        $rowsToSend = $adb->pquery("SELECT '1' FROM vtiger_emailcamp_sendemail WHERE emailcampaignsid=$recordId");
        if ($adb->num_rows($rowsToSend) == 0) {
            $campaignRelResult = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_list_rel WHERE emailcampaignsid=$recordId");
            $campaignRelRecords = array();
            $db = PearDatabase::getInstance();
            $recordModel = Vtiger_Record_Model::getInstanceById($recordId);

            // Ciclo Destinatari e inserisco in tabella

            while ($campaignRelRecord = $adb->fetch_array($campaignRelResult)) {
                $relData = $db->pquery("SELECT * FROM vtiger_emailcampaigns_list_rel WHERE id =?", array(
                    $campaignRelRecord['id']
                ));
                $time_utc = new DateTime('now', new DateTimeZone('UTC'));
                $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
                $log->debug("EmailCampaignsDebug " . $currentTimestamp . " Foreach camps currentid: " . $campaignRelRecord['id']);
                self::debug("EmailCampaignsDebug " . $currentTimestamp . " Foreach camps currentid: " . $campaignRelRecord['id']);
                $emails_list = $recordModel->getEmailListByListType($relData->fields['list_type'], json_decode($relData->fields['list_data'], true));
                foreach ($emails_list as $crmid => $email) {
                    $Subscriber = Vtiger_Record_Model::getInstanceById($crmid);
                    $SubscriberOptout = $Subscriber->get('emailcampaign_optout');
                    if (!in_array(strtolower($email), $campaignRelRecords) && !$SubscriberOptout) {
                        array_push($campaignRelRecords, strtolower($email));
                        $adb->pquery("INSERT INTO `vtiger_emailcamp_sendemail` (`emailcampaignsid`, `related_id`,`activityid`,`issent`,`email`) VALUES ('$recordId', '$crmid','0','0','$email')");
                    }
                }
                $time_utc = new DateTime('now', new DateTimeZone('UTC'));
                $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
                $log->debug("EmailCampaignsDebug " . $currentTimestamp . " Foreach completed inserted " . count($campaignRelRecords) . " emails");
                self::debug("EmailCampaignsDebug " . $currentTimestamp . " Foreach completed inserted " . count($campaignRelRecords) . " emails");
            } //While
        } //if
        //Verifico se presente la riga su vtiger_scheduleemailcampagine, setto lo stato ad attivo.
        $schedleEmailCamp = $adb->pquery("SELECT* FROM vtiger_scheduleemailcampagine WHERE emailcampaignsid = ?", array($recordId));
        $noOfScheduledReports = $adb->num_rows($schedleEmailCamp);
        if ($noOfScheduledReports == 0) {
            $querycheckschedule = "INSERT INTO `vtiger_scheduleemailcampagine` (`emailcampaignsid`, `status`, `next_trigger_time`, `send_email`) VALUES ('$recordId', 1, '$currentTimestamp', 0)";
            $adb->pquery($querycheckschedule, array());
        }

        //update campaign status
        $querycheckschedule = "UPDATE `vtiger_emailcampaigns` set campaign_status='LBL_RUNNING' where emailcampaignsid=$recordId";
        $adb->pquery($querycheckschedule, array());
        
        //Send scheduler notification I558
        if($noOfScheduledReports > 0){
            $notifyTo = $schedleEmailCamp->fields['notify_to'];
            $otherNotify = $schedleEmailCamp->fields['other_notify'];
            if(($notifyTo != '' || $otherNotify != '') && $schedleEmailCamp->fields['is_scheduled'] == 1){
                \EmailCampaigns\Scheduler::sendSchedulerNotification($notifyTo, $otherNotify, $recordId);
                $query = "UPDATE `vtiger_scheduleemailcampagine` set is_scheduled='2' where emailcampaignsid=$recordId";
                $adb->pquery($query, array());
            }
        }
        //END
        
        // Procedo con l'invio mail scorrendo la tabella vtiger_emailcamp_sendemail
        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event start");
        self::debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event start");

        $rowsToSend = $adb->pquery("SELECT * FROM vtiger_emailcamp_sendemail WHERE emailcampaignsid=$recordId AND issent=0 LIMIT $batch");
        // Verifico se ci sono mail da inviare dalla tabella issent=0
        if ($adb->num_rows($rowsToSend) > 0) {
            $time_utc = new DateTime('now', new DateTimeZone('UTC'));
            $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
            $log->debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event rowstosend " . $adb->num_rows($rowsToSend));
            self::debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event rowstosend " . $adb->num_rows($rowsToSend));
            // Ciclo destinatari

            $mailer = Emails_Mailer_Model::getInstance();
            $mailer->SMTPKeepAlive = true;
            $mailer->IsHTML(true);
            $mailserverresult = $adb->pquery("select * from vtiger_systems", array());
            $numberofrow = $adb->num_rows($mailserverresult);
            if ($numberofrow == 0) {
                $mailserverresult = $adb->pquery("INSERT INTO vtiger_systems (`server`,`server_type`,`smtp_auth`) VALUES (' ','email',1);", array());
            }

            //GET ID OF SMTP SETTING FROM PICKLIST NAME VAL BETWEEN PARENTHESIS
            preg_match('#\((.*?)\)#', $recordModel_email->get('smtpsetting'), $match);

            $res = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_smtpsettings WHERE id=?", array($match[1]));

            while ($resultrow = $adb->fetch_array($res)) {
                $fromEmail = $resultrow['fromemail'];
                $fromName = $resultrow['fromname'];
            }

            //Get attachments linked to Campaign
            $resAttachs = $adb->pquery("SELECT s.notesid as documentid FROM vtiger_senotesrel s INNER JOIN vtiger_crmentity c ON c.crmid=s.notesid WHERE s.crmid=? AND c.deleted=0;", array($recordModel_email->get('id')));
            $attachments = array();
            while ($rowAttachs = $adb->fetch_array($resAttachs)) {
                $attachments[] = $rowAttachs['documentid'];
            }

            while ($singleRow = $adb->fetch_array($rowsToSend)) {
                $record_exists = $adb->query("SELECT * FROM vtiger_crmentity WHERE deleted = 0 and crmid = " . $singleRow["related_id"]);
                $count = $adb->num_rows($record_exists);
                if ($count == 0) {
                    $c = file_get_contents("logs/EmailCampLog" . date("Y-m-d") . ".txt");
                    file_put_contents("logs/EmailCampLog" . date("Y-m-d") . ".txt", $c . "\n Sendstatus -1 for " . $singleRow["email"]);
                    $adb->pquery("UPDATE vtiger_emailcamp_sendemail SET issent=-1,activityid=NULL WHERE emailcampaignsid=$recordId AND related_id=" . $singleRow['related_id'] . ";");
                    continue;
                }
                /*   $adb->query("UPDATE vtiger_crmentity_seq SET id=id+1");
                  $lastId = $adb->query("SELECT id FROM vtiger_crmentity_seq");
                  while ($idrow = $adb->fetch_array($lastId)) {
                  $lastId=$idrow["id"];
                  break;
                  } */
                /*  $adb->pquery("INSERT INTO vtiger_emailtrackingreport (emailtrackingreportid,parent_id,subject,emailcampaignsid,email_open,email_click) values(?,?,?,?,'','')",array($lastId,$singleRow["related_id"],$recordModel_email->get('subject'),$recordId));
                  $adb->pquery("INSERT INTO vtiger_emailtrackingreportcf (emailtrackingreportid) values(?)",array($lastId)); */

                $time_utc = new DateTime('now', new DateTimeZone('UTC'));
                $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
                $log->debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event while curremail: " . $singleRow["email"]);
                self::debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event while curremail: " . $singleRow["email"]);
                $to = $singleRow["email"];
                $recordModel = Vtiger_Record_Model::getCleanInstance("Emails");
                $recordModel->set('mode', '');
                $recordModel->set('description', $recordModel_email->get('description'));
                $recordModel->set('subject', $recordModel_email->get('subject'));
                $recordModel->set('ccmail', '');
                $recordModel->set('bccmail', '');
                $recordModel->set('email_flag', 'SENT');
                $recordModel->set('saved_toid', $to);
                $parentIds = $singleRow["related_id"] . '@1|';
                $recordModel->set('parent_id', $parentIds);
                $recordModel->set('from_email', $fromEmail);
                $recordModel->set('from_name', $fromName);
                $emailtrackingreport = Vtiger_Record_Model::getCleanInstance('EmailTrackingReport');
                $emailtrackingreport->set('mode', '');
                $emailtrackingreport->set('subject', $recordModel_email->get('subject'));
                $emailtrackingreport->set('parent_id', $singleRow["related_id"]);
                $emailtrackingreport->set('emailcampaignsid', $recordId);
                $emailtrackingreport->set('funnelid', $recordModel_email->get('funnelid'));

                $record_exists = $adb->query("SELECT * FROM vtiger_crmentity WHERE deleted = 0 and crmid = " . $singleRow["related_id"]);


                if ($recordModel_email->get("typeofassignment") != "LBL_ASS_ENTITY") {
                    $emailtrackingreport->set('assigned_user_id', $recordModel_email->get('assignto'));
                    $recordModel->set('assigned_user_id', $recordModel_email->get('assignto'));
                    //$userid = $recordModel_email->get('assignto');
                    //$adb->pquery("INSERT INTO vtiger_crmentity (`crmid`, `smcreatorid`, `smownerid`, `modifiedby`, `setype`, `createdtime`, `modifiedtime`, `version`, `presence`, `deleted`, `label`) VALUES (?, ? , ?, ?, 'EmailTrackingReport', UTC_TIMESTAMP() , UTC_TIMESTAMP(), '0', '1', '0', '');",array($lastId,$userid,$userid,$userid));
                } else {
                    if ($count > 0) {
                        $related_moduleName = $adb->query_result($record_exists, 0, 'setype');
                        $related_recordModel = Vtiger_Record_Model::getInstanceById($singleRow["related_id"], $related_moduleName);
                        $emailtrackingreport->set('assigned_user_id', $related_recordModel->get('assigned_user_id'));
                        $recordModel->set('assigned_user_id', $related_recordModel->get('assigned_user_id'));
                        //$userid=$related_recordModel->get('assigned_user_id');
                        //$adb->pquery("INSERT INTO vtiger_crmentity (`crmid`, `smcreatorid`, `smownerid`, `modifiedby`, `setype`, `createdtime`, `modifiedtime`, `version`, `presence`, `deleted`, `label`) VALUES (?, ? , ?, ?, 'EmailTrackingReport', UTC_TIMESTAMP() , UTC_TIMESTAMP(), '0', '1', '0', '');",array($lastId,$userid,$userid,$userid));
                    }
                }

                $emailtrackingreport->save();
                $emailtrackingreportid = $emailtrackingreport->getId();
                $time_utc = new DateTime('now', new DateTimeZone('UTC'));
                $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
                $log->debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event saved trackingreport id: " . $emailtrackingreportid);
                self::debug("EmailCampaignsDebug " . $currentTimestamp . " pre-send event saved trackingreport id: " . $emailtrackingreportid);

                $id = $singleRow['related_id'];
                $sendresult = EmailCampaigns_SaveAjax_Action::send($recordModel_email, $singleRow["related_id"], $emailtrackingreportid, trim($singleRow["email"]), $adb->query_result($record_exists, 0, 'setype'), $mailer, $singleRow["emailcampaignsid"], $attachments);
                if ($sendresult) {
                    $issaveemail = $adb->query("SELECT * FROM vtiger_emailcampaign_outgoingserverdetail WHERE issaveemail=1");
                    $saveemail = $adb->num_rows($issaveemail);
                    if ($saveemail > 0) {
                        $recordModel->save();
                    }
                    $adb->pquery("UPDATE vtiger_emailcamp_sendemail SET issent=1,activityid=$emailtrackingreportid WHERE emailcampaignsid=$recordId AND related_id= $id;");
                } else {
                    $c = file_get_contents("logs/EmailCampLog_" . $recordId . "_" . date("Y-m-d") . ".txt");
                    file_put_contents("logs/EmailCampLog_" . $recordId . "_" . date("Y-m-d") . ".txt", $c . "\n Sendstatus -1 for " . $singleRow["email"]);
                    $adb->pquery("UPDATE vtiger_emailcamp_sendemail SET issent=-1,activityid=-1 WHERE emailcampaignsid=$recordId AND related_id= $id;");
                    if ($emailtrackingreportid != 0) {
                        $adb->pquery("UPDATE vtiger_crmentity SET deleted=1 WHERE crmid=$emailtrackingreportid and setype='EmailTrackingReport'");
                    }
                }
            } //While
            $mailer->SmtpClose();

            // Verifico se ci sono ancora email da inviare

            $remainingRows = $adb->pquery("SELECT  '1' FROM vtiger_emailcamp_sendemail where emailcampaignsid=$recordId AND issent=0");
            if ($adb->num_rows($remainingRows) == 0) {
                // Chiudere la campagna
                $querycheckschedule = "UPDATE `vtiger_scheduleemailcampagine` set status=0 where emailcampaignsid=$recordId";
                $adb->pquery($querycheckschedule, array());

                //update campaign status
                $querycheckschedule = "UPDATE `vtiger_emailcampaigns` set campaign_status='LBL_COMPLETED' where emailcampaignsid=$recordId";
                $adb->pquery($querycheckschedule, array());
            }
        }

        return $currentTimestamp;
    }
//massSave

    public function getCleanedDescription($description)
    {
        $token_data_pair = explode('$', $description);
        foreach ($token_data_pair as $column) {
            $needle_array = explode('-', $column);
            if (is_array($needle_array) && ($needle_array[0] == "contacts" || $needle_array[0] == "accounts" || $needle_array[0] == "leads")) {
                $needle = '$' . "$column$";
                $description = str_replace($needle, "", $description);
            }
        }
        return $description;
    }

    public function send($recordModel_email, $par_crmid, $emailtrackingreportid, $email, $par_module_name, $mailer, $campid, $attachments = array())
    {

        global $log;

        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " send event start email: " . $email);
        self::debug("EmailCampaignsDebug " . $currentTimestamp . " send event start email: " . $email);

        $unsubscribe_option = $recordModel_email->get('unsubscribe_option');
        global $current_user, $adb, $emailcamp_sparkpost_api;
        $status = false;

        //GET ID OF SMTP SETTING FROM PICKLIST NAME VAL BETWEEN PARENTHESIS
        preg_match('#\((.*?)\)#', $recordModel_email->get('smtpsetting'), $match);

        $res = $adb->pquery("SELECT * FROM vtiger_emailcampaigns_smtpsettings WHERE id=?", array($match[1]));

        while ($resultrow = $adb->fetch_array($res)) {
            $userName = $resultrow['email'];
            $mail_server = $resultrow['servername'];
            $fromEmail = $resultrow['fromemail'];
            $fromName = $resultrow['fromname'];
            $replyTo = $resultrow['replytoemail'];
            $smtp_auth = $resultrow['auth'];
            $password = $resultrow['password'];
            $returnPath = $resultrow['returnpath'];
        }

        $mailer->reinitialize();

        foreach ($attachments as $attachid) {
            $documentModel = Vtiger_Record_Model::getInstanceById($attachid, 'Documents');
            $fileDetails = $documentModel->getFileDetails();

            $path = $fileDetails['path'] . $fileDetails['attachmentsid'] . '_' . $fileDetails['name'];
            try {
                $mailer->addAttachment($path, $fileDetails["name"]);
            } catch (phpmailerException $e) {
                file_put_contents("logs/EmailCampaigns_Attachment_ex.txt", $e->getMessage());
            }
        }

        $mailer->ConfigSenderInfo($fromEmail, $userName, $replyTo);
        $mergedDescription = $recordModel_email->get('description');
        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " send event before getCleanedDescription/getMergedDescription");
        self::debug("EmailCampaignsDebug " . $currentTimestamp . " send event before getCleanedDescription/getMergedDescription");

        $description = getMergedDescription(decode_html($mergedDescription), $par_crmid, $par_module_name);
        $description = EmailCampaigns_SaveAjax_Action::getCleanedDescription($description);

        $time_utc = new DateTime('now', new DateTimeZone('UTC'));
        $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
        $log->debug("EmailCampaignsDebug " . $currentTimestamp . " send event after getCleanedDescription/getMergedDescription");
        self::debug("EmailCampaignsDebug " . $currentTimestamp . " send event after getCleanedDescription/getMergedDescription");

        $siteURL = rtrim(vglobal('site_URL'), "/") . "/";
        $trackingenabled = $adb->pquery("select * from vtiger_emailcampaign_outgoingserverdetail where id = 1 and istrackingenabled=1", array());
        $numrows = $adb->num_rows($trackingenabled);

        $campaign = $adb->pquery("select campaign_name from vtiger_emailcampaigns where emailcampaignsid=?", array($campid));
        $campaign_name = $campaign->fields['campaign_name'];

        if ($emailtrackingreportid != '' && $numrows > 0) {
            $trackURL = $siteURL . "modules/EmailCampaigns/emailopen.php?emailtrackingreportid=$emailtrackingreportid&parent_id=$par_crmid";
            $imageDetails = "<img src='" . $trackURL . "' alt='' width='1' height='1'>";
            $mailer->Body .= $imageDetails;
            $mailer->AltBody .= $imageDetails;
        }

        $current_user_id = $current_user->id;
        $regexp = "<a\s[^>]*href=(\"??)([^\" >]*?)\\1[^>]*>(.*)<\/a>";
        if (preg_match_all("/$regexp/siU", $description, $matches, PREG_SET_ORDER)) {
            foreach ($matches as $match) {
                if (strpos($match[0], 'class="subscribe"') || strpos($match[0], 'class="unsubscribe"'))
                    continue;
                $description = str_replace('${CAMP_TITLE}', $campaign_name, $description);
                $description = str_replace('${EMAIL}', $email, $description);
                $description = str_replace('${CRMID}', $par_crmid, $description);
                $customLinkParams = $recordModel_email->get('custom_link_params');

                // start @change t42547
                $url = $match[2];

                if(!empty($customLinkParams)) {

                  $urlParts = explode('?', $match[2]);
                  if(count($urlParts) > 1){
                      $url = $match[2].'&'.$customLinkParams;
                  }else{
                    $url = $match[2].'?'.$customLinkParams;
                  }
                }
                // end @change t42457

                $link_url = base64_encode($url);
                $link_name = str_replace("'", " ", strip_tags($match[3]));
                $src = "href='" . $siteURL . "modules/EmailCampaigns/linktrack.php?id=$emailtrackingreportid&p_id=$par_crmid&email=$emailtrackingreportid&link_name=$link_name&url=$link_url'";
                $pattern = 'href="' . $match[2] . '"';
                $description = str_replace($pattern, $src, $description);
                //$description=  preg_replace($pattern,$src, $description);
            }
        }
        if ($unsubscribe_option != 0) {

            $lblsubphrase = vtranslate('LBL_SUBSCRIBER_PHRASE', 'EmailCampaigns');
            $lblsubphraselink = vtranslate('LBL_SUBSCRIBER_PHRASE_LINK', 'EmailCampaigns');
            $lblunsubphrase = vtranslate('LBL_UNSUBSCRIBER_PHRASE', 'EmailCampaigns');
            $lblunsubphraselink = vtranslate('LBL_UNSUBSCRIBER_PHRASE_LINK', 'EmailCampaigns');
            $shortURLOptions = array(
                'handler_path' => 'modules/EmailCampaigns/subscriber.php',
                'handler_class' => 'EmailCampaigns_Subscriber',
                'handler_function' => 'Subscriber',
                'handler_data' => array(
                    'recordid' => $par_crmid,
                    'modulename' => $par_module_name,
                    'custom_link_params' => $recordModel_email->get('custom_link_params')
                )
            );
            $subscribeUrl = Vtiger_ShortURL_Helper::generateURL($shortURLOptions);
            $shortURLOptions = array(
                'handler_path' => 'modules/EmailCampaigns/unsubscriber.php',
                'handler_class' => 'EmailCampaigns_Unsubscriber',
                'handler_function' => 'Unsubscriber',
                'handler_data' => array(
                    'recordid' => $par_crmid,
                    'modulename' => $par_module_name,
                    'custom_link_params' => $recordModel_email->get('custom_link_params')
                )
            );
            $unSubscribeUrl = Vtiger_ShortURL_Helper::generateURL($shortURLOptions);
            if (strpos($description, 'class="subscribe"') || strpos($description, 'class="unsubscribe"')) {

                $subscribePattern = "/(?<=class=\"subscribe\" href=(\"|'))[^\"']+(?=(\"|'))/";
                $description = preg_replace($subscribePattern, $subscribeUrl, $description);
                $unsubscribePattern = "/(?<=class=\"unsubscribe\" href=(\"|'))[^\"']+(?=(\"|'))/";
                $description = preg_replace($unsubscribePattern, $unSubscribeUrl, $description);
            } else {
                $unsubscriber = "<br><br>" . $lblunsubphrase . "<a href='$unSubscribeUrl'>" . $lblunsubphraselink . "</a>";
                $description .= $unsubscriber;

                $subscriber = "<br><br>" . $lblsubphrase . "<a href='$subscribeUrl'>" . $lblsubphraselink . "</a>";
                $description .= $subscriber;
            }
        }

        $mailer->Body .= $description;
        $mailer->AltBody .= $mailer->html2text($description);
        $mergedSubject = $recordModel_email->get('subject');
        $mailer->Subject = EmailCampaigns_SaveAjax_Action::getCleanedDescription(getMergedDescription(decode_html($mergedSubject), $par_crmid, $par_module_name));
        $mailer->AddAddress($email);

        // start - vicus add-on for email-campaigns
        $emailCampaignParser = new VebEmailCampaignParser();
        $emailCampaignParser->setBody($mailer->Body);
        if ($emailCampaignParser->isEmailCampaign()) {

          // format (handle) $this->Body
          // 1. standaard footer text verwijderen
          // 2. eigen footer toevoegen incl Subscribe, Unsubscribe
          // 3. omzetten van url https://castellum.vicus.nl  naar https://autoresponder.vicus.nl/
          // 4. https://castellum.vicus.nl/modules/EmailCampaigns/linktrack.php -> https://autoresponder.vicus.nl/vema_hub.php?c=base64(allparams)&v=1
          $emailCampaignParser->formatCampaignEmailLinks($par_crmid);
          $mailer->Body = $emailCampaignParser->getBody();

          // names comply to http://www.faqs.org/rfcs/rfc822.html
          // hopelijk zien we deze headers terug bij een bounce, eerst testen voordat we gaan programmeren
          $campaign_id = 'VebEmailCampaigns';
          $mailer->AddCustomHeader('X-VebEmailCampaigns-Campaign-Id', $campaign_id);
          $mailer->AddCustomHeader('X-VebEmailCampaigns-Subscriber-Id', $par_crmid);
            
          // t33253 - tekstversie staat er meervoudig in
          $mailer->AltBody = '';

          // set encoding
          $mailer->CharSet = 'utf-8';
        }
        // end - vicus add-on for email-campaigns

        if (!isset($emailcamp_sparkpost_api) || !$emailcamp_sparkpost_api) {

            $mailer->Host = $mail_server; // specify main and backup server

            // To support TLS
            $hostinfo = explode("://", $mail_server);
            $smtpsecure = $hostinfo[0];
            if ($smtpsecure == 'tls' || $smtpsecure == 'ssl') {
                $mailer->SMTPSecure = $smtpsecure;
                $mailer->Host = $hostinfo[1];
            }
            // End
            $portinfo = explode(":", $mailer->Host);
            if (count($portinfo) > 1) {
                $mailer->Host = $portinfo[0];
                $mailer->Port = $portinfo[1];
            }

            $mailer->Username = $userName; // SMTP username
            $mailer->FromName = $fromName;
            $mailer->Password = htmlspecialchars_decode($password); // SMTP password
            $mailer->SMTPAuth = $smtp_auth;
            $mailer->Sender = $returnPath;
            $time_utc = new DateTime('now', new DateTimeZone('UTC'));
            $currentTimestamp = $time_utc->format('Y-m-d H:i:s');
            $log->debug("EmailCampaignsDebug " . $currentTimestamp . " send event pre sendMethod ");
            self::debug("EmailCampaignsDebug " . $currentTimestamp . " send event pre sendMethod ");
            try {
                $status = $mailer->Send(true);
            } catch (phpmailerException $e) {
                $c = file_get_contents("logs/EmailCampLog_" . $campid . "_" . date("Y-m-d") . ".txt");
                file_put_contents("logs/EmailCampLog_" . $campid . "_" . date("Y-m-d") . ".txt", $c . "\n " . $e->errorMessage());
            } catch (Exception $e) {
                $c = file_get_contents("logs/EmailCampLog_" . $campid . "_" . date("Y-m-d") . ".txt");
                file_put_contents("logs/EmailCampLog_" . $campid . "_" . date("Y-m-d") . ".txt", $c . "\n " . $e->errorMessage());
            }
            $log->debug("EmailCampaignsDebug " . $currentTimestamp . " send event post sendMethod ");
            self::debug("EmailCampaignsDebug " . $currentTimestamp . " send event post sendMethod ");
            if (!$status) {
                $status = false;
                $c = file_get_contents("logs/EmailCampLog_" . $campid . "_" . date("Y-m-d") . ".txt");
                file_put_contents("logs/EmailCampLog_" . $campid . "_" . date("Y-m-d") . ".txt", $c . "\n " . $mailer->ErrorInfo);
            }
        } else {
            //$before = microtime(true);
            $ch = curl_init('https://api.sparkpost.com/api/v1/transmissions');
            if (FALSE === $ch) {
                echo "failed";
                throw new Exception('failed to initialize');
            }
            $body = $mailer->Body;
            $data_string = '{"options": {"sandbox": false}, "content": {"from": "' . $mailer->From . '", "subject": "' . $mailer->Subject . '", "html":' . json_encode($body) . '}, "recipients": [{"address": "' . $email . '"}]}';
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'Authorization: cc490b26fb5cd56eb7ac07960732a6274b0af55f',
                'Content-Length: ' . strlen($data_string)
            ));
            $result = json_decode(curl_exec($ch));

            if ($result->results->total_accepted_recipients == 1)
                $status = true;
            else
                $status = false;
        }


        return $status;
    }

    public function getAdvComparator($comparator, $value, $datatype = '', $columnname = '')
    {

        global $adb, $default_charset;
        $value = html_entity_decode(trim($value), ENT_QUOTES, $default_charset);
        $value = $adb->sql_escape_string($value);
        $valuearray = explode(",", trim($value));
        if (isset($valuearray) && count($valuearray) > 1 && $comparator == "e") {
            $newvalue = '';
            for ($n = 0; $n < count($valuearray); $n++) {
                if ($datatype == 'D') {
                    $dbvalue = getValidDBInsertDateTimeValue(trim($valuearray[$n]), $datatype);
                } elseif ($datatype == 'DT') {
                    $dbvalue = getValidDBInsertDateTimeValue(trim($valuearray[$n]), $datatype);
                } else {
                    $dbvalue = $valuearray[$n];
                }
                if ($newvalue == '') {
                    $newvalue .= "'" . trim($dbvalue) . "'";
                } else {
                    $newvalue .= ",'" . trim($dbvalue) . "'";
                }
            }

            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) IN (" . $newvalue . ") or " . "vtiger_groups.groupname IN (" . $newvalue . "))";
            } else {
                $rtvalue = $columnname . " IN (" . $newvalue . ")";
            }
        } elseif ($comparator == "e") {

            if ($datatype == 'D') {
                $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
            } elseif ($datatype == 'DT') {
                $dbvalue0 = getValidDBInsertDateTimeValue(trim($value), $datatype) . ' 00:00:00';
                $dbvalue1 = getValidDBInsertDateTimeValue(trim($value), $datatype) . ' 23:59:59';
            } else {
                $dbvalue = $value;
            }

            if (trim($dbvalue) == "NULL") {
                $rtvalue1 = " is NULL";
            } elseif (trim($dbvalue) != "") {
                $rtvalue1 = " = " . $adb->quote($dbvalue);
            } elseif (trim($dbvalue) == "" && ($datatype == "V" || $datatype == "E")) {
                $rtvalue1 = " = " . $adb->quote($dbvalue);
            } else {
                $rtvalue1 = " is NULL";
            }

            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) IN (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname IN (" . $adb->quote($dbvalue) . "))";
            } elseif ($columnname == 'vtiger_crmentity.modifiedtime' || $columnname == 'vtiger_crmentity.createdtime') {
                $rtvalue = "(" . $columnname . " between '" . getValidDBInsertDateTimeValue($dbvalue0) . "' and '" . getValidDBInsertDateTimeValue($dbvalue1) . "')";
            } else {
                $rtvalue = $columnname . " " . $rtvalue1;
            }
        }

        if (isset($valuearray) && count($valuearray) > 1 && $comparator == "n") {
            $newvalue = '';
            for ($n = 0; $n < count($valuearray); $n++) {
                if ($datatype == 'D') {
                    $dbvalue = getValidDBInsertDateTimeValue(trim($valuearray[$n]), $datatype);
                } elseif ($datatype == 'DT') {
                    $dbvalue = getValidDBInsertDateTimeValue(trim($valuearray[$n]), $datatype);
                } else {
                    $dbvalue = $valuearray[$n];
                }

                if ($newvalue == '') {
                    $newvalue .= "'" . trim($dbvalue) . "'";
                } else {
                    $newvalue .= ",'" . trim($dbvalue) . "'";
                }
            }


            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql)  NOT IN  (" . $newvalue . ") or " . "vtiger_groups.groupname  NOT IN (" . $newvalue . "))";
            } else {
                $rtvalue = $columnname . " NOT IN (" . $newvalue . ")";
            }
        } elseif ($comparator == "n") {
            if ($datatype == 'D') {
                $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
            } elseif ($datatype == 'DT') {
                $dbvalue0 = getValidDBInsertDateTimeValue(trim($value), $datatype) . ' 00:00:00';
                $dbvalue1 = getValidDBInsertDateTimeValue(trim($value), $datatype) . ' 23:59:59';
            } else {
                $dbvalue = $value;
            }

            if (trim($dbvalue) == "NULL") {
                $rtvalue1 = " is NOT NULL";
            } elseif (trim($dbvalue) != "") {
                $rtvalue1 = " <> " . $adb->quote($dbvalue);
            } elseif (trim($dbvalue) == "" && $datatype == "V") {
                $rtvalue1 = " <> " . $adb->quote($dbvalue);
            } elseif (trim($dbvalue) == "" && $datatype == "E") {
                $rtvalue1 = " <> " . $adb->quote($dbvalue);
            } else {
                $rtvalue1 = " is NOT NULL";
            }


            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) NOT IN (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname NOT IN (" . $adb->quote($dbvalue) . "))";
            } elseif ($columnname == 'vtiger_crmentity.modifiedtime' || $columnname == 'vtiger_crmentity.createdtime') {
                $rtvalue = "(" . $columnname . " NOT between '" . getValidDBInsertDateTimeValue($dbvalue0) . "' and '" . getValidDBInsertDateTimeValue($dbvalue1) . "')";
            } else {
                $rtvalue = $columnname . " " . $rtvalue1;
            }
        }

        if (isset($valuearray) && count($valuearray) > 1 && $comparator == "s") {
            $newvalue = '';
            for ($n = 0; $n < count($valuearray); $n++) {

                if (trim($valuearray[$n]) == "" && ($datatype == "V" || $datatype == "E")) {
                    $rtvalue2 = " like '" . formatForSqlLike($valuearray[$n], 3) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n], 3);
                } else {
                    $rtvalue2 = " like '" . formatForSqlLike($valuearray[$n], 2) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n], 2);
                }

                if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                    $concatSql = getSqlForNameInDisplayFormat(array(
                        'first_name' => "vtiger_users.first_name",
                        'last_name' => "vtiger_users.last_name"
                        ), 'Users');
                    $rtvalue1 = " (trim($concatSql) like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname  like (" . $adb->quote($dbvalue) . "))";
                } else {
                    $rtvalue1 = $columnname . " " . $rtvalue2;
                }


                if ($newvalue == '') {
                    $newvalue .= $rtvalue1;
                } else {
                    $newvalue .= " or " . $rtvalue1;
                }
            }
            $rtvalue = $newvalue;
        } elseif ($comparator == "s") {
            if (trim($value) == "" && ($datatype == "V" || $datatype == "E")) {
                $dbvalue = formatForSqlLike($value, 3);
                $rtvalue2 = " like '" . formatForSqlLike($value, 3) . "'";
            } else {
                $rtvalue2 = " like '" . formatForSqlLike($value, 2) . "'";
                $dbvalue = formatForSqlLike($value, 2);
            }

            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname  like (" . $adb->quote($dbvalue) . "))";
            } else {
                $rtvalue = $columnname . " " . $rtvalue2;
            }
        }


        if (isset($valuearray) && count($valuearray) > 1 && $comparator == "ew") {
            $newvalue = '';
            for ($n = 0; $n < count($valuearray); $n++) {

                if (trim($valuearray[$n]) == "" && ($datatype == "V" || $datatype == "E")) {
                    $rtvalue2 = " like '" . formatForSqlLike($valuearray[$n], 3) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n], 3);
                } else {
                    $rtvalue2 = " like '" . formatForSqlLike($valuearray[$n], 1) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n], 1);
                }

                if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                    $concatSql = getSqlForNameInDisplayFormat(array(
                        'first_name' => "vtiger_users.first_name",
                        'last_name' => "vtiger_users.last_name"
                        ), 'Users');
                    $rtvalue1 = " (trim($concatSql) like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname  like (" . $adb->quote($dbvalue) . "))";
                } else {
                    $rtvalue1 = $columnname . " " . $rtvalue2;
                }

                if ($newvalue == '') {
                    $newvalue .= $rtvalue1;
                } else {
                    $newvalue .= " or " . $rtvalue1;
                }
            }
            $rtvalue = $newvalue;
        } elseif ($comparator == "ew") {
            if (trim($value) == "" && ($datatype == "V" || $datatype == "E")) {
                $rtvalue2 = " like '" . formatForSqlLike($value, 3) . "'";
                $dbvalue = formatForSqlLike($value, 3);
            } else {
                $rtvalue2 = " like '" . formatForSqlLike($value, 1) . "'";
                $dbvalue = formatForSqlLike($value, 1);
            }


            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname  like (" . $adb->quote($dbvalue) . "))";
            } else {
                $rtvalue = $columnname . " " . $rtvalue2;
            }
        }


        if (isset($valuearray) && count($valuearray) > 1 && $comparator == "c") {
            $newvalue = '';
            for ($n = 0; $n < count($valuearray); $n++) {

                if (trim($valuearray[$n]) == "" && ($datatype == "V" || $datatype == "E")) {
                    $rtvalue2 = " like '" . formatForSqlLike($valuearray[$n], 3) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n], 3);
                } else {
                    $rtvalue2 = " like '" . formatForSqlLike($valuearray[$n]) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n]);
                }

                if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                    $concatSql = getSqlForNameInDisplayFormat(array(
                        'first_name' => "vtiger_users.first_name",
                        'last_name' => "vtiger_users.last_name"
                        ), 'Users');
                    $rtvalue1 = " (trim($concatSql) like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname  like (" . $adb->quote($dbvalue) . "))";
                } else {
                    $rtvalue1 = $columnname . " " . $rtvalue2;
                }

                if ($newvalue == '') {
                    $newvalue .= $rtvalue1;
                } else {
                    $newvalue .= " or " . $rtvalue1;
                }
            }
            $rtvalue = $newvalue;
        } elseif ($comparator == "c") {
            if (trim($value) == "" && ($datatype == "V" || $datatype == "E")) {
                $rtvalue2 = " like '" . formatForSqlLike($value, 3) . "'";
                $dbvalue = formatForSqlLike($value, 3);
            } else {
                $rtvalue2 = " like '" . formatForSqlLike($value) . "'";
                $dbvalue = formatForSqlLike($value);
            }

            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname  like (" . $adb->quote($dbvalue) . "))";
            } else {
                $rtvalue = $columnname . " " . $rtvalue2;
            }
        }


        if (isset($valuearray) && count($valuearray) > 1 && $comparator == "k") {
            $newvalue = '';
            for ($n = 0; $n < count($valuearray); $n++) {

                if (trim($valuearray[$n]) == "" && ($datatype == "V" || $datatype == "E")) {
                    $rtvalue2 = " not like ''";
                    $dbvalue = '';
                } else {
                    $rtvalue2 = " not like '" . formatForSqlLike($valuearray[$n]) . "'";
                    $dbvalue = formatForSqlLike($valuearray[$n]);
                }

                if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                    $concatSql = getSqlForNameInDisplayFormat(array(
                        'first_name' => "vtiger_users.first_name",
                        'last_name' => "vtiger_users.last_name"
                        ), 'Users');
                    $rtvalue1 = " (trim($concatSql)  not like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname   not like (" . $adb->quote($dbvalue) . "))";
                } else {
                    $rtvalue1 = $columnname . " " . $rtvalue2;
                }

                if ($newvalue == '') {
                    $newvalue .= $rtvalue1;
                } else {
                    $newvalue .= " or " . $rtvalue1;
                }
            }
            $rtvalue = $newvalue;
        } elseif ($comparator == "k") {
            if (trim($value) == "" && ($datatype == "V" || $datatype == "E")) {
                $rtvalue2 = " not like ''";
                $dbvalue = '';
            } else {
                $rtvalue2 = " not like '" . formatForSqlLike($value) . "'";
                $dbvalue = formatForSqlLike($value);
            }

            if ($columnname == 'vtiger_crmentity.smownerid' || $columnname == 'vtiger_crmentity.modifiedby') {
                $concatSql = getSqlForNameInDisplayFormat(array(
                    'first_name' => "vtiger_users.first_name",
                    'last_name' => "vtiger_users.last_name"
                    ), 'Users');
                $rtvalue = " (trim($concatSql) not like (" . $adb->quote($dbvalue) . ") or " . "vtiger_groups.groupname not like (" . $adb->quote($dbvalue) . "))";
            } else {
                $rtvalue = $columnname . " " . $rtvalue2;
            }
        }


        if (($comparator == 'next120days' || $comparator == 'next90days' || $comparator == 'next60days' || $comparator == 'next30days' || $comparator == 'last120days' || $comparator == 'last90days' || $comparator == 'last60days' || $comparator == 'last30days' || $comparator == 'last7days' || $comparator == 'nextmonth' || $comparator == 'thismonth' || $comparator == 'lastmonth' || $comparator == 'nextweek' || $comparator == 'thisweek' || $comparator == 'lastweek' || $comparator == 'nextfq' || $comparator == 'thisfq' || $comparator == 'prevfq' || $comparator == 'bw' || $comparator == 'custom' || $comparator == 'prevfy' || $comparator == 'thisfy' || $comparator == 'nextfy') && count($valuearray) == 2) {
            if ($datatype == 'D') {
                $dbvalue0 = getValidDBInsertDateTimeValue(trim($valuearray[0]), $datatype);
                $dbvalue1 = getValidDBInsertDateTimeValue(trim($valuearray[1]), $datatype);
                $rtvalue = "(" . $columnname . " between '" . $dbvalue0 . "' and '" . $dbvalue1 . "')";
            } elseif ($datatype == 'DT') {
                $dbvalue0 = getValidDBInsertDateTimeValue(trim($valuearray[0]), $datatype) . ' 00:00:00';
                $dbvalue1 = getValidDBInsertDateTimeValue(trim($valuearray[1]), $datatype) . ' 23:59:59';
                $rtvalue = "(" . $columnname . " between '" . getValidDBInsertDateTimeValue($dbvalue0) . "' and '" . getValidDBInsertDateTimeValue($dbvalue1) . "')";
            }
        }


        if ($comparator == 'tomorrow' || $comparator == 'today' || $comparator == 'yesterday') {
            $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
            if ($datatype == 'D') {
                $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
                $rtvalue = $columnname . " = " . $adb->quote($dbvalue);
            } elseif ($datatype == 'DT') {
                $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
                $dbvalue0 = $dbvalue . ' 00:00:00';
                $dbvalue1 = $dbvalue . ' 23:59:00';
                $rtvalue = "(" . $columnname . " between '" . getValidDBInsertDateTimeValue($dbvalue0) . "' and '" . getValidDBInsertDateTimeValue($dbvalue1) . "')";
            }
        }



        if ($comparator == "b") {
            if ($datatype = 'D') {
                $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
            } else {
                $dbvalue = $value;
            }

            $rtvalue = $columnname . " < " . $adb->quote($dbvalue);
        }

        if ($comparator == "a") {
            if ($datatype = 'D') {
                $dbvalue = getValidDBInsertDateTimeValue(trim($value), $datatype);
            } else {
                $dbvalue = $value;
            }
            $rtvalue = $columnname . " > " . $adb->quote($dbvalue);
        }

        if ($comparator == 'ny') {
            $rtvalue = $columnname . " IS NOT NULL AND " . $columnname . " != ''";
        }

        if ($comparator == 'y') {
            $rtvalue = $columnname . " IS  NULL OR " . $columnname . " = ''";
        }

        if ($comparator == "l") {
            $rtvalue = $columnname . " < " . $adb->quote($value);
        }
        if ($comparator == "g") {
            $rtvalue = $columnname . " > " . $adb->quote($value);
        }
        if ($comparator == "m") {
            $rtvalue = $columnname . " <= " . $adb->quote($value);
        }
        if ($comparator == "h") {
            $rtvalue = $columnname . " >= " . $adb->quote($value);
        }

        return '(' . $rtvalue . ')';
    }

    private function debug($msg) {

      return;
      file_put_contents('debugSaveAjax.log', __LINE__.' '.var_export($msg, true)."\n", FILE_APPEND);
    }
}
