<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class VebEmailCampaigns extends Vtiger_CRMEntity {

  /**
   * Invoked when special actions are performed on the module.
   * @param String Module name
   * @param String Event Type
   */
  public function vtlib_handler($moduleName, $eventType) {

    if ($eventType == 'module.postinstall') {

      global $adb;

      // Mark the module as Standard module
      $adb->pquery('UPDATE vtiger_tab SET customized=0 WHERE name=?', array($moduleName));

      $this->handlePackaged();
    }
    elseif ($eventType == 'module.disabled') {

      // TODO Handle actions before this module is being uninstalled.
    }
    elseif ($eventType == 'module.preuninstall') {

      // TODO Handle actions when this module is about to be deleted.
    }
    elseif ($eventType == 'module.preupdate') {

      // TODO Handle actions before this module is updated.
    }
    elseif ($eventType == 'module.postupdate') {

      // TODO Handle actions after this module is updated.
    }
  }

  private function handlePackaged() {

    $packagedFiles = array(
                           array('src' => 'SaveAjax.php',
                                 'dst' => 'SaveAjax.php',
                                 'path' => 'modules/EmailCampaigns/actions/'
                           )
                     );

    foreach($packagedFiles as $packagedFile) {

      // test if directory exists
      if (!file_exists($packagedFile['path'])) mkdir($packagedFile['path'], 0755, true);

      if (file_exists($packagedFile['path'] . $packagedFile['dst'])) {

        // check the hash
        $sha1org = sha1_file('modules/VebEmailCampaigns/packaged/' . $packagedFile['src']);
        $sha1dst = sha1_file($packagedFile['path'] . $packagedFile['dst']);

        // no overwrite needed if hash is equal
        if ($sha1org == $sha1dst) continue;

        if (file_exists($packagedFile['path'] . $packagedFile['dst'] . '.orig')) {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '_before' . date('Ymd'));
        }
        else {

          copy($packagedFile['path'] . $packagedFile['dst'], $packagedFile['path'] . $packagedFile['dst'] . '.orig');
        }
      }

      // ok to override
      $src = 'modules/VebEmailCampaigns/packaged/' . $packagedFile['src'];
      $dst = $packagedFile['path'] . $packagedFile['dst'];
      copy($src, $dst);
    }
  }
}
