<?php
/*
 * 
 *
 */
include_once('modules/VebEmailConsent/VebEmailConsentParser.php');

class VebEmailCampaignParser extends VebEmailConsentParser {

/*
  protected $linkStyle = 'font-family:arial, helvetica neue, helvetica, sans-serif;
                          font-size:12px;
                          text-decoration:underline;
                          color:#5B626A;';

  protected $paragraphStyle = 'margin:0;
                               font-size:12px;
                               font-family:arial, helvetica neue, helvetica, sans-serif;
                               line-height:21px;
                               color:#333333;
                               text-align:center;
                               max-width:550px;';
 */
  protected $linkStyle = 'font-family: Roboto, Helvetica, Arial, DejaVu Sans, Liberation Sans, Freesans, sans-serif;
                          font-size:12px;
                          text-decoration:underline;
                          color:#5B626A;';

  protected $paragraphStyle = 'margin:0;
                               font-family: Roboto, Helvetica, Arial, DejaVu Sans, Liberation Sans, Freesans, sans-serif;
                               font-size:12px;
                               line-height:21px;
                               color:#333333;
                               text-align:center;
                               max-width:550px;';

  
  /**
   * Constructor
   * @param boolean $exceptions Should we throw external exceptions?
   */
  public function __construct() {

    parent::__construct();
  }

  public function isEmailCampaign() {

    // it is a campaign - call from EmailCampaigns/actions/SaveAjax.php
    // return (strpos($this->Body, 'div class="emailCampaign') !== false);
    return true;
  }

  public function formatCampaignEmailLinks($crmId) {

    // als allereerste preset doc
    $this->setDocument();

    // dan: voeg de custom footer toe
    $this->addFooter($crmId);

    // en dan: rebuildURLs
    $this->rebuildURLs();
  }

  private function addFooter($entityId) {

    // Compose the footer (keep it neutral)
    $this->Body .= <<<EOT
<table align="center" bgcolor="#fff" cellpadding="0" cellspacing="0" style="background-color: #ffffff;" width="100%">
  <tbody>
    <tr>
      <td align="center" style="padding:0;margin:0;">
        <table align="center" bgcolor="#fff" cellpadding="0" cellspacing="0" style="border-collapse:collapse;border-spacing:0px;background-color:#fff;">
          <tbody>
            <tr>
              <td align="center" bgcolor="#fff" style="margin:0;padding-left:20px;padding-right:20px;padding-top:30px;padding-bottom:30px;background-color:#fff;">
                <table align="center" bgcolor="#fff" cellpadding="0" cellspacing="0" style="border-collapse:collapse;border-spacing:0px;" width="100%">
                  <tbody>
                    <tr>
                      <td align="center" style="padding:0;margin:0;padding-top:5px;">
EOT;

    // get customized footer conform accounttype, or default
    $this->getCustomizedOrDefaultFooter($entityId);

    $this->getAdvertMessage();

    $this->Body .= <<<EOT
                      </td>
                    </tr>
                  </tbody>
                </table>
              </td>
            </tr>
          </tbody>
        </table>
      </td>
    </tr>
  </tbody>
</table>
EOT;

    // and reload it in the DOMDocument
    $this->srcDoc->encoding = 'utf-8';
    $this->srcDoc->loadHTML(utf8_decode($this->Body));

    // and get in the Xpath
    $this->srcXpath = new DOMXPath($this->srcDoc);
  }

  private function getCustomizedOrDefaultFooter($entityId) {

    // from module emailCampaigns:
    // @todo add style to settings
    $unsubscribeLink = '<a href="%smodules/EmailCampaigns/unsubscriber.php?current_user_id=%s&recordid=%s&modulename=%s" style="%s">%s</a>';
    $subscribeLink = '<a href="%smodules/EmailCampaigns/subscriber.php?current_user_id=%s&recordid=%s&modulename=%s" style="%s">%s</a>';

    // default footer
    $accountType = 'default';

    // must footer be customized
    if (Settings_VebSettings_Record_Model::getSetting('footerCustomizedToAccountType', 'VebEmailCampaigns')  == 1) {

      $entityTypeInfo = $this->getEntityType($entityId);

      $accountType = $entityTypeInfo['account']['accountType'];
      $accountName = $entityTypeInfo['account']['accountName'];
    }

    // define the unsubscribe link
    $unsubscribe = sprintf($unsubscribeLink, $this->siteURL,
                                             $entityTypeInfo['ownerId'],
                                             $entityId,
                                             $entityTypeInfo['entityType'],
                                             $this->linkStyle,
                                             vtranslate('hier', 'VebEmailCampaigns'));

    // define the unsubscribe link
    $subscribe = sprintf($subscribeLink, $this->siteURL,
                                         $entityTypeInfo['ownerId'],
                                         $entityId,
                                         $entityTypeInfo['entityType'],
                                         $this->linkStyle,
                                         vtranslate('hier', 'VebEmailCampaigns'));

    switch ($accountType) {
      
      case 'klant':
      case 'leverancier':
      case 'partner':

            $this->Body .= '<p style="' . $this->paragraphStyle . '">';
            $this->Body .= vtranslate('Je ontvangt deze e-mail omdat je organisatie', 'VebEmailCampaigns');
            $this->Body .= sprintf(' %s %s ', $accountName, $accountType);
            $this->Body .= vtranslate('is van', 'VebEmailCampaigns');
            $this->Body .= ' ';
            $this->Body .= $this->companySettings->get('organizationname');
            $this->Body .= '</p>';

            $this->Body .= '<p style="' . $this->paragraphStyle . '">';
            $this->Body .= vtranslate('Mocht jij niet de juiste contactperoon zijn voor dit bericht stuur dan een e-mail met naam en e-mailadres van de juiste contactpersoon naar', 'VebEmailCampaigns');
            $this->Body .= ' ';

            // @change t46546
            // $this->Body .= Settings_VebSettings_Record_Model::getSetting('contactEmailAddress', 'VebEmailCampaigns');
            $this->Body .= '<a href="mailto:';
            $this->Body .= Settings_VebSettings_Record_Model::getSetting('contactEmailAddress', 'VebEmailCampaigns');
            $this->Body .= '">';
            $this->Body .= Settings_VebSettings_Record_Model::getSetting('contactEmailAddress', 'VebEmailCampaigns');
            $this->Body .= '</a>';
            //

            $this->Body .= '</p>';
            break;

      default:

            $this->Body .= '<p style="' . $this->paragraphStyle . '">';
            $this->Body .= sprintf(vtranslate('Je ontvangt deze e-mail omdat je hebt aangegeven dat je tips en updates wilt ontvangen over de oplossingen en diensten van %s.', 'VebEmailCampaigns'), $this->companySettings->get('organizationname'));
            $this->Body .= '</p>';

            $this->Body .= '<p style="' . $this->paragraphStyle . '">';
            $this->Body .= vtranslate('Als je dit soort e-mails niet meer wilt ontvangen, kun je je', 'VebEmailCampaigns');
            $this->Body .=  ' ';
            $this->Body .=  $unsubscribe;
            $this->Body .=  ' ';
            $this->Body .=  vtranslate('afmelden.', 'VebEmailCampaigns');
            $this->Body .= '</p>';
            break;
    }
  }

  private function getEntityType($entityId) {

    $entityTypeInfo = array();

    // need to get the setype and ownerid
    $this->adb = PearDatabase::getInstance();

    $query = "SELECT setype, smownerid FROM vtiger_crmentity WHERE crmid = ? AND deleted = 0";
    $result = $this->adb->pquery($query, array($entityId));

    $entityType = $this->adb->query_result($result, 0, 'setype');
    $ownerId = $this->adb->query_result($result, 0, 'smownerid');

    $entityTypeInfo['entityType'] = $entityType;
    $entityTypeInfo['ownerId'] = $ownerId;
    $entityTypeInfo['account'] = array('accountName' => null, 'accountType' => null);

    // if 'Contacts' get the organisation name and type of relation
    if ($entityType == 'Contacts') $entityTypeInfo['account'] = $this->getContactsAccountInformation($entityId);

    return $entityTypeInfo;
  }

  private function getContactsAccountInformation($entityId) {

    // accountInfo defaults
    $accountInfo = array('accountName' => null, 'accountType' => null);

    $query = "SELECT accountid FROM vtiger_contactdetails WHERE contactid = ?";
    $result = $this->adb->pquery($query, array($entityId));

    $accountId = $this->adb->query_result($result, 0, 'accountid');

    if ($accountId > 0) {

      // accounttype field
      $accountTypeField = Settings_VebSettings_Record_Model::getSetting('accountTypeField', 'VebEmailCampaigns');

      $query = sprintf("SELECT accountname, %s
                        FROM vtiger_account, vtiger_accountscf
                        WHERE vtiger_account.accountid = vtiger_accountscf.accountid
                        AND vtiger_account.accountid = ?", $accountTypeField);

      $result = $this->adb->pquery($query, array($accountId));

      // expects only one, if not, use first one in result
      $accountName = $this->adb->query_result($result, 0, 'accountname');
      $accountInfo['accountName'] = $accountName;

      $accountTypePicklistValues = $this->adb->query_result($result, 0, $accountTypeField);
      $accountInfo['accountType'] = $this->getAccountType($accountTypePicklistValues);
    }

    return $accountInfo;
  }

  private function getAccountType($accountTypePicklistValues) {

    // @todo which field?? default = single select other field
    // got some possibilities for accountType
    // Klant
    // Concurrent |##| Ex-klant
    // Prospect |##| Potentiele Partner |##| Potentiele Leverancier
    // so:
    $accountTypes = explode(' |##| ', $accountTypePicklistValues);

    // footer differs for 3 types: 'Klant', 'Actieve Leverancier', 'Partner'
    if (in_array('Vicus zelf', $accountTypes)) {

      $accountType = 'klant';
    }
    elseif (in_array('Klant', $accountTypes)) {

      $accountType = 'klant';
    }
    elseif (in_array('Actieve Leverancier',  $accountTypes)) {
         
      $accountType = 'leverancier';
    }
    elseif (in_array('Partner', $accountTypes)) {

      $accountType = 'partner';
    }
    else {

      $accountType = null;
    }

    return $accountType;
  }

  private function getAdvertMessage() {

    $this->Body .= '<p style="' . $this->paragraphStyle . '">';
    $this->Body .= vtranslate('Deze e-mail is verstuurd met de Vtiger E-mailmarketing Automation suite van Vicus.', 'VebEmailCampaigns');
    $this->Body .= ' ';
    $this->Body .= vtranslate('Check', 'VebEmailCampaigns');
    $this->Body .= ' ';
    $this->Body .= sprintf('<a href="https://www.vicus.nl/oplossingen/marketing-automation" style="%s">%s</a>', $this->linkStyle, vtranslate('deze link', 'VebEmailCampaigns'));
    $this->Body .= ' ';
    $this->Body .= vtranslate('als jij ook meer wilt halen uit jouw e-mailmarketing.', 'VebEmailCampaigns');
    $this->Body .= '</p>';
    
    $this->Body .= '<hr style="line-height:21px;
                               color:#333333;
                               text-align:center;
                               max-width:550px;" />';
    
    $this->Body .= '<p style="' . $this->paragraphStyle . '">';

    $footerLinks = '';
    if (!empty($this->companySettings->get('website'))) {

      $footerLinks .= sprintf('<a href="%s">%s</a>', $this->companySettings->get('website'),
                                                     $this->companySettings->get('organizationname'));
    }
    if (!empty($this->consentSettings->get('company_contact_link'))) {

      if (!empty($footerLinks)) $footerLinks .= ' | ';

      $footerLinks .= sprintf('<a hef="%s">%s %s</a>', $this->consentSettings->get('company_contact_link'),
                                                       $this->companySettings->get('address'),
                                                       $this->companySettings->get('city'));
    }
    if (!empty($this->consentSettings->get('company_privacy_link'))) {

      if (!empty($footerLinks)) $footerLinks .= ' | ';

      $footerLinks = sprintf('<a href="%s">%s</a>', $this->consentSettings->get('company_privacy_link'),
                                                    vtranslate('Privacy Policy', 'VebEmailCampaigns'));
    }

    $this->Body .= $footerLinks;
    $this->Body .= '</p>';
  }    

  private function debug($line, $msg) {

    file_put_contents('veb/logs/VebEmailCampaignParser.txt', $line . ' ' . var_export($msg, true)."\n", FILE_APPEND);
  }
}
