<?php
/***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class VebDomainNames extends Vtiger_CRMEntity {
	var $table_name = 'vtiger_vebdomainnames';
	var $table_index= 'vebdomainnamesid';

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_vebdomainnamescf', 'vebdomainnamesid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_vebdomainnames', 'vtiger_vebdomainnamescf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_vebdomainnames' => 'vebdomainnamesid',
		'vtiger_vebdomainnamescf'=>'vebdomainnamesid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
	);
	var $list_fields_name = Array (
	);

	// Make the field link to detail view
	var $list_link_field = 'domainnameno';

	// For Popup listview and UI type support
	var $search_fields = Array(
	);
	var $search_fields_name = Array (
	);

	// For Popup window record selection
	var $popup_fields = Array ('');

	// For Alphabetical search
	var $def_basicsearch_col = '';

	// Column value to use on detail view record text display
	var $def_detailview_recname = '';

	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('','assigned_user_id');

	var $default_order_by = '';
	var $default_sort_order='ASC';

	/**
	* Invoked when special actions are performed on the module.
	* @param String Module name
	* @param String Event Type
	*/
	function vtlib_handler($moduleName, $eventType) {
 		if($eventType == 'module.postinstall') {
 			//Enable ModTracker for the module
 			static::enableModTracker($moduleName);

 			//Add related list to Accounts
 			$Vtiger_Utils_Log = true;
			include_once('vtlib/Vtiger/Menu.php');
			include_once('vtlib/Vtiger/Module.php');
			include_once('includes/main/WebUI.php');

			$accountsModule = Vtiger_Module::getInstance('Accounts');
			$accountsModule->setRelatedList(Vtiger_Module::getInstance('VebDomainNames'), 'Domain Names',Array('ADD'),'get_dependents_list');

		} else if($eventType == 'module.disabled') {
			// TODO Handle actions before this module is being uninstalled.
		} else if($eventType == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($eventType == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($eventType == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
 	}
	
       
	/**
	 * Enable ModTracker for the module
	 */
	public static function enableModTracker($moduleName)
	{
		include_once 'vtlib/Vtiger/Module.php';
		include_once 'modules/ModTracker/ModTracker.php';
			
		//Enable ModTracker for the module
		$moduleInstance = Vtiger_Module::getInstance($moduleName);
		ModTracker::enableTrackingForModule($moduleInstance->getId());
	}
}
