<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */
class VebCompanyData_Module_Model extends Vtiger_Module_Model
{

    /**
     * Function to get the Quick Links for the module
     * @param <Array> $linkParams
     * @return <Array> List of Vtiger_Link_Model instances
     */
    public function getSideBarLinks($linkParams)
    {
        $links = parent::getSideBarLinks($linkParams);

        $quickLink = array(
            'linktype' => 'SIDEBARLINK',
            'linklabel' => 'LBL_DASHBOARD',
            'linkurl' => $this->getDashBoardUrl(),
            'linkicon' => '',
        );

        //Check profile permissions for Dashboards
        $moduleModel = Vtiger_Module_Model::getInstance('Dashboard');
        $userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();
        $permission = $userPrivilegesModel->hasModulePermission($moduleModel->getId());
        if ($permission)
        {
            $links['SIDEBARLINK'][] = Vtiger_Link_Model::getInstanceFromValues($quickLink);
        }

        return $links;
    }

    /**
     * Function returns Settings Links
     * @return Array
     */
    public function updateheaderscript()
    {
        global $log;
        $log->debug("Entering updateheaderscript() method....");
        global $adb;

        $sql = "SELECT max(linkid)+1 AS cnt FROM vtiger_links";
        $result = $adb->query($sql);

        $sql1 = "SELECT linklabel FROM vtiger_links WHERE tabid =7 AND linklabel ='VebCompanyDataCommonHeaderScript'";
        $result1 = $adb->query($sql1);
        if ($adb->num_rows($result1) == 0)
        {
            if ($adb->num_rows($result) > 0)
            {
                $no = $adb->query_result($result, 0, 'cnt');
                if ($no != 0)
                {
                    //$tabid = $adb->getUniqueID("vtiger_ws_entity");
                    $ws_entitySql = "INSERT INTO vtiger_links (linkid ,tabid ,linktype,linklabel,linkurl,linkicon,sequence,handler_path ,handler_class,handler,parent_link) VALUES (?,7, 'HEADERSCRIPT', 'VebCompanyDataCommonHeaderScript', 'modules/VebCompanyData/VebCompanyData.js', '', '0', NULL , NULL , NULL , NULL);";
                    $res = $adb->pquery($ws_entitySql, array($no));
                    $adb->pquery('update vtiger_links_seq set id=?', array($no));
                    $log->debug("Entered Record in vtiger_links ");
                }
            }
        }
        $sqla = "SELECT max(linkid)+1 AS cnt FROM vtiger_links";
        $resulta = $adb->query($sqla);

        $sql1a = "SELECT linklabel FROM vtiger_links WHERE tabid =6 AND linklabel ='VebCompanyDataCommonHeaderScript'";
        $result1a = $adb->query($sql1a);
        if ($adb->num_rows($result1a) == 0)
        {
            if ($adb->num_rows($resulta) > 0)
            {
                $no = $adb->query_result($resulta, 0, 'cnt');
                if ($no != 0)
                {
                    //$tabid = $adb->getUniqueID("vtiger_ws_entity");
                    $ws_entitySqlacc = "INSERT INTO vtiger_links (linkid ,tabid ,linktype,linklabel,linkurl,linkicon,sequence,handler_path ,handler_class,handler,parent_link) VALUES (?,6, 'HEADERSCRIPT', 'VebCompanyDataCommonHeaderScript', 'modules/VebCompanyData/VebCompanyDataaccounts.js', '', '0', NULL , NULL , NULL , NULL);";
                    $resacc = $adb->pquery($ws_entitySqlacc, array(++$no));
                    $adb->pquery('update vtiger_links_seq set id=?', array($no));
                    $log->debug("Entered Record in vtiger_links ");
                }
            }
        }

        $log->debug("Exiting updateheaderscript() method....");
        //$this->setAppMenu($moduleName);
    }

    public function getlablefield($string)
    {
        global $log;
        $log->debug("Entering updateheaderscript() method....");
        global $adb;
        $fieldlabel = "";
        $sql = "SELECT fieldlabel FROM vtiger_field WHERE tabid=7 AND (columnname=? OR fieldname=?)";
        $result = $adb->pquery($sql, array($string, $string));
        if ($adb->num_rows($result) > 0)
        {
            $fieldlabel = $adb->query_result($result, 0, 'fieldlabel');
            return vtranslate($fieldlabel, 'Leads');
        }
        $fieldlabel = "";
        $log->debug("Exiting getlablefield() method....");
    }

    public function getlableaccountfield($string)
    {
        global $log;
        $log->debug("Entering updateheaderscript() method....");
        global $adb;
        $fieldlabel = "";
        $sql = "SELECT fieldlabel FROM vtiger_field WHERE tabid=6 AND (columnname=? OR fieldname=?)";
        $result = $adb->pquery($sql, array($string, $string));
        if ($adb->num_rows($result) > 0)
        {
            $fieldlabel = $adb->query_result($result, 0, 'fieldlabel');
            return vtranslate($fieldlabel, 'Accounts');
        }
        $fieldlabel = "";
        $log->debug("Exiting getlablefield() method....");
    }

    public function getSettingLinks()
    {
        global $root_directory;
		 global $log;
	  	$log->debug("Entering into getSettingLinks() method.");

        $currentUserModel = Users_Record_Model::getCurrentUserModel();
        $settingLinks = parent::getSettingLinks();
        $this->updateheaderscript();

        $vebcompanydatafile = 'modules/VebCompanyData/views/VebCompanyDataPopView.php';
        $vebleadfile = 'modules/Leads/views/VebCompanyDataPopView.php';
        @copy($vebcompanydatafile, $vebleadfile);

        $vebcompanydatafile = 'modules/VebCompanyData/views/VebCompanyDataPopAccountView.php';
        $vebleadfile = 'modules/Accounts/views/VebCompanyDataPopAccountView.php';
        @copy($vebcompanydatafile, $vebleadfile);

		//vimport('~~modules/com_vtiger_workflow/VTWorkflowUtils.php');

		$layoutEditorImagePath = Vtiger_Theme::getImagePath('LayoutEditor.gif');
		$editWorkflowsImagePath = Vtiger_Theme::getImagePath('EditWorkflows.png');
		$settingsLinks = array();

		$settingsLinks[] = array(
					'linktype' => 'LISTVIEWSETTING',
					'linklabel' => 'LBL_CONFIGURATION_SETTINGS',
					'linkurl' => 'index.php?module=VebCompanyData&parent=Settings&view=Show',
					'linkicon' => ''
			);

		$log->debug("Exiting getSettingLinks() method....");
		return $settingsLinks;

    }

    /**
     * Function returns deleted records condition
     */
    public function getDeletedRecordCondition()
    {
        return 'vtiger_crmentity.deleted = 0 AND vtiger_leaddetails.converted = 0';
    }

    /**
     * Function to get the list of recently visisted records
     * @param <Number> $limit
     * @return <Array> - List of Vtiger_Record_Model or Module Specific Record Model instances
     */
    public function getdefaulturl()
    {
        return 'index.php?module=' . $this->get('name') . '&view=SFindex';
    }

    /*
     * Function to get supported utility actions for a module
     */

    public function getUtilityActionsNames()
    {
        return array('Import', 'Export', 'Merge', 'ConvertLead', 'DuplicatesHandling');
    }

    public function getUserDetails()
    {
        global $adb;
        $userdetails = array();

        $result = $adb->pquery("SELECT username, password FROM veb_company_data_settings ORDER BY id limit 0,1", array());
        $username = $adb->query_result($result, 0, 'username');
        $password = $adb->query_result($result, 0, 'password');

        $userdetails['username'] = $username;
        $userdetails['password'] = $password;

        return $userdetails;
    }

    /*
     * mapping Account (maybe add to standard config of module, cause also Amit needs those)
     * field must be in the mapping
     * and must be in the dataset of creditdevice
     */

    public function getMappingAccount()
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");

        $mapping = array_flip($mapping);
        return $mapping;
    }

    /*
     * mapping Account (maybe add to standard config of module, cause also Amit needs those)
     * field must be in the mapping
     * and must be in the dataset of creditdevice
     */
    public function getMappingLead()
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");


        $mapping = array_flip($mappinglead);
        return $mapping;
    }

    /*
     * Map the data of CrediDevice objects to standard object
     *
     * @param	object	in credidevice format
     * @return 	object	in standard format
     */
    public function standardizeCreditDeviceData($data)
    {

        $crm = new stdClass();

        // review
        $crm->review_turnover_code = $data->review->turnover_code;
        $crm->review_turnover_amount = VebCompanyData_Module_Model::turnoverCodeToTurnover($data->review->turnover_code);
        $crm->review_credit_flag = VebCompanyData_Module_Model::validateExistance($data->review->credit_flag); // only in extended!
        // insolventies
        $crm->insolvencies_is_insolvent = VebCompanyData_Module_Model::companyDataYesNo($data->insolvencies->is_insolvent);

        $crm->contact_info_name = $data->contact_info->name;
        $crm->contact_info_tradenames = implode(' | ', $data->contact_info->tradenames);
        // address, zipcode, city, country (iso2)
        $crm->contact_info_address_office_address = $data->contact_info->address_office->address;
        $crm->contact_info_address_office_zipcode = VebCompanyData_Module_Model::formatPostalcode($data->contact_info->address_office->country, $data->contact_info->address_office->zipcode);
        $crm->contact_info_address_office_city = VebCompanyData_Module_Model::formatCity($data->contact_info->address_office->city);
        $crm->contact_info_address_office_country = VebCompanyData_Module_Model::countryIso2ToFull($data->contact_info->address_office->country);

        $crm->contact_info_address_postal_address = $data->contact_info->address_postal->address;
        $crm->contact_info_address_postal_zipcode = VebCompanyData_Module_Model::formatPostalcode($data->contact_info->address_office->country, $data->contact_info->address_postal->zipcode);
        $crm->contact_info_address_postal_city = VebCompanyData_Module_Model::formatCity($data->contact_info->address_postal->city);
        $crm->contact_info_address_postal_country = VebCompanyData_Module_Model::countryIso2ToFull($data->contact_info->address_postal->country);

        // Plus package
        // previous_address_office
        // previous_address_postal

        $crm->contact_info_tel_number = VebCompanyData_Module_Model::formatPhone($data->contact_info->tel_number);
        $crm->contact_info_fax_number = VebCompanyData_Module_Model::formatPhone($data->contact_info->fax_number);
        $crm->contact_info_mob_number = VebCompanyData_Module_Model::formatPhone($data->contact_info->mob_number);

        $crm->contact_info_mail = VebCompanyData_Module_Model::formatEmail($data->contact_info->mail);
        $crm->contact_info_mail_extra = VebCompanyData_Module_Model::formatEmailExtra($data->contact_info->mail);

        $crm->contact_info_website = VebCompanyData_Module_Model::formatWebsite($data->contact_info->website);
        $crm->contact_info_website_extra  = VebCompanyData_Module_Model::formatWebsiteExtra($data->contact_info->website);

        $crm->contact_info_nmi = VebCompanyData_Module_Model::vebboolean($data->contact_info->nmi); // no mail indicator
        $crm->registration_reg_type = $data->registration->reg_type; // "KvK-nummer"
        $crm->registration_reg_number = $data->registration->reg_number;
        $crm->registration_branch_number = $data->registration->branch_number; // Vestigingsnummer
        //$crm->registration_vat_number = $data->registration->vat_number;
        $crm->registration_vat_number_eu = $data->registration->vat_number_eu; // BTW in EU formaat
        $crm->registration_legal_current = $data->registration->legal_current; // "Besloten Vennootschap"
        $crm->registration_active = VebCompanyData_Module_Model::companyDataYesNo($data->registration->active); // Yes|No|Unknown

        $crm->registration_dates_registration = VebCompanyData_Module_Model::companyDataFormatDate($data->registration->dates->registration);
        $crm->registration_dates_memorandum = VebCompanyData_Module_Model::companyDataFormatDate($data->registration->dates->memorandum);
        $crm->registration_dates_settlement = VebCompanyData_Module_Model::companyDataFormatDate($data->registration->dates->settlement);

        $crm->registration_creditdevice_id = $data->registration->creditdevice_id;

        // we do only the first for the moment, later maybe more
        $crm->activities_sbi_code = $data->activities->sbi[0]->code; // "8291"
        $crm->activities_sbi_text = $data->activities->sbi[0]->text; // "Kredietinformatie- en incassobureaus"
        // we add only the second for the moment if exists
        if (isset($data->activities->sbi[1])) {
            $crm->activities_sbi_code2 = $data->activities->sbi[1]->code; // "8291"
            $crm->activities_sbi_text2 = $data->activities->sbi[1]->text; // "Kredietinformatie- en incassobureaus"
        }

        $crm->activities_economically_active = VebCompanyData_Module_Model::companyDataYesNo($data->activities->economically_active); // Yes|No|Unknown

        $crm->management_first_manager = implode(", ", $data->management->first_manager); // array(initials, lastname, gender) hebben we hier iets aan?
        // take only last year for standard fields
        $crm->employees_year = $data->employees->items[0]->year;
        $crm->employees_total = $data->employees->items[0]->total;  // can be missing or different!
        $crm->employees_total_kvk = $data->employees->items[0]->total_kvk;

        // more years! (maybe show as textarea 2018: 12
        //    $crm->employees_txt = "Jr | Ttl | Kvk\n";
        $crm->employees_txt = '';
        foreach ($data->employees->items as $item)
        {
            $crm->employees_txt .= $item->year . ': ' . $item->total . ' (kvk: ' . $item->total_kvk . ")\n";
        }

        //Writing the data to a log
        $filename = __DIR__ . '/creditdevice-'.date("Y-m").'.log';
        $timestamp = date("Y-m-d H:m:i");
        file_put_contents($filename, "=========={$timestamp} crm:\n" . print_r($crm, true) . "\n\n", FILE_APPEND);

        return $crm;
    }

    /**
     * CreditDevice check if the element exists (needs improvement, ic looping)
     * is required to be able to deviateis several servicelevels
     * fro the moment only nl is required
     */
    public function validateExistance($object)
    {
        if (isset($object))
        {
            return $object;
        } else
        {
            return false;
        }
    }
    public function vebboolean($value)
    {
        if($value)
        return true;
        else
        return false;
    }

    /**
     * CreditDevice puts more websites in one field
     * www.vicus.nl | www.crm-dicteren.nl
     * we only get the first in the standard field
     */
    public function formatWebsite($website)
    {
        // remove http/https
        $clean = str_replace("https://", "", $website);
        $clean = str_replace("http://", "", $clean);

        $sites = explode(' | ', $clean);

        return $sites[0];
    }

    /**
     * CreditDevice puts more websites in one field
     * www.vicus.nl | www.crm-dicteren.nl
     * we remove the first and send the rest
     */
    public function formatWebsiteExtra($website)
    {
        // remove http/https
        $clean = str_replace("https://", "", $website);
        $clean = str_replace("http://", "", $clean);

        $sites = explode(' | ', $clean);
        unset($sites[0]);
        return implode(', ',$sites);
    }

    /**
     * CreditDevice puts more emailadresses in one field
     * wijkvananton@gmail.com | wilbertvanwijk@gmail.com
     * @return  string  only the first one
     */
    public function formatEmail($email)
    {
        $emails = explode(' | ', $email);
        return $emails[0];
    }

    /**
     * CreditDevice puts more emailadresses in one field
     * wijkvananton@gmail.com | wilbertvanwijk@gmail.com
     * @return  string  we remove the first and send the second
     */
    public function formatEmailExtra($email)
    {
        $emails = explode(' | ', $email);
        return $emails[1];
    }

    /**
     * CreditDevice country iso2 codes to Country
     * fro the moment only nl is required
     * @see https://inquiry.creditandcollection.nl/docs/report.html#report-description-turnovercode
     */
    public function countryIso2ToFull($code)
    {
        $code = strtolower($code);
        $countries = array(
            'nl' => 'Nederland',
        );

        if (isset($countries[$code]))
        {
            return $countries[$code];
        } else
        {
            return $code;
        }
    }

    /**
     * CreditDevice postalcodes to crm postalcodes
     *
     */
    public function formatPostalcode($countrycode = '', $postcode = '')
    {
        $clean = str_replace(" ", "", $postcode);
        $upper = strtoupper($clean);
        if (strtolower($countrycode) == 'nl')
        {
            $formatted = substr($upper, 0, 4) . ' ' . substr($upper, -2);
        } else
        {
            $formatted = $upper;
        }
        return $formatted;
    }

    /**
     * CreditDevice codes to revenue
     *
     * @see https://inquiry.creditandcollection.nl/docs/report.html#report-description-turnovercode
     */
    public function turnoverCodeToTurnover($code)
    {

        $revenues = array(
            1 => 0,
            2 => 50000,
            3 => 100000,
            4 => 200000,
            5 => 400000,
            6 => 1000000,
            7 => 2000000,
            8 => 5000000,
            9 => 10000000,
            10 => 20000000,
            11 => 50000000,
            12 => 100000000
        );

        if (isset($revenues[$code]))
        {
            return $revenues[$code];
        } else
        {
            return 0;
        }
    }

    /**
     * CreditDevice Boolean to Yes|No|Unknown
     *
     */
    public function companyDataYesNo($value)
    {
        //echo "<br>companyDataYesNo".$value;
        If ($value === true || $value == '1' || $value === 1)
        {
            return 'Yes' ;
            //return vtranslate('Yes', 'VebCompanyData');
        } elseif ($value === false || $value == '0' || $value == 0 || $value == '')
        {
            //return vtranslate('No', 'VebCompanyData');
            return 'No' ;
        } else
        {
            //return vtranslate('Unknown', 'VebCompanyData');
            //return vtranslate($value, 'VebCompanyData');
            return 'Unknown';
        }

    }

    /**
     * @todo format date according usersettings "2001-11-29"
     */
    public function companyDataFormatDate($date){
        // get user settings date format
        $userModel = Users_Record_Model::getCurrentUserModel();

        if($userModel->get('date_format') =='mm-dd-yyyy')
         $newDate = date("m-d-Y", strtotime($date));
         if($userModel->get('date_format') =='dd-mm-yyyy')
         $newDate = date("d-m-Y", strtotime($date));
         if($userModel->get('date_format') =='yyyy-mm-dd')
         $newDate = date("Y-m-d", strtotime($date));

        // convert to user format
        return $newDate;
    }

    /**
     * Format clean phone numbers without spaces and dashes
     */
    public function formatPhone($phone) {
        $phone = preg_replace("/[^0-9+]*/",'',$phone);
        return $phone;
    }

    /**
     * Format City - converts the first character of each word in a string to uppercase.
     */
    public function formatCity($city) {
        $city = strtolower($city);
        return ucwords($city);
    }

    public function Isfieldactive($module,$field)
    {
        global $log;
        $log->debug("Entering Isfieldactive() method....");
        if($module =='Leads')
        {
            $tabid = 7;
        }
        if($module =='Accounts')
        {
            $tabid = 6;
        }
        global $adb;
        $fieldlabel = "";
        $sql = "SELECT presence FROM vtiger_field WHERE tabid=? AND (columnname= ? OR fieldname= ?)";
        $result = $adb->pquery($sql, array($tabid, $field,$field));

        if ($adb->num_rows($result) > 0)
        {
            $presence = $adb->query_result($result, 0, 'presence');
            if($presence !=1)
            return true;
            else
            return false;
        }
        $fieldlabel = "";
        $log->debug("Exiting Isfieldactive() method....");
    }
    
	public function getModuleIcon() {
		$moduleName = $this->getName();
		$lowerModuleName = strtolower($moduleName);
		$title = vtranslate($moduleName, $moduleName);

		$moduleIcon = "<i class='vicon-$lowerModuleName' title='$title'></i>";
		if ($this->source == 'custom') {
			$moduleShortName = mb_substr(trim($title), 0, 2);
			$moduleIcon = "<i class='vicon-$lowerModuleName' title='$title'></i>";
		}

		$imageFilePath = 'layouts/'.Vtiger_Viewer::getLayoutName()."/modules/$moduleName/$moduleName.png";
		if (file_exists($imageFilePath)) {
			$moduleIcon = "<img src='$imageFilePath' title='$title' style='width: 35px;margin: -5px;'  />";
		}

		return $moduleIcon;
	}

}
