<?php

/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */
ini_set('display_errors', 'Off');
//error_reporting(E_ERROR);

class VebCompanyData_SearchVebCompanyData_Action extends Vtiger_Save_Action
{

    public function process(Vtiger_Request $request)
    {

        $mode = $request->get('mode');
        $this->$mode($request);
    }

    public function searchleadconfigfields()
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");
        $mappingarray['searchleads'] = $searchleads;
        echo json_encode(array_reverse($mappingarray));
    }

    public function searchaccountconfigfields()
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");
        $mappingarray['searchaccounts'] = $searchaccounts;
        echo json_encode(array_reverse($mappingarray));
    }

    public function LeadmappingTranslatefields(Vtiger_Request $request)
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");
        //api fields => vtigerfield
        $fieldMappinglbl = $vebfieldMappingarray;
        $fieldMapping = array();
       // $moduleModel = Vtiger_Module_Model::getInstance('Leads');

        foreach ($fieldMappinglbl as $key => $value)
        {

            //$fieldModel = Vtiger_Field_Model::getInstance($key, $moduleModel);
            $isactive = VebCompanyData_Module_Model::Isfieldactive('Leads',$key);


            if( $isactive )
            {
                $fieldMapping[$key]['value'] = $value;
                $fieldMapping[$key]['lable'] = VebCompanyData_Module_Model::getlablefield($key);
            }

            $fields_details[$key] = $value;
        }
        $companies = array();
        $mappingarray['companies'] = $companies;
        $mappingarray['fieldMapping'] = array_flip($fields_details);
        $mappingarray['fields_details'] = $fieldMapping; //$fields_details;
        $mappingarray['result'] = 'true';
        $mappingarray['count'] = count($mappingarray['fields_details']);

        echo json_encode(array_reverse($mappingarray));
    }

    public function Leadmappingfields(Vtiger_Request $request)
    {
        $mappingarray= VebCompanyData_SearchVebCompanyData_Action::LeadmappingfieldsAsArray($request);
        echo json_encode($mappingarray);
    }

    public function LeadmappingfieldsAsArray(Vtiger_Request $request)
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");
        //api fields => vtigerfield
        foreach ($vebfieldMappingarray as $key => $value)
        {
            $fieldMapping[$key] = $value;
        }
        $companies = array();
        $mappingarray['companies'] = $companies;
        $res = array_flip($fieldMapping);
        foreach ($res as $k => $v){

            $res[$k] = array_keys($fieldMapping, $k);
        }

        $mappingarray['fieldMapping'] = $res;
        // $mappingarray['fieldMapping'] = array_flip($fieldMapping);
        $mappingarray['company_details'] = $fieldMapping;
        $mappingarray['result'] = 'true';
        $mappingarray['count'] = count($fieldMapping);
        //count($mappingarray['fields']);
        return array_reverse($mappingarray);
    }

    public function AccountmappingTranslatefields(Vtiger_Request $request)
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");
        //api fields => vtigerfield
        $fieldMappinglbl = $vebfieldMapping_accounts_array;
        $fieldMapping = array();

        foreach ($fieldMappinglbl as $key => $value)
        {
            $isactive = VebCompanyData_Module_Model::Isfieldactive('Accounts',$key);
            if( $isactive )
            {
				$fieldMapping[$key]['value'] = $value;
	            $fieldMapping[$key]['lable'] = VebCompanyData_Module_Model::getlableaccountfield($key);
			}
            $fields_details[$key] = $value;
        }
        $companies = array();
        $mappingarray['companies'] = $companies;
        $mappingarray['fieldMapping'] = array_flip($fields_details);
        $mappingarray['fields_details'] = $fieldMapping; //$fields_details;
        $mappingarray['result'] = 'true';
        $mappingarray['count'] = count($mappingarray['fields_details']);
        echo json_encode(array_reverse($mappingarray));
    }

    public function Accountmappingfields(Vtiger_Request $request)
    {
        $mappingarray = VebCompanyData_SearchVebCompanyData_Action::AccountmappingfieldsAsArray($request);
        echo json_encode($mappingarray);
    }

    public function AccountmappingfieldsAsArray(Vtiger_Request $request)
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");
        //api fields => vtigerfield

        foreach ($vebfieldMapping_accounts_array as $key => $value)
        {
           $fieldMapping[$key] = $value;
        }
        $companies = array();
        $mappingarray['companies'] = $companies;
        $res = array_flip($fieldMapping);
        foreach ($res as $k => $v)
            $res[$k] = array_keys($fieldMapping, $k);
        $mappingarray['fieldMapping'] = $res; //array_flip($fieldMapping);
        $mappingarray['company_details'] = $fieldMapping;
        $mappingarray['result'] = 'true';
        $mappingarray['count'] = count($fieldMapping);

        return array_reverse($mappingarray);
    }

    public function getMappingAccount()
    {
        include("modules/VebCompanyData/VebCompanyData_config.php");

        $mapping = array_flip($mapping);
        echo json_encode($mapping);
    }

    public function getMappingLead()
    {

        include("modules/VebCompanyData/VebCompanyData_config.php");
        $mapping = array_flip($mappinglead);
        echo json_encode($mapping);
    }


    public function getformatteddata(Vtiger_Request $request)
    {
       $type   =  $request->get('field');
       $data    =  $request->get('value');
       if($type == 'country')
       {
        echo $formateddata = VebCompanyData_Module_Model::countryIso2ToFull($data);
       }

    }

    public function searchModule(Vtiger_Request $request)
    {
        $protocol = 'soap';
        $platform = 'webservices';
        $COC_Number = $request->get('COC_Number');
        $cname = $request->get('COMPANY_Name');
        $cityname = $request->get('CITY_name');

        $userdetails = VebCompanyData_Module_Model::getUserDetails();

        $baseurl = 'https://inquiry.creditandcollection.nl/api';
        $username = $userdetails['username'];
        $password = $userdetails['password'];
        $command = '/companies';

        ////////////////////////////////////
        $c = curl_init();
        curl_setopt($c, CURLOPT_HEADER, 0);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_USERPWD, $username . ":" . $password);
        curl_setopt($c, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($c, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($c, CURLOPT_HTTPHEADER, array('Connection: Keep-Alive', 'Keep-Alive: 60'));
        ////////////////////////////////
        // make type hinted function calls to any of the Webservices.nl API's

        if ($cname)
        {
            $params = 'name=' . $cname;
        }

        if ($cityname)
        {
            $params = 'city=' . $cityname;
        }
        if ($cityname != "" AND $cname != "")
        {
            $params = 'city=' . trim($cityname) . '&name=' . $cname;
        }

        if ($cityname != "" AND $COC_Number != "")
        {
            $params = 'city=' . $cityname . '&address=' . $cityname . '&reg_number=' . $COC_Number;
        }
        if ($cname != "" AND $COC_Number != "")
        {
            $params = 'name=' . $cname . '&reg_number=' . $COC_Number;
        }
        if ($COC_Number != "")
        {
            //$COC_Number = 32095093;
            $params = 'country=NL&reg_number=' . $COC_Number;
        }

        $cntr = 0;
        //$result = array();
        $result = array();
        $result['data'] = array();

        while ($cntr < 500) {

            ///////////////
            curl_setopt($c, CURLOPT_URL, $baseurl . $command . '?' . $params . '&page=' . $cntr);
            /////////////
            $result1 = curl_exec($c);
            $data = json_decode($result1);

            //Writing the data to a log
            $filename = '/home/cs1002/public_html/logs/creditdevice-'.date("Y-m").'.log';
            $timestamp = date("Y-m-d H:m:i");
            file_put_contents($filename, "=========={$timestamp} page {$cntr}:\n" . print_r($data, true) . "\n\n", FILE_APPEND);

            $result['data'] = array_merge($result['data'], $data->list); //echo count($result['data']);
            if ($data->meta->more_items === false)
            {
                $result['count'] = $cntr;
                if (count($result['data']) >= 1 && $cntr == 0)
                    $result['count'] = count($result['data']);
                $result['result'] = 'true';
                $result['sucess'] = 'true';
                break;
            }

            $cntr += 1;
        }

        $result = array_reverse($result);

        echo str_replace("'", "", json_encode($result));
        	//echo $res = '{"result":"true","count":5,"sucess":"true","data":[{"id":"yaPAyEcu1MxnuR71WNmhWw==","name":"Vicus Management & Advies B.V.","reg_number":"32095093","est_number":"000013521640","vat_number":null,"address":"Heideweg 3","zipcode":"3768BA","city":"Soest","country":"NL","additional":"Hoofdvestiging"},{"id":"S8Wlq9EaHmGNhSEi1cGkWw==","name":"Vicus eBusiness Solutions B.V.","reg_number":"32105890","est_number":"000018118267","vat_number":null,"address":"Vanadiumweg 22","zipcode":"3812PZ","city":"Amersfoort","country":"NL","additional":"Hoofdvestiging"},{"id":"+7ODHtUIJjrHh7xWGoj8kA==","name":"Vicus Fruit B.V.","reg_number":"62997793","est_number":"000024467901","vat_number":null,"address":"Beusichemseweg 134 a","zipcode":"3997ML","city":"t Goy","country":"NL","additional":"Hoofdvestiging"},{"id":"Eex\/yr00D3EILijhmbTjkg==","name":"Proles Vicus Beheer B.V.","reg_number":"08053729","est_number":"000017133076","vat_number":null,"address":"Rondweg 13","zipcode":"8091XA","city":"Wezep","country":"NL","additional":"Hoofdvestiging"},{"id":"X8bqH+0ZU1IovK0IJnt4Fw==","name":"Vicus Vastgoed B.V.","reg_number":"54434084","est_number":"000024199672","vat_number":null,"address":"Prinsenhoef 12","zipcode":"5032PL","city":"Tilburg","country":"NL","additional":"Hoofdvestiging"},{"id":"tSFWwP9RtBIvv\/O2\/go5TA==","name":"Vicus Maastricht B.V.","reg_number":"14616138","est_number":"000005665256","vat_number":null,"address":"Geleenstraat 10 A","zipcode":"6411HS","city":"Heerlen","country":"NL","additional":"Hoofdvestiging"},{"id":"T7dCRGuiCmfQqNlRC\/03Ig==","name":"Vicus Bomba B.V.","reg_number":"56713894","est_number":"000026234440","vat_number":null,"address":"Bovendijk 16","zipcode":"3648NM","city":"Wilnis","country":"NL","additional":"Hoofdvestiging"},{"id":"kz0e4eMfiLi7tqyAJxz7eQ==","name":"Vicus Beheer B.V.","reg_number":"24347250","est_number":"000004040465","vat_number":null,"address":"St. Helenabaai 813","zipcode":"2904AE","city":"Capelle aan den IJssel","country":"NL","additional":"Hoofdvestiging"},{"id":"6SKVIWxtJNdZZ1XzMoXrEw==","name":"Militus Vicus B.V.","reg_number":"20134472","est_number":"000017069467","vat_number":null,"address":"Krekelberg 118","zipcode":"4708KP","city":"Roosendaal","country":"NL","additional":"Hoofdvestiging"},{"id":"sG9LtYgvrTW59tIgjSfpbQ==","name":"Vicus Realty B.V.","reg_number":"34241658","est_number":"000020189850","vat_number":null,"address":"Hoogoorddreef 15","zipcode":"1101BA","city":"Amsterdam","country":"NL","additional":"Hoofdvestiging"},{"id":"yaPAyEcu1MxnuR71WNmhWw==","name":"Vicus Management & Advies B.V.","reg_number":"32095093","est_number":"000013521640","vat_number":null,"address":"Heideweg 3","zipcode":"3768BA","city":"Soest","country":"NL","additional":"Hoofdvestiging"},{"id":"S8Wlq9EaHmGNhSEi1cGkWw==","name":"Vicus eBusiness Solutions B.V.","reg_number":"32105890","est_number":"000018118267","vat_number":null,"address":"Vanadiumweg 22","zipcode":"3812PZ","city":"Amersfoort","country":"NL","additional":"Hoofdvestiging"},{"id":"+7ODHtUIJjrHh7xWGoj8kA==","name":"Vicus Fruit B.V.","reg_number":"62997793","est_number":"000024467901","vat_number":null,"address":"Beusichemseweg 134 a","zipcode":"3997ML","city":"t Goy","country":"NL","additional":"Hoofdvestiging"},{"id":"Eex\/yr00D3EILijhmbTjkg==","name":"Proles Vicus Beheer B.V.","reg_number":"08053729","est_number":"000017133076","vat_number":null,"address":"Rondweg 13","zipcode":"8091XA","city":"Wezep","country":"NL","additional":"Hoofdvestiging"},{"id":"X8bqH+0ZU1IovK0IJnt4Fw==","name":"Vicus Vastgoed B.V.","reg_number":"54434084","est_number":"000024199672","vat_number":null,"address":"Prinsenhoef 12","zipcode":"5032PL","city":"Tilburg","country":"NL","additional":"Hoofdvestiging"},{"id":"tSFWwP9RtBIvv\/O2\/go5TA==","name":"Vicus Maastricht B.V.","reg_number":"14616138","est_number":"000005665256","vat_number":null,"address":"Geleenstraat 10 A","zipcode":"6411HS","city":"Heerlen","country":"NL","additional":"Hoofdvestiging"},{"id":"T7dCRGuiCmfQqNlRC\/03Ig==","name":"Vicus Bomba B.V.","reg_number":"56713894","est_number":"000026234440","vat_number":null,"address":"Bovendijk 16","zipcode":"3648NM","city":"Wilnis","country":"NL","additional":"Hoofdvestiging"},{"id":"kz0e4eMfiLi7tqyAJxz7eQ==","name":"Vicus Beheer B.V.","reg_number":"24347250","est_number":"000004040465","vat_number":null,"address":"St. Helenabaai 813","zipcode":"2904AE","city":"Capelle aan den IJssel","country":"NL","additional":"Hoofdvestiging"},{"id":"6SKVIWxtJNdZZ1XzMoXrEw==","name":"Militus Vicus B.V.","reg_number":"20134472","est_number":"000017069467","vat_number":null,"address":"Krekelberg 118","zipcode":"4708KP","city":"Roosendaal","country":"NL","additional":"Hoofdvestiging"},{"id":"sG9LtYgvrTW59tIgjSfpbQ==","name":"Vicus Realty B.V.","reg_number":"34241658","est_number":"000020189850","vat_number":null,"address":"Hoogoorddreef 15","zipcode":"1101BA","city":"Amsterdam","country":"NL","additional":"Hoofdvestiging"},{"id":"oMQ9ImIKElOJHDNQfXtYcw==","name":"Vicus Servisons","reg_number":"67591817","est_number":"000036116580","vat_number":null,"address":"Hoekwantweg 4","zipcode":"8256PS","city":"Biddinghuizen","country":"NL","additional":"Hoofdvestiging"},{"id":"TjFjcNravEr3sm2GTBRiSQ==","name":"Vicus Novus B.V.","reg_number":"51018594","est_number":"000021113025","vat_number":null,"address":"t Zand 52","zipcode":"3454PB","city":"De Meern","country":"NL","additional":"Hoofdvestiging"},{"id":"fKg+9Pl4kaaNnjfDFaxkeA==","name":"Vicus B.V.","reg_number":"39067439","est_number":"000002598221","vat_number":null,"address":"Wildbaan 2","zipcode":"8222AG","city":"Lelystad","country":"NL","additional":"Hoofdvestiging"},{"id":"4TycwPGWb31ePI059DQ0UA==","name":"Vicus Antiek","reg_number":"17158638","est_number":"000012675008","vat_number":null,"address":"De Steenzager 25","zipcode":"5506GE","city":"Veldhoven","country":"NL","additional":"Hoofdvestiging"},{"id":"EaeQIpNtTLc09Ek7p1bP6A==","name":"Vicus Zorg","reg_number":"56043732","est_number":"000025637568","vat_number":null,"address":"Beltmolenstraat 5","zipcode":"6088CA","city":"Roggel","country":"NL","additional":"Hoofdvestiging"},{"id":"yaPAyEcu1MxnuR71WNmhWw==","name":"Vicus Management & Advies B.V.","reg_number":"32095093","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"+7ODHtUIJjrHh7xWGoj8kA==","name":"Vicus Fruit B.V.","reg_number":"62997793","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"Eex\/yr00D3EILijhmbTjkg==","name":"Proles Vicus Beheer B.V.","reg_number":"08053729","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"X8bqH+0ZU1IovK0IJnt4Fw==","name":"Vicus Vastgoed B.V.","reg_number":"54434084","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"tSFWwP9RtBIvv\/O2\/go5TA==","name":"Vicus Maastricht B.V.","reg_number":"14616138","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"T7dCRGuiCmfQqNlRC\/03Ig==","name":"Vicus Bomba B.V.","reg_number":"56713894","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"kz0e4eMfiLi7tqyAJxz7eQ==","name":"Vicus Beheer B.V.","reg_number":"24347250","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"S8Wlq9EaHmGNhSEi1cGkWw==","name":"Vicus eBusiness Solutions B.V.","reg_number":"32105890","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"6SKVIWxtJNdZZ1XzMoXrEw==","name":"Militus Vicus B.V.","reg_number":"20134472","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"sG9LtYgvrTW59tIgjSfpbQ==","name":"Vicus Realty B.V.","reg_number":"34241658","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"fKg+9Pl4kaaNnjfDFaxkeA==","name":"Vicus B.V.","reg_number":"39067439","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"TjFjcNravEr3sm2GTBRiSQ==","name":"Vicus Novus B.V.","reg_number":"51018594","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"cCSGFrPaT28O1tnVfdSGWg==","name":"Vereniging van eigenaars woningen gebouw Tulipa Vicus te Oegstgeest","reg_number":"53153022","est_number":null,"vat_number":null,"address":"Lageweg 37 G 1","zipcode":"2222AG","city":"Katwijk","country":"NL","additional":"Rechtspersoon"},{"id":"jEBAdp34PRoFFRaqunUecw==","name":"G.J. Telematics Consultants B.V.","reg_number":"23086679","est_number":"000012698237","vat_number":null,"address":"Binnendams 68","zipcode":"3373AE","city":"Hardinxveld-Giessendam","country":"NL","additional":"Hoofdvestiging"},{"id":"aI3RHl7BEw7Pho\/jH3uDSQ==","name":"Vereniging van Eigenaars van gebouw Hortus Vicus","reg_number":"50580477","est_number":null,"vat_number":null,"address":"Zwaanshof 7","zipcode":"2665CX","city":"Bleiswijk","country":"NL","additional":"Rechtspersoon"},{"id":"Eavwh4RGWGKH4IHwRUjB6A==","name":"Kopersvereniging Aqua Vicus","reg_number":"28098706","est_number":null,"vat_number":null,"address":"Warande 89","zipcode":"2404HT","city":"Alphen aan den Rijn","country":"NL","additional":"Rechtspersoon"},{"id":"WC4eJ6VWI+LEKF+i2x8Knw==","name":"Promenad Invest B.V.","reg_number":"34259817","est_number":"000008479720","vat_number":null,"address":"Hoogoorddreef 15","zipcode":"1101BA","city":"Amsterdam","country":"NL","additional":"Hoofdvestiging"},{"id":"nIPp9TG5LQyiM3cjHQD4mA==","name":"Peniri B.V.","reg_number":"17191918","est_number":"000016343670","vat_number":null,"address":"Kastelenplein 168 F","zipcode":"5653LX","city":"Eindhoven","country":"NL","additional":"Hoofdvestiging"},{"id":"r4af27Teh1jgYAM5ikEKkw==","name":"Praedium Investment Management & Consultancy B.V.","reg_number":"09146910","est_number":"000012085901","vat_number":null,"address":"Veenweg 18","zipcode":"7051GR","city":"Varsseveld","country":"NL","additional":"Hoofdvestiging"},{"id":"cCSGFrPaT29XDKG3+KzeTw==","name":"Vereniging van eigenaars gebouwen Tulipa Hortus\/Vicus\/Alallegro te Oegstgeest","reg_number":"53152328","est_number":null,"vat_number":null,"address":"Lageweg 37 G 1","zipcode":"2222AG","city":"Katwijk","country":"NL","additional":"Rechtspersoon"},{"id":"b+bGkF2amuwNjB+T+CD0\/A==","name":"Vereniging van Eigenaars Parkappartementen Aqua Vicus","reg_number":"27368646","est_number":null,"vat_number":null,"address":"Warande 57","zipcode":"2404HS","city":"Alphen aan den Rijn","country":"NL","additional":"Rechtspersoon"},{"id":"WC4eJ6VWI+LEKF+i2x8Knw==","name":"Promenad Invest B.V.","reg_number":"34259817","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"r4af27Teh1jgYAM5ikEKkw==","name":"Praedium Investment Management & Consultancy B.V.","reg_number":"09146910","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"WC4eJ6VWI+LMXUzVCrvVvw==","name":"Vicus Realty Delta B.V.","reg_number":"34252884","est_number":"000016349660","vat_number":null,"address":"Prins Bernhardplein 200","zipcode":"1097JB","city":"Amsterdam","country":"NL","additional":"Hoofdvestiging"},{"id":"MtYeMpaqr+6QYTS2wR4X5Q==","name":"Vicus Leidschendam B.V.","reg_number":"27163263","est_number":"000016856244","vat_number":null,"address":"Rietvinklaan 1","zipcode":"2265CC","city":"Leidschendam","country":"NL","additional":"Hoofdvestiging"},{"id":"sG9LtYgvrTXRpzSzFGc+Vw==","name":"Vicus Realty Alpha B.V.","reg_number":"34241661","est_number":"000016239687","vat_number":null,"address":"Hoogoorddreef 15","zipcode":"1101BA","city":"Amsterdam","country":"NL","additional":"Hoofdvestiging"},{"id":"LhBB3mGh7R39G5H9RAosTQ==","name":"Vicus Fruit","reg_number":"54735696","est_number":"000024467901","vat_number":null,"address":"Beusichemseweg 134 a","zipcode":"3997ML","city":"t Goy","country":"NL","additional":"Hoofdvestiging"},{"id":"WC4eJ6VWI+LMXUzVCrvVvw==","name":"Vicus Realty Delta B.V.","reg_number":"34252884","est_number":null,"vat_number":null,"address":"Claude Debussylaan 24","zipcode":"1082MD","city":"Amsterdam","country":"NL","additional":"Rechtspersoon"},{"id":"sG9LtYgvrTXRpzSzFGc+Vw==","name":"Vicus Realty Alpha B.V.","reg_number":"34241661","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"MtYeMpaqr+7ja95c+dgusQ==","name":"Roos, van Vliet & Van Vliet II B.V.","reg_number":"27163263","est_number":null,"vat_number":null,"address":"Herenstraat 12 A","zipcode":"2291BG","city":"Wateringen","country":"NL","additional":"Nevenvestiging"},{"id":"MtYeMpaqr+6QYTS2wR4X5Q==","name":"Vicus Leidschendam B.V.","reg_number":"27163263","est_number":null,"vat_number":null,"address":null,"zipcode":null,"city":null,"country":"NL","additional":"Rechtspersoon"},{"id":"kz0e4eMfiLjb7j94qjZElQ==","name":"Stichting Vicus","reg_number":"24340075","est_number":null,"vat_number":null,"address":"Postbus 80504","zipcode":"2508GM","city":"s-Gravenhage","country":"NL","additional":"Rechtspersoon"},{"id":"AUyEN06mHG1XJc4f0eIyDA==","name":"Stichting Wiedus","reg_number":"24312559","est_number":null,"vat_number":null,"address":"Postbus 80504","zipcode":"2508GM","city":"s-Gravenhage","country":"NL","additional":"Rechtspersoon"},{"id":"j1BGxGxH1U3z\/chUH7Fv\/w==","name":"Devicay","reg_number":"63888467","est_number":"000032760329","vat_number":null,"address":"Kalvermarkt 11","zipcode":"2312LL","city":"Leiden","country":"NL","additional":"Hoofdvestiging"}]}';
        //parent::process($request);
    }

    public function inquireModule(Vtiger_Request $request)
    {

        $standardizeCreditDeviceData = VebCompanyData_SearchVebCompanyData_Action::inquireModuleAsArray($request);
        echo json_encode($standardizeCreditDeviceData);
    }

    public function inquireModuleAsArray(Vtiger_Request $request)
    {

        $protocol = 'soap';
        $platform = 'webservices';
        $id = $request->get('COC_Number');
        $country = $request->get('country');
        $reg_number = $request->get('reg_number');
        // disabled // $product	=	'D44CI701';//$request->get('COMPANY_Name');

        $userdetails = VebCompanyData_Module_Model::getUserDetails();

        $baseurl = 'https://inquiry.creditandcollection.nl/api';
        $username = $userdetails['username'];
        $password = $userdetails['password'];
        $command = '/instants';

        $paramsaary['reg_number'] = $reg_number;
        $paramsaary['short'] = true;
        ////////////////////////////////////
        $c = curl_init();
        curl_setopt($c, CURLOPT_HEADER, 0);
        curl_setopt($c, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($c, CURLOPT_USERPWD, $username . ":" . $password);
        curl_setopt($c, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($c, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($c, CURLOPT_POST, 1);
        curl_setopt($c, CURLOPT_POSTFIELDS, json_encode($paramsaary));
        $header = array('Content-Type: application/json');
        curl_setopt($c, CURLOPT_HTTPHEADER, $header);
        $paramsaary = array();

        $cntr = 0;
        $result = array();
        $result['data'] = array();

        curl_setopt($c, CURLOPT_URL, $baseurl . $command);
        /////////////
        $result1 = curl_exec($c);

        // log
        $filename = '/home/cs1002/public_html/logs/creditdevice-'.date("Y-m").'.log';
        $timestamp = date("Y-m-d H:m:i");

        if($result1 === false)
        {
            file_put_contents($filename, "=========={$timestamp}: {$command} Curl error:\n" . curl_error($c) . "\n\n", FILE_APPEND);
        }
        else {
            $data = json_decode($result1);
            
            file_put_contents($filename, "=========={$timestamp}: {$command} result1\n" . print_r($result1, true) . "\n\n". print_r(curl_getinfo ($c), true) . "\n\n", FILE_APPEND);
            file_put_contents($filename, "=========={$timestamp}: {$command} data\n" . print_r($data, true) . "\n\n", FILE_APPEND);
        }
        
        

        // $res =$result1;
        //$res = ' {"review":{"turnover_code":6},"insolvencies":{"is_insolvent":false},"contact_info":{"name":"Vicus Fruit B.V.","tradenames":["Vicus Fruit B.V."],"address_office":{"address":"Beusichemseweg 134 A","street":"Beusichemseweg","house_number":"134","house_number_suffix":"A","zipcode":"3997ML","city":"T GOY","country":"NL"},"address_postal":{"address":"Beusichemseweg 134 A","street":"Beusichemseweg","house_number":"134","house_number_suffix":"A","zipcode":"3997ML","city":"T GOY","country":"NL"},"tel_number":"030-6012676","mail":"wijkvananton@gmail.com | wilbertvanwijk@gmail.com","nmi":true},"registration":{"reg_type":"KvK-nummer","reg_number":"62997793","branch_number":"000024467901","vat_number":"855047094","vat_number_eu":"NL855047094B01","legal_current":"Besloten vennootschap met gewone structuur","active":true,"dates":{"registration":"2015-03-26","memorandum":"2015-03-26","settlement":"2012-02-23","legal_since":"2015-03-26"},"creditdevice_id":"OV6l8gqwB63L"},"activities":{"sbi":[{"code":"46311","text":"Groothandel in groenten en fruit"}],"economically_active":true},"management":{"first_manager":{"initials":"A.W.J.","lastname":"van Wijk","gender":"MALE"}},"employees":{"items":[{"year":"2017","total":2},{"year":"2016","total":3},{"year":"2015","total_kvk":3},{"year":"2014","total_kvk":0}]}}';
		//$data = json_decode(strtolower($res));

		$standardizeCreditDeviceData = VebCompanyData_Module_Model::standardizeCreditDeviceData($data);

        return $standardizeCreditDeviceData;
    }

    public function getPermission()
    {
        $moduleModel = Vtiger_Module_Model::getInstance('VebCompanyData');
        $userPrivilegesModel = Users_Privileges_Model::getCurrentUserPrivilegesModel();

        $userPrivilegesModel->isAdminUser();
        $profileTabsPermissions[$moduleModel->getId()];
        if ($userPrivilegesModel->isAdminUser())
        {
            echo 'allowed';
            return;
        }


        if ($profileTabsPermissions[$moduleModel->getId()])
        {
            echo 'allowed';
            return;
        } else
        {
            echo 'not allowed';
            return;
        }
    }

}
