/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

Vtiger_Edit_Js('VebCompanyDataaccounts_ExtensionStore_Js', {}, {
    /**
     * Function to register events for banner
     */
    registerEventsForBanner: function () {
        var bxTarget = jQuery('.bxslider');
        var items = jQuery('li', bxTarget);
        if (items.length) {
            bxTarget.bxSlider({
                mode: 'fade',
                auto: true,
                pager: items.length > 1,
                speed: items.length > 1 ? 1500 : 0,
                pause: 3000
            });
        }
    },
    /**
     * Function to getPromotions from marketplace
     */
    getPromotions: function () {
        var thisInstance = this;
        var params = {
            'module': 'ExtensionStore',
            'view': 'Listings',
            'mode': 'getPromotions'
        };
        app.request.post({data: params}).then(
                function (err, data) {
                    if ((typeof data != 'undefined') && (jQuery(data).find('img').length > 0)) {
                        jQuery('.dashboardBanner').append(data);
                        thisInstance.registerEventsForBanner();
                    } else {
                        jQuery('.togglePromotion').addClass('hide');
                    }
                },
                function (error) {
                }
        );
    },

    /**
     * Function to request get promotions from market place based on promotion closed date
     */
    getPromotionsFromMarketPlace: function (promotionClosedDate) {
        var thisInstance = this;
        if (promotionClosedDate != null) {
            var maxPromotionParams = {
                'module': 'ExtensionStore',
                'action': 'Promotion',
                'mode': 'maxCreatedOn'
            };
            app.request.post({data: maxPromotionParams}).then(
                    function (err, data) {
                        var date = data['result'];
                        var dateObj = new Date(date);
                        var closedDate = new Date(promotionClosedDate);
                        var dateDiff = ((dateObj.getTime()) - (closedDate.getTime())) / (1000 * 60 * 60 * 24);
                        if (dateDiff > 0) {
                            thisInstance.getPromotions();
                        } else {
                            jQuery('.togglePromotion').addClass('hide');
                        }
                    });
        } else if (promotionClosedDate == null) {
            thisInstance.getPromotions();
        }
    },
    popupPageContentsContainer: false,

    getPopupPageContainer: function () {
        if (this.popupPageContentsContainer == false) {
            this.popupPageContentsContainer = jQuery('#popupPageContainer');
        }
        return this.popupPageContentsContainer;

    },
    openPopUpweb: function (e) {
        var thisInstance = this;
        var parentElem = jQuery(e.target).closest('td');
        var params = this.getPopUpParams(parentElem);
        params.module = 'Accounts';
        params.view = 'VebCompanyDataPopAccountView';
        var isMultiple = false;
        if (params.multi_select) {
            isMultiple = true;
        }

        var sourceFieldElement = jQuery('input[class="sourceField"]', parentElem);

        var prePopupOpenEvent = jQuery.Event(Vtiger_Edit_Js.preReferencePopUpOpenEvent);
        sourceFieldElement.trigger(prePopupOpenEvent);

        if (prePopupOpenEvent.isDefaultPrevented()) {
            return;
        }
        var popupInstance = Vtiger_Popup_Js.getInstance();
        popupInstance.show(params, function (data) {
            var responseData = JSON.parse(data);
            var dataList = new Array();
            for (var id in responseData) {
                var data = {
                    'name': responseData[id].name,
                    'id': id
                }
                dataList.push(data);
                if (!isMultiple) {
                    thisInstance.setReferenceFieldValue(parentElem, data);
                }
            }
            if (isMultiple) {
                sourceFieldElement.trigger(Vtiger_Edit_Js.refrenceMultiSelectionEvent, {'data': dataList});
            }
            sourceFieldElement.trigger(Vtiger_Edit_Js.postReferenceSelectionEvent, {'data': responseData});
        });
    },

    registerEventsForOpenEditPopup: function (e) {
        var thisInstance = this;
        thisInstance.openPopUpweb(e);
        app.helper.showProgress();
        
        //CITY_name
    },
    registerEventsForTogglePromotion: function (container) {
        var thisInstance = this;
        jQuery('.VebCompanyData').on('click', function (e) {
                thisInstance.openPopUpweb(e);
                app.helper.showProgress();
            
        });
    },

    insertTogglePromotionHtml: function () {
        var vebHtml = '<div id="vebdiv" style="display:block;"></div><button type="button" class="btn btn-success saveButton VebCompanyData">Company Data</button>&nbsp;&nbsp;&nbsp;&nbsp;';
        var params = {};
        
        app.helper.showProgress();
        params['module'] = "VebCompanyData";
        params['parent'] = "";
        params['action'] = 'SearchVebCompanyData';
        params['mode'] = 'getPermission';
        jQuery(vebHtml).insertBefore(".btn-success");
        app.request.post({'data': params}).then(
                function (err, data) {
                    
                    app.helper.hideProgress();
                    //alert(data)
                    if(data != 'allowed')
                    {   
                       jQuery('.VebCompanyData').addClass("hide");
                    }
                });
                
       
       
       
       
       // jQuery(vebHtml).insertBefore(".btn-success");
    },
    insertEditPageHtml: function () {
        var url_string = window.location.href; // www.test.com?filename=test
        var url = new URL(url_string);
        var recordid = url.searchParams.get("record");

        var vebHtml = '<button class="btn btn-default" id="Accounts_detailView_basicAction_LBL_COMPANY_DATA" onclick="window.location.href =&quot;index.php?module=Accounts&amp;view=Edit&amp;record=' + recordid + '&amp;app=MARKETING&amp;mode=companydatapopup&quot;;">Company Data</button>';
        var params = {};
        app.helper.showProgress();
        params['module'] = "VebCompanyData";
        params['parent'] = "";
        params['action'] = 'SearchVebCompanyData';
        params['mode'] = 'getPermission';
        app.request.post({'data': params}).then(
                function (err, data) {
                  
                    app.helper.hideProgress();
                    if(data == 'allowed')
                    {
                        jQuery(vebHtml).insertAfter("#Accounts_detailView_basicAction_LBL_EDIT");
                    }
                });
       
        
    },

    editViewContainer: false,
    formValidatorInstance: false,
    getEditViewContainer: function () {
        if (this.editViewContainer === false) {
            this.editViewContainer = jQuery('.editViewPageDiv');
        }
        return this.editViewContainer;
    },
    setEditViewContainer: function (container) {
        this.editViewContainer = container;
    },

    formElement: false,
    getForm: function () {
        if (this.formElement === false) {
            this.formElement = jQuery('#EditView');
        }
        return this.formElement;
    },
    _moduleName: false,
    getModuleName: function () {
        if (this._moduleName != false) {
            return this._moduleName;
        }
        return app.module();
    },
    setModuleName: function (module) {
        this._moduleName = module;
        return this;
    },
    referenceModulePopupRegisterEvent: function (container) {
        var thisInstance = this;
        container.off('click', '.relatedPopup');
        container.on("click", '.relatedPopup', function (e) {
            thisInstance.openPopUp(e);
        });
        container.on('change', '.referenceModulesList', function (e) {
            var element = jQuery(e.currentTarget);
            var closestTD = thisInstance.getParentElement(element).next();
            var popupReferenceModule = element.val();
            var referenceModuleElement = jQuery('input[name="popupReferenceModule"]', closestTD).length ?
                    jQuery('input[name="popupReferenceModule"]', closestTD) : jQuery('input.popupReferenceModule', closestTD);
            var prevSelectedReferenceModule = referenceModuleElement.val();
            referenceModuleElement.val(popupReferenceModule);

            //If Reference module is changed then we should clear the previous value
            if (prevSelectedReferenceModule != popupReferenceModule) {
                closestTD.find('.clearReferenceSelection').trigger('click');
            }
        });
    },

    registerPostReferenceEvent: function (container) {
        var thisInstance = this;

        container.find('.sourceField').on(Vtiger_Edit_Js.postReferenceSelectionEvent, function (e, result) {
            var dataList = result.data;
            var element = jQuery(e.currentTarget);

            if (typeof element.data('autofill') != 'undefined') {
                thisInstance.autoFillElement = element;
                if (typeof (dataList.id) == 'undefined') {
                    thisInstance.postRefrenceComplete(dataList, container);
                } else {
                    thisInstance.postRefrenceSearch(dataList, container);
                }
            }
        });
    },

    registerEvents: function () {

        var thisInstance = this;
        var moduleName = app.getModuleName();
        var moduleView = app.view();
        if (moduleName == 'Accounts' && moduleView == 'Edit') {
 			 thisInstance.insertTogglePromotionHtml();
			 this.referenceModulePopupRegisterEvent(this.getForm());
            //	this.referenceModulePopupRegisterEvent(form);
            this.registerPostReferenceEvent(this.getEditViewContainer());
            thisInstance.registerEventsForTogglePromotion(this.getForm());
            var url_string = window.location.href; // www.test.com?filename=test
            var url = new URL(url_string);
            var mode = url.searchParams.get("mode");               
            if (mode == 'companydatapopup')
            {
                this.registerEventsForOpenEditPopup(this.getEditViewContainer());
            }
            //jQuery('.VebCompanyData').trigger('click');
        }

        if (moduleName == 'Accounts' && moduleView == 'Detail') {
            thisInstance.insertEditPageHtml();
        }
    }
});

jQuery(document).ready(function () {
    var moduleName = app.getModuleName();
    var moduleView = app.view();
   
    if (moduleName == 'Accounts' && moduleView == 'Detail') {
        var instance = new VebCompanyDataaccounts_ExtensionStore_Js();
        instance.registerEvents();
    }

    if (moduleName == 'Accounts' && moduleView == 'Edit') {
        var instance = new VebCompanyDataaccounts_ExtensionStore_Js();
        instance.registerEvents();
        
    }
    //jQuery('.VebCompanyData').trigger('click');
   
});
