<?php
/* * **********************************************************************************************
 * * The contents of this file are subject to the Vtiger SalesFunnel Module License Version 1.0
 * ( "License" ); You may not use this file except in compliance with the License
 * The Original Code is:  Technokrafts Labs Pvt Ltd
 * The Initial Developer of the Original Code is Technokrafts Labs Pvt Ltd.
 * Portions created by Technokrafts Labs Pvt Ltd are Copyright ( C ) Technokrafts Labs Pvt Ltd.
 * All Rights Reserved.
 * *
 * ********************************************************************************************** */

/**
 * SalesFunnel class extending the Core class
 */
class VebCompanyData extends CRMEntity
{
    function vtlib_handler($moduleName, $eventType){
        global $adb;
        if ($eventType == 'module.postinstall')
        {
            // TODO Handle actions after this module is installed.
            $this->updateheaderscript();
        } else if ($eventType == 'module.disabled')
        {
            $this->deleteheaderscript();
            // TODO Handle actions before this module is being enabled.
        } else if ($eventType == 'module.enabled')
        {
            $this->updateheaderscript();
            // TODO Handle actions before this module is being uninstalled.
        } else if ($eventType == 'module.preuninstall')
        {
            // TODO Handle actions when this module is about to be deleted.
        } else if ($eventType == 'module.preupdate')
        {
            $this->updateheaderscript();
            // TODO Handle actions before this module is updated.
        } else if ($eventType == 'module.postupdate')
        {
            // TODO Handle actions after this module is updated.
            //$this->setAppMenu($moduleName);
            //$this->updateheaderscript();
           // $this->checkWebServiceEntry();
        }
    }

    public function getdefaulturl()
    {
        return 'index.php?module=' . $this->get('name') . '&view=Edit';
    }

    function setAppMenu($moduleName)
    {
        global $adb,$log;

        $log->debug("Entering setAppMenu() method....");

        $tab_sql = "SELECT tabid FROM vtiger_tab WHERE name = '$moduleName'";
        $tab_res = $adb->pquery($tab_sql, array());
        $tabid = $adb->query_result($tab_res, 0, 'tabid');
        unset($tab_res);
        $check_entry = $adb->pquery("SELECT * FROM vtiger_app2tab WHERE  tabid = ? ", array($tabid));
        if ($adb->num_rows($check_entry) > 0)
        {
            $del_sql = "DELETE FROM vtiger_app2tab WHERE tabid=?";
            $del_res = $adb->pquery($del_sql, array($tabid));
        }
        unset($del_res);
        $log->debug("Entering setAppMenu() method....");
        return 1;
    }

    /**
     * Function to check if entry exsist in webservices if not then enter the entry
     */
    function updateheaderscript()
    {
        global $log;
        $log->debug("Entering updateheaderscript() method....");
        global $adb;

        $sql = "SELECT max(linkid)+1 AS cnt FROM vtiger_links";
        $result = $adb->query($sql);

        $sql1 = "SELECT linklabel FROM vtiger_links WHERE tabid =7 AND linklabel ='VebCompanyDataCommonHeaderScript'";
        $result1 = $adb->query($sql1);
        if ($adb->num_rows($result1) == 0)
        {
            if ($adb->num_rows($result) > 0)
            {
                $no = $adb->query_result($result, 0, 'cnt');
                if ($no != 0)
                {
                    //$tabid = $adb->getUniqueID("vtiger_ws_entity");
                    $ws_entitySql = "INSERT INTO vtiger_links (linkid ,tabid ,linktype,linklabel,linkurl,linkicon,sequence,handler_path ,handler_class,handler,parent_link) VALUES (?,7, 'HEADERSCRIPT', 'VebCompanyDataCommonHeaderScript', 'modules/VebCompanyData/VebCompanyData.js', '', '0', NULL , NULL , NULL , NULL);";
                    $res = $adb->pquery($ws_entitySql, array($no));
                    $adb->pquery('update vtiger_links_seq set id=?', array($no));
                    $log->debug("Entered Record in vtiger_links ");
                }
            }
        }
        $sqla = "SELECT max(linkid)+1 AS cnt FROM vtiger_links";
        $resulta = $adb->query($sqla);

        $sql1a = "SELECT linklabel FROM vtiger_links WHERE tabid =6 AND linklabel ='VebCompanyDataCommonHeaderScript'";
        $result1a = $adb->query($sql1a);
        if ($adb->num_rows($result1a) == 0)
        {
            if ($adb->num_rows($resulta) > 0)
            {
                $no = $adb->query_result($resulta, 0, 'cnt');
                if ($no != 0)
                {
                    //$tabid = $adb->getUniqueID("vtiger_ws_entity");
                    $ws_entitySqlacc = "INSERT INTO vtiger_links (linkid ,tabid ,linktype,linklabel,linkurl,linkicon,sequence,handler_path ,handler_class,handler,parent_link) VALUES (?,6, 'HEADERSCRIPT', 'VebCompanyDataCommonHeaderScript', 'modules/VebCompanyData/VebCompanyDataaccounts.js', '', '0', NULL , NULL , NULL , NULL);";
                    $resacc = $adb->pquery($ws_entitySqlacc, array(++$no));
                    $adb->pquery('update vtiger_links_seq set id=?', array($no));
                    $log->debug("Entered Record in vtiger_links ");
                }
            }
        }
        $log->debug("Exiting updateheaderscript() method....");
        $moduleName = 'VebCompanyData';
        $this->setAppMenu($moduleName);
    }

    function deleteheaderscript()
    {
        global $log;
        $log->debug("Entering deleteheaderscript() method....");
        global $adb;

        $sql = "SELECT max(linkid) AS cnt FROM vtiger_links";
        $result = $adb->query($sql);
        if ($adb->num_rows($result) > 0)
        {
            $no = $adb->query_result($result, 0, 'cnt');
            if ($no != 0)
            {
                //$tabid = $adb->getUniqueID("vtiger_ws_entity");
                $ws_entitySql = "DELETE FROM vtiger_links WHERE (tabid =7 OR tabid =6)  AND linklabel='VebCompanyDataCommonHeaderScript';";
                $res = $adb->pquery($ws_entitySql, array());

                $adb->pquery('update vtiger_links_seq set id=?', array(--$no));
                $log->debug("Entered Record in vtiger WS entity ");
            }
        }
        $log->debug("Exiting deleteheaderscript() method....");
    }



}
?>