<?php

/**
 * VGS Visual Pipeline Module
 *
 *
 * @package        VGSVisualPipeline Module
 * @author         Curto Francisco - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

//include_once 'modules/VGSVisualPipeline/models/VGSLicenseManager.php';

class VGSVisualPipeline_VGSSaveVP_Action extends Vtiger_Action_Controller {

    public function checkPermission(Vtiger_Request $request) {
        global $current_user;

/*
        if (!isLicenseValid($request->getModule())) {
            throw new Exception("VGSVisualPipeline Module License not activated", 1);
        }   
*/
       return true; //We use WS to updated, if user not allow is validated them
    }

    public function process(Vtiger_Request $request) {
        global $current_user;

        include_once 'include/Webservices/Create.php';
        include_once 'include/Webservices/Revise.php';
        include_once 'include/Webservices/Delete.php';

        $id = $request->get('id');
        $modulo = $request->get('modulo');
        $columna = $request->get('columna');
        $valor = $request->get('valor');
        $sorting = $request->get('sort_order');

        if (in_array($modulo, array('Quotes', 'SalesOrder', 'Invoice', 'PurchaseOrder'))) {
            $this->updateInventoryModule($modulo,$columna,$valor,$id);
            $this->saveSorting($modulo, $sorting);
        } else {
            try {

                $visualPipeline = array(
                    'id' => vtws_getWebserviceEntityId($modulo, $id),
                    $columna => $valor,
                );

                vtws_revise($visualPipeline, $current_user);

                $this->saveSorting($modulo, $sorting);
                $response = new Vtiger_Response();
                $response->setResult('ok');
                $response->emit();
            } catch (Exception $exc) {
                echo $exc->getTraceAsString();
                $response = new Vtiger_Response();
                $response->setResult('error');
                $response->emit();
            }
        }
    }

    function saveSorting($moduleName, $sorting) {
        $db = PearDatabase::getInstance();

        $db->pquery("DELETE FROM vtiger_vgsvisualsorting WHERE module=?", array($moduleName));
        $db->pquery("INSERT INTO vtiger_vgsvisualsorting (module,sorting) VALUES (?,?)", array($moduleName, serialize($sorting)));
    }

    function updateInventoryModule($targetModule, $targetFieldName, $targetFieldValue, $targetRecordId) {
        //If the current user has Editview access to the record go ahead. Otherwise do not update
        if(isPermitted($targetModule,'EditView',$targetRecordId)){
            $db = PearDatabase::getInstance();
            $moduleInstance = Vtiger_Module_Model::getInstance($targetModule);
            $fieldInstance = Vtiger_Field_Model::getInstance($targetFieldName, $moduleInstance);

            $sql = "UPDATE $fieldInstance->table SET $fieldInstance->column = ? WHERE $moduleInstance->basetableid = ?";
            $db->pquery($sql, array($targetFieldValue, $targetRecordId));
        }
        
        
    }

}
