<?php

/**
 * VGS Visual Pipeline Module
 *
 *
 * @package        VGSVisualPipeline Module
 * @author         Curto Francisco - www.vgsglobal.com
 * @license        vTiger Public License.
 * @version        Release: 1.0
 */

class VGSVisualPipeline_VGSGetPicklistFields_Action extends Vtiger_Action_Controller {

    public function checkPermission(Vtiger_Request $request) {
        global $current_user;
        
        if (!is_admin($current_user)) {
            throw new AppException('LBL_PERMISSION_DENIED');
        }
    }

    public function process(Vtiger_Request $request) {


        if(isset($_REQUEST['mode']) && $request->get('mode') == 'fieldValues'){
            $fieldsResponse['result'] = 'ok';
            $fieldsResponse['fieldvaluestohide'] = $this->getFieldValues($request);

        }else{
            $db = PearDatabase::getInstance();
        
            $sql = "SELECT fieldname,fieldlabel
               FROM vtiger_field INNER JOIN vtiger_tab ON vtiger_field.tabid=vtiger_tab.tabid 
               WHERE vtiger_tab.name = ? AND uitype in ('15','16') 
               AND vtiger_field.presence in (0,2)
               AND fieldname != 'hdnTaxType'
               AND fieldname != 'campaignrelstatus'";
        
        
            $result = $db->pquery($sql, array($request->get('source_module')));
            if ($db->num_rows($result) > 0) {
                $htmlOptions = $this->buildOptionsArray($result,$request->get('source_module'));
                $fieldsResponse['result'] = 'ok';
                $fieldsResponse['options'] = $htmlOptions;
                $fieldsResponse['fieldtable'] = $this->getModuleFields($request->get('source_module'));
            } else {
                $fieldsResponse['result'] = 'fail';
            }
        }

        $response = new Vtiger_Response();
        $response->setResult($fieldsResponse);
        $response->emit();
    }
    
    function buildOptionsArray($result,$selectedModule) {
        $db = PearDatabase::getInstance();
        
        for ($i = 0; $i < $db->num_rows($result); $i++) {
            $optionArray[$db->query_result($result, $i, 'fieldname')] = getTranslatedString($db->query_result($result, $i, 'fieldlabel'),$selectedModule);
        }
        return $optionArray;
    }

    function getModuleFields($moduleName, $selectedField=[]){
        $struct = new Vtiger_RecordStructure_Model;
        $struct->setModule(Vtiger_Module_Model::getInstance($moduleName));
        $moduleStructure = $struct->getStructure();

        $html = '<p>' . vtranslate('Please choose which fields should be displayed','VGSVisualPipeline') . '</p>'; 
        $html .= '<table id="field-table" class="table table-bordered table-condensed themeTableColor"><tbody>';
        foreach ($moduleStructure  as $blockLabel => $fieldList) {
            $html .= '<tr><td colspan=6><h5>' . vtranslate($blockLabel,$moduleName) . '</h5></td></tr>';
            $a = 0;


            foreach ($fieldList as $fieldName => $fieldModel) {
                $html .= '<td><input type="checkbox" name="' . $fieldName . '"';

                if(in_array($fieldName, $selectedField)){
                    $html .= ' checked ';
                }

                $html .='</td><td>' . vtranslate($fieldModel->get('label'),$moduleName) . '</td>';

                if(($a+1) % 3 == 0)
                    $html .= "</tr><tr>";


                $a = $a + 1;    
            }
            
        }

         $html .= '</tr></tbody></table>';

        return $html;

    }

    function getFieldValues(Vtiger_Request $request){

        $moduleName = $request->get('modulename');
        $fieldName = $request->get('fieldname');

        $fieldModel = Vtiger_Field_Model::getInstance($fieldName, Vtiger_Module_Model::getInstance($moduleName));
        $fieldValues = $fieldModel->getPicklistValues();

        $html = '<p>' . vtranslate('Please choose which picklist values to <b>hide</b> in the kanban view') . '</p>';
        $html .= '<select style="min-width:500px; width:60%;" name="valuestohide" id="fieldsSelect" class="select2 span12" multiple>';
                    foreach ($fieldValues as $fieldValue) {
                       $html .= '<option value="' . $fieldValue . '" > ' .vtranslate($fieldValue,$moduleName) . '</option>';
                    }
                                                
         $html .= '</select>';

        return $html;

    }

}
